/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;

public abstract class NTBillDisposer
implements IReceivingDisposer,
IPaymentDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal arAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        if (action.getDestBill() != null && action.getDestBill() instanceof ReceivingBillInfo) {
            ReceivingBillInfo recingBillInfo = (ReceivingBillInfo)action.getDestBill();
            ReceivingBillEntryInfo receivingEnInfo = new ReceivingBillEntryInfo();
            ReceivingBillEntryCollection receiveEntryNum = recingBillInfo.getEntries();
            if (receiveEntryNum != null && receiveEntryNum.size() > 0) {
                receivingEnInfo = receiveEntryNum.get(0);
            }
            if (EmptyUtil.isEmpty((String)receivingEnInfo.getSourceBillId())) {
                throw new NTException(NTException.BOTPNOSOUREID);
            }
            if (action.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
                DbUtil.execute((Context)ctx, (String)("update " + this.getDBTableName() + " set FRpBillId=null where FID=?"), (Object[])new Object[]{receivingEnInfo.getSourceBillId()});
            }
            if (action.getActionType().equals((Object)DisposerActionEnum.SAVE) || action.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) {
                DbUtil.execute((Context)ctx, (String)("update " + this.getDBTableName() + " set FRpBillId=? where FID=?"), (Object[])new Object[]{recingBillInfo.getId().toString(), receivingEnInfo.getSourceBillId()});
            }
        }
        if (action.getDestBill() != null && action.getDestBill() instanceof PaymentBillInfo) {
            PaymentBillInfo paymentBillInfo = (PaymentBillInfo)action.getDestBill();
            PaymentBillEntryInfo paymentEnInfo = null;
            PaymentBillEntryCollection paymentEntryNum = paymentBillInfo.getEntries();
            if (paymentEntryNum == null) {
                return;
            }
            for (int i = 0; i < paymentEntryNum.size(); ++i) {
                paymentEnInfo = paymentEntryNum.get(i);
                if (EmptyUtil.isEmpty((String)paymentEnInfo.getSourceBillId())) {
                    throw new NTException(NTException.BOTPNOSOUREID);
                }
                if (action.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
                    DbUtil.execute((Context)ctx, (String)("update " + this.getDBTableName() + " set FRpBillId=null where FID=?"), (Object[])new Object[]{paymentEnInfo.getSourceBillId()});
                }
                if (!action.getActionType().equals((Object)DisposerActionEnum.SAVE) && !action.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) continue;
                DbUtil.execute((Context)ctx, (String)("update " + this.getDBTableName() + " set FRpBillId=? where FID=?"), (Object[])new Object[]{paymentBillInfo.getId().toString(), paymentEnInfo.getSourceBillId()});
            }
        }
    }

    protected abstract String getDBTableName();

    public static NTBillDisposer getInstance(Context ctx, String bizBillId) throws BOSException {
        if (EmptyUtil.isEmpty((String)bizBillId)) {
            return null;
        }
        BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
        String disposerName = "";
        if (bosType.equals((Object)new ReceivableBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.ReceivableDisposer";
        }
        if (disposerName.equals("")) {
            return null;
        }
        try {
            return (NTBillDisposer)Class.forName(disposerName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

