/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.EndorsementTypeEnum;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.TreeSet;

public class NTRptEndorsementFilterParam
implements FilterParam {
    private static final long serialVersionUID = -391841330201578995L;
    private Date starttime;
    private Date endtime;
    private String currencyId;
    private String[] companyId;
    private String companyifId;
    private EndorsementTypeEnum endorseType1;
    private String ednorseCompanyID;
    private String endorseeName;
    private BillMediumEnum billMedium;

    public FilterInfo getFilter() {
        CompanyOrgUnitInfo companyif = SysContext.getSysContext().getCurrentFIUnit();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("endorseDate", (Object)DateTimeUtils.truncateDate((Date)this.getStarttime()), CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("endorseDate", (Object)DateUtil.getNextDay((Date)DateTimeUtils.truncateDate((Date)this.getEndtime())), CompareType.LESS));
        if (this.getCurrency() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrency().getId().toString(), CompareType.EQUALS));
        }
        TreeSet<String> Company = new TreeSet<String>();
        if (!FMHelper.isEmpty((Object[])this.getCompanyId())) {
            int count = this.companyId.length;
            for (int i = 0; i < count; ++i) {
                Company.add(this.companyId[i]);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", Company, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyif.getId().toString()));
        }
        if (this.getEndorseType() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(this.getEndorseType().getValue())));
        }
        if (!FMHelper.isEmpty((String)this.getEndorseeName())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("endorsee", (Object)this.getEndorseeName()));
        }
        if (this.getBillMedium() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billMedium", (Object)new Integer(this.getBillMedium().getValue())));
        }
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection selectcollection = new SorterItemCollection();
        selectcollection.add(new SorterItemInfo("currency.name"));
        selectcollection.add(new SorterItemInfo("number"));
        return selectcollection;
    }

    public CompanyOrgUnitInfo getCompanyif() {
        if (!EmptyUtil.isEmpty((String)this.companyifId)) {
            CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
            info.setId(BOSUuid.read((String)this.companyifId));
            return info;
        }
        return null;
    }

    public void setCompanyif(CompanyOrgUnitInfo companyif) {
        this.companyifId = companyif != null && companyif.getId() != null ? companyif.getId().toString() : "";
    }

    public CurrencyInfo getCurrency() {
        if (this.currencyId != null) {
            CurrencyInfo info = new CurrencyInfo();
            info.setId(BOSUuid.read((String)this.currencyId));
            return info;
        }
        return null;
    }

    public void setCurrency(CurrencyInfo info) {
        this.currencyId = info == null ? null : info.getId().toString();
    }

    public Date getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Date endtime) {
        this.endtime = endtime;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Date starttime) {
        this.starttime = starttime;
    }

    public String[] getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String[] companyId) {
        this.companyId = companyId;
    }

    public void setEndorseType(EndorsementTypeEnum enums) {
        this.endorseType1 = enums;
    }

    public EndorsementTypeEnum getEndorseType() {
        return this.endorseType1;
    }

    public String getEdnorseCompanyID() {
        return this.ednorseCompanyID;
    }

    public void setEdnorseCompanyID(String ednorseCompanyID) {
        this.ednorseCompanyID = ednorseCompanyID;
    }

    public String getEndorseeName() {
        return this.endorseeName;
    }

    public void setEndorseeName(String endorseeName) {
        this.endorseeName = endorseeName;
    }

    public BillMediumEnum getBillMedium() {
        return this.billMedium;
    }

    public void setBillMedium(BillMediumEnum billMedium) {
        this.billMedium = billMedium;
    }
}

