/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillStateEnum;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillDataImport;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillImportVerify;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.app.NTDataImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayableBillDataImportForABC
extends AbstractDataTransmission {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)PayableBillDataImport.class.getName());
    private static final BigDecimal DEFAULT_EXCHANGERATE = Constants.ONE;
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    private CompanyOrgUnitInfo currentCompany;

    protected ICoreBase getController(Context arg0) throws TaskExternalException {
        try {
            return PayableBillFactory.getLocalInstance(arg0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PayableBillInfo head;
        block21: {
            boolean flag;
            String number;
            GuaranteeDetailInfo entry;
            block20: {
                head = new PayableBillInfo();
                entry = null;
                number = (String)this.getData(hsData, "FNumber");
                if (!EmptyUtil.isEmpty((String)number) && number.length() > 80) {
                    throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"493_PayableBillDataImport", (Locale)ctx.getLocale()));
                }
                flag = true;
                this.curKey = number;
                if (this.lastKey == null) {
                    this.lastKey = this.curKey;
                }
                this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
                int mode = datataskMode;
                if (mode != 16) break block20;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                view.setFilter(fi);
                PayableBillCollection coll = null;
                try {
                    coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                if (coll.size() > 0) {
                    Object expiredDate;
                    Object issueDate;
                    head = coll.get(0);
                    Object draftNumber = this.getData(hsData, "FDraftNumber");
                    if (draftNumber != null && draftNumber.toString().length() > 0) {
                        head.setDraftNumber(draftNumber.toString());
                    }
                    if ((issueDate = this.getData(hsData, "FIssueDate")) != null && issueDate.toString().length() > 0) {
                        head.setIssueDate(TypeConversionUtils.objToDate((Object)issueDate));
                    }
                    if ((expiredDate = this.getData(hsData, "FExpiredDate")) != null && expiredDate.toString().length() > 0) {
                        head.setExpiredDate(TypeConversionUtils.objToDate((Object)expiredDate));
                    }
                }
                break block21;
            }
            if (EmptyUtil.isEmpty((String)number)) {
                try {
                    boolean isUsedParam = DataImportUtils.getImportParam((Context)ctx);
                    if (isUsedParam) {
                        String souID = this.currentCompany.getId().toString().trim();
                        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                        if (!iCodingRuleManager.isExist((IObjectValue)head, souID)) {
                            IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                            EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(this.currentCompany.getBOSType());
                            String[] materialNames = new String[]{entityObjectInfo.getAlias()};
                            throw new BOSException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"494_PayableBillDataImport", (Locale)ctx.getLocale()));
                        }
                        this.curKey = iCodingRuleManager.getNumber((IObjectValue)head, souID, "");
                    } else {
                        flag = false;
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.toString());
                }
            }
            if (!this.isExistHead(hsData, ctx)) {
                if (!this.infoMap.containsKey(this.curKey)) {
                    head = (PayableBillInfo)this.parseHead(hsData, ctx);
                    this.infoMap.put(this.curKey, head);
                } else {
                    head = (PayableBillInfo)this.infoMap.get(this.curKey);
                }
                if (this.isTransmitEntry(hsData) && (entry = (GuaranteeDetailInfo)this.parseEntry(head, hsData, ctx)) != null) {
                    head.getGuaranteeEntrys().add(entry);
                }
            }
            if (flag) {
                head.setCompany(this.currentCompany);
                head.setNumber(this.curKey);
            }
        }
        new PayableBillImportVerify().verifyHead(ctx, (CoreBaseInfo)head);
        return head;
    }

    private boolean isExistHead(Hashtable hsData, Context ctx) throws TaskExternalException {
        String company = this.currentCompany.getNumber();
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        evi.setFilter(filter);
        try {
            PayableBillCollection coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(evi);
            if (coll != null && coll.size() > 0) {
                throw new TaskExternalException(number + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"392_PayableBillDataImport", (Locale)ctx.getLocale()));
            }
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return true;
        }
    }

    private void checkEmpty(Context ctx, Object obj, String msg) throws TaskExternalException {
        if (obj == null) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"79_ReceivableBillImportVerify", (Locale)ctx.getLocale()), new String(msg));
            throw new TaskExternalException(msgStr + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"79_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException {
        CSBankInfo cs;
        SupplierInfo csInfo;
        BEBankCollection coll;
        FilterInfo filter;
        EntityViewInfo view;
        NTTypeInfo obj;
        PayableBillInfo info = new PayableBillInfo();
        BigDecimal zero = Constants.ZERO;
        Object data = null;
        info.setApplyUnit(this.currentCompany);
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        info.setBillState(PayableBillStateEnum.TempSaved);
        data = this.getData(hsData, "historyBill");
        if (data != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"450_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            info.setHistoryBill(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "applyUnit")) != null && data.toString().trim().length() > 0) {
            CompanyOrgUnitInfo obj2 = (CompanyOrgUnitInfo)NTDataImportUtil.getInfoByNumber(ctx, "applyUnit", data.toString(), (IObjectValue)new CompanyOrgUnitInfo());
            info.setApplyUnit(obj2);
        }
        this.checkEmpty(ctx, info.getApplyUnit(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"394_PayableBillDataImport", (Locale)ctx.getLocale()));
        data = this.getData(hsData, "FNtType");
        if (data != null && data.toString().trim().length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("financeType.*"));
            obj = (NTTypeInfo)NTDataImportUtil.getInfoByNumber(ctx, "FNtType", data.toString(), (IObjectValue)new NTTypeInfo(), sic);
            info.setNtType(obj);
        }
        this.setFinanceingSource(info);
        boolean isBankDraft = true;
        if (info.getNtType() != null && info.getNtType().getGroup().getAlias().equals(NTTypeGroupEnum.RECEIVABLE_CommerceAccept.getAlias())) {
            isBankDraft = false;
        }
        this.checkEmpty(ctx, info.getType(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"395_PayableBillDataImport", (Locale)ctx.getLocale()));
        data = this.getData(hsData, "billMaker");
        if (!isBankDraft && info.isHistoryBill() && this.currentCompany.getId().toString().equals(info.getApplyUnit().toString())) {
            info.setBillMakerName(data.toString());
        } else {
            info.setBillMaker(this.currentCompany);
            info.setBillMakerName(this.currentCompany.getName());
        }
        if (info.getRegion() == null) {
            info.setRegion(BankAreaTypeEnum.In);
        }
        if ((data = this.getData(hsData, "blockFlowType")) != null && data.toString().trim().length() > 0) {
            obj = (BlockingFlowTypeInfo)NTDataImportUtil.getInfoByNumber(ctx, "blockFlowType", data.toString(), (IObjectValue)new BlockingFlowTypeInfo());
            info.setBlockFlowType((BlockingFlowTypeInfo)obj);
        }
        if ((data = this.getData(hsData, "FPayeeName")) != null && data.toString().trim().length() > 0) {
            obj = (SupplierInfo)NTDataImportUtil.getInfoByNumber(ctx, data.toString(), (IObjectValue)new SupplierInfo());
            if (obj != null) {
                info.setPayee((SupplierInfo)obj);
                info.setPayeeName(obj.getName());
            } else {
                CustomerInfo obj1 = (CustomerInfo)NTDataImportUtil.getInfoByNumber(ctx, data.toString(), (IObjectValue)new CustomerInfo());
                if (obj1 != null) {
                    info.setPayee1(obj1);
                    info.setPayeeName(obj1.getName());
                } else {
                    info.setPayeeName(data.toString());
                }
            }
        }
        if ((data = this.getData(hsData, "FCurrency")) != null && data.toString().trim().length() > 0) {
            obj = (CurrencyInfo)NTDataImportUtil.getInfoByNumber(ctx, "currency", data.toString(), (IObjectValue)new CurrencyInfo());
            info.setCurrency((CurrencyInfo)obj);
        } else {
            obj = (CurrencyInfo)NTDataImportUtil.getInfoByNumber(ctx, "currency", "BB01", (IObjectValue)new CurrencyInfo());
            info.setCurrency((CurrencyInfo)obj);
        }
        info.setAmount(zero);
        data = this.getData(hsData, "FAmount");
        if (data != null && data.toString().trim().length() > 0) {
            info.setAmount(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setLocalCurExRate(Constants.ONE);
        data = this.getData(hsData, "localCurExRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setLocalCurExRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if (info.getCreditCurExRate() == null) {
            info.setCreditCurExRate(TypeConversionUtils.objToBigDecimal((Object)"1"));
        }
        info.setAmountLocalCur(info.getAmount().multiply(info.getLocalCurExRate()));
        info.setAssureProportion(zero);
        data = this.getData(hsData, "assureProportion");
        if (data != null && data.toString().trim().length() > 0) {
            info.setAssureProportion(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setAssureAmount(zero);
        info.setOriAssureAmount(zero);
        data = this.getData(hsData, "assureAmount");
        if (data != null && data.toString().trim().length() > 0) {
            info.setAssureAmount(TypeConversionUtils.objToBigDecimal((Object)data));
            info.setOriAssureAmount(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setBalance(info.getAmount().subtract(info.getAssureAmount()));
        data = this.getData(hsData, "FContractNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setContractNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FIssueDate")) != null && data.toString().trim().length() > 0) {
            info.setIssueDate(TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "acceptDate")) != null && data.toString().trim().length() > 0) {
            info.setAcceptDate(TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "FExpiredDate")) != null && data.toString().trim().length() > 0) {
            info.setExpiredDate(TypeConversionUtils.objToDate((Object)data));
        }
        if (!EmptyUtil.isEmpty((Object)info.getExpiredDate()) && !EmptyUtil.isEmpty((Object)info.getIssueDate())) {
            info.setHorizon(FinHorizon.getHorizon((Date)info.getIssueDate(), (Date)info.getExpiredDate()));
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "buyerPayDisCnt")) != null && data.toString().trim().length() > 0) {
            info.setBuyerPayDisCnt(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "discountDate")) != null && data.toString().trim().length() > 0) {
            info.setDiscountDate(TypeConversionUtils.objToDate((Object)data));
        }
        info.setBizDate(new Date());
        info.setDiscountRate(zero);
        data = this.getData(hsData, "discountRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setDiscountRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        info.setDiscount(zero);
        data = this.getData(hsData, "discount");
        if (data != null && data.toString().trim().length() > 0) {
            info.setDiscount(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "isInCredit")) != null && data.toString().trim().length() > 0) {
            info.setIsInCredit(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "creditLimit")) != null && data.toString().trim().length() > 0) {
            obj = (CreditLimitInfo)NTDataImportUtil.getInfoByNumber(ctx, "creditLimit", data.toString(), (IObjectValue)new CreditLimitInfo());
            this.setCreditLimitInfo(ctx, info, (CreditLimitInfo)obj);
        } else if (info.isIsInCredit()) {
            info.setIsInCredit(false);
        }
        if (this.currentCompany.getName().equals(info.getBillMakerName()) && this.currentCompany.getName().equals(info.getApplyUnit().getName())) {
            info.setMakeType(BillMakeTypeEnum.SELF);
        } else if (this.currentCompany.getName().equals(info.getBillMakerName()) && !this.currentCompany.getId().toString().equals(info.getApplyUnit().getName())) {
            info.setMakeType(BillMakeTypeEnum.SUB);
            if (info.isHistoryBill()) {
                info.setConfirmer(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getPerson());
            }
        } else {
            info.setMakeType(BillMakeTypeEnum.ENTRUST);
        }
        data = this.getData(hsData, "garanteeType");
        if (data != null && data.toString().trim().length() > 0) {
            obj = (GuaranteeTypeInfo)NTDataImportUtil.getInfoByNumber(ctx, "garanteeType", data.toString(), (IObjectValue)new GuaranteeTypeInfo());
            info.setGaranteeType((GuaranteeTypeInfo)obj);
            info.setGuaranteeTypeInputMode(this.getGuaranteeTypeInputModeValue(data.toString()));
        } else {
            obj = (GuaranteeTypeInfo)NTDataImportUtil.getInfoByNumber(ctx, "garanteeType", "002", (IObjectValue)new GuaranteeTypeInfo());
            info.setGaranteeType((GuaranteeTypeInfo)obj);
            info.setGuaranteeTypeInputMode(GuaranteeTypeInputModeEnum.assure);
        }
        data = this.getData(hsData, "FOutBankAccountNumber");
        if (data != null && data.toString().trim().length() > 0) {
            obj = NTDataImportUtil.getAccountBankByNumber(ctx, data.toString());
            info.setOutBankAccount((AccountBankInfo)obj);
            if (obj != null) {
                info.setOutBankAccountName(obj.getBankAccountNumber());
                info.setInstitutionName(obj.getBank().toString());
                info.setInstitution(obj.getBank());
                if (info.getInstitution() != null) {
                    BankInfo bankInfo = info.getInstitution();
                    try {
                        bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getInstitution().getId()));
                        if (bankInfo.getAccountBank() != null) {
                            if (BEBankFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()))) {
                                BEBankInfo beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                                info.setDrawerBankNumber(beInfo.getNumber());
                            }
                        } else {
                            view = new EntityViewInfo();
                            filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("name", (Object)(info.getInstitutionName() + "%"), CompareType.LIKE));
                            view.setFilter(filter);
                            coll = new BEBankCollection();
                            coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                            if (coll.size() > 0) {
                                info.setDrawerBankNumber(coll.get(0).getNumber());
                            }
                        }
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                info.setOutBankAccountName(data.toString());
            }
        }
        if ((data = this.getData(hsData, "FPayeeAccountName")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAccountName(data.toString());
        } else if (info.getPayee() != null || info.getPayee1() != null) {
            csInfo = info.getPayee() != null ? info.getPayee() : info.getPayee1();
            try {
                cs = FMHelper.getCSBankInfo((Context)ctx, (Object)csInfo, (String)this.currentCompany.getId().toString());
                info.setPayeeAccountName(cs.getBankAccount());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        data = this.getData(hsData, "FPayeeBankName");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayeeBankName(data.toString());
        } else if (info.getPayee() != null || info.getPayee1() != null) {
            csInfo = info.getPayee() != null ? info.getPayee() : info.getPayee1();
            try {
                cs = FMHelper.getCSBankInfo((Context)ctx, (Object)csInfo, (String)this.currentCompany.getId().toString());
                info.setPayeeBankName(cs.getBank());
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)(cs.getBank() + "%"), CompareType.LIKE));
                view.setFilter(filter);
                coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                if (coll.size() > 0) {
                    info.setPayeeBankNumber(coll.get(0).getNumber());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        data = this.getData(hsData, "FIsAccept");
        if (data != null && data.toString().trim().length() > 0) {
            if (!data.equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"449_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (data.equals(Constants.ONE.toString())) {
                info.setIsAccept(true);
            } else {
                info.setIsAccept(false);
            }
        }
        if ((data = this.getData(hsData, "FAcceptDate")) != null && data.toString().trim().length() > 0) {
            if (!info.isIsAccept()) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"451_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            info.setAcceptDate(TypeConversionUtils.objToDate((Object)data));
        }
        if ((data = this.getData(hsData, "FacceptorName")) != null && data.toString().trim().length() > 0) {
            info.setAcceptor(data.toString());
        } else if (info.getNtType().getGroup().equals((Object)NTTypeGroupEnum.PAYABLE_BankAccept)) {
            if (info.getInstitution() != null) {
                info.setAcceptor(info.getInstitution().getName());
            }
        } else {
            info.setAcceptor(info.getBillMakerName());
        }
        data = this.getData(hsData, "FBillMedium");
        if (data != null && data.toString().trim().length() > 0) {
            if ("1".equals(data)) {
                info.setBillMedium(BillMediumEnum.PAPERY);
            } else if ("2".equals(data)) {
                info.setBillMedium(BillMediumEnum.ELECTRONIC);
            } else {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"542_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FDraftNumber")) != null && data.toString().trim().length() > 0) {
            info.setDraftNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FIsCanTransfer")) != null && data.toString().trim().length() > 0) {
            if (!(data = data.toString().trim().equals("1") ? Constants.ONE.toString() : Constants.ZERO.toString()).equals(Constants.ONE.toString()) && !data.equals(Constants.ZERO.toString())) {
                throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"543_PayableBillImportVerify", (Locale)ctx.getLocale()));
            }
            info.setIsCanTransfer(TypeConversionUtils.objToBoolean((Object)data));
        }
        if ((data = this.getData(hsData, "FAcceptorAccountName")) != null && data.toString().trim().length() > 0) {
            info.setAcceptorAccountName(data.toString());
        }
        if ((data = this.getData(hsData, "FAcceptorBankNum")) != null && data.toString().trim().length() > 0) {
            info.setAcceptorBankNum(data.toString());
        }
        if ((data = this.getData(hsData, "FDrawerBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setDrawerBankNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setPayeeBankNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FAcceptorBankNum")) != null && data.toString().trim().length() > 0) {
            info.setAcceptorBankNum(data.toString());
        }
        return info;
    }

    private void setCreditLimitInfo(Context ctx, PayableBillInfo info, CreditLimitInfo clInfo) {
        if (clInfo == null) {
            return;
        }
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("entrys.*");
            selector.add("Currency.*");
            selector.add("CreditUsage.*");
            CreditLimitInfo creditInfo = CreditLimitFactory.getLocalInstance((Context)ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(clInfo.getId()), selector);
            info.setCreditLimit(creditInfo);
            info.setIsInCredit(true);
            info.setCreditCurrency(creditInfo.getCurrency());
            if (creditInfo.getCreditUsage().isColligateCredit() && creditInfo.getShareType() == ShareTypeEnum.ASSIGN) {
                throw new TaskExternalException(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"AmountShareCreditNotImport"));
            }
            if (info.getCurrency().getId().toString().equals(info.getCreditCurrency().getId().toString())) {
                info.setCreditCurExRate(Constants.ONE);
            } else {
                ExchangeRateInfo exRate = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)info.getCurrency(), (CurrencyInfo)info.getCreditCurrency(), (CompanyOrgUnitInfo)this.currentCompany, (Date)info.getBizDate());
                if (exRate == null) {
                    throw new TaskExternalException(EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"MaintainExchangeRateTable"));
                }
                info.setCreditCurExRate(exRate.getConvertRate());
            }
            info.setUsedQuota(info.getAmount().multiply(info.getCreditCurExRate()));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setFinanceingSource(PayableBillInfo info) {
        if (info.getNtType() != null && info.getNtType().getFinanceType() != null) {
            info.setSource(info.getNtType().getFinanceType().getFinancingSource());
            info.setType(info.getNtType().getFinanceType());
        }
    }

    private GuaranteeTypeInputModeEnum getGuaranteeTypeInputModeValue(String guaranteeTypeNumber) {
        if (guaranteeTypeNumber.equals("001")) {
            return GuaranteeTypeInputModeEnum.credit;
        }
        if (guaranteeTypeNumber.equals("002")) {
            return GuaranteeTypeInputModeEnum.assure;
        }
        if (guaranteeTypeNumber.equals("003")) {
            return GuaranteeTypeInputModeEnum.pledge;
        }
        if (guaranteeTypeNumber.equals("004")) {
            return GuaranteeTypeInputModeEnum.impawn;
        }
        return GuaranteeTypeInputModeEnum.other;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo parseEntry(PayableBillInfo headInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        GuaranteeDetailInfo info = new GuaranteeDetailInfo();
        BigDecimal zero = Constants.ZERO;
        Object data = null;
        data = this.getData(hsData, "garantee");
        if (data != null && data.toString().trim().length() > 0) {
            info.setGuaranteeName(data.toString());
        }
        info.setScale(zero);
        data = this.getData(hsData, "proportion");
        if (data != null && data.toString().trim().length() > 0) {
            info.setScale(TypeConversionUtils.objToBigDecimal((Object)data));
        } else {
            info.setScale(Constants.ONE_HUNDRED);
        }
        data = this.getData(hsData, "billNumber");
        if (data != null && data.toString().trim().length() > 0) {
            if (GuaranteeTypeInputModeEnum.assure.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                AssureBillInfo assureBill = (AssureBillInfo)NTDataImportUtil.getInfoByNumber(ctx, "billNumber", data.toString(), (IObjectValue)new AssureBillInfo());
                this.checkAssureBill(ctx, assureBill);
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.assure);
                info.setBilltype(GuanTypeBillEnum.AssureBill);
                info.setBillNumber(assureBill.getNumber());
                info.setBillId(assureBill.getId().toString());
                info.setAmount(assureBill.getAssureLimitAmt());
                info.setBalance(assureBill.getAssureCfgFee());
                info.setGuaranteeComp(assureBill.getAssureCompany());
                info.setGuaranteeCustomer(assureBill.getAssureCustomer());
                info.setCurrency(assureBill.getCurrency());
                info.setExchangeRate(this.getExchangeRate(ctx, headInfo.getCurrency(), assureBill.getCurrency(), headInfo.getIssueDate()));
                return info;
            } else if (GuaranteeTypeInputModeEnum.pledge.equals((Object)headInfo.getGuaranteeTypeInputMode()) || GuaranteeTypeInputModeEnum.impawn.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                WageInfo wageInfo = (WageInfo)NTDataImportUtil.getInfoByNumber(ctx, "billNumber", data.toString(), (IObjectValue)new WageInfo());
                this.checkWage(ctx, wageInfo, headInfo);
                if (GuaranteeTypeInputModeEnum.pledge.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                    info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.pledge);
                } else {
                    info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.impawn);
                }
                info.setBilltype(GuanTypeBillEnum.wage);
                info.setBillNumber(wageInfo.getNumber());
                info.setBillId(wageInfo.getId().toString());
                info.setGuaranteeComp(wageInfo.getCompany());
                info.setGuaranteeName(wageInfo.getGuarantee());
                info.setWage(wageInfo.getAmount());
                info.setWageRate(wageInfo.getWagerate());
                info.setCanWage(wageInfo.getWageAmount());
                info.setRealWage(headInfo.getAmount());
                return info;
            } else {
                if (!GuaranteeTypeInputModeEnum.credit.equals((Object)headInfo.getGuaranteeTypeInputMode())) return null;
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.credit);
                data = this.getData(hsData, "garantee");
                if (data == null || data.toString().trim().length() <= 0) return info;
                info.setGuaranteeCompHand(data.toString());
            }
            return info;
        } else {
            data = this.getData(hsData, "garanCompany");
            if (data != null && data.toString().trim().length() > 0) {
                info.setGuaranteeCompHand(data.toString());
            }
            if ((data = this.getData(hsData, "entrysAmount")) != null && data.toString().trim().length() > 0) {
                info.setAmount(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setWage(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setCanWage(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setRealWage(TypeConversionUtils.objToBigDecimal((Object)data));
            }
            if ((data = this.getData(hsData, "entrysCurrency")) != null && data.toString().trim().length() > 0) {
                CurrencyInfo obj = (CurrencyInfo)NTDataImportUtil.getInfoByNumber(ctx, "entrysCurrency", data.toString(), (IObjectValue)new CurrencyInfo());
                info.setCurrency(obj);
            }
            if ((data = this.getData(hsData, "entrysLocalCurExRate")) != null && data.toString().trim().length() > 0) {
                info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
                info.setWageRate(TypeConversionUtils.objToBigDecimal((Object)data));
            }
            if (GuaranteeTypeInputModeEnum.assure.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.assure);
                return info;
            } else if (GuaranteeTypeInputModeEnum.pledge.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.pledge);
                return info;
            } else if (GuaranteeTypeInputModeEnum.impawn.equals((Object)headInfo.getGuaranteeTypeInputMode())) {
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.impawn);
                return info;
            } else {
                if (!GuaranteeTypeInputModeEnum.credit.equals((Object)headInfo.getGuaranteeTypeInputMode())) return null;
                info.setGuaranteeTypeProperty(GuaranteeTypePropertyEnum.credit);
                data = this.getData(hsData, "garantee");
                if (data == null || data.toString().trim().length() <= 0) return info;
                info.setGuaranteeCompHand(data.toString());
            }
        }
        return info;
    }

    private BigDecimal getExchangeRate(Context ctx, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws TaskExternalException {
        try {
            if (sourceCurr == null || destCurr == null) {
                return null;
            }
            BigDecimal rate = null;
            if (sourceCurr.getId().equals((Object)destCurr.getId())) {
                return Constants.ONE;
            }
            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo((Context)ctx, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)sourceCurr, (CurrencyInfo)destCurr, (Date)date);
            if (exchangeRateInfo == null) {
                throw new FinBizException(FinBizException.EXRATENULL);
            }
            rate = exchangeRateInfo.getConvertRate();
            if (exchangeRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                // empty if block
            }
            return Constants.ONE.divide(rate, 4);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isTransmitEntry(Hashtable hsData) {
        return this.getData(hsData, "garantee") != null && this.getData(hsData, "garantee").toString().trim().length() > 0 || this.getData(hsData, "billNumber") != null && this.getData(hsData, "billNumber").toString().trim().length() > 0 || this.getData(hsData, "garanCompany") != null && this.getData(hsData, "garanCompany").toString().trim().length() > 0;
    }

    protected void checkAssureBill(Context ctx, AssureBillInfo assureBill) throws TaskExternalException {
        String companyName_l1 = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getName(new Locale("L1"));
        String companyName_l2 = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getName(new Locale("L2"));
        String companyName_l3 = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getName(new Locale("L3"));
        if (assureBill.isCanceled() || !assureBill.getState().equals((Object)AssureBillStateEnum.APPROVE)) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError1", (Locale)ctx.getLocale()));
        }
        if (!(assureBill.getAssuredCompany().equals(companyName_l1) || assureBill.getAssuredCompany().equals(companyName_l2) || assureBill.getAssuredCompany().equals(companyName_l3))) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError2", (Locale)ctx.getLocale()));
        }
    }

    protected void checkWage(Context ctx, WageInfo wageInfo, PayableBillInfo headInfo) throws TaskExternalException {
        if (wageInfo.isIsAntiWage() || !wageInfo.getBillStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError3", (Locale)ctx.getLocale()));
        }
        if (wageInfo.getOwnerCompany() != null && !wageInfo.getOwnerCompany().getId().equals((Object)this.currentCompany.getId())) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError4", (Locale)ctx.getLocale()));
        }
        if (headInfo.getInstitution() != null && wageInfo.getInstitution() != null && !headInfo.getInstitution().getId().equals((Object)wageInfo.getInstitution().getId())) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"PayableImportError5", (Locale)ctx.getLocale()));
        }
        if (headInfo.getInstitution() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"bank", (Locale)ctx.getLocale()));
        }
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fm.nt.app.PayableBillQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String currency;
            String billMedium;
            String outBankAccountNumber;
            String draftNumber;
            String remark;
            String contractNumber;
            String payeeBankNumber;
            String payeeBankName;
            String payeeAccountName;
            String payeeName;
            String isCanTransfer;
            String expiredDate;
            String issueDate;
            String amount;
            String ntType;
            String number = rs.getString("number");
            if (number != null) {
                result.put("FNumber", number);
            }
            if ((ntType = rs.getString("ntType.name")) != null) {
                result.put("FNtType", ntType);
            }
            if ((amount = rs.getString("Amount")) != null) {
                result.put("FAmount", amount);
            }
            if ((issueDate = rs.getString("IssueDate")) != null) {
                result.put("FIssueDate", issueDate);
            }
            if ((expiredDate = rs.getString("ExpiredDate")) != null) {
                result.put("FExpiredDate", expiredDate);
            }
            if ((isCanTransfer = rs.getString("isCanTransfer")) != null) {
                if (isCanTransfer.equals("true")) {
                    result.put("FIsCanTransfer", ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"572_yes", (Locale)ctx.getLocale()));
                } else {
                    result.put("FIsCanTransfer", ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"573_no", (Locale)ctx.getLocale()));
                }
            }
            if ((payeeName = rs.getString("payeeName")) != null) {
                result.put("FPayeeName", payeeName);
            }
            if ((payeeAccountName = rs.getString("PayeeAccountName")) != null) {
                result.put("FPayeeAccountName", payeeAccountName);
            }
            if ((payeeBankName = rs.getString("PayeeBankName")) != null) {
                result.put("FPayeeBankName", payeeBankName);
            }
            if ((payeeBankNumber = rs.getString("payeeBankNumber")) != null) {
                result.put("FPayeeBankNumber", payeeBankNumber);
            }
            if ((contractNumber = rs.getString("ContractNumber")) != null) {
                result.put("FContractNumber", contractNumber);
            }
            if ((remark = rs.getString("Remark")) != null) {
                result.put("FRemark", remark);
            }
            if ((draftNumber = rs.getString("draftNumber")) != null) {
                result.put("FDraftNumber", draftNumber);
            }
            if ((outBankAccountNumber = rs.getString("OutBankAccount.bankAccountNumber")) != null) {
                result.put("FOutBankAccountNumber", outBankAccountNumber);
            }
            if ((billMedium = rs.getString("billMedium")) != null) {
                Integer enumValue = new Integer(billMedium);
                String medium = BillMediumEnum.getEnum(enumValue).getAlias();
                result.put("FBillMedium", medium);
            }
            if ((currency = rs.getString("Currency.name")) != null) {
                result.put("FCurrency", currency);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

