/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.IWageDisposer;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.WageDisposerActionEnum;
import com.kingdee.eas.fm.fin.WageEntryInfo;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.OprtEnum;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Set;

public class ReceivableBillDisposer
implements IWageDisposer {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";

    public void dispose(Context ctx, WageDisposerActionEnum action, IObjectPK pk) throws BOSException, EASBizException {
        if (action.equals((Object)WageDisposerActionEnum.delete)) {
            this.deleteWage(ctx, pk);
        } else if (action.equals((Object)WageDisposerActionEnum.antiwage)) {
            this.antiWage(ctx, pk);
        } else if (action.equals((Object)WageDisposerActionEnum.unAntiwage)) {
            this.unAntiWage(ctx, pk);
        }
    }

    private void unAntiWage(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        Set srcIDs = FMHelper.getSrcBillIdSet((Context)ctx, (String)pk.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcIDs, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        ReceivableBillCollection coll = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillCollection(evi);
        ReceivableBillInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getBillState().equals((Object)BillStateEnum.SAVED) || info.getBillState().equals((Object)BillStateEnum.Audit)) continue;
            throw new NTException(NTException.UNANTIWAGEERROR, new Object[]{info.getNumber()});
        }
        DbUtil.execute((Context)ctx, (String)("update t_nt_receivablebill set FDigest=null,FIsDisPledge=0  where" + FMHelper.buildIn((String)"FID", (Object[])srcIDs.toArray())));
        DbUtil.execute((Context)ctx, (String)("update T_NT_ReceivablePledgeDetail set FIsDisPledge=0 where FIsClose=0 and FWageID='" + pk.toString() + "' and " + FMHelper.buildIn((String)"FReceivableID", (Object[])srcIDs.toArray())));
        this.updatePledgeBillAmount(ctx, pk.toString());
    }

    private void antiWage(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BigDecimal balance = Constants.ZERO;
        WageInfo wageInfo = WageFactory.getLocalInstance((Context)ctx).getWageInfo((IObjectPK)new ObjectUuidPK(pk.toString()));
        WageEntryInfo wageEntryInfo2 = null;
        for (WageEntryInfo wageEntryInfo2 : wageInfo.getEntrys()) {
            balance = balance.add(this.getFinancingBillBalance(ctx, wageEntryInfo2.getBillid()));
        }
        if (balance.compareTo(Constants.ZERO) > 0) {
            throw new NTException(NTException.PLEDGEBALANCENOTZERO);
        }
        Set srcIDs = FMHelper.getSrcBillIdSet((Context)ctx, (String)pk.toString());
        DbUtil.execute((Context)ctx, (String)(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"408_ReceivableBillDisposer", (Locale)ctx.getLocale()) + FMHelper.buildIn((String)"FID", (Object[])srcIDs.toArray())));
        DbUtil.execute((Context)ctx, (String)("update T_NT_ReceivablePledgeDetail set FIsDisPledge=1 where FIsClose=0 and FWageID='" + wageInfo.getId().toString() + "' and " + FMHelper.buildIn((String)"FReceivableID", (Object[])srcIDs.toArray())));
        this.updatePledgeBillAmount(ctx, pk.toString());
    }

    private void deleteWage(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        WageInfo wage = WageFactory.getLocalInstance((Context)ctx).getWageInfo(pk, sic);
        if (wage.isFiVouchered()) {
            throw new FMException(FMException.HASFIVOUCHERED);
        }
        Set srcIDs = FMHelper.getSrcBillIdSet((Context)ctx, (String)pk.toString());
        DbUtil.execute((Context)ctx, (String)("update t_nt_receivablebill set fdigest=null,FWageId=(select FLastWageId from T_NT_ReceivablePledgeDetail where FReceivableID=t_nt_receivablebill.fid and fwageid=t_nt_receivablebill.fwageid),FIsPledge=0,FIsDisPledge=0  where " + FMHelper.buildIn((String)"FID", (Object[])srcIDs.toArray())));
        DbUtil.execute((Context)ctx, (String)("delete from  T_NT_ReceivablePledgeDetail where FWageId='" + wage.getId().toString() + "'"));
        BOSObjectType srcBosType = new ReceivableBillInfo().getBOSType();
        BotRelationUtil.removeRelationByDestObjId((Context)ctx, (String)pk.toString(), (String)srcBosType.toString());
        IReceivableBill iReceivablebill = ReceivableBillFactory.getLocalInstance(ctx);
        for (String id : srcIDs) {
            ReceivableBillInfo recvableBillInfo = iReceivablebill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            recvableBillInfo.setOprtLogDate(wage.getIssuedate());
            NTHelper.writOprtLog(ctx, (IObjectValue)recvableBillInfo, recvableBillInfo.getId().toString(), OprtEnum.SAVE, OprtEnum.PLEDGE);
        }
    }

    private BigDecimal getFinancingBillBalance(Context ctx, String financingId) throws EASBizException, BOSException {
        BOSObjectType bosType = BOSUuid.read((String)financingId).getType();
        FinancingBillInfo info = new FinancingBillInfo();
        if (bosType.equals((Object)new PayableBillInfo().getBOSType())) {
            info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(financingId));
        } else if (bosType.equals((Object)LoanInfo.BOSTYPE)) {
            info = LoanFactory.getLocalInstance((Context)ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(financingId));
        } else if (bosType.equals((Object)LetterOfCreditInfo.BOSTYPE)) {
            info = LetterOfCreditFactory.getLocalInstance((Context)ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(financingId));
        } else if (bosType.equals((Object)new LetterOfGuaranteeInfo().getBOSType())) {
            info = LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(financingId));
        }
        return info.getBalance();
    }

    private void updatePledgeBillAmount(Context ctx, String wageId) throws BOSException {
        DbUtil.execute((Context)ctx, (String)("update T_FIN_Wage set FAmount=(select sum(b.FBillAmt) from T_NT_ReceivablePledgeDetail a ,t_nt_receivablebill b where a.FReceivableID=b.fid and a.FIsDisPledge=0 and a.fwageid ='" + wageId + "') ,FAmountLocalCur=FAmount*FLocalCurExRate   where FId ='" + wageId + "'"));
        DbUtil.execute((Context)ctx, (String)("update T_FIN_Wage set FAmountLocalCur=FAmount*FLocalCurExRate   where FId ='" + wageId + "'"));
    }
}

