/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.nt.AcceptApplyBillException;
import com.kingdee.eas.fm.nt.AcceptApplyBillFactory;
import com.kingdee.eas.fm.nt.AcceptApplyBillInfo;
import com.kingdee.eas.fm.nt.AcceptApplyBillStatusEnum;
import com.kingdee.eas.fm.nt.app.AbstractAcceptApplyBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class AcceptApplyBillControllerBean
extends AbstractAcceptApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.AcceptApplyBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AcceptApplyBillInfo info = (AcceptApplyBillInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AcceptApplyBillInfo info = AcceptApplyBillFactory.getLocalInstance(ctx).getAcceptApplyBillInfo(pk);
        if (info.getBillState().equals((Object)AcceptApplyBillStatusEnum.AUDITED)) {
            throw new AcceptApplyBillException(AcceptApplyBillException.ISAUDITED);
        }
        info.setBillState(AcceptApplyBillStatusEnum.AUDITED);
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setAuditor(user);
        info.setAuditDate(new Timestamp(new Date().getTime()));
        AcceptApplyBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AcceptApplyBillInfo info = AcceptApplyBillFactory.getLocalInstance(ctx).getAcceptApplyBillInfo(pk);
        if (!info.getBillState().equals((Object)AcceptApplyBillStatusEnum.AUDITED) || info.isIsGenRec()) {
            throw new AcceptApplyBillException(AcceptApplyBillException.ISNOTAUDITED);
        }
        info.setBillState(AcceptApplyBillStatusEnum.SUBMITED);
        info.setAuditor(null);
        info.setAuditDate(null);
        AcceptApplyBillFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
    }
}

