/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.app.AbstractAssureAmountWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssureAmountWebFacadeControllerBean
extends AbstractAssureAmountWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.AssureAmountWebFacadeControllerBean");
    private static final String NTAutoGenerateResource = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private static final String SUCESSMSG = "sucessMsg";

    @Override
    protected Map _submit(Context ctx, AssureAmountInfo info) throws BOSException, EASBizException {
        boolean isExist = PayableBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        if (isExist) {
            PayableBillInfo payableInfo = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            BigDecimal amount = info.getAmount();
            if (amount.compareTo(Constants.ZERO) <= 0 || amount.compareTo(payableInfo.getBalance()) > 0) {
                throw new NTException(NTException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"139_AssureAmountEditUI")});
            }
            if (payableInfo.getIssueDate() != null) {
                Date bizDate = info.getBizDate();
                Date issueDate = payableInfo.getIssueDate();
                Date expriedDate = payableInfo.getExpiredDate();
                bizDate = DateTimeUtils.truncateDate((Date)bizDate);
                issueDate = DateTimeUtils.truncateDate((Date)issueDate);
                expriedDate = DateTimeUtils.truncateDate((Date)expriedDate);
                if (bizDate.before(issueDate) || bizDate.after(expriedDate)) {
                    throw new NTException(NTException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"138_AssureAmountEditUI")});
                }
            }
            if (info.getSeq() <= 0L) {
                throw new NTException(NTException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"Seq_Less_Zero")});
            }
        }
        if (info.getAmount().compareTo(Constants.ZERO) <= 0) {
            throw new NTException(NTException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"AssureAmount_Less_Zero")});
        }
        if (info.getDescription() != null && info.getDescription().length() > 500) {
            throw new NTException(NTException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"425_AssureAmountEditUI")});
        }
        IObjectPK pk = AssureAmountFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SUCESSMSG, CASWebUtil.getResource((Context)ctx, (String)NTAutoGenerateResource, (String)"Submit_Success"));
        return map;
    }
}

