/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.nt.BankDraftEnum;
import com.kingdee.eas.fm.nt.BankDraftFactory;
import com.kingdee.eas.fm.nt.BankDraftInfo;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.app.AbstractBankDraftControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.dao.DBHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BankDraftControllerBean
extends AbstractBankDraftControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.BankDraftControllerBean");

    @Override
    protected void _antiAudit(Context ctx, IObjectPK idSet) throws BOSException, EASBizException {
        BankDraftInfo bankDraftInfo = BankDraftFactory.getLocalInstance(ctx).getBankDraftInfo(idSet);
        if (null != bankDraftInfo) {
            if ((bankDraftInfo.getBillState() != BankDraftEnum.AUDIT || bankDraftInfo.isFiVouchered()) && bankDraftInfo.getBillState() == BankDraftEnum.FOOTUP && bankDraftInfo.getBillState() == BankDraftEnum.BOUNCED) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"5_BankDraftControllerBean", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException("selected bankDraftInfo is null!");
        }
        bankDraftInfo.setBillState(BankDraftEnum.REGISTED);
        this.updatePartial(ctx, (CoreBaseInfo)bankDraftInfo, this.getSelectors());
    }

    @Override
    protected void _audit(Context ctx, IObjectPK idSet) throws BOSException, EASBizException {
        BankDraftInfo bankDraftInfo = BankDraftFactory.getLocalInstance(ctx).getBankDraftInfo(idSet);
        if (null != bankDraftInfo) {
            if (bankDraftInfo.getBillState() != BankDraftEnum.REGISTED) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"6_BankDraftControllerBean", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException("selected bankDraftInfo is null!");
        }
        bankDraftInfo.setBillState(BankDraftEnum.AUDIT);
        this.updatePartial(ctx, (CoreBaseInfo)bankDraftInfo, this.getSelectors());
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billState");
        return sic;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            BankDraftInfo info = (BankDraftInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setFiVouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setFiVouchered(true);
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._update(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected String _getAccountView(Context ctx, String number) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select fid from T_BD_AccountView where fnumber = ?";
        String fid = null;
        try {
            conn = DBHelper.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, number);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                fid = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            try {
                BOSException bosException = new BOSException();
                bosException.setStackTrace(e.getStackTrace());
                logger.error((Object)"", (Throwable)e);
                throw bosException;
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        DBHelper.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return fid;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankDraftInfo info = (BankDraftInfo)model;
        info.setBillState(BankDraftEnum.SAVE);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((BankDraftInfo)model));
        IObjectPK pk = super._submit(ctx, model);
        NTHelper.updateFpItem(ctx, pk, "com.kingdee.eas.fm.nt.BankDraft");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((BankDraftInfo)model));
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BankDraftInfo info = (BankDraftInfo)model;
        info.setBillState(BankDraftEnum.REGISTED);
        if (null != info.getSourceBillId() && !info.getSourceBillId().equals("")) {
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        }
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((BankDraftInfo)model));
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        IObjectPK pk = super._submit(ctx, model);
        NTHelper.updateFpItem(ctx, pk, "com.kingdee.eas.fm.nt.BankDraft");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((BankDraftInfo)model));
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        this.rewriteSourceBill(ctx, (BankDraftInfo)model, true);
        return pk;
    }

    protected void rewriteSourceBill(Context ctx, BankDraftInfo info, boolean isAddNew) throws BOSException {
        String id = info.getSourceBillId();
        if (null != id && !id.trim().equals("")) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_NT_BankDraftReq set FIsDraw = ? where fid = '").append(id).append("'");
            if (isAddNew) {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{1});
            } else {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{0});
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BankDraftInfo info = BankDraftFactory.getLocalInstance(ctx).getBankDraftInfo(pk);
        if (null != info.getSourceBillId() && !info.getSourceBillId().equals("")) {
            NTHelper.OnWaybgCtrl(ctx, info.getSourceBillId());
        }
        NTHelper.cancelFpItem(ctx, pk.toString());
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        this.rewriteSourceBill(ctx, info, false);
        super._delete(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (int i = 0; i < arrayPK.length; ++i) {
            this._delete(ctx, arrayPK[i]);
        }
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK[])arrayPK);
        super._delete(ctx, arrayPK);
    }
}

