/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fm.nt.BankDraftBookNotifyBuilder;
import com.kingdee.eas.fm.nt.BankDraftCollection;
import com.kingdee.eas.fm.nt.BankDraftFactory;
import com.kingdee.eas.fm.nt.BankDraftInfo;
import com.kingdee.eas.fm.nt.app.AbstractBankDraftFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BankDraftFacadeControllerBean
extends AbstractBankDraftFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.BankDraftFacadeControllerBean");

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        BankDraftBookNotifyBuilder builder = new BankDraftBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_NT_BankDraft SET FChuna = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName();
        String billId = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            if (this.isBooked(ctx, billId)) continue;
            JournalCollection jcoll = builder.getJournalColl(ctx, billId);
            for (JournalInfo journal : jcoll) {
                journal.setCreateDate(journal.getBizDate());
            }
            journalColl.addCollection(jcoll);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
    }

    @Override
    protected void _antiBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_NT_BankDraft SET FChuna = NULL WHERE FID = ? ";
        String billId = null;
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        }
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        BankDraftCollection coll = BankDraftFactory.getLocalInstance(ctx).getBankDraftCollection(evi);
        BankDraftInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
        }
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }
}

