/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.nt.BillDisposerAction;
import com.kingdee.eas.fm.nt.ChequeAppRecFactory;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeBookNotifyBuilder;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeDisposerFacotry;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.IChequeAppRec;
import com.kingdee.eas.fm.nt.IChequeDisposer;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.TeleOrderBookBuilder;
import com.kingdee.eas.fm.nt.app.AbstractChequeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ChequeControllerBean
extends AbstractChequeControllerBean {
    @Override
    protected void _addBatch(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        ChequeCollection chequeCollection = (ChequeCollection)collection;
        if (chequeCollection.size() == 0) {
            return;
        }
        ChequeInfo info0 = chequeCollection.get(0);
        boolean rst = this.hasNumber(ctx, (CoreBaseInfo)info0, info0.getCompany().getId().toString());
        String batchSilent = "";
        if (rst) {
            batchSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info0, (String)info0.getCompany().getId().toString());
        }
        for (int i = 0; i < chequeCollection.size(); ++i) {
            ChequeInfo info = chequeCollection.get(i);
            if (info.isDistribute()) {
                if (info.getKeepCompany() == null && info.getKeepDepartment() == null && info.getKeeper() == null) {
                    FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"keepCompany");
                } else {
                    info.setState(ChequeStatusEnum.NEW);
                }
            } else {
                info.setState(ChequeStatusEnum.STORE);
            }
            info.setBookCurrency(info.getCurrency());
            info.setIsOwnReceive(info.getNtType().isIsCash());
            if (!FMHelper.isEmpty((String)batchSilent)) {
                info.setBatch(batchSilent);
            }
            this.addnew(ctx, (CoreBaseInfo)info);
        }
    }

    private boolean hasNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK == null || arrayPK.length <= 0) {
            return;
        }
        ChequeInfo info = this.getChequeInfo(ctx, " select id, batch where id = '" + arrayPK[0].getKeyValue("id") + "'");
        if (this._exists(ctx, " select id where (isAbandon=1 or  state not in(0,1)) and batch ='" + info.getBatch() + "'")) {
            throw new NTException(NTException.HAS_APPLY_CHEQUE);
        }
        super._delete(ctx, arrayPK);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    @Override
    protected void _vc(Context ctx, String id, IObjectValue journal) throws BOSException, EASBizException {
        JournalInfo journalInfo = (JournalInfo)journal;
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        ChequeInfo info = (ChequeInfo)this._getValue(ctx, (IObjectPK)pk);
        StringBuffer sqlUpdateJounal = new StringBuffer(128);
        sqlUpdateJounal.append(" update T_CAS_Journal set ");
        sqlUpdateJounal.append(" FTicketNumber = '").append(info.getNumber()).append("'");
        sqlUpdateJounal.append(" where fid ='").append(journalInfo.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sqlUpdateJounal.toString());
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_NT_Cheque set FIsVC = ").append(1).append(",");
        sql.append(" FJournalID = '").append(journalInfo.getId().toString()).append("'");
        sql.append(" where fid ='").append(id).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _antiVC(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("journal.*");
        sic.add("applyRec.*");
        ChequeInfo info = (ChequeInfo)this._getValue(ctx, (IObjectPK)pk, sic);
        String companyId = info.getCompany().getId().toString();
        String applyCompanyId = null;
        if (info.getApplyRec().getApplyCompany() != null) {
            applyCompanyId = info.getApplyRec().getApplyCompany().getId().toString();
        }
        String keepCompanyId = info.getKeepCompany().getId().toString();
        CompanyOrgUnitInfo cur = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (!(cur.getId().toString().equals(companyId) || cur.getId().toString().equals(applyCompanyId) || cur.getId().toString().equals(keepCompanyId))) {
            throw new NTException(NTException.NOT_CURRENT_COMPANY_CQ);
        }
        if (!info.isIsVC()) {
            throw new NTException(NTException.SELECT_VC_CQ);
        }
        if (info.getJournal() != null && info.getJournal().getBillId() != null && info.getJournal().getBillType() == BillTypeEnum.Cheque) {
            throw new NTException(NTException.NOTVCJOURNALBILLCHEQUE);
        }
        StringBuffer sqlUpdateJounal = new StringBuffer(128);
        sqlUpdateJounal.append(" update T_CAS_Journal set  ");
        sqlUpdateJounal.append(" FTicketNumber = null ");
        sqlUpdateJounal.append(" where fid ='").append(info.getJournal().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sqlUpdateJounal.toString());
        StringBuffer sql = new StringBuffer(128);
        sql.append(" update T_NT_Cheque set FIsVC = 0,");
        sql.append(" FJournalID = null ");
        sql.append(" where fid ='").append(id).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _antiApply(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChequeInfo info = (ChequeInfo)model;
        NTTypeGroupEnum ntGroup = NTTypeFactory.getLocalInstance(ctx).getGroup(info.getNtType().getId().toString());
        if (info.getPaymentBillNum() != null) {
            throw new NTException(NTException.REFTOPMTCANTDO);
        }
        if (ntGroup.equals((Object)NTTypeGroupEnum.TELE_ORDER)) {
            if (info.getPaymentBillNum() != null) {
                throw new NTException(NTException.HASLINKBILL);
            }
            if (info.getJournal() != null) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"22_ChequeControllerBean", (Locale)ctx.getLocale())});
            }
            if (info.isIsVC()) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"23_ChequeControllerBean", (Locale)ctx.getLocale())});
            }
        }
        StringBuffer sql = new StringBuffer(1024);
        sql.append(" update T_NT_Cheque set FState = ").append(1).append(",");
        sql.append(" FApplyRecID = null, ");
        sql.append(" FUsage = null, ");
        sql.append(" FFeeType = null, ");
        sql.append(" FProjectID = null, ");
        sql.append(" FTurnInAcctBankID = null, ");
        sql.append(" FOppAccountID = null, ");
        sql.append(" FProjectManagerID = null, ");
        sql.append(" FPayeeAcctBank = null, ");
        sql.append(" FPayeeAcctNumber = null, ");
        sql.append(" FPayeeName = null, ");
        sql.append(" FIssueDate = null, ");
        sql.append(" FExpiredDate = null, ");
        sql.append(" FIsApply = 0 ,");
        sql.append(" FIsOwnReceive = 0 ,");
        sql.append(" FFeeTypeID = null ,");
        sql.append(" FIsTransfer = 0 ,");
        sql.append(" FPassword = null ,");
        sql.append(" FActualBankAcctID = null ,");
        sql.append(" FBankAcctID = FBankAcctDistrID,");
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getBankAcctDistr())) {
            sql.append(" FCurrencyID = null,");
        } else {
            AccountBankInfo acct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getBankAcctDistr().getId()));
            if (acct.getCurrency() == null) {
                sql.append(" FCurrencyID = null, ");
            } else {
                sql.append(" FCurrencyID = '");
                sql.append(acct.getCurrency().getId().toString() + "', ");
            }
        }
        if (ntGroup.equals((Object)NTTypeGroupEnum.CHEQUE)) {
            sql.append("  FIsQuota= 0 , ");
            sql.append("Famount=null ");
        } else if (ntGroup.equals((Object)NTTypeGroupEnum.TELE_ORDER)) {
            sql.append("FRemitOutAddr1ID = null,");
            sql.append("FRemitOutAddr2ID = null,");
            sql.append("FRemitInAddr1ID = null,");
            sql.append("FRemitInAddr2ID = null,");
            sql.append("FRemitInName1 = null,");
            sql.append("FRemitInName2 = null,");
            sql.append("Famount = null ");
        }
        sql.append(" where fid ='").append(info.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer deleteSql = new StringBuffer(128);
        deleteSql.append(" delete from T_NT_ChequeAppRec where fid ='").append(info.getApplyRec().getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
    }

    @Override
    protected void _apply(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        ChequeCollection chequeCollection = (ChequeCollection)collection;
        for (int j = 0; j < chequeCollection.size(); ++j) {
            ChequeInfo info = chequeCollection.get(j);
            this.applyCheque(ctx, info);
        }
    }

    @Override
    protected void _cancelWriteOff(Context ctx, Set ids) throws BOSException, EASBizException {
        ChequeInfo info;
        int i;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("cashier", null));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        ev.getSelector().add(new SelectorItemInfo("applyRec.*"));
        ChequeCollection coll = this.getChequeCollection(ctx, ev);
        if (coll == null || coll.size() == 0) {
            throw new NTException(NTException.NOT_FOR_CANCELWRITEOFF);
        }
        HashSet<String> appRecId = new HashSet<String>();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getPaymentBillNum() != null) {
                throw new NTException(NTException.REFTOPMTCANTDO);
            }
            if (info.isIsApply()) {
                info.setState(ChequeStatusEnum.APPLIED);
                info.setAmount(Constants.ZERO);
                info.setCapitalization(null);
                info.setUsage(null);
                info.setDescription(null);
                info.setCurrency(info.getBookCurrency());
                continue;
            }
            info.setState(ChequeStatusEnum.NEW);
            info.setIssueDate(null);
            info.setExpiredDate(null);
            info.setAmount(Constants.ZERO);
            info.setCapitalization(null);
            info.setPayeeName(null);
            info.setUsage(null);
            info.setDescription(null);
            info.setCurrency(info.getBookCurrency());
            info.setProject(null);
            info.setProjectManager(null);
            info.put("feeType", null);
            info.setPayeeAcctBank(null);
            info.setPayeeAcctNumber(null);
            info.setOppAccount(null);
            if (info.getApplyRec() == null) continue;
            appRecId.add(info.getApplyRec().getId().toString());
            info.setApplyRec(null);
        }
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            Set set = FMHelper.getSrcBillIdSet((Context)ctx, (String)info.getId().toString());
            Iterator it = set.iterator();
            while (it.hasNext()) {
                this.dispose(ctx, (String)it.next(), info, "antiWriteOff");
            }
            iBOTRelation.removeRelationByDestObjId(info.getId().toString(), null);
            iBOTRelation.removeRelationBySrcObjId(info.getId().toString(), null);
            this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        }
        if (appRecId.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("delete from T_NT_ChequeAppRec where ");
            sb.append(FMHelper.buildIn((String)"fid", (Object[])appRecId.toArray()));
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    @Override
    protected void _writeOff(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChequeCollection coll = new ChequeCollection();
        coll.addObject(model);
        this._reimburse(ctx, (IObjectCollection)coll);
    }

    @Override
    protected void _writeOff(Context ctx, IObjectValue model, List srcBillIdList) throws BOSException, EASBizException {
        ChequeInfo info = (ChequeInfo)model;
        ChequeInfo old = this.getChequeInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        if (old.getState().equals((Object)ChequeStatusEnum.WRITTEN_OFF)) {
            String methoName = "writeOff";
            BOSObjectType type = info.getBOSType();
            FMHelper.throwCanNotExcMethod((Context)ctx, (String)methoName, (BOSObjectType)type);
        }
        this._writeOff(ctx, model);
        FMHelper.saveBOTRelation((Context)ctx, (List)srcBillIdList, (String)info.getId().toString());
    }

    private void dispose(Context ctx, String srcBillId, ChequeInfo info, String actionType) throws BOSException, EASBizException {
        IChequeDisposer disposer = ChequeDisposerFacotry.getInstance(ctx, srcBillId);
        if (disposer != null) {
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setSrcBillPk((IObjectPK)new ObjectUuidPK(srcBillId));
            disposerAction.setDestBill((IObjectValue)info);
            disposerAction.setActionType(actionType);
            disposer.dispose(ctx, disposerAction);
        }
    }

    @Override
    protected void _abandon(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ChequeInfo cheque = (ChequeInfo)model;
        cheque.setAbandonState(cheque.getState());
        cheque.setState(ChequeStatusEnum.Canceled);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _antiAbandon(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ChequeInfo cheque = (ChequeInfo)model;
        cheque.setState(cheque.getAbandonState());
        cheque.setNull("abandonState");
        super._update(ctx, pk, model);
    }

    @Override
    protected void _distribute(Context ctx, String[] ids, String departmentId, String keeperId, String companyId, String bankAcctId, boolean batch) throws BOSException, EASBizException {
        try {
            ids = this.getids(ctx, ids, batch);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String idsql = FMHelper.Array2String((String[])ids);
        StringBuffer sql = new StringBuffer();
        if (bankAcctId == null) {
            sql.append("update T_NT_Cheque set ");
            sql.append(this.getDistributeFieldSql(departmentId, keeperId, companyId));
            sql.append("FBankAcctDistrID=null,FState=1 where fid in " + idsql);
        } else {
            sql.append("update T_NT_Cheque set ");
            sql.append(this.getDistributeFieldSql(departmentId, keeperId, companyId));
            sql.append("FBankAcctID='" + bankAcctId + "',FBankAcctDistrID='" + bankAcctId + "',FState=1");
            AccountBankInfo acct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAcctId));
            if (acct.getCurrency() != null) {
                String currency = acct.getCurrency().getId().toString();
                sql.append(",FCurrencyID='" + currency + "'");
            }
            if (acct.getBank() != null) {
                String bank = acct.getBank().getId().toString();
                sql.append(",FBankID='" + bank + "'");
            }
            sql.append(" where fid in " + idsql);
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getDistributeFieldSql(String departmentId, String keeperId, String companyId) {
        StringBuffer sql = new StringBuffer();
        if (departmentId != null) {
            sql.append("FKeepDepartmentID='" + departmentId + "',");
        } else {
            sql.append("FKeepDepartmentID=null,");
        }
        if (keeperId != null) {
            sql.append("FKeeperID='" + keeperId + "',");
        } else {
            sql.append("FKeeperID=null,");
        }
        if (companyId != null) {
            sql.append("FKeepCompanyID='" + companyId + "',");
        } else {
            sql.append("FKeepCompanyID=null,");
        }
        return sql.toString();
    }

    private String[] getids(Context ctx, String[] ids, boolean batch) throws BOSException, EASBizException, SQLException {
        int i;
        if (batch) {
            String idsql = FMHelper.Array2String((String[])ids);
            String sql = "select fid from t_nt_cheque where fbatch in (select distinct FBatch from T_NT_Cheque where FID in " + idsql + ")";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            ids = new String[set.size()];
            i = 0;
            while (set.next()) {
                ids[i++] = set.getString("fid");
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ChequeCollection coll = this.getChequeCollection(ctx, view);
        for (i = 0; i < coll.size(); ++i) {
            ChequeInfo info = coll.get(i);
            if (info.isIsAbandon()) {
                throw new NTException(NTException.HAS_CANCEL);
            }
            if (info.getState() == ChequeStatusEnum.STORE) continue;
            throw new NTException(NTException.HAS_NO_USED);
        }
        return ids;
    }

    @Override
    protected void _book(Context ctx, Set ids) throws BOSException, EASBizException {
        FilterInfo chequeFilter = new FilterInfo();
        chequeFilter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        chequeFilter.getFilterItems().add(new FilterItemInfo("cashier", null));
        chequeFilter.getFilterItems().add(new FilterItemInfo("PaymentBillNum", null));
        chequeFilter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        chequeFilter.getFilterItems().add(new FilterItemInfo("ntType.group", (Object)new Integer(1)));
        EntityViewInfo chequeEvi = new EntityViewInfo();
        chequeEvi.setFilter(chequeFilter);
        ChequeCollection chequeColl = this.getChequeCollection(ctx, chequeEvi);
        FilterInfo teleFilter = new FilterInfo();
        teleFilter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        teleFilter.getFilterItems().add(new FilterItemInfo("cashier", null));
        teleFilter.getFilterItems().add(new FilterItemInfo("PaymentBillNum", null));
        teleFilter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        teleFilter.getFilterItems().add(new FilterItemInfo("ntType.group", (Object)new Integer(11)));
        EntityViewInfo teleEvi = new EntityViewInfo();
        teleEvi.setFilter(teleFilter);
        ChequeCollection teleColl = this.getChequeCollection(ctx, teleEvi);
        if (!(chequeColl != null && chequeColl.size() != 0 || teleColl != null && teleColl.size() != 0)) {
            throw new NTException(NTException.NOT_FOR_BOOK);
        }
        String userid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String sql = "UPDATE T_NT_Cheque SET fcashierid = ?, FJournalID=? ,FisVC = 1 WHERE fid=?";
        if (chequeColl != null && chequeColl.size() > 0) {
            for (int i = 0; i < chequeColl.size(); ++i) {
                String id = chequeColl.get(i).getId().toString();
                ChequeBookNotifyBuilder builder = new ChequeBookNotifyBuilder();
                JournalCollection journalColl = builder.getJournalColl(ctx, id);
                JournalInfo journalInfo = journalColl.get(0);
                String jouranlid = journalInfo.getId().toString();
                IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
                int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(journalInfo.getCompany().getId()));
                if (val != 0) {
                    throw new NTException(NTException.BOOKONLYBYBILL);
                }
                BookNotifyFacadeFactory.getLocalInstance((Context)ctx).bookBatch(journalColl);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userid, jouranlid, id});
            }
        }
        String telsql = "UPDATE T_NT_Cheque SET fcashierid = ?, FJournalID=? WHERE fid=?";
        if (teleColl != null && teleColl.size() > 0) {
            for (int i = 0; i < teleColl.size(); ++i) {
                String id = teleColl.get(i).getId().toString();
                TeleOrderBookBuilder builder = new TeleOrderBookBuilder();
                JournalCollection journalColl = builder.getJournalColl(ctx, id);
                JournalInfo journalInfo = journalColl.get(0);
                String jouranlid = journalInfo.getId().toString();
                IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
                int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(journalInfo.getCompany().getId()));
                if (val != 0) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"24_ChequeControllerBean", (Locale)ctx.getLocale())});
                }
                BookNotifyFacadeFactory.getLocalInstance((Context)ctx).bookBatch(journalColl);
                DbUtil.execute((Context)ctx, (String)telsql, (Object[])new Object[]{userid, jouranlid, id});
            }
        }
    }

    @Override
    protected void _cancelBook(Context ctx, Set ids) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("*");
        ev.getSelector().add("journal.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("cashier", null, CompareType.NOTEQUALS));
        ev.setFilter(filter);
        ChequeCollection coll = this.getChequeCollection(ctx, ev);
        if (coll == null || coll.size() == 0) {
            throw new NTException(NTException.NOT_FOR_CANCELBOOK);
        }
        ids.clear();
        for (int i = 0; i < coll.size(); ++i) {
            ChequeInfo info = coll.get(i);
            String chequeId = info.getId().toString();
            Set srcBill = FMHelper.getSrcBillIdSet((Context)ctx, (String)chequeId);
            if (srcBill != null && srcBill.size() > 0) {
                Iterator it = srcBill.iterator();
                String src = (String)it.next();
                BOSObjectType srcType = BOSUuid.read((String)src).getType();
                PaymentBillInfo pay = new PaymentBillInfo();
                SettlementBillInfo sett = new SettlementBillInfo();
                if (srcType.equals((Object)pay.getBOSType())) {
                    this.checkPaymentBill(ctx, chequeId);
                }
                if (srcType.equals((Object)sett.getBOSType())) {
                    this.checkSettlementBill(ctx, chequeId);
                }
            }
            ids.add(info.getId().toString());
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("UPDATE T_NT_Cheque SET fcashierid = null, FJournalID=null ,FisVC = 0  WHERE fid=?");
        for (String id : ids) {
            BookNotifyFacadeFactory.getLocalInstance((Context)ctx).antiBook(id);
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{id});
        }
    }

    private void checkPaymentBill(Context ctx, String chequeId) throws BOSException, EASBizException {
        String sql = "SELECT top 1 * FROM T_CAS_PaymentBill WHERE (FBillStatus = ?) and FChequeId=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(15), chequeId});
        try {
            if (rs.next()) {
                throw new NTException(NTException.REL_BILL_PAYED);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkSettlementBill(Context ctx, String chequeId) throws BOSException, EASBizException {
        String sql = "SELECT top 1 * FROM T_FS_SettlementBill  WHERE (fcashierid is not null) and FChequeId=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{chequeId});
        try {
            if (rs.next()) {
                throw new NTException(NTException.REL_BILL_PAYED);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ChequeInfo dbInfo;
        String paymentBillNum;
        ChequeInfo info = (ChequeInfo)model;
        if (info.isWriteOffEdit() && (paymentBillNum = (dbInfo = this.getChequeInfo(ctx, pk)).getPaymentBillNum()) != null) {
            throw new NTException(NTException.ALREADYPAY, new Object[]{paymentBillNum});
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _batchCancelDistribute(Context ctx, String id) throws BOSException, EASBizException {
        ChequeInfo vo = this.getChequeInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("batch", (Object)vo.getBatch()));
        view.setFilter(filter);
        ChequeCollection coll = this.getChequeCollection(ctx, view);
        HashSet<String> ids = new HashSet<String>();
        ids.clear();
        for (int i = 0; i < coll.size(); ++i) {
            ChequeInfo info = coll.get(i);
            if (info.isIsAbandon()) {
                throw new NTException(NTException.HAS_CANCEL);
            }
            if (info.getState() != ChequeStatusEnum.NEW) {
                throw new NTException(NTException.HAS_NO_USED);
            }
            ids.add(info.getId().toString());
            StringBuffer sb = new StringBuffer(256);
            sb.append("update T_NT_Cheque set FBankAcctID=FBankAcctOldID,FKeepCompanyID= null,FKeepDepartmentID= null,FKeeperID = null , ");
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getBankAcctOld())) {
                sb.append(" FCurrencyID = null,");
            } else {
                AccountBankInfo acct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getBankAcctDistr().getId()));
                sb.append(" FCurrencyID = '");
                sb.append(acct.getCurrency().getId().toString() + "', ");
            }
            sb.append("fstate=0  where ");
            sb.append("fid='" + info.getId().toString() + "' ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    @Override
    protected void _cancelDistribute(Context ctx, Set ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isAbandon", (Object)Constants.FALSE));
        view.setFilter(filter);
        ChequeCollection coll = this.getChequeCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            throw new NTException(NTException.NOT_FOR_CANCELDES);
        }
        ids.clear();
        for (int i = 0; i < coll.size(); ++i) {
            ChequeInfo info = coll.get(i);
            StringBuffer sb = new StringBuffer(256);
            sb.append("update T_NT_Cheque set FBankAcctID=FBankAcctOldID,FBankAcctDistrID=FBankAcctOldID,");
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getBankAcctOld())) {
                sb.append(" FCurrencyID = null,");
            } else {
                AccountBankInfo acct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getBankAcctDistr().getId()));
                if (acct.getCurrency() != null) {
                    sb.append(" FCurrencyID = '").append(acct.getCurrency().getId().toString() + "', ");
                }
            }
            sb.append("fstate=0  where ");
            sb.append("fid='" + info.getId().toString() + "' ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    @Override
    protected boolean _checkDup(Context ctx, String[] number, BOSUuid bankAcct, BOSUuid companyId, BOSUuid ntType) throws BOSException, EASBizException {
        IContextHelper helper = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean bySettleNumber = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT002", (IObjectPK)new ObjectUuidPK(helper.getCurrentCompany().getId()));
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < number.length; ++i) {
            list.add(number[i]);
        }
        FilterInfo filter = new FilterInfo();
        if (bySettleNumber) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId.toString()));
            filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)ntType.toString()));
            if (null != bankAcct) {
                filter.getFilterItems().add(new FilterItemInfo("bankAcct.id", (Object)bankAcct.toString()));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("number", list, CompareType.INCLUDE));
        return this._exists(ctx, filter);
    }

    public static PaymentBillInfo getDefaultPaymentBillInfo(Context ctx, String Number2) throws LoanException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("Number", (Object)Number2, CompareType.EQUALS));
        vi.setFilter(fInfo);
        PaymentBillCollection bftCollection = null;
        bftCollection = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(vi);
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        PaymentBillInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }

    @Override
    protected void _updateCheque(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ChequeInfo cheque = (ChequeInfo)model;
        if (!cheque.isIsQuota()) {
            cheque.setNull("sealSymbol");
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _reimburse(Context ctx, IObjectCollection model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        ChequeCollection chequeCollection = (ChequeCollection)model;
        if (chequeCollection.size() <= 0) {
            return;
        }
        IChequeAppRec iRec = ChequeAppRecFactory.getLocalInstance(ctx);
        for (int i = 0; i < chequeCollection.size(); ++i) {
            ChequeInfo cheque = chequeCollection.get(i);
            if (cheque.getPaymentBillNum() != null && (cheque.isIsVC() || ChequeStatusEnum.WRITTEN_OFF.equals((Object)cheque.getState()))) {
                throw new NTException(NTException.REFTOPMTCANTDO);
            }
            if (cheque.getState().equals((Object)ChequeStatusEnum.NEW)) {
                IObjectPK pk = iRec.addnew((CoreBaseInfo)cheque.getApplyRec());
                cheque.getApplyRec().setId(BOSUuid.read((String)pk.toString()));
            }
            cheque.setState(ChequeStatusEnum.WRITTEN_OFF);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cheque.getId().toString())), (CoreBaseInfo)cheque);
            iRec.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cheque.getApplyRec().getId().toString())), (CoreBaseInfo)cheque.getApplyRec());
        }
    }

    @Override
    protected void _antiReimburse(Context ctx, Set model) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model, CompareType.INCLUDE));
        view.setFilter(filter);
        ChequeCollection chequeCollection = ChequeFactory.getLocalInstance(ctx).getChequeCollection(view);
        HashSet<String> deleteRecIDs = new HashSet<String>();
        for (int i = 0; i < chequeCollection.size(); ++i) {
            ChequeInfo cheque = chequeCollection.get(i);
            if (cheque.isIsApply()) {
                cheque.setState(ChequeStatusEnum.APPLIED);
                if (cheque.isIsQuota()) {
                    cheque.setAmount(null);
                    cheque.setCapitalization(null);
                    if (cheque.getApplyRec() != null) {
                        IChequeAppRec rec = ChequeAppRecFactory.getLocalInstance(ctx);
                        ObjectUuidPK pk = new ObjectUuidPK(cheque.getApplyRec().getId());
                        ChequeAppRecInfo recInfo = rec.getChequeAppRecInfo((IObjectPK)pk);
                        recInfo.setReimburser(null);
                        rec.update((IObjectPK)pk, (CoreBaseInfo)recInfo);
                    }
                }
            } else {
                cheque.setState(ChequeStatusEnum.NEW);
                cheque.setBankAcct(cheque.getBankAcctDistr());
                deleteRecIDs.add(cheque.getApplyRec().getId().toString());
                cheque.setApplyRec(null);
                cheque.setAmount(null);
                cheque.setCapitalization(null);
                cheque.setIssueDate(null);
                cheque.setUsage(null);
                cheque.setActualBankAcct(null);
                cheque.setCurrency(cheque.getBookCurrency());
            }
            cheque.setReimburseDate(null);
            cheque.setIsOwnReceive(cheque.getNtType().isIsCash());
            cheque.setIsTransfer(false);
            cheque.setIsLineation(false);
            cheque.setPayeeName(null);
            cheque.setPayeeAcctBank(null);
            cheque.setPayeeAcctNumber(null);
            cheque.setFeeTypeID(null);
            cheque.setTurnInAcctBank(null);
            cheque.setOppAccount(null);
            cheque.setProject(null);
            cheque.setProjectManager(null);
            cheque.setPassword(null);
            cheque.setDescription(null);
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            Set set = FMHelper.getSrcBillIdSet((Context)ctx, (String)cheque.getId().toString());
            Iterator it = set.iterator();
            while (it.hasNext()) {
                this.dispose(ctx, (String)it.next(), cheque, "antiWriteOff");
            }
            iBOTRelation.removeRelationByDestObjId(cheque.getId().toString(), null);
            iBOTRelation.removeRelationBySrcObjId(cheque.getId().toString(), null);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cheque.getId().toString())), (CoreBaseInfo)cheque);
        }
        if (deleteRecIDs.isEmpty()) {
            return;
        }
        FilterInfo filterID = new FilterInfo();
        filterID.getFilterItems().add(new FilterItemInfo("id", deleteRecIDs, CompareType.INCLUDE));
        ChequeAppRecFactory.getLocalInstance(ctx).delete(filterID);
    }

    @Override
    protected void _abandon(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ChequeCollection chequeCollection = ChequeFactory.getLocalInstance(ctx).getChequeCollection(view);
        for (int i = 0; i < chequeCollection.size(); ++i) {
            ChequeInfo cheque = chequeCollection.get(i);
            cheque.setAbandonDate(new Date());
            cheque.setAbandonState(cheque.getState());
            cheque.setState(ChequeStatusEnum.Canceled);
            super.updateCheque(ctx, (IObjectPK)new ObjectUuidPK(cheque.getId().toString()), (IObjectValue)cheque);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectPK auditorID) throws BOSException, EASBizException {
        ChequeInfo info;
        if (pk == null) {
            return;
        }
        if (auditorID == null) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            auditorID = new ObjectUuidPK(userInfo.getId());
        }
        if (((info = this.getChequeInfo(ctx, pk)).getState().equals((Object)ChequeStatusEnum.APPLIED) || info.getState().equals((Object)ChequeStatusEnum.APPLYING)) && !info.isIsAudit()) {
            CompanyOrgUnitInfo com;
            IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
            boolean needAudit = localInstance.getBooleanParam("NT029", (IObjectPK)new ObjectUuidPK((com = localInstance.getCurrentCompany()).getId()));
            if (!needAudit) {
                throw new NTException(NTException.CHEQUEAUDITPARAMERROR);
            }
        } else {
            throw new NTException(NTException.CHEQUEAUDITERROR);
        }
        info.setIsApply(true);
        info.setState(ChequeStatusEnum.APPLIED);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
        String sql = "update T_NT_Cheque set FIsAudit = 1 where FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        sql = "update T_NT_ChequeAppRec set FAuditorID = ? where FID = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{auditorID.toString(), info.getApplyRec().getId().toString()});
    }

    @Override
    protected void _cancelAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompanyOrgUnitInfo com;
        if (pk == null) {
            return;
        }
        ChequeInfo info = this.getChequeInfo(ctx, pk);
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean needAudit = localInstance.getBooleanParam("NT029", (IObjectPK)new ObjectUuidPK((com = localInstance.getCurrentCompany()).getId()));
        if (needAudit) {
            info.setIsApply(false);
            info.setState(ChequeStatusEnum.APPLYING);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
        }
        if ((info.getState().equals((Object)ChequeStatusEnum.APPLIED) || info.getState().equals((Object)ChequeStatusEnum.APPLYING)) && info.isIsAudit()) {
            String sql = "update T_NT_Cheque set FIsAudit = 0 where FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            if (info.getApplyRec() != null) {
                sql = "update T_NT_ChequeAppRec set FAuditorID = null where FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getApplyRec().getId().toString()});
            }
        } else {
            throw new NTException(NTException.CHEQUECANCELAUDITERROR);
        }
    }

    @Override
    protected void _applyCheque(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IChequeAppRec iRec = ChequeAppRecFactory.getLocalInstance(ctx);
        ChequeInfo info = (ChequeInfo)model;
        if (info.getState() != ChequeStatusEnum.NEW && info.getState() != ChequeStatusEnum.APPLIED) {
            throw new NTException(NTException.SELECT_BLANK_CHEQUE);
        }
        iRec.save((CoreBaseInfo)info.getApplyRec());
        IContextHelper helper = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean needAudit = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT029", (IObjectPK)new ObjectUuidPK(helper.getCurrentCompany().getId()));
        if (needAudit) {
            info.setState(ChequeStatusEnum.APPLYING);
        } else {
            info.setIsApply(true);
            info.setState(ChequeStatusEnum.APPLIED);
        }
        this.submit(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
    }
}

