/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class DiscountBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    private SelectorItemCollection getEndorseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("CU.id");
        sic.add("DiscountBank.*");
        return sic;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        DiscountBillInfo disBillInfo = DiscountBillFactory.getLocalInstance(ctx).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getEndorseSelector());
        if (disBillInfo.getRecvAccount() == null) {
            return null;
        }
        JournalInfo jnInfo = new JournalInfo();
        String s = disBillInfo.getNoteBillNumber();
        if (s.length() > 80) {
            s = s.substring(0, 75) + "...";
        }
        jnInfo.setAccountView(disBillInfo.getRecvAccountView());
        jnInfo.setAccountBank(disBillInfo.getRecvAccount());
        jnInfo.setCurrency(disBillInfo.getCurrency());
        jnInfo.setCreateDate(disBillInfo.getDiscountDate());
        if (disBillInfo.getPayablebill() != null) {
            jnInfo.setIsDebit(false);
            jnInfo.setCreditAmount(disBillInfo.getActDiscountInt());
        } else {
            jnInfo.setIsDebit(true);
            jnInfo.setDebitAmount(disBillInfo.getActRecvAmount());
        }
        jnInfo.setSettlementType(this.getSettlementType(ctx, disBillInfo));
        jnInfo.setSettlementNumber(s);
        jnInfo.setBizDate(disBillInfo.getDiscountDate());
        jnInfo.setOppAccountView(disBillInfo.getRecvAccountView());
        jnInfo.setOppUnit(disBillInfo.getDiscountBank().getName());
        jnInfo.setBillType(BillTypeEnum.DiscountBill);
        jnInfo.setBillNumber(s);
        jnInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"25_DiscountBillBookNotifyBuilder", (Locale)ctx.getLocale()));
        jnInfo.setBillId(disBillInfo.getId().toString());
        jnInfo.setType(JournalTypeEnum.BANK);
        jnInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        jnInfo.setCompany(disBillInfo.getCompany());
        jnInfo.setCU(disBillInfo.getCompany().getCU());
        jnInfo.setCashier(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        jnInfo.setSource(JournalSourceEnum.BYBILL);
        JournalCollection jnColl = new JournalCollection();
        jnColl.add(jnInfo);
        return jnColl;
    }

    private SettlementTypeInfo getSettlementType(Context ctx, DiscountBillInfo discountBill) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (discountBill.getReceivablebill() != null) {
            filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)"33333333-3333-3333-3333-3333333333331C9A9013"));
        } else if (discountBill.getPayablebill() != null) {
            filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)"66666666-6666-6666-6666-6666666666661C9A9013"));
        }
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        return type;
    }
}

