/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.DiscountApplyBillFactory;
import com.kingdee.eas.fm.nt.DiscountApplyBillInfo;
import com.kingdee.eas.fm.nt.DiscountBillCollection;
import com.kingdee.eas.fm.nt.DiscountBillEntryCollection;
import com.kingdee.eas.fm.nt.DiscountBillEntryInfo;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.DiscountBillStateEnum;
import com.kingdee.eas.fm.nt.DiscountTypeEnum;
import com.kingdee.eas.fm.nt.IDiscountBill;
import com.kingdee.eas.fm.nt.NTFacadeFactory;
import com.kingdee.eas.fm.nt.PayableException;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.AbstractDiscountBillWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DiscountBillWebFacadeControllerBean
extends AbstractDiscountBillWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.DiscountBillWebFacadeControllerBean");

    private IDiscountBill getBizInterface(Context ctx) throws BOSException {
        return DiscountBillFactory.getLocalInstance(ctx);
    }

    @Override
    protected Map _submit(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        DiscountBillInfo discountInfo = (DiscountBillInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)map.get("model").toString(), DiscountBillInfo.class);
        boolean isCreateRecOrPay = (Boolean)map.get("isCreateRecOrPay");
        String discountApplyBillId = (String)map.get("discountApplyBillId");
        if (!EmptyUtil.isEmpty((String)discountApplyBillId)) {
            discountInfo.setSourceBillId(discountApplyBillId);
        }
        CoreBaseCollection objColl = this.createReceivableDiscount(ctx, discountInfo, discountApplyBillId);
        try {
            this.getBizInterface(ctx).batchDiscount((IObjectCollection)objColl, isCreateRecOrPay);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", DiscountBillWebFacadeControllerBean.getResource(ctx, "236_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    private CoreBaseCollection createReceivableDiscount(Context ctx, DiscountBillInfo discountInfo, String discountApplyBillId) throws EASBizException, BOSException {
        DiscountBillEntryCollection entryColl = discountInfo.getEntrys();
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        DiscountBillInfo info = discountInfo;
        info.setBillAmount(BigDecimal.ZERO);
        info.setDiscountInt(BigDecimal.ZERO);
        info.setActDiscountInt(BigDecimal.ZERO);
        info.setDiscountLocInt(BigDecimal.ZERO);
        info.setActRecvAmount(BigDecimal.ZERO);
        info.setActRecvLocAmount(BigDecimal.ZERO);
        for (int i = 0; i < entryColl.size(); ++i) {
            DiscountBillEntryInfo entryInfo = entryColl.get(i);
            entryInfo.setId(null);
            idSet.add(entryInfo.getReceivableBill().getId());
            info.setBillAmount(info.getBillAmount().add(entryInfo.getReceivableBill().getBillAmt()));
            info.setDiscountInt(info.getDiscountInt().add(entryInfo.getDiscountInt()));
            info.setActDiscountInt(info.getActDiscountInt().add(entryInfo.getActDiscountInt()));
            entryInfo.setDiscountLocInt(entryInfo.getActDiscountInt().multiply(entryInfo.getReceivableBill().getExchangeRate()));
            info.setDiscountLocInt(info.getDiscountLocInt().add(entryInfo.getDiscountLocInt()));
            info.setActRecvAmount(info.getActRecvAmount().add(entryInfo.getActRecvAmount()));
            entryInfo.setActRecvLocAmount(entryInfo.getActRecvAmount().multiply(entryInfo.getReceivableBill().getExchangeRate()));
            info.setActRecvLocAmount(info.getActRecvLocAmount().add(entryInfo.getActRecvLocAmount()));
        }
        ReceivableBillCollection recColls = this.getReceivableBillCollByIdSet(ctx, idSet);
        info.setSource(recColls.get(0).getSource());
        this.buildHeader(ctx, info, recColls, discountApplyBillId);
        info.setLocalAmount(info.getBillAmount().multiply(info.getExRate()));
        ReceivableBillInfo receivableInfo = info.getEntrys().get(0).getReceivableBill();
        if (receivableInfo != null && !EmptyUtil.isEmpty((String)receivableInfo.getPayeeBankNum())) {
            info.setPasterBankNum(receivableInfo.getPayeeBankNum());
        }
        CoreBaseCollection objColl = new CoreBaseCollection();
        objColl.add((CoreBaseInfo)info);
        return objColl;
    }

    private void buildHeader(Context ctx, DiscountBillInfo info, ReceivableBillCollection recColls, String discountApplyBillId) throws EASBizException, BOSException {
        BOSObjectType bosTypeRec = new ReceivableBillInfo().getBOSType();
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (recColls.get(0).getId().getType().equals((Object)bosTypeRec)) {
            info.setIsWFAudit(true);
            info.setReceivablebill(recColls.get(0));
        } else {
            info.setIsWFAudit(false);
        }
        info.setCreateTime(DateUtil.getTimeStampDayBegin());
        info.setCreator(currentUser);
        if (EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            info.setSourceBillId(recColls.get(0).getId().toString());
        }
        info.setNoteBillNumber(recColls.get(0).getNumber());
        info.setCurrency(recColls.get(0).getCurrency());
        if (info.getRecvAccount() != null) {
            info.setRecvAccountView(info.getRecvAccount().getAccount());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String s = sdf.format(info.getDiscountDate());
            info.setDiscountDate(sdf.parse(s));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        info.setMaturityDate(recColls.get(0).getExpiredDate());
        info.setIssureDate(recColls.get(0).getIssuesDate());
        info.setExRate(recColls.get(0).getExchangeRate());
        info.setDeliver(recColls.get(0).getDeliver());
        if (info.getDiscountBank() != null && info.getDiscountBank().isInGroup()) {
            info.setType(DiscountTypeEnum.In);
        } else {
            info.setType(DiscountTypeEnum.Out);
        }
        info.setBillState(DiscountBillStateEnum.NEWSTATE);
        if (info.getReceivablebill() != null) {
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("holderAccount.*"));
            selColl.add(new SelectorItemInfo("holderAccount.bank.*"));
            ReceivableBillInfo recInfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(info.getReceivablebill().getId()), selColl);
            if (recInfo.getHolderAccount() != null) {
                info.setDiscountApplierAcctNum(recInfo.getHolderAccount().getBankAccountNumber());
                BankInfo bank = recInfo.getHolderAccount().getBank();
                if (bank.getAccountBank() != null) {
                    BEBankInfo beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bank.getAccountBank().getId()));
                    if (beInfo != null) {
                        info.setDiscountApplierBankNum(beInfo.getNumber());
                    }
                } else {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    String name = recInfo.getHolderAccount().getBank().getName();
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)(name + "%"), CompareType.LIKE));
                    view.setFilter(filter);
                    BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
                    if (coll.size() > 0) {
                        info.setDiscountApplierBankNum(coll.get(0).getNumber());
                    }
                }
            }
        }
        if (info.getRecvAccount() != null) {
            AccountBankInfo acctBankInfo = info.getRecvAccount();
            BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getBank().getId()));
            if (bankInfo.getAccountBank() != null) {
                BEBankInfo beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                if (beInfo != null) {
                    info.setPasterBankNum(beInfo.getNumber());
                }
            } else {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                String bankName = bankInfo.getName();
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)(bankName + "%"), CompareType.LIKE));
                viewInfo.setFilter(filterInfo);
                BEBankCollection beColl = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(viewInfo);
                if (beColl.size() > 0) {
                    info.setPasterBankNum(beColl.get(0).getNumber());
                }
            }
        }
        if (!EmptyUtil.isEmpty((String)discountApplyBillId)) {
            DiscountApplyBillInfo discountApplyBillInfo = DiscountApplyBillFactory.getLocalInstance(ctx).getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(discountApplyBillId));
            info.setDiscountApplyBill(discountApplyBillInfo);
        }
    }

    private ReceivableBillCollection getReceivableBillCollByIdSet(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(sic);
        return ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillCollection(entityViewInfo);
    }

    @Override
    protected Map _batchGather(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)map.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            DiscountBillCollection colls = this.getDisBillColl(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                DiscountBillInfo billInfo = colls.get(i);
                try {
                    this.relaGather(ctx, billInfo);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(DiscountBillWebFacadeControllerBean.getResource(ctx, "237_ReceivableBill", new String[]{billInfo.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(DiscountBillWebFacadeControllerBean.getResource(ctx, "238_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? DiscountBillWebFacadeControllerBean.getResource(ctx, "239_ReceivableBill", null) : summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "240_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void relaGather(Context ctx, DiscountBillInfo billInfo) throws BOSException, EASBizException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()), (String)"nt_discount_gather");
        if (!isPermission) {
            throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "241_ReceivableBill", new String[]{billInfo.getCompany().getName()}));
        }
        if (billInfo.getRpBillId() != null) {
            throw new BOSException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"530_RpBillIdNotNull"));
        }
        if (!billInfo.getBillState().equals((Object)DiscountBillStateEnum.AUDITSTATE)) {
            throw new BOSException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"531_BillStateNotAudit"));
        }
        DiscountBillCollection disColl = new DiscountBillCollection();
        disColl.add(billInfo);
        this.getBizInterface(ctx).gather((IObjectCollection)disColl);
    }

    private DiscountBillCollection getDisBillColl(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("entrys.*");
        selector.add("entrys.receivableBill.*");
        selector.add("entrys.receivableBill.holderAccount.id");
        selector.add("entrys.receivableBill.holderAccount.name");
        selector.add("entrys.receivableBill.holderAccount.bankAccountNumber");
        selector.add("entrys.receivableBill.ntType.*");
        selector.add("entrys.receivableBill.ntType.group");
        selector.add("entrys.receivableBill.currency.*");
        selector.add("entrys.receivableBill.company.*");
        selector.add("receivablebill.*");
        selector.add("currency.*");
        selector.add("recvAccount.*");
        selector.add("recvAccount.company");
        selector.add("recvAccount.company.*");
        selector.add("recvAccount.openArea.province");
        selector.add("recvAccount.openArea.name");
        selector.add("DiscountBank.name");
        selector.add("DiscountBank.number");
        selector.add("DiscountBank.accountBank");
        selector.add("DiscountBank.accountBank.*");
        selector.add("DiscountBank.relatedCompany");
        selector.add("DiscountInBank.name");
        selector.add("DiscountInBank.number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(selector);
        DiscountBillCollection coll = this.getBizInterface(ctx).getDiscountBillCollection(view);
        return coll;
    }

    @Override
    protected Map _batchAuditTie(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)map.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            DiscountBillCollection colls = this.getDisBillColl(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                DiscountBillInfo billInfo = colls.get(i);
                try {
                    this.relaAuditTie(ctx, billInfo);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(DiscountBillWebFacadeControllerBean.getResource(ctx, "198_ReceivableBill", new String[]{billInfo.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(DiscountBillWebFacadeControllerBean.getResource(ctx, "242_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? DiscountBillWebFacadeControllerBean.getResource(ctx, "200_ReceivableBill", null) : summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "201_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void relaAuditTie(Context ctx, DiscountBillInfo billInfo) throws BOSException, EASBizException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()), (String)"nt_discount_audit");
        if (!isPermission) {
            throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "243_ReceivableBill", new String[]{billInfo.getCompany().getName()}));
        }
        if (!billInfo.getBillState().equals((Object)DiscountBillStateEnum.NEWSTATE)) {
            throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "244_ReceivableBill", null));
        }
        if (billInfo.getDiscountBank() != null && billInfo.getDiscountBank().getRelatedCompany() != null && billInfo.getDiscountBank().getRelatedCompany().getId().toString().equals(billInfo.getCompany().getId().toString())) {
            throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "245_ReceivableBill", null));
        }
        HashSet<String> set = new HashSet<String>();
        set.add(billInfo.getId().toString());
        this.getBizInterface(ctx).batchAuditTie(set);
    }

    @Override
    protected Map _batchAntAuditTie(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)map.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            DiscountBillCollection colls = this.getDisBillColl(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                DiscountBillInfo billInfo = colls.get(i);
                try {
                    this.relaAntAuditTie(ctx, billInfo);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(DiscountBillWebFacadeControllerBean.getResource(ctx, "203_ReceivableBill", new String[]{billInfo.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(DiscountBillWebFacadeControllerBean.getResource(ctx, "246_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? DiscountBillWebFacadeControllerBean.getResource(ctx, "205_ReceivableBill", null) : summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "206_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void relaAntAuditTie(Context ctx, DiscountBillInfo billInfo) throws BOSException, EASBizException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()), (String)"nt_discount_unAudit");
        if (!isPermission) {
            throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "247_ReceivableBill", new String[]{billInfo.getCompany().getName()}));
        }
        if (!DiscountBillStateEnum.AUDITSTATE.equals((Object)billInfo.getBillState())) {
            throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "248_ReceivableBill", null));
        }
        HashSet<String> set = new HashSet<String>();
        set.add(billInfo.getId().toString());
        this.getBizInterface(ctx).batchAntAuditTie(set);
    }

    @Override
    protected Map _batchBook(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)map.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            DiscountBillCollection colls = this.getDisBillColl(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                DiscountBillInfo billInfo = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()), (String)"nt_discount_book");
                    if (!isPermission) {
                        throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "249_ReceivableBill", new String[]{billInfo.getCompany().getName()}));
                    }
                    if (billInfo.getCashier() != null || !FMHelper.isEmpty((String)billInfo.getRpBillId())) {
                        throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "312_ReceivableBill", null));
                    }
                    NTFacadeFactory.getLocalInstance(ctx).bookJouranl(billInfo.getId().toString(), "com.kingdee.eas.fm.nt.app.DiscountBillBookNotifyBuilder");
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(DiscountBillWebFacadeControllerBean.getResource(ctx, "250_ReceivableBill", new String[]{billInfo.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(DiscountBillWebFacadeControllerBean.getResource(ctx, "251_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? DiscountBillWebFacadeControllerBean.getResource(ctx, "252_ReceivableBill", null) : summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "253_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _batchCancelBook(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)map.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            DiscountBillCollection colls = this.getDisBillColl(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                DiscountBillInfo billInfo = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()), (String)"nt_discount_book");
                    if (!isPermission) {
                        throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "254_ReceivableBill", new String[]{billInfo.getCompany().getName()}));
                    }
                    if (billInfo.getCashier() == null) {
                        throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "313_ReceivableBill", null));
                    }
                    NTFacadeFactory.getLocalInstance(ctx).cancelBookJouranl(billInfo.getId().toString());
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(DiscountBillWebFacadeControllerBean.getResource(ctx, "255_ReceivableBill", new String[]{billInfo.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(DiscountBillWebFacadeControllerBean.getResource(ctx, "256_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? DiscountBillWebFacadeControllerBean.getResource(ctx, "257_ReceivableBill", null) : summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "258_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _batchCancelDiscount(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)map.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            DiscountBillCollection colls = this.getDisBillColl(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                DiscountBillInfo billInfo = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()), (String)"nt_discount_cancel");
                    if (!isPermission) {
                        throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "259_ReceivableBill", new String[]{billInfo.getCompany().getName()}));
                    }
                    if (DiscountBillStateEnum.AUDITSTATE.equals((Object)billInfo.getBillState())) {
                        throw new BOSException(DiscountBillWebFacadeControllerBean.getResource(ctx, "260_ReceivableBill", null));
                    }
                    this.getBizInterface(ctx).cancelDiscount(billInfo.getId().toString());
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(DiscountBillWebFacadeControllerBean.getResource(ctx, "261_ReceivableBill", new String[]{billInfo.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(DiscountBillWebFacadeControllerBean.getResource(ctx, "262_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? DiscountBillWebFacadeControllerBean.getResource(ctx, "263_ReceivableBill", null) : summary + DiscountBillWebFacadeControllerBean.getResource(ctx, "264_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _gather(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            DiscountBillInfo info = this.getBizInterface(ctx).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(id));
            this.relaGather(ctx, info);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", DiscountBillWebFacadeControllerBean.getResource(ctx, "265_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _auditTie(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            DiscountBillInfo info = this.getBizInterface(ctx).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(id));
            this.relaAuditTie(ctx, info);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", DiscountBillWebFacadeControllerBean.getResource(ctx, "222_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _antAuditTie(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            DiscountBillInfo info = this.getBizInterface(ctx).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(id));
            this.relaAntAuditTie(ctx, info);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", DiscountBillWebFacadeControllerBean.getResource(ctx, "223_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _book(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            NTFacadeFactory.getLocalInstance(ctx).bookJouranl(id, "com.kingdee.eas.fm.nt.app.DiscountBillBookNotifyBuilder");
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", DiscountBillWebFacadeControllerBean.getResource(ctx, "266_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _cancelBook(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            NTFacadeFactory.getLocalInstance(ctx).cancelBookJouranl(id);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", DiscountBillWebFacadeControllerBean.getResource(ctx, "267_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _cancelDiscount(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            DiscountBillInfo info = this.getBizInterface(ctx).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(id));
            this.getBizInterface(ctx).cancelDiscount(info.getId().toString());
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", DiscountBillWebFacadeControllerBean.getResource(ctx, "268_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }

    @Override
    protected void _checPermission(Context ctx, Map idMap) throws BOSException, EASBizException {
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        DiscountBillCollection colls = this.getDisBillColl(ctx, idSet);
        for (int i = 0; i < colls.size(); ++i) {
            DiscountBillInfo info = colls.get(i);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"nt_discount_print");
            if (isPermission) continue;
            throw new PayableException(PayableException.COMMON, new Object[]{DiscountBillWebFacadeControllerBean.getResource(ctx, "304_ReceivableBill", new String[]{info.getCompany().getName()})});
        }
    }
}

