/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.util.Date;

public class EndEndBankAcctBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    private SelectorItemCollection getEndorseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("fromCompany.*");
        sic.add("company.*");
        sic.add("bankAccount.*");
        sic.add("bankAccount.company.*");
        return sic;
    }

    private Date getCreateDate(Context ctx, EndorsementBillInfo endBillInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Date endorseDate = endBillInfo.getEndorseDate();
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany);
        if (currPeriodInfo != null && endorseDate.before(currPeriodInfo.getBeginDate())) {
            return currPeriodInfo.getBeginDate();
        }
        return endorseDate;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        EndorsementBillInfo endBillInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getEndorseSelector());
        JournalInfo jnInfo = new JournalInfo();
        jnInfo.setType(JournalTypeEnum.BANK);
        Date createDate = this.getCreateDate(ctx, endBillInfo);
        jnInfo.setCreateDate(createDate);
        jnInfo.setPeriod(PeriodUtils.getPeriodInfo((Context)ctx, (Date)createDate, (CompanyOrgUnitInfo)endBillInfo.getFromCompany()));
        jnInfo.setAssisDate(endBillInfo.getEndorseDate());
        jnInfo.setBizDate(endBillInfo.getEndorseDate());
        jnInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        jnInfo.setCompany(endBillInfo.getBankAccount().getCompany());
        jnInfo.setCU(endBillInfo.getBankAccount().getCompany().getCU());
        jnInfo.setDescription(endBillInfo.getDescription());
        jnInfo.setAccountView(endBillInfo.getBankAccount().getAccount());
        jnInfo.setAccountBank(endBillInfo.getBankAccount());
        jnInfo.setCurrency(endBillInfo.getCurrency());
        jnInfo.setBillType(BillTypeEnum.EndorsementBill);
        jnInfo.setBillNumber(endBillInfo.getNumber());
        jnInfo.setBillId(endBillInfo.getId().toString());
        jnInfo.setIsDebit(true);
        BigDecimal debitAmt = null;
        debitAmt = endBillInfo.getFee() == null ? endBillInfo.getEndorseAmt() : endBillInfo.getEndorseAmt().subtract(endBillInfo.getFee());
        jnInfo.setDebitAmount(debitAmt);
        jnInfo.setCashier(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        jnInfo.setSource(JournalSourceEnum.BYBILL);
        JournalCollection jnColl = new JournalCollection();
        jnColl.add(jnInfo);
        return jnColl;
    }
}

