/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.util.Date;

public class EndRecvBankAcctBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    private SelectorItemCollection getRecvBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bankAccount.*");
        sic.add("company.*");
        return sic;
    }

    private Date getCreateDate(Context ctx, ReceivableBillInfo recvBillInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Date takeDate = recvBillInfo.getTakeDate();
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany);
        if (currPeriodInfo != null && takeDate.before(currPeriodInfo.getBeginDate())) {
            return currPeriodInfo.getBeginDate();
        }
        return takeDate;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        String[] strs = billId.split("\n");
        String newRecvId = strs[0];
        String endorId = strs[1];
        ReceivableBillInfo recvBillInfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(newRecvId), this.getRecvBillSelector());
        EndorsementBillInfo endBillInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(endorId));
        JournalInfo jnInfo = new JournalInfo();
        jnInfo.setType(JournalTypeEnum.BANK);
        Date createDate = this.getCreateDate(ctx, recvBillInfo);
        jnInfo.setCreateDate(createDate);
        jnInfo.setPeriod(PeriodUtils.getPeriodInfo((Context)ctx, (Date)createDate, (CompanyOrgUnitInfo)recvBillInfo.getCompany()));
        jnInfo.setAssisDate(recvBillInfo.getTakeDate());
        jnInfo.setBizDate(recvBillInfo.getTakeDate());
        jnInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        jnInfo.setCompany(recvBillInfo.getCompany());
        jnInfo.setCU(recvBillInfo.getCompany().getCU());
        jnInfo.setDescription(recvBillInfo.getDigest());
        jnInfo.setAccountView(recvBillInfo.getBankAccount().getAccount());
        jnInfo.setAccountBank(recvBillInfo.getBankAccount());
        jnInfo.setCurrency(recvBillInfo.getCurrency());
        jnInfo.setBillType(BillTypeEnum.ReceivableBill);
        jnInfo.setBillNumber(recvBillInfo.getNumber());
        jnInfo.setBillId(recvBillInfo.getId().toString());
        jnInfo.setIsDebit(false);
        BigDecimal creditAmt = null;
        creditAmt = endBillInfo.getFee() == null ? endBillInfo.getEndorseAmt() : endBillInfo.getEndorseAmt().subtract(endBillInfo.getFee());
        jnInfo.setCreditAmount(creditAmt);
        jnInfo.setCashier(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        jnInfo.setSource(JournalSourceEnum.BYBILL);
        JournalCollection jnColl = new JournalCollection();
        jnColl.add(jnInfo);
        return jnColl;
    }
}

