/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class InEndorseBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        EndorsementBillInfo endoreseBillInfo = this.getEndorseBill(ctx, billId);
        if (endoreseBillInfo.getInnerAccount() == null) {
            return new SubsidiaryLedgerCollection();
        }
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        slInfo.setApplyUnit(endoreseBillInfo.getInnerAccount().getApplyUnit());
        slInfo.setCompany(endoreseBillInfo.getInnerAccount().getCompany());
        slInfo.setInnerAccount(endoreseBillInfo.getInnerAccount());
        slInfo.setCurrency(endoreseBillInfo.getCurrency());
        slInfo.setBillId(endoreseBillInfo.getId());
        String s = endoreseBillInfo.getNoteBillNumber();
        if (s.length() > 80) {
            s = s.substring(0, 75) + "...";
        }
        slInfo.setBillNumber(s);
        slInfo.setBizType(SubsidiaryBillTypeEnum.ENDORSEMENTBILL);
        slInfo.setDate(endoreseBillInfo.getEndorseDate());
        slInfo.setCpCurrency(endoreseBillInfo.getCurrency());
        slInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.app.EndorseServerResource.RecvBillInEndorseBill", (Locale)ctx.getLocale()));
        slInfo.setCreditAmount(this.getCreditAmount(endoreseBillInfo));
        slInfo.setDebitAmount(Constants.ZERO);
        slInfo.setExchangeRate(InEndorseBillSubsidiaryBookProvider.getExRate(ctx, endoreseBillInfo.getCurrency().getId()));
        slInfo.setBookkeeper(endoreseBillInfo.getHandler());
        slInfo.setIsDownLoad(false);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        coll.add(slInfo);
        return coll;
    }

    private BigDecimal getCreditAmount(EndorsementBillInfo endoreseBillInfo) {
        if (endoreseBillInfo.getFee() != null) {
            return endoreseBillInfo.getEndorseAmt().subtract(endoreseBillInfo.getFee());
        }
        return endoreseBillInfo.getEndorseAmt();
    }

    private static BigDecimal getExRate(Context ctx, BOSUuid currencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BOSUuid companyId = currentCompany.getId();
        BOSUuid baseCurId = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany).getId();
        return FinUtils.getCurrencyExRate((Context)ctx, (BOSUuid)companyId, (BOSUuid)currencyId, (BOSUuid)baseCurId, (Date)DateUtil.getDayBegin());
    }

    private EndorsementBillInfo getEndorseBill(Context ctx, String endorseBillId) throws BOSException, EASBizException {
        SelectorItemCollection sicEndorse = new SelectorItemCollection();
        sicEndorse.add("*");
        sicEndorse.add("innerAccount.*");
        sicEndorse.add("innerAccount.company.*");
        sicEndorse.add("innerAccount.applyUnit.*");
        EndorsementBillInfo endoreseBillInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(endorseBillId), sicEndorse);
        return endoreseBillInfo;
    }
}

