/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.nt.CreditApplyEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyInfo;
import com.kingdee.eas.fm.nt.app.AbstractLetterOfCreditApplyControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfCreditApplyControllerBean
extends AbstractLetterOfCreditApplyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.LetterOfCreditApplyControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)model;
        if (info.getCompany() == null) {
            info.setCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)this.getValue(ctx, pk);
        if (info.getBillstate().equals((Object)CreditApplyEnum.Audit)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.AUDITCANNOTDELETE);
        }
        super._delete(ctx, pk);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)value;
        if (info.getBillstate().equals((Object)CreditApplyEnum.Save)) {
            info.setBillstate(CreditApplyEnum.Submit);
        }
        IObjectPK pk = super._submit(ctx, value);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)model;
        if (info.getBillstate() == null || info.getBillstate().equals((Object)CreditApplyEnum.Save)) {
            info.setBillstate(CreditApplyEnum.Save);
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _batchAntAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = LetterOfCreditApplyFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)colls.get(i);
            Set destId = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            if (destId.size() > 0) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISGENBILLERROR, new Object[]{info.getNumber()});
            }
            if (!info.getBillstate().equals((Object)CreditApplyEnum.Audit)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANANTIAUDIT, new Object[]{info.getNumber()});
            }
            if (!info.getBillstate().equals((Object)CreditApplyEnum.Audit)) continue;
            info.setBillstate(CreditApplyEnum.Save);
            info.setAuditor(null);
        }
        super.update(ctx, colls);
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = LetterOfCreditApplyFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)colls.get(i);
            if (!info.getBillstate().equals((Object)CreditApplyEnum.Submit)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDIT, new Object[]{info.getNumber()});
            }
            info.setBillstate(CreditApplyEnum.Audit);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        if (colls.size() > 0) {
            super.update(ctx, colls);
        }
    }

    @Override
    protected void _AntiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)this.getValue(ctx, pk);
        Set destId = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        if (destId.size() > 0) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISGENBILLERROR, new Object[]{info.getNumber()});
        }
        if (!info.getBillstate().equals((Object)CreditApplyEnum.Audit)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANANTIAUDIT, new Object[]{info.getNumber()});
        }
        if (info.getBillstate().equals((Object)CreditApplyEnum.Audit)) {
            info.setBillstate(CreditApplyEnum.Save);
            info.setAuditor(null);
            super.update(ctx, pk, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _Audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditApplyInfo info = (LetterOfCreditApplyInfo)this.getValue(ctx, pk);
        if (info.getBillstate().equals((Object)CreditApplyEnum.Audit)) {
            return;
        }
        if (!info.getBillstate().equals((Object)CreditApplyEnum.Submit)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDIT, new Object[]{info.getNumber()});
        }
        info.setBillstate(CreditApplyEnum.Audit);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        super.update(ctx, pk, (CoreBaseInfo)info);
    }
}

