/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.CreditDealReceivedDetail;
import com.kingdee.bos.ebservice.CreditDealReceivedQueryResponseBody;
import com.kingdee.bos.ebservice.CreditDealReceivedResponseBody;
import com.kingdee.bos.ebservice.CreditQueryReceivedResponseBody;
import com.kingdee.bos.ebservice.ReceivedDetail;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.app.service.LetterOfCreditEBGServiceUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedRejectDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedRejectVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditQueryReceivedVO;
import com.kingdee.eas.fm.be.app.service.vo.DealReceivedRejectQueryVO;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditCollection;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.CreditApplyEnum;
import com.kingdee.eas.fm.nt.DealModeEnum;
import com.kingdee.eas.fm.nt.ILetterOfCreditReach;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.LetterOfCreditReachCollection;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.fm.nt.app.AbstractLetterOfCreditReachControllerBean;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfCreditReachControllerBean
extends AbstractLetterOfCreditReachControllerBean {
    public static final String RESOURCE = "com.kingdee.eas.fm.nt.NtResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.LetterOfCreditReachControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        IObjectPK pk = super._addnew(ctx, model);
        this.dispose(ctx, info);
        return pk;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)this.getValue(ctx, srcBillPK, sic);
        if (new LoanApplyBillInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                info.setIsGenLoanReq(false);
            } else {
                info.setIsGenLoanReq(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, (IObjectValue)info, bOTBillOperStateEnum, bOTRelationInfo);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)model;
        if (info.getBillState() == null || info.getBillState().equals((Object)CreditApplyEnum.Save)) {
            info.setBillState(CreditApplyEnum.Save);
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)value;
        boolean isRemoteCredit = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN005", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        LetterOfCreditInfo lci = LetterOfCreditFactory.getLocalInstance((Context)ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getCredit().getId()));
        boolean isIsForward = lci.isIsForward();
        if (isRemoteCredit && isIsForward && (info.getDealMode() == DealModeEnum.Pay || info.getDealMode() == DealModeEnum.ImportNeg)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.REMOTEFIRSTACCEPT);
        }
        if ((!isRemoteCredit && isIsForward || !isIsForward) && info.getDealMode() == DealModeEnum.Accept) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOTNEEDACCEPT);
        }
        if (!info.getBillState().equals((Object)CreditApplyEnum.Audit)) {
            info.setBillState(CreditApplyEnum.Submit);
        }
        IObjectPK pk = super._submit(ctx, value);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)this.getValue(ctx, pk);
        Set destId = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        if (destId.size() > 0 || info.getBillState().equals((Object)CreditApplyEnum.Audit)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANNOTDELETE, new String[]{info.getNumber()});
        }
        super._delete(ctx, pk);
    }

    private void dispose(Context ctx, LetterOfCreditReachInfo info) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        if (FMHelper.isEmpty((String)sourceBillId)) {
            return;
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(info.getSourceBillId(), info.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, idMap);
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        CoreBaseCollection colls = LetterOfCreditReachFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)colls.get(i);
            if (null == info) continue;
            Set destId = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            if (destId.size() > 0) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISGENBILLERROR, new Object[]{info.getNumber()});
            }
            if (!info.getBillState().equals((Object)CreditApplyEnum.Audit)) {
                return;
            }
            if (info.getDealMode().equals((Object)DealModeEnum.Refuse)) {
                info.setIsRefuse(false);
            }
            info.setBillState(CreditApplyEnum.Save);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        super.update(ctx, colls);
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        CoreBaseCollection colls = LetterOfCreditReachFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)colls.get(i);
            if (null == info) continue;
            if (info.getCredit().getLetterStatus().equals((Object)LetterStatusEnum.close)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDITCLOSE);
            }
            if (!info.getBillState().equals((Object)CreditApplyEnum.Submit)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDIT, new Object[]{info.getNumber()});
            }
            if (info.getDealMode().equals((Object)DealModeEnum.Refuse)) {
                info.setIsRefuse(true);
            }
            info.setBillState(CreditApplyEnum.Audit);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        super.update(ctx, colls);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Credit.number"));
        sic.add(new SelectorItemInfo("Credit.letterNumber"));
        sic.add(new SelectorItemInfo("BillState"));
        sic.add(new SelectorItemInfo("Credit.Amount"));
        sic.add(new SelectorItemInfo("Credit.Balance"));
        sic.add(new SelectorItemInfo("Credit.LetterStatus"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("dealMode"));
        sic.add(new SelectorItemInfo("ReachDate"));
        sic.add(new SelectorItemInfo("ReachNum"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("ActualPayDate"));
        sic.add(new SelectorItemInfo("Credit.IsBatch"));
        sic.add(new SelectorItemInfo("Credit.intendPayDate"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("IsRefuse"));
        sic.add(new SelectorItemInfo("IsGenPay"));
        sic.add(new SelectorItemInfo("IsGenLoanReq"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("referenceNum"));
        sic.add(new SelectorItemInfo("contractNo"));
        sic.add(new SelectorItemInfo("systemBuisnessNo"));
        sic.add(new SelectorItemInfo("applicant"));
        sic.add(new SelectorItemInfo("beneficiary"));
        sic.add(new SelectorItemInfo("submitBank"));
        sic.add(new SelectorItemInfo("claimAmount"));
        sic.add(new SelectorItemInfo("rejectResult"));
        return sic;
    }

    @Override
    protected void _SingleAntiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        CoreBaseCollection colls = LetterOfCreditReachFactory.getLocalInstance(ctx).getCollection(view);
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)colls.get(0);
        if (null != info) {
            Set destId = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            if (destId.size() > 0) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISGENBILLERROR, new Object[]{info.getNumber()});
            }
            if (!info.getBillState().equals((Object)CreditApplyEnum.Audit)) {
                return;
            }
            if (info.getDealMode().equals((Object)DealModeEnum.Refuse)) {
                info.setIsRefuse(false);
            }
            info.setBillState(CreditApplyEnum.Save);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        super.update(ctx, colls);
    }

    @Override
    protected void _SingleAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        CoreBaseCollection colls = LetterOfCreditReachFactory.getLocalInstance(ctx).getCollection(view);
        LetterOfCreditReachInfo info = (LetterOfCreditReachInfo)colls.get(0);
        if (null != info) {
            if (info.getCredit().getLetterStatus().equals((Object)LetterStatusEnum.close)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDITCLOSE);
            }
            if (!info.getBillState().equals((Object)CreditApplyEnum.Submit)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDIT, new Object[]{info.getNumber()});
            }
            if (info.getDealMode().equals((Object)DealModeEnum.Refuse)) {
                info.setIsRefuse(true);
            }
            info.setBillState(CreditApplyEnum.Audit);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        super.update(ctx, colls);
    }

    @Override
    protected Map _refuseAndCommitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        LetterOfCreditReachCollection colls = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachCollection(ev);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        LetterOfCreditEBGServiceUtil letterOfCreditEBGServiceUtil = new LetterOfCreditEBGServiceUtil();
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReachInfo info = colls.get(i);
            try {
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.verifyBeforeReject(ctx, isLocked, info);
                CreditDealReceivedRejectVO refuseVO = this.praseRejectVO(ctx, info);
                CreditDealReceivedResponseBody resposeBody = letterOfCreditEBGServiceUtil.dealReceivedReject(ctx, refuseVO);
                CreditDealReceivedDetail[] resposeList = resposeBody.getDetails();
                this.dealWithRejectResponse(ctx, resposeList, info);
                continue;
            }
            catch (Exception e) {
                e.getStackTrace();
                ++error;
                result.getDetailMsgList().add(this.getResouceString("REACH_REFUSECMTBE_ERRORMSG_85", info.getNumber(), e.getMessage()));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.REFUSEPAYSUMMARY_31, new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    private CreditDealReceivedRejectVO praseRejectVO(Context ctx, LetterOfCreditReachInfo info) throws Exception {
        CreditDealReceivedRejectVO refuseVO = new CreditDealReceivedRejectVO();
        String creditid = info.getCredit().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("letterNumber"));
        sic.add(new SelectorItemInfo("payBankAcct.bankAccountNumber"));
        LetterOfCreditInfo LCInfo = LetterOfCreditFactory.getLocalInstance((Context)ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(creditid), sic);
        if (null == LCInfo.getCurrency().getIsoCode()) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.MAINTAINISOCODE_047, new String[]{info.getNumber(), LCInfo.getLetterNumber()});
        }
        refuseVO.setCurrency(LCInfo.getCurrency().getIsoCode());
        refuseVO.setAccNo(LCInfo.getPayBankAcct().getBankAccountNumber());
        String[] serialNos = beServiceHelper.getSerialNumber((int)1);
        refuseVO.setBatchSeqId(serialNos[0]);
        info.setBatchSeqId(serialNos[0]);
        info.setIsCommitToBe(true);
        SelectorItemCollection LCRsic = new SelectorItemCollection();
        LCRsic.add(new SelectorItemInfo("batchSeqId"));
        LCRsic.add(new SelectorItemInfo("detailSeqId"));
        LCRsic.add(new SelectorItemInfo("isCommitToBe"));
        LetterOfCreditReachFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, LCRsic);
        refuseVO.setBatchBizNo(serialNos[0]);
        refuseVO.setTotalCount("1");
        ArrayList<CreditDealReceivedRejectDetailVO> rejectList = new ArrayList<CreditDealReceivedRejectDetailVO>();
        CreditDealReceivedRejectDetailVO refuseDetailVO = new CreditDealReceivedRejectDetailVO();
        refuseDetailVO.setBranchNo(info.getBranchNo());
        refuseDetailVO.setCreditNo(LCInfo.getLetterNumber());
        refuseDetailVO.setReceivedCreditNumber(info.getNumber());
        refuseDetailVO.setDetailBizNo("detailBizNo");
        refuseDetailVO.setDetailSeqId(serialNos[0]);
        refuseDetailVO.setReferenceNum(info.getReferenceNum());
        if (info.getRemark() != null) {
            refuseDetailVO.setNote(info.getRemark());
        } else {
            refuseDetailVO.setNote("empty");
        }
        refuseDetailVO.setApplyDate(new Date());
        refuseDetailVO.setApplicant(info.getApplicant());
        refuseDetailVO.setBeneficiary(info.getBeneficiary());
        refuseDetailVO.setAmount(info.getAmount().toString());
        refuseDetailVO.setClaimAmount(info.getClaimAmount().toString());
        int rejectValue = info.getRejectResult().getValue();
        char temp = (char)(rejectValue + 64);
        refuseDetailVO.setRejectResult(String.valueOf(temp));
        refuseDetailVO.setContractNo(info.getContractNo());
        rejectList.add(refuseDetailVO);
        refuseVO.setDetails(rejectList);
        return refuseVO;
    }

    private void verifyBeforeReject(Context ctx, boolean isLocked, LetterOfCreditReachInfo info) throws Exception {
        String companyid = info.getCompany().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)"letterofcreditreach_reject");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_REJECT_PERMISSION_36, new String[]{company.getName()});
        }
        if (!isLocked) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.BILLISLOCKED_46, new String[]{info.getNumber()});
        }
        String letterOfCreditId = info.getCredit().getId().toString();
        SelectorItemCollection LetterOfCreditSic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isDirect"));
        LetterOfCreditInfo letterOfCreditInfo = LetterOfCreditFactory.getLocalInstance((Context)ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(letterOfCreditId), LetterOfCreditSic);
        if (!letterOfCreditInfo.isIsDirect()) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOTDIRECTCANTREJECTTOBE_048, new String[]{info.getNumber()});
        }
        CreditApplyEnum billState = info.getBillState();
        BankReturnStatusEnum bankReturnStatus = info.getBankReturnStatus();
        if (!CreditApplyEnum.Audit.equals((Object)billState)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.STATEMISMATCHCANTREJECTTOBE_049, new String[]{info.getNumber()});
        }
        if (!info.isIsCommitToBe() || info.getBankReturnStatus() == null || BankReturnStatusEnum.COMMIT_FAIL.equals((Object)info.getBankReturnStatus())) {
            throw new LetterException(LetterException.COMMITEDCANTCMTAGIN);
        }
        DealModeEnum dealMode = info.getDealMode();
        if (!DealModeEnum.Refuse.equals((Object)dealMode)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.DEALMISMATCHCANTREJECTTOBE_050, new String[]{info.getNumber()});
        }
    }

    private void dealWithRejectResponse(Context ctx, CreditDealReceivedDetail[] resposeList, LetterOfCreditReachInfo info) throws Exception {
        if (resposeList != null && resposeList.length > 0) {
            for (int index = 0; index < resposeList.length; ++index) {
                SelectorItemCollection sic;
                CreditDealReceivedDetail detail = resposeList[index];
                ILetterOfCreditReach iLetterOfCreditReach = LetterOfCreditReachFactory.getLocalInstance(ctx);
                String ebStatus = detail.getEbStatus();
                if (info.getDetailSeqId() == null || !info.getDetailSeqId().equals(detail.getDetailSeqId())) continue;
                if ("EB_PROCESSING".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.EB_PROCESSING);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_PROCESSING".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_PROCESSING);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_SUCCESS".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_SUCCESS);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    info.setIsRefuse(true);
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    sic.add(new SelectorItemInfo("IsRefuse"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_FAIL".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_FAIL);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_EXCEPTION".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_EXCEPTION);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"UnDefinedEBStatus_93", (Object[])new String[]{ebStatus}));
            }
        } else {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"NothingResponseFromBE_94"));
        }
    }

    @Override
    protected Map _synStatus(Context ctx) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(currCompany.getId()), (String)"letterofcreditreach_synstatus");
            if (!isPermission) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_SYNSTATUS_PERMISSION_37, new String[]{currCompany.getName()});
            }
            CreditQueryReceivedVO queryVO = this.praseQueryVO(ctx);
            CreditQueryReceivedResponseBody responseBody = new LetterOfCreditEBGServiceUtil().queryReceivedCredit(ctx, queryVO);
            BatchExecuteResult responseResult = (BatchExecuteResult)this.dealWithQueryResponse(ctx, responseBody);
            if (responseResult.isError() > 0) {
                result = responseResult;
            } else {
                result.setError(0);
                result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"REACH_DOWNLOAD_SUCCESS_88"));
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private Map dealWithQueryResponse(Context ctx, CreditQueryReceivedResponseBody responseBody) throws Exception {
        ILetterOfCreditReach ireach = LetterOfCreditReachFactory.getLocalInstance(ctx);
        ReceivedDetail[] details = responseBody.getDetails();
        BatchExecuteResult result = new BatchExecuteResult();
        int size = details.length;
        int error = 0;
        for (int i = 0; i < details.length; ++i) {
            LetterOfCreditReachInfo info = new LetterOfCreditReachInfo();
            try {
                ReceivedDetail detail = details[i];
                info.setBillState(CreditApplyEnum.Save);
                info.setBatchSeqId(responseBody.getBatchSeqId());
                EntityViewInfo ev = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("letterNumber"));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("company.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("letterNumber", (Object)detail.getCreditNo()));
                filter.getFilterItems().add(new FilterItemInfo("isDirect", (Object)new Integer("1")));
                ev.setSelector(sic);
                ev.setFilter(filter);
                BillBaseCollection colls = LetterOfCreditFactory.getLocalInstance((Context)ctx).getBillBaseCollection(ev);
                String lcId = null;
                if (colls.size() > 0) {
                    LetterOfCreditInfo LCInfo = (LetterOfCreditInfo)colls.get(0);
                    lcId = LCInfo.getId().toString();
                    info.setCredit(LCInfo);
                    String curCompanyId = LCInfo.getCompany().getId().toString();
                    CompanyOrgUnitInfo currCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCompanyId));
                    info.setCompany(currCompany);
                    EntityViewInfo lcrEv = new EntityViewInfo();
                    SelectorItemCollection lcrSic = new SelectorItemCollection();
                    lcrSic.add(new SelectorItemInfo("id"));
                    FilterInfo lcrFilter = new FilterInfo();
                    lcrFilter.getFilterItems().add(new FilterItemInfo("Credit.id", (Object)LCInfo.getId().toString()));
                    lcrEv.setSelector(lcrSic);
                    lcrEv.setFilter(lcrFilter);
                    LetterOfCreditReachCollection lcrColls = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachCollection(lcrEv);
                    if (lcrColls != null && lcrColls.size() > 0) {
                        int sizetemp = lcrColls.size();
                        info.setReachNum(String.valueOf(sizetemp + 1));
                    } else {
                        info.setReachNum("1");
                    }
                } else {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.COUNTEROPENORNOEXIST_055, new String[]{detail.getReceivedCreditNumber(), detail.getCreditNo()});
                }
                info.setBranchNo(detail.getBranchNo());
                info.setNumber(detail.getReceivedCreditNumber());
                info.setReferenceNum(detail.getReferenceNum());
                info.setContractNo(detail.getContractNo());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date receivedDate = sdf.parse(detail.getReceivedDate());
                info.setReachDate(receivedDate);
                info.setAmount(this.getStandardNumber(detail.getAmount()));
                info.setClaimAmount(this.getStandardNumber(detail.getClaimAmount()));
                info.setSubmitBank(detail.getSubmitBank());
                info.setApplicant(detail.getApplicant());
                info.setBeneficiary(detail.getBeneficiary());
                Date noticedDate = sdf.parse(detail.getNoticedDate());
                info.setNoticedDate(noticedDate);
                info.setSystemBuisnessNo(detail.getSystemBuisnessNo());
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date receivedNoticeDate = sdf2.parse(detail.getReceivedNoticeDate());
                info.setReceivedNoticeDate(receivedNoticeDate);
                FilterInfo filterDup = FMHelper.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
                if (this._exists(ctx, filterDup)) {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.REACHEXIST_054, new String[]{detail.getReceivedCreditNumber()});
                }
                IObjectPK pk = ireach.addnew((CoreBaseInfo)info);
                ArrayList<String> srcList = new ArrayList<String>();
                srcList.add(lcId);
                BOTPUtil.saveBOTRelation((Context)ctx, srcList, (String)pk.toString());
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(this.getResouceString("REACH_DOWNLOAD_ERRORMSG_86", info.getNumber(), e.getMessage()));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.DOWNLOADSUMMARY_053, new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    private CreditQueryReceivedVO praseQueryVO(Context ctx) throws Exception {
        CreditQueryReceivedVO queryVO = new CreditQueryReceivedVO();
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("payBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("IssueDate"));
        ev.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankReturnStatus", (Object)3));
        filter.getFilterItems().add(new FilterItemInfo("LetterStatus", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        ev.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("IssueDate");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        ev.setSorter(sorter);
        LetterOfCreditCollection colls = LetterOfCreditFactory.getLocalInstance((Context)ctx).getLetterOfCreditCollection(ev);
        if (colls.size() <= 0) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NONEEDDOWNLOAD_052);
        }
        LetterOfCreditInfo info = colls.get(0);
        queryVO.setAccNo(info.getPayBankAcct().getBankAccountNumber());
        queryVO.setCurrency(info.getCurrency().getIsoCode());
        queryVO.setStartDate(info.getIssueDate());
        Date endDate = new Date();
        queryVO.setEndDate(endDate);
        return queryVO;
    }

    @Override
    protected Map _synRejectStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("Credit.id"));
        sic.add(new SelectorItemInfo("batchSeqId"));
        sic.add(new SelectorItemInfo("ReachDate"));
        sic.add(new SelectorItemInfo("Credit.letterNumber"));
        sic.add(new SelectorItemInfo("Credit.Currency.isoCode"));
        sic.add(new SelectorItemInfo("Credit.Currency.id"));
        sic.add(new SelectorItemInfo("Credit.id"));
        sic.add(new SelectorItemInfo("Credit.payBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("number"));
        ev.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        LetterOfCreditReachCollection colls = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachCollection(ev);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        LetterOfCreditEBGServiceUtil letterOfCreditEBGServiceUtil = new LetterOfCreditEBGServiceUtil();
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReachInfo info = colls.get(i);
            try {
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.verifyBeforesynRejectStatus(ctx, isLocked, info);
                DealReceivedRejectQueryVO refuseQueryVO = this.praseRejectQueryVO(ctx, info);
                CreditDealReceivedQueryResponseBody resposeBody = letterOfCreditEBGServiceUtil.dealReceivedRejectQuery(ctx, refuseQueryVO);
                this.dealWithRejectQueryResponse(ctx, resposeBody, info);
                continue;
            }
            catch (Exception e) {
                e.getStackTrace();
                ++error;
                result.getDetailMsgList().add(this.getResouceString("REACH_REJECTSN_ERRORMSG_87", info.getNumber(), e.getMessage()));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.REFUSEPAYSUMMARY_31, new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    private DealReceivedRejectQueryVO praseRejectQueryVO(Context ctx, LetterOfCreditReachInfo info) throws Exception {
        DealReceivedRejectQueryVO rejectQueryVO = new DealReceivedRejectQueryVO();
        if (info.getCredit() != null && info.getCredit().getPayBankAcct() != null) {
            rejectQueryVO.setAccNo(info.getCredit().getPayBankAcct().getBankAccountNumber());
        } else {
            rejectQueryVO.setAccNo("");
        }
        if (info.getCredit() == null || info.getCredit().getCurrency() == null) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.MAINTAINISOCODE_047, new String[]{info.getNumber(), info.getCredit().getLetterNumber()});
        }
        rejectQueryVO.setCurrency(info.getCredit().getCurrency().getIsoCode());
        if (info.getBatchSeqId() == null) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.BATCHNOISNULL_051, new String[]{info.getNumber()});
        }
        rejectQueryVO.setBatchSeqId(info.getBatchSeqId());
        rejectQueryVO.setStartDate(info.getReachDate());
        rejectQueryVO.setEndDate(new Date());
        return rejectQueryVO;
    }

    private void verifyBeforesynRejectStatus(Context ctx, boolean booleanValue, LetterOfCreditReachInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"letterofcreditreach_synrejectstatus");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_SYNREJECTSTATUS_PERMISSION_38, new String[]{info.getCompany().getName()});
        }
        if (!info.isIsCommitToBe()) {
            throw new LetterException(LetterException.CMTTOBEBEFORESYNSTATUS_063);
        }
        if (info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION) {
            throw new LetterException(LetterException.SUCCESSORFAILCANTSYNSTATUS_064);
        }
    }

    private void dealWithRejectQueryResponse(Context ctx, CreditDealReceivedQueryResponseBody responseBody, LetterOfCreditReachInfo info) throws Exception {
        CreditDealReceivedDetail[] details = responseBody.getDetails();
        if (details.length > 0) {
            ILetterOfCreditReach iLetterOfCreditReach = LetterOfCreditReachFactory.getLocalInstance(ctx);
            for (int i = 0; i < details.length; ++i) {
                SelectorItemCollection sic;
                CreditDealReceivedDetail detail = details[i];
                String ebStatus = detail.getEbStatus();
                if (info.getDetailSeqId() == null || !info.getDetailSeqId().equals(detail.getDetailSeqId())) continue;
                if ("EB_PROCESSING".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.EB_PROCESSING);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_PROCESSING".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_PROCESSING);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_SUCCESS".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_SUCCESS);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    info.setIsRefuse(true);
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    sic.add(new SelectorItemInfo("IsRefuse"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_FAIL".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_FAIL);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                if ("BANK_EXCEPTION".equals(ebStatus)) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_EXCEPTION);
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    iLetterOfCreditReach.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                throw new Exception("UnDefined EBStatus!!!");
            }
        } else {
            throw new Exception("there is nothing resposed from be");
        }
    }

    private BigDecimal getStandardNumber(String str) {
        if (str == null || str.trim().length() == 0) {
            return new BigDecimal("0.0");
        }
        String subStr = str.substring(3);
        String subAmt = subStr.replaceAll(",", "");
        return new BigDecimal(subAmt);
    }

    private String getResouceString(String key, String infoNum, String errorMsg) {
        return EASResource.getString((String)RESOURCE, (String)key, (Object[])new String[]{infoNum, errorMsg});
    }
}

