/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordCollection;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.CreditApplyEnum;
import com.kingdee.eas.fm.nt.DealModeEnum;
import com.kingdee.eas.fm.nt.ILetterOfCreditReach;
import com.kingdee.eas.fm.nt.ILetterOfCreditReachWebFacade;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditReachWebFacadeFactory;
import com.kingdee.eas.fm.nt.app.AbstractLetterOfCreditReachWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LetterOfCreditReachWebFacadeControllerBean
extends AbstractLetterOfCreditReachWebFacadeControllerBean {
    public static final String RESOURCE = "com.kingdee.eas.fm.nt.NtResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.LetterOfCreditReachWebFacadeControllerBean");

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        ILetterOfCreditReach iletterOfCreditReach = LetterOfCreditReachFactory.getLocalInstance(ctx);
        for (int i = 0; i < ids.length; ++i) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("id"));
            LetterOfCreditReachInfo info = iletterOfCreditReach.getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"letterofcreditreach_remove");
                if (!isPermission) {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_REMOVE_PERMISSION_30, new String[]{info.getCompany().getName()});
                }
                iletterOfCreditReach.delete((IObjectPK)new ObjectUuidPK(ids[i].trim()));
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(this.getResouceString("REACH_DELETE_ERRORMSG_81", info.getNumber(), e.getMessage()));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.DELETESUMMARYMSG_16, new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        ILetterOfCreditReach iletterOfCreditReach = LetterOfCreditReachFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int i = 0; i < ids.length; ++i) {
            LetterOfCreditReachInfo info = iletterOfCreditReach.getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"letterofcreditreach_audit");
                if (!isPermission) {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_AUDIT_PERMISSION_33, new String[]{info.getCompany().getName()});
                }
                iletterOfCreditReach.SingleAudit((IObjectPK)new ObjectUuidPK(ids[i]));
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(this.getResouceString("REACH_AUDIT_ERRORMSG_82", info.getNumber(), e.getMessage()));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.AUDITSUMMARYMSG_17, new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        ILetterOfCreditReachWebFacade iletterOfCreditReachWebFacade = LetterOfCreditReachWebFacadeFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int i = 0; i < ids.length; ++i) {
            LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"letterofcreditreach_unaudit");
                if (!isPermission) {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_UNAUDIT_PERMISSION_34, new String[]{info.getCompany().getName()});
                }
                iletterOfCreditReachWebFacade.singleUnAudit((IObjectPK)new ObjectUuidPK(ids[i]));
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(this.getResouceString("REACH_UNAUDIT_ERRORMSG_83", info.getNumber(), e.getMessage()));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.UNAUDITSUMMARYMSG_18, new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    @Override
    protected void _singleUnAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ILetterOfCreditReach iLetterOfCreditReach = LetterOfCreditReachFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("Credit.LetterStatus"));
        sic.add(new SelectorItemInfo("dealMode"));
        sic.add(new SelectorItemInfo("BillState"));
        sic.add(new SelectorItemInfo("Credit.id"));
        sic.add(new SelectorItemInfo("Credit.letterNumber"));
        sic.add(new SelectorItemInfo("Credit.LetterStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        LetterOfCreditReachInfo LCReachInfo = iLetterOfCreditReach.getLetterOfCreditReachInfo(pk, sic);
        if (null != LCReachInfo) {
            BankReturnStatusEnum bankReturnStatus;
            if (LCReachInfo.isIsCommitToBe() && (BankReturnStatusEnum.EB_PROCESSING.equals((Object)(bankReturnStatus = LCReachInfo.getBankReturnStatus())) || BankReturnStatusEnum.BANK_PROCESSING.equals((Object)bankReturnStatus))) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISCMTTOBECANTUNAUDIT, new Object[]{LCReachInfo.getNumber()});
            }
            Set destId = FMHelper.getDestBillIdSet((Context)ctx, (String)LCReachInfo.getId().toString());
            if (destId.size() > 0) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISGENBILLERROR, new Object[]{LCReachInfo.getNumber()});
            }
            if (!LCReachInfo.getBillState().equals((Object)CreditApplyEnum.Audit)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANANTIAUDIT, new Object[]{LCReachInfo.getNumber()});
            }
            LetterOfCreditInfo LCInfo = LCReachInfo.getCredit();
            if (LetterStatusEnum.close.equals((Object)LCInfo.getLetterStatus())) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANTUNAUDIT_29, new Object[]{LCReachInfo.getNumber(), LCInfo.getLetterNumber()});
            }
            if (DealModeEnum.Refuse.equals((Object)LCReachInfo.getDealMode())) {
                LCReachInfo.setIsRefuse(false);
            }
            LCReachInfo.setBillState(CreditApplyEnum.Submit);
            LCReachInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        iLetterOfCreditReach.update(pk, (CoreBaseInfo)LCReachInfo);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Credit.id"));
        sic.add(new SelectorItemInfo("Credit.number"));
        sic.add(new SelectorItemInfo("BillState"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("Credit.Amount"));
        sic.add(new SelectorItemInfo("Credit.Balance"));
        sic.add(new SelectorItemInfo("Credit.LetterStatus"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("dealMode"));
        sic.add(new SelectorItemInfo("ReachDate"));
        sic.add(new SelectorItemInfo("ReachNum"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("handler"));
        sic.add(new SelectorItemInfo("ActualPayDate"));
        sic.add(new SelectorItemInfo("Credit.IsBatch"));
        sic.add(new SelectorItemInfo("Credit.intendPayDate"));
        sic.add(new SelectorItemInfo("Summary"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("IsRefuse"));
        sic.add(new SelectorItemInfo("IsGenPay"));
        sic.add(new SelectorItemInfo("IsGenLoanReq"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("rejectResult"));
        sic.add(new SelectorItemInfo("claimAmount"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnMsg"));
        sic.add(new SelectorItemInfo("claimAmount"));
        sic.add(new SelectorItemInfo("Credit.bankReturnStatus"));
        sic.add(new SelectorItemInfo("Credit.operateStatus"));
        sic.add(new SelectorItemInfo("Credit.isDirect"));
        return sic;
    }

    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        ILetterOfCreditReachWebFacade iLOCRWebFacade = LetterOfCreditReachWebFacadeFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int i = 0; i < ids.length; ++i) {
            LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"letterofcreditreach_unaudit");
                if (!isPermission) {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_SUBMIT_PERMISSION_40, new String[]{info.getCompany().getName()});
                }
                iLOCRWebFacade.submitById((IObjectPK)new ObjectUuidPK(ids[i]));
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(this.getResouceString("REACH_SUBMIT_ERRORMSG_84", info.getNumber(), e.getMessage()));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.SUBMITSUMMARYMSG_22, new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    @Override
    protected Map _submit(Context ctx, LetterOfCreditReachInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.verifyBeforeSubmit(ctx, info);
            ILetterOfCreditReach iletterOfCreditReach = LetterOfCreditReachFactory.getLocalInstance(ctx);
            if (!info.getBillState().equals((Object)CreditApplyEnum.Audit)) {
                info.setBillState(CreditApplyEnum.Submit);
            }
            ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
            iletterOfCreditReach.update((IObjectPK)pk, (CoreBaseInfo)info);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"REACH_SUBMIT_SUCCESS_89"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    @Deprecated
    protected Map _beforeSubmit(Context ctx, LetterOfCreditReachInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.verifyBeforeSubmit(ctx, info);
            result.setError(0);
            result.setSummaryMsg("success");
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected void _submitById(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ILetterOfCreditReach iletterOfCreditReach = LetterOfCreditReachFactory.getLocalInstance(ctx);
        LetterOfCreditReachInfo LCRInfo = iletterOfCreditReach.getLetterOfCreditReachInfo(pk);
        this.verifyBeforeSubmit(ctx, LCRInfo);
        if (!CreditApplyEnum.Audit.equals((Object)LCRInfo.getBillState())) {
            LCRInfo.setBillState(CreditApplyEnum.Submit);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("BillState"));
        iletterOfCreditReach.updatePartial((CoreBaseInfo)LCRInfo, sic);
    }

    private void verifyBeforeSubmit(Context ctx, LetterOfCreditReachInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"letterofcreditreach_submit");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_SUBMIT_PERMISSION_40, new String[]{info.getCompany().getName()});
        }
        BigDecimal amount = info.getAmount();
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.AMOUNTMORETHANZERO_23);
        }
        UserInfo handler = info.getHandler();
        if (handler == null || handler != null && handler.getName() != null && handler.getName().trim().length() == 0) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.HANDLERNOTEMPTY_25);
        }
        if (info.getSummary() != null && info.getSummary().length() >= 200) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.SUMMARYLENLMT_27);
        }
        if (info.getRemark() != null && info.getRemark().length() >= 200) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.REMARKLENLMT_28);
        }
        boolean isRemoteCredit = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN005", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        LetterOfCreditInfo LCInfo = LetterOfCreditFactory.getLocalInstance((Context)ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getCredit().getId()));
        boolean isIsForward = LCInfo.isIsForward();
        if (isRemoteCredit && isIsForward && (info.getDealMode() == DealModeEnum.Pay || info.getDealMode() == DealModeEnum.ImportNeg)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.REMOTEFIRSTACCEPT_19, new String[]{info.getNumber(), LCInfo.getNumber()});
        }
        if (!isIsForward && info.getDealMode() == DealModeEnum.Accept) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.SIGHTNOTNEEDACCEPT_20, new String[]{info.getNumber(), LCInfo.getNumber()});
        }
        if (!isRemoteCredit && isIsForward && info.getDealMode() == DealModeEnum.Accept) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.FORWARDNOTNEEDACCEPT_21, new String[]{info.getNumber(), LCInfo.getNumber()});
        }
    }

    @Override
    protected Map _refuseAndCommitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)LetterOfCreditReachFactory.getLocalInstance(ctx).refuseAndCommitToBe(ids);
        return result;
    }

    @Override
    protected Map _synStatus(Context ctx) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)LetterOfCreditReachFactory.getLocalInstance(ctx).synStatus();
        return result;
    }

    @Override
    protected Map _synRejectStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)LetterOfCreditReachFactory.getLocalInstance(ctx).synRejectStatus(ids);
        return result;
    }

    @Override
    protected Map _pay(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), this.getVerifySelectors());
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_Repayment_addnew");
            if (!isPermission) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_PAY_PERMISSION_35, new String[]{info.getCompany().getName()});
            }
            if (DealModeEnum.Accept.equals((Object)info.getDealMode())) {
                if (info.isIsGenPay()) {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.REPEATGENPAYBILL_060);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bill.isDirect", (Object)new Integer("1"), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("reachId", (Object)id, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bankReturnStatus", (Object)3, CompareType.EQUALS));
                view.setFilter(filter);
                LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getLocalInstance((Context)ctx).getLetOfCreditAcctRecordCollection(view);
                if (colls == null || colls.size() <= 0) {
                    throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANTPAYCAUSEOFACCT_84, new String[]{info.getNumber()});
                }
                result.setError(0);
                result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"PAYPERMISSION_VERIFY_SUCCESS_90"));
            } else {
                this.verifyBeforePay(ctx, info);
                result.setError(0);
                result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"PAYPERMISSION_VERIFY_SUCCESS_90"));
            }
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _accept(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.verifyBeforeAccept(ctx, id);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"ACCEPTPERMISSION_VERIFY_SUCCESS_91"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _edit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.verifyBeforeEdit(ctx, id);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"EDITPERMISSION_VERIFY_SUCCESS_92"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private void verifyBeforeEdit(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"letterofcreditreach_edit");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOREACHEDITPERMISSION_083, new String[]{info.getCompany().getName()});
        }
    }

    private void verifyBeforePay(Context ctx, LetterOfCreditReachInfo info) throws Exception {
        CreditApplyEnum billState = info.getBillState();
        if (!CreditApplyEnum.Audit.equals((Object)billState)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.AUDITNEEDFORPAY_059);
        }
        boolean isGenPay = info.isIsGenPay();
        if (isGenPay) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.REPEATGENPAYBILL_060);
        }
        LetterStatusEnum letterStatus = info.getCredit().getLetterStatus();
        if (LetterStatusEnum.close.equals((Object)letterStatus)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CREDITCLOSEDCANTPAY_061);
        }
        if (!DealModeEnum.Pay.equals((Object)info.getDealMode())) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ONLYPAYCANDO_062);
        }
        boolean isNeedAccept = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN005", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (isNeedAccept && info.getCredit().isIsForward()) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ACCEPTNEEDBEFOREPAY_063);
        }
        LetterOperateTypeEnum operateStatus = info.getCredit().getOperateStatus();
        boolean isDirect = info.getCredit().isIsDirect();
        BankReturnStatusEnum ebstatus = info.getCredit().getBankReturnStatus();
        if (!LetterOperateTypeEnum.AUDIT.equals((Object)operateStatus)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CREDITUNAUDITCANTPAY_064);
        }
        if (!BankReturnStatusEnum.BANK_SUCCESS.equals((Object)ebstatus) && isDirect) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CREDITNOTBESUCCESSCANTPAY_065);
        }
    }

    private void verifyBeforeAccept(Context ctx, String id) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), this.getVerifySelectors());
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_addnew");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_ACCEPT_PERMISSION_39, new String[]{info.getCompany().getName()});
        }
        boolean isAccept = info.isIsAccept();
        if (isAccept) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.REPEATACCEPT_056);
        }
        DealModeEnum dealMode = info.getDealMode();
        if (!DealModeEnum.Accept.equals((Object)dealMode)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ONLYACCEPTCANDO_057);
        }
        CreditApplyEnum billState = info.getBillState();
        if (!CreditApplyEnum.Audit.equals((Object)billState)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.AUDITNEEDFORACCEPT_058);
        }
    }

    public SelectorItemCollection getVerifySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("BillState"));
        sic.add(new SelectorItemInfo("Credit.LetterStatus"));
        sic.add(new SelectorItemInfo("Credit.isDYZ"));
        sic.add(new SelectorItemInfo("IsGenPay"));
        sic.add(new SelectorItemInfo("IsAccept"));
        sic.add(new SelectorItemInfo("IsRefuse"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("dealMode"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Credit.IsForward"));
        sic.add(new SelectorItemInfo("rejectResult"));
        sic.add(new SelectorItemInfo("claimAmount"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("Credit.bankReturnStatus"));
        sic.add(new SelectorItemInfo("Credit.operateStatus"));
        sic.add(new SelectorItemInfo("Credit.isDirect"));
        return sic;
    }

    private boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str.trim());
        if (!isNum.matches()) {
            return false;
        }
        return str.charAt(0) != '0';
    }

    private String getResouceString(String key, String infoNum, String errorMsg) {
        return EASResource.getString((String)RESOURCE, (String)key, (Object[])new String[]{infoNum, errorMsg});
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        LetterOfCreditReachInfo info = LetterOfCreditReachFactory.getLocalInstance(ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(id), sic);
        try {
            if (!BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)info.getBankReturnStatus())) {
                throw new LetterException(LetterException.CANTMODIFYBANKRETURNSTATUS_080);
            }
            info.setBankReturnStatus(BankReturnStatusEnum.getEnum(status));
            if (status == 3) {
                info.setIsRefuse(true);
                sic.add(new SelectorItemInfo("IsRefuse"));
            }
            LetterOfCreditReachFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.fin.LetterOfCreditWebResource", (String)"StatusUpdateSuccess_103"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }
}

