/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.LetterOfCreditRecStateEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.fm.nt.app.AbstractLetterOfCreditReceiveControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfCreditReceiveControllerBean
extends AbstractLetterOfCreditReceiveControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.LetterOfCreditReceiveControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)model;
        info.setIsGenRecBill(false);
        if (info.getCompany() == null) {
            info.setCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        this.disposeAcceptApplyBill(ctx, info.getSourceBillId(), false);
        return super._addnew(ctx, model);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)value;
        if (info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Save)) {
            info.setBillstate(LetterOfCreditRecStateEnum.Submit);
        }
        IObjectPK pk = super._submit(ctx, value);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)model;
        if (info.getBillstate() == null || info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Save)) {
            info.setBillstate(LetterOfCreditRecStateEnum.Save);
        }
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)this.getValue(ctx, (IObjectPK)new ObjectStringPK(pk.toString()));
        if (info.isIsGenRecBill()) {
            throw new FinBizException(FinBizException.DELETE1, new Object[]{info.getNumber()});
        }
        if (info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Audit) || !info.getLetterStatus().equals((Object)LetterStatusEnum.open)) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.AUDITCLOSECANNOTDELETE);
        }
        super._delete(ctx, pk);
        this.disposeAcceptApplyBill(ctx, info.getSourceBillId(), true);
    }

    private void disposeAcceptApplyBill(Context ctx, String id, boolean isDelete) throws BOSException {
        String sSQL = "Update T_NT_AcceptApplyBill Set FisGenRec = ? Where Fid = ? ";
        Boolean isGenRec = true;
        if (isDelete) {
            isGenRec = false;
        }
        DbUtil.execute((Context)ctx, (String)sSQL, (Object[])new Object[]{isGenRec, id});
    }

    @Override
    protected void _batchAntAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = LetterOfCreditReceiveFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)colls.get(i);
            Set destId = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            if (info.isIsGenRecBill()) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANNOTANTIAUDIT);
            }
            if (info.getLetterStatus().equals((Object)LetterStatusEnum.close) || destId.size() > 0) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANNOTANTIAUDIT);
            }
            if (!info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Audit)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANANTIAUDIT, new Object[]{info.getNumber()});
            }
            if (!info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Audit)) continue;
            info.setBillstate(LetterOfCreditRecStateEnum.Submit);
            info.setAuditor(null);
        }
        super.update(ctx, colls);
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = LetterOfCreditReceiveFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)colls.get(i);
            if (!info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Submit)) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDIT, new Object[]{info.getNumber()});
            }
            info.setBillstate(LetterOfCreditRecStateEnum.Audit);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        if (colls.size() > 0) {
            super.update(ctx, colls);
        }
    }

    @Override
    protected void _close(Context ctx, Set idSet, Date closeDate) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = LetterOfCreditReceiveFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)colls.get(i);
            if (info.getBillstate().equals((Object)LetterOfCreditRecStateEnum.Save)) continue;
            info.setLetterStatus(LetterStatusEnum.close);
            info.setCloseDate(DateTimeUtils.truncateDate((Date)closeDate));
        }
        super.update(ctx, colls);
    }

    @Override
    protected void _open(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection colls = LetterOfCreditReceiveFactory.getLocalInstance(ctx).getCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfCreditReceiveInfo info = (LetterOfCreditReceiveInfo)colls.get(i);
            info.setLetterStatus(LetterStatusEnum.open);
            info.setCloseDate(null);
        }
        super.update(ctx, colls);
    }

    @Override
    protected void _output(Context ctx) throws BOSException {
    }
}

