/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;

public class NTServerUtils {
    public static CtrlUnitInfo getCompanyCU(Context ctx, BOSUuid orgId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("CU.*");
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), sic);
        return companyInfo.getCU();
    }

    public static boolean isSubmitAndBiz(Context ctx) {
        BOSUuid curOrgId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId();
        ObjectUuidPK orgPK = new ObjectUuidPK(curOrgId);
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM004", (IObjectPK)orgPK);
        return val;
    }

    public static boolean isBillRecAccount(Context ctx) {
        BOSUuid curOrgId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId();
        ObjectUuidPK orgPK = new ObjectUuidPK(curOrgId);
        int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)orgPK);
        return val == 0;
    }

    public static boolean isSubmitAndBiz(Context ctx, IObjectPK orgPK) {
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("TM004", orgPK);
        return val;
    }

    public static boolean isBillRecAccount(Context ctx, IObjectPK orgPK) {
        int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", orgPK);
        return val == 0;
    }

    public static CompanyOrgUnitInfo getClearhouseCompany(Context ctx, CompanyOrgUnitInfo com1, CompanyOrgUnitInfo com2) throws BOSException, EASBizException {
        IBank ibank = BankFactory.getLocalInstance((Context)ctx);
        if (com1 != null && ibank.isClearinghouseCompany(com1.getId().toString())) {
            return com1;
        }
        if (com2 != null && ibank.isClearinghouseCompany(com2.getId().toString())) {
            return com2;
        }
        BankCollection bankColl = ibank.getBankCollection();
        int n = bankColl.size();
        for (int i = 0; i < n; ++i) {
            BankInfo bank = bankColl.get(i);
            if (bank.getRelatedCompany() == null || !bank.isInGroup()) continue;
            return bank.getRelatedCompany();
        }
        throw new IllegalArgumentException("no clearhouse company found!");
    }

    public static BankInfo getClearhouse(Context ctx, CompanyOrgUnitInfo com1, CompanyOrgUnitInfo com2) throws BOSException, EASBizException {
        IBank ibank = BankFactory.getLocalInstance((Context)ctx);
        if (com1 != null && ibank.isClearinghouseCompany(com1.getId().toString())) {
            return ibank.getClearingHouse(com1.getId().toString());
        }
        if (com2 != null && ibank.isClearinghouseCompany(com2.getId().toString())) {
            return ibank.getClearingHouse(com2.getId().toString());
        }
        BankCollection bankColl = ibank.getBankCollection();
        int n = bankColl.size();
        for (int i = 0; i < n; ++i) {
            BankInfo bank = bankColl.get(i);
            if (bank.getRelatedCompany() == null) continue;
            return bank;
        }
        throw new IllegalArgumentException("no clearhouse  found!");
    }

    public static boolean checkIsInAuditWF(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        AssignmentInfo[] assigns = service.checkAssignmentInfos(pk.toString(), ctx.getCaller().toString());
        int n = assigns.length;
        for (int i = 0; i < n; ++i) {
            if (!assigns[i].getBizPackage().equals("com.kingdee.eas.base.multiapprove.client") || !assigns[i].getBizFunction().equals("MultiApproveUIFunction") || !assigns[i].getBizOperation().equals("ActionSubmit")) continue;
            return true;
        }
        return false;
    }
}

