/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class NoteBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        throw new BOSException("not Support");
    }

    public SubsidiaryLedgerCollection getSubsidiaryColl(Context ctx, String newRecvId, EndorsementBillInfo endBillInfo) throws BOSException, EASBizException {
        ReceivableBillInfo recvBillInfo = this.getRecvBill(ctx, newRecvId);
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        slInfo.setApplyUnit(recvBillInfo.getInnerAccount().getApplyUnit());
        slInfo.setCompany(recvBillInfo.getInnerAccount().getCompany());
        slInfo.setInnerAccount(recvBillInfo.getInnerAccount());
        slInfo.setCurrency(recvBillInfo.getCurrency());
        slInfo.setBizType(SubsidiaryBillTypeEnum.RECEIVABLEBILL);
        slInfo.setDate(recvBillInfo.getTakeDate());
        slInfo.setBillId(recvBillInfo.getId());
        slInfo.setBillNumber(recvBillInfo.getNumber());
        slInfo.setCpCurrency(recvBillInfo.getCurrency());
        slInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.app.EndorseServerResource.RecvBillInEndorseBill", (Locale)ctx.getLocale()));
        slInfo.setCreditAmount(Constants.ZERO);
        slInfo.setDebitAmount(recvBillInfo.getBillAmt().multiply(Constants.ONE.subtract(endBillInfo.getFeeRate())));
        slInfo.setExchangeRate(NoteBillSubsidiaryBookProvider.getExRate(ctx, recvBillInfo.getCurrency().getId()));
        slInfo.setBookkeeper(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        slInfo.setIsDownLoad(false);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        coll.add(slInfo);
        return coll;
    }

    private BigDecimal getCreditAmount(EndorsementBillInfo endoreseBillInfo) {
        if (endoreseBillInfo.getFee() != null) {
            return endoreseBillInfo.getEndorseAmt().subtract(endoreseBillInfo.getFee());
        }
        return endoreseBillInfo.getEndorseAmt();
    }

    private static BigDecimal getExRate(Context ctx, BOSUuid currencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BOSUuid companyId = currentCompany.getId();
        BOSUuid baseCurId = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany).getId();
        return FinUtils.getCurrencyExRate((Context)ctx, (BOSUuid)companyId, (BOSUuid)currencyId, (BOSUuid)baseCurId, (Date)DateUtil.getDayBegin());
    }

    private ReceivableBillInfo getRecvBill(Context ctx, String recvBillId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("innerAccount.*");
        sic.add("innerAccount.company.*");
        sic.add("innerAccount.applyUnit.*");
        ReceivableBillInfo info = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(recvBillId), sic);
        return info;
    }
}

