/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.EndorseListingFactory;
import com.kingdee.eas.fm.nt.EndorseListingInfo;
import com.kingdee.eas.fm.nt.HorizonTypeEnum;
import com.kingdee.eas.fm.nt.INTType;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableTransferBillFactory;
import com.kingdee.eas.fm.nt.PayableTransferBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.TransferBillTypeEnum;
import com.kingdee.eas.fm.nt.app.AbstractPayableTransferBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PayableTransferBillControllerBean
extends AbstractPayableTransferBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.PayableTransferBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayableTransferBillInfo oldInfo;
        PayableTransferBillInfo info = (PayableTransferBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
        if (null != info.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = this.getPayableTransferBillInfo(ctx, "select * where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        IObjectPK pk = super._submit(ctx, model);
        if (info.isCreatePayment()) {
            NTHelper.genPaymentBillByBotp(ctx, (CoreBillBaseInfo)info, false);
        }
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayableTransferBillInfo info = (PayableTransferBillInfo)model;
        PayableBillCollection coll = this.copyPayableBillCollection(info.getPayableEntrys());
        info.getPayableEntrys().clear();
        info.setNumber(info.getSrcBillNumber());
        IObjectPK pk = super._addnew(ctx, model);
        info.setId(BOSUuid.read((String)pk.toString()));
        int iState = 3;
        String sDigest = ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"37_PayableTransferBillControllerBean", (Locale)ctx.getLocale()) + info.getApplyName();
        if (info.getTransferTpye() == TransferBillTypeEnum.In) {
            iState = 2;
        }
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            PayableBillInfo payableBill = (PayableBillInfo)iter.next();
            DbUtil.execute((Context)ctx, (String)"update t_nt_payablebill set FBillState=?,FBillLastState=?,fremark=?,ftransferDate=?,ftransferid=?  where FId=?", (Object[])new Object[]{new Integer(iState), new Integer(payableBill.getBillState().getValue()), sDigest, info.getTransferDate(), info.getId().toString(), payableBill.getId().toString()});
            FinUtils.addBotRelation((Context)ctx, (String)payableBill.getId().toString(), (String)info.getId().toString());
        }
        if (info.getTransferTpye() == TransferBillTypeEnum.Out) {
            NTHelper.updateFpItem(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), "com.kingdee.eas.fm.nt.app.PayableTransferBill");
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)info);
        }
        return pk;
    }

    private PayableBillCollection copyPayableBillCollection(PayableBillCollection coll) {
        PayableBillCollection retColl = new PayableBillCollection();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            retColl.add((PayableBillInfo)iter.next());
        }
        return retColl;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PayableTransferBillInfo info = (PayableTransferBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(pk.toString()));
        String sql = "select * from t_nt_receivablebill where FFivouchered=1 and ftransferid='" + pk.toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                throw new NTException(NTException.TRANSFERBILLNOTDEL4ISVOUCHER);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        sql = "select * from t_nt_payablebill where FBillState in (1,9) and ftransferid='" + pk.toString() + "'";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                throw new NTException(NTException.TRANSFERBILLNOTDEL4STATE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        ArrayList ids = botRelation.getDestObjIdByDestType(pk.toString(), new PaymentBillInfo().getBOSType().toString());
        for (String paymentId : ids) {
            PaymentBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(paymentId));
        }
        if (info.getTransferTpye() == TransferBillTypeEnum.Out) {
            NTHelper.cancelFpItem(ctx, pk.toString());
        }
        DbUtil.execute((Context)ctx, (String)"delete from T_NT_PayableTransferBill where FID=?", (Object[])new Object[]{pk.toString()});
        botRelation.removeRelationByDestObjId(pk.toString(), new PayableBillInfo().getBOSType().toString());
        DbUtil.execute((Context)ctx, (String)"update t_nt_payablebill set FBillState=?,fremark=null,ftransferDate=null,ftransferid=null  where ftransferid=?", (Object[])new Object[]{new Integer(NTHelper.getNTInitState(ctx, false)), pk.toString()});
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    private void genReceivablebill(Context ctx, PayableTransferBillInfo model, boolean isCreateReceiving) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Iterator iter = model.getPayableEntrys().iterator();
        while (iter.hasNext()) {
            PayableBillInfo payableBill = (PayableBillInfo)iter.next();
            INTType inttype = NTTypeFactory.getLocalInstance(ctx);
            if (model.getTransferTpye() != TransferBillTypeEnum.In) continue;
            ReceivableBillInfo receivableBill = new ReceivableBillInfo();
            receivableBill.setCompany(model.getApplyCompany());
            NTTypeInfo ntTypeInfo = inttype.getNTTypeInfo((IObjectPK)new ObjectUuidPK(payableBill.getNtType().getId().toString()));
            receivableBill.setNtType(this.getNtype4ReceivableBill(ctx, ntTypeInfo));
            receivableBill.setDraftNumber(payableBill.getDraftNumber());
            receivableBill.setDraftPackageNumber(payableBill.getDraftNumber());
            receivableBill.setIsSplit(payableBill.isIsSplit());
            if (payableBill.isIsSplit()) {
                receivableBill.setSubStartNumber(payableBill.getSubStartNumber());
                BigDecimal subQuantity = payableBill.getAmount().multiply(new BigDecimal(100));
                receivableBill.setSubQuantity(subQuantity);
                receivableBill.setSubEndNumber(payableBill.getSubEndNumber());
                receivableBill.setSubRegion(payableBill.getSubStartNumber().stripTrailingZeros().toPlainString() + "-" + payableBill.getSubEndNumber().stripTrailingZeros().toPlainString());
                receivableBill.setDraftNumber(receivableBill.getDraftPackageNumber() + "-" + receivableBill.getSubRegion());
            }
            receivableBill.setDrawerName(payableBill.getBillMakerName());
            receivableBill.setDrawerAccount(payableBill.getOutBankAccount());
            receivableBill.setDrawerAccountName(payableBill.getOutBankAccountName());
            receivableBill.setIsNoUsed(false);
            receivableBill.setBillMedium(payableBill.getBillMedium());
            receivableBill.setSource(payableBill.getDraftSource() != null ? payableBill.getDraftSource() : BillSourceEnum.BYHAND);
            String institutionName = null;
            institutionName = payableBill.getInstitution() != null ? payableBill.getInstitution().getName() : payableBill.getInstitutionName();
            if (!EmptyUtil.isEmpty((String)institutionName)) {
                BEBankInfo drawerBank = this.getBEBank(ctx, institutionName);
                if (drawerBank != null) {
                    receivableBill.setDrawerBank(drawerBank);
                    receivableBill.setDrawerBankName(drawerBank.getName());
                } else {
                    receivableBill.setDrawerBankName(institutionName);
                }
            }
            receivableBill.setDrawerBankNum(payableBill.getDrawerBankNumber());
            receivableBill.setPayee(payableBill.getPayee1());
            receivableBill.setPayeeSupp(payableBill.getPayee());
            receivableBill.setPayeeName(payableBill.getPayeeName());
            receivableBill.setPayeeAccountName(payableBill.getPayeeAccountName());
            receivableBill.setPayeeBankName(payableBill.getPayeeBankName());
            receivableBill.setPayeeBankNum(payableBill.getPayeeBankNumber());
            receivableBill.setIssuesDate(payableBill.getIssueDate());
            receivableBill.setCurrency(payableBill.getCurrency());
            receivableBill.setBillAmt(payableBill.getAmount());
            receivableBill.setExchangeRate(payableBill.getLocalCurExRate());
            receivableBill.setNaturalAmt(payableBill.getAmountLocalCur());
            receivableBill.setDeliverName(payableBill.getBillMakerName());
            receivableBill.setDeliverComp(payableBill.getBillMaker());
            receivableBill.setFundFlowItem(model.getFundFlowItemRec());
            ObjectBaseInfo csInfo = NTHelper.getCSInfoByNumber(ctx, payableBill.getBillMakerName());
            receivableBill.setDeliver(this.getCustomer(csInfo));
            receivableBill.setDeliverSupp(this.getSupplier(csInfo));
            receivableBill.setAcceptorName(payableBill.getAcceptor());
            if (payableBill.getAcceptorAccountName() != null && payableBill.getAcceptorAccountName().length() > 0) {
                receivableBill.setAcceptorAccountName(payableBill.getAcceptorAccountName());
            } else {
                receivableBill.setAcceptorAccountName("0");
            }
            Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
            receivableBill.setAcceptanceDate(payableBill.getAcceptDate() != null ? payableBill.getAcceptDate() : currentDate);
            receivableBill.setAcceptorBank(payableBill.getAcceptorBank());
            receivableBill.setAcceptorBankNum(payableBill.getAcceptorBankNum());
            receivableBill.setSourceBillId(payableBill.getId().toString());
            receivableBill.setContractNo(payableBill.getContractNumber());
            receivableBill.setExpiredDate(payableBill.getExpiredDate());
            receivableBill.setTakeDate(model.getTransferDate());
            receivableBill.setOutBgItemId(model.getPayableBgItemId());
            receivableBill.setOutBgItemName(model.getPayableBgItemName());
            receivableBill.setOutBgItemNumber(model.getPayableBgItemNumber());
            receivableBill.setFpItem(model.getFppayableItem());
            receivableBill.setAcceptanceBank(payableBill.getInstitution());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)receivableBill.getAcceptorBank())) {
                receivableBill.setAcceptanceBankName(receivableBill.getAcceptorBank().getName());
            } else if (ntTypeInfo.getGroup() == NTTypeGroupEnum.PAYABLE_BankAccept) {
                if (!EmptyUtil.isEmpty((String)receivableBill.getDrawerBankName())) {
                    receivableBill.setAcceptanceBankName(receivableBill.getDrawerBankName());
                }
            } else if (!EmptyUtil.isEmpty((String)receivableBill.getDrawerBankName())) {
                receivableBill.setAcceptanceBankName(receivableBill.getDrawerBankName());
            } else {
                receivableBill.setAcceptanceBankName(receivableBill.getDrawerName());
            }
            receivableBill.setOperator(model.getApplicant());
            receivableBill.setIsVendeePayInt(payableBill.isBuyerPayDisCnt());
            receivableBill.setIsHistory(false);
            int NT052 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("NT052", (IObjectPK)new ObjectUuidPK(model.getApplyCompany().getId().toString()));
            if (NT052 == 1) {
                receivableBill.setBillState(BillStateEnum.SAVED);
            } else {
                receivableBill.setBillState(BillStateEnum.TempSaved);
            }
            receivableBill.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            receivableBill.setTransferId(model.getId().toString());
            receivableBill.setDigest(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"38_PayableTransferBillControllerBean", (Locale)ctx.getLocale()));
            if (payableBill.getHorizonType() == HorizonTypeEnum.Mouths) {
                receivableBill.setPeriod(payableBill.getHorizon());
            } else {
                receivableBill.setPeriod(FinHorizon.getHorizon((Date)payableBill.getIssueDate(), (Date)payableBill.getExpiredDate()));
            }
            receivableBill.setExcuteBotp(BillStateEnum.SAVED);
            if (EmptyUtil.isEmpty((CoreBaseInfo)receivableBill.getHolder())) {
                receivableBill.setHolder(model.getApplyCompany());
            }
            IObjectPK pk = NTHelper.genReceivableBill(ctx, receivableBill);
            this.addEndorseListing(ctx, model, receivableBill, currentCompany);
            FinUtils.addBotRelation((Context)ctx, (String)model.getId().toString(), (String)pk.toString());
            if (!isCreateReceiving) continue;
            NTHelper.botpByRuleFilter(ctx, (CoreBillBaseInfo)receivableBill, new ReceivingBillInfo().getBOSType().toString());
        }
    }

    private BEBankInfo getBEBank(Context ctx, String bankName) throws BOSException {
        BEBankInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)bankName, CompareType.EQUALS));
        view.setFilter(filter);
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    private NTTypeInfo getNtype4ReceivableBill(Context ctx, NTTypeInfo ntTypeInfo) throws EASBizException, BOSException {
        NTTypeInfo returnType = null;
        INTType inttype = NTTypeFactory.getLocalInstance(ctx);
        returnType = ntTypeInfo.getGroup() == NTTypeGroupEnum.PAYABLE_CommerceAccept ? inttype.getNTTypeInfo((IObjectPK)new ObjectUuidPK("44444444-4444-4444-4444-4444444444441C9A9013")) : inttype.getNTTypeInfo((IObjectPK)new ObjectUuidPK("33333333-3333-3333-3333-3333333333331C9A9013"));
        return returnType;
    }

    private void addEndorseListing(Context ctx, PayableTransferBillInfo transferBill, ReceivableBillInfo newBillInfo, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        EndorseListingInfo elInfo = new EndorseListingInfo();
        elInfo.setHead(newBillInfo);
        elInfo.setEndorseDate(transferBill.getTransferDate());
        elInfo.setEndorser(newBillInfo.getPayeeName());
        elInfo.setEndorsee(currentCompany.getName());
        EndorseListingFactory.getLocalInstance(ctx).addnew(elInfo);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        BOTRelationInfo botInfo = (BOTRelationInfo)bOTRelationInfo;
        if (botInfo.getDestEntityID().equals(new VoucherInfo().getBOSType().toString())) {
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)"update T_NT_PayableTransferBill set FAccountantID=? where FID=?", (Object[])new Object[]{user.getId().toString(), botInfo.getSrcObjectID()});
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                DbUtil.execute((Context)ctx, (String)"update T_NT_PayableTransferBill set FAccountantID=null where FID=?", (Object[])new Object[]{botInfo.getSrcObjectID()});
            }
        }
    }

    @Override
    protected void _cancelConfirm(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("Fivouchered"));
        ObjectUuidPK pk = new ObjectUuidPK(id);
        PayableTransferBillInfo model = PayableTransferBillFactory.getLocalInstance(ctx).getPayableTransferBillInfo((IObjectPK)pk, sic);
        if (model.isFivouchered()) {
            throw new NTException(NTException.NOTCANCELCONFIRM4TRANSFER);
        }
        ReceivableBillFactory.getLocalInstance(ctx).removeWithTransfer(id);
        DbUtil.execute((Context)ctx, (String)"update T_NT_PayableTransferBill set FConfirmerID=null where FID=?", (Object[])new Object[]{id});
        if (model.getTransferTpye() == TransferBillTypeEnum.In) {
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(model.getId()), (String)model.getCompany().getId().toString());
        }
    }

    @Override
    protected void _confirm(Context ctx, IObjectValue model, boolean isCreateReceiving) throws BOSException, EASBizException {
        PayableTransferBillInfo transferinfo = (PayableTransferBillInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("transfer", (Object)transferinfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("Currency.*"));
        view.getSelector().add(new SelectorItemInfo("Type.*"));
        view.getSelector().add(new SelectorItemInfo("Institution.*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        view.getSelector().add(new SelectorItemInfo("billMaker.*"));
        view.getSelector().add(new SelectorItemInfo("acceptorBank.*"));
        PayableBillCollection coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
        transferinfo.getPayableEntrys().addCollection(coll);
        this.genReceivablebill(ctx, transferinfo, isCreateReceiving);
        DbUtil.execute((Context)ctx, (String)"update T_NT_PayableTransferBill set FConfirmerID=? where FID=?", (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString(), transferinfo.getId().toString()});
        if (transferinfo.getTransferTpye() == TransferBillTypeEnum.In) {
            FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(transferinfo.getId()), (String)transferinfo.getCompany().getId().toString());
        }
    }

    private CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }
}

