/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.NoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.NoteReceivableOpUtil;
import com.kingdee.eas.fm.be.app.service.NoteUpdateStautsUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.app.util.NoteBizInfo;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.IWageBillEntry;
import com.kingdee.eas.fm.fin.WageBillEntryCollection;
import com.kingdee.eas.fm.fin.WageBillEntryFactory;
import com.kingdee.eas.fm.fin.WageBillEntryInfo;
import com.kingdee.eas.fm.nt.AbstractReceivableBillInfo;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IPledgeRevokeBillEntry;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.PledgeRevokeBillCollection;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryCollection;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryFactory;
import com.kingdee.eas.fm.nt.PledgeRevokeBillEntryInfo;
import com.kingdee.eas.fm.nt.PledgeRevokeBillFactory;
import com.kingdee.eas.fm.nt.PledgeRevokeBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.AbstractPledgeRevokeBillControllerBean;
import com.kingdee.eas.fm.nt.app.BillServerUtil;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class PledgeRevokeBillControllerBean
extends AbstractPledgeRevokeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.PledgeRevokeBillControllerBean");
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";

    @Override
    protected ArrayList _commitToBE(Context ctx, Set idSet, String commitType) throws BOSException, EASBizException {
        ArrayList<BankPayResult> commitResult = new ArrayList<BankPayResult>();
        PledgeRevokeBillCollection pledgeRevokeBillColl = this.getPledgeRevokeBillCollByBill(ctx, idSet);
        int count = pledgeRevokeBillColl.size();
        for (int index = 0; index < count; ++index) {
            PledgeRevokeBillInfo info = pledgeRevokeBillColl.get(index);
            TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
            int size = info.getEntrys().size();
            for (int i = 0; i < size; ++i) {
                ReceivableBillInfo entry = info.getEntrys().get(i).getReceivableBill();
                String accNo = entry.getHolderAccount().getBankAccountNumber();
                ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
                if (lst == null) {
                    lst = new ArrayList<ReceivableBillInfo>();
                }
                lst.add(entry);
                accNoMap.put(accNo, lst);
            }
            NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil(ctx);
            try {
                for (String accNo : accNoMap.keySet()) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    List infoList = (List)accNoMap.get(accNo);
                    for (ReceivableBillInfo entry : infoList) {
                        totalAmount = totalAmount.add(entry.getBillAmt());
                    }
                    this.doCommitBE(ctx, recOpUtil, accNo, totalAmount, infoList, info);
                }
                continue;
            }
            catch (Exception e) {
                BankPayResult resultInfo = new BankPayResult();
                resultInfo.setId(info.getId().toString());
                resultInfo.setNumber(info.getNumber().toString());
                resultInfo.setErrorDetail(e.getMessage());
                commitResult.add(resultInfo);
            }
        }
        return commitResult;
    }

    private void doCommitBE(Context ctx, NoteReceivableOpUtil recOpUtil, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, PledgeRevokeBillInfo info) throws EASBizException, BOSException {
        logger.error((Object)"begin to commitToBE EndorsementBillInfo");
        try {
            this.beforeProcess(ctx, info.isCommitedToBE(), infoList);
            NoteReceivableBody body = this.parseRequestBody(ctx, totalAmount, infoList, info);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.REMOVE_PLEDGE);
            NoteReceivableDetail[] detail = recOpUtil.noteRecOp(ctx, bizInfo, body);
            info.setCommitedToBE(true);
            this.updatePartial(ctx, info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBE"}));
            this.afterProcess(ctx, info, infoList, detail);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void afterProcess(Context ctx, PledgeRevokeBillInfo info, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        CoreBaseCollection wageColl = new CoreBaseCollection();
        HashSet recSet = new HashSet();
        this.updatePledgeRevokeBillByDetail(ctx, info, infoList, details, recColl, recSet);
        if (recColl != null && recColl.size() > 0) {
            wageColl.add((CoreBaseInfo)info);
            this.updateBatchData(ctx, wageColl);
            ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
        }
        if (!EmptyUtil.isEmpty(recSet)) {
            IWageBillEntry wageEntryFactory = WageBillEntryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo wageEntryEv = new EntityViewInfo();
            FilterInfo wageEntryFilter = new FilterInfo();
            wageEntryFilter.getFilterItems().add(new FilterItemInfo("receivableBill.id", recSet, CompareType.INCLUDE));
            wageEntryEv.setFilter(wageEntryFilter);
            WageBillEntryCollection wageBillEntryColl = wageEntryFactory.getWageBillEntryCollection(wageEntryEv);
            HashSet<String> wageEntryIds = new HashSet<String>();
            for (int i = 0; i < wageBillEntryColl.size(); ++i) {
                wageEntryIds.add(wageBillEntryColl.get(i).getId().toString());
            }
            this.updatePledgeBill(ctx, wageEntryIds, false);
        }
    }

    private NoteReceivableBody parseRequestBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, PledgeRevokeBillInfo info) throws EASBizException, BOSException {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseDetail(ctx, infoList, info));
        return body;
    }

    private NoteReceivableDetail[] parseDetail(Context ctx, List<ReceivableBillInfo> infoList, PledgeRevokeBillInfo info) throws EASBizException, BOSException {
        BankInfo bankInfo = info.getInstitution();
        NoteReceivableDetail[] details = null;
        if (infoList.size() > 0) {
            details = new NoteReceivableDetail[infoList.size()];
            for (int i = 0; i < infoList.size(); ++i) {
                ReceivableBillInfo recInfo = infoList.get(i);
                NoteReceivableDetail detail = new NoteReceivableDetail();
                detail.setDetailSeqID(recInfo.getDetailSeqID());
                detail.setDetailBizNo(recInfo.getDetailSeqID());
                detail.setBillNo(recInfo.getDraftNumber());
                detail.setDraftType(recInfo.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
                detail.setTransferFlag("EM01");
                detail.setOppAccNo("0");
                detail.setOppAccName(bankInfo.getName());
                BEBankInfo beInfo = null;
                if (bankInfo.getAccountBank() != null) {
                    beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                }
                if (beInfo != null) {
                    detail.setOppCnapsCode(beInfo.getNumber());
                }
                detail.setOperationCode("19");
                detail.setOppAmount(info.getAmount().setScale(2).toString());
                detail.setBookingDate(DraftBEUtil.date2String(recInfo.getIssuesDate(), "yyyyMMddHHmmss"));
                detail.setDueDate(DraftBEUtil.date2String(recInfo.getExpiredDate(), "yyyyMMdd"));
                detail.setDesc(recInfo.getDescription());
                if (recInfo.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                    BillServerUtil.setKeepFlag(detail, recInfo);
                }
                details[i] = detail;
            }
        }
        return details;
    }

    private void beforeProcess(Context ctx, boolean isCommitBE, List<ReceivableBillInfo> infoList) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
        CoreBaseCollection recBillCollection = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo info = infoList.get(i);
            info.setDetailSeqID(serialNos[i]);
            info.setBatchSeqID(serialNos[0]);
            if (isCommitBE && info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                info.setBankReturnStatus(null);
                info.setBankReturnMsg(null);
            }
            recBillCollection.add((CoreBaseInfo)info);
        }
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recBillCollection);
    }

    private PledgeRevokeBillCollection getPledgeRevokeBillCollByBill(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Currency.*"));
        selector.add(new SelectorItemInfo("Institution.*"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.*"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.ntType.*"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.id"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.name"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.bankAccountNumber"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.id"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.name"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.number"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorseDate"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.company.*"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCompany.*"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedSupplier.*"));
        selector.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCustomer.*"));
        selector.add(new SelectorItemInfo("entrys.company.*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        view.setSelector(selector);
        PledgeRevokeBillCollection coll = PledgeRevokeBillFactory.getLocalInstance(ctx).getPledgeRevokeBillCollection(view);
        return coll;
    }

    @Override
    protected Map _syncStatus(Context ctx, Set idSet, String syncType) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = this.getSelectors4EditStatus();
        view.setSelector(sic);
        int success = 0;
        PledgeRevokeBillCollection coll = this.getPledgeRevokeBillCollection(ctx, view);
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil();
        PledgeRevokeBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            try {
                if (!info.isCommitedToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                for (int j = 0; j < info.getEntrys().size(); ++j) {
                    PledgeRevokeBillEntryInfo pledgeRevokeBillEntryInfo = info.getEntrys().get(j);
                    ReceivableBillInfo entry = pledgeRevokeBillEntryInfo.getReceivableBill();
                    String batchSeqID = entry.getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID) || pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doSyncStatus(ctx, info, recOpUtil, batchSeqMap);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == idSet.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private SelectorItemCollection getSelectors4EditStatus() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.name"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.number"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorseDate"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.company.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.endorseBill.endorsedCustomer.*"));
        return sic;
    }

    private void doSyncStatus(Context ctx, PledgeRevokeBillInfo info, NoteReceivableOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        CoreBaseCollection wageEntryColl = new CoreBaseCollection();
        HashSet recSet = new HashSet();
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryRec(ctx, recOpUtil, infoList);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess4Sys(ctx, info, infoList, details, recColl, recSet);
        }
        CoreBaseCollection wageColl = new CoreBaseCollection();
        if (recColl != null && recColl.size() > 0) {
            wageColl.add((CoreBaseInfo)info);
            this.updateBatchData(ctx, wageColl);
            ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
        }
        if (!EmptyUtil.isEmpty(recSet)) {
            IWageBillEntry wageEntryFactory = WageBillEntryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo wageEntryEv = new EntityViewInfo();
            FilterInfo wageEntryFilter = new FilterInfo();
            wageEntryFilter.getFilterItems().add(new FilterItemInfo("receivableBill.id", recSet, CompareType.INCLUDE));
            wageEntryEv.setFilter(wageEntryFilter);
            WageBillEntryCollection wageBillEntryColl = wageEntryFactory.getWageBillEntryCollection(wageEntryEv);
            HashSet<String> wageEntryIds = new HashSet<String>();
            for (int i = 0; i < wageBillEntryColl.size(); ++i) {
                logger.error((Object)("\u6dfb\u52a0\u4e86\u8d28\u62bc\u5206\u5f55ID\uff1a " + wageBillEntryColl.get(i).getId().toString()));
                wageEntryIds.add(wageBillEntryColl.get(i).getId().toString());
            }
            this.updatePledgeBill(ctx, wageEntryIds, false);
        }
    }

    private NoteReceivableDetail getDetail(String detailSeqID) {
        NoteReceivableDetail detail = new NoteReceivableDetail();
        detail.setBankBatchSeqID("fsksfhtj");
        detail.setBankStatus("NCB4292");
        detail.setBankStatusMsg("NCB4292 -\u671f\u671b\u65e5\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\u7968\u636e\u72b6\u6001\uff1a\u672a\u77e5");
        detail.setBillNo("130858400104920220222153508372");
        detail.setBookingDate("20211215");
        detail.setDetailSeqID(detailSeqID);
        detail.setDraftType("AC01");
        detail.setDueDate("20221015");
        detail.setEbSeqID("fsksfhtj");
        detail.setEbStatus("BANK_FAIL");
        detail.setEbStatusMsg("\u4ea4\u6613\u5931\u8d25");
        detail.setOperationCode("19");
        detail.setOppAccName("\u62db\u5546\u94f6\u884c\u6df1\u5733\u86c7\u53e3\u652f\u884c");
        detail.setOppAccNo("0");
        detail.setOppAmount("10.00");
        detail.setOppCnapsCode("308584001049");
        detail.setTransferFlag("EM01");
        return detail;
    }

    private CoreBaseCollection afterProcess4Sys(Context ctx, PledgeRevokeBillInfo info, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details, CoreBaseCollection recColl, Set recSet) throws EASBizException, BOSException {
        this.updatePledgeRevokeBillByDetail(ctx, info, infoList, details, recColl, recSet);
        return recColl;
    }

    private void updatePledgeRevokeBillByDetail(Context ctx, PledgeRevokeBillInfo info, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details, CoreBaseCollection recColl, Set recSet) {
        int i;
        HashSet<String> idSet = new HashSet<String>();
        int count = infoList.size();
        for (i = 0; i < count; ++i) {
            idSet.add(infoList.get(i).getId().toString());
        }
        logger.error((Object)"updatePledgeRevokeBillByDetail \u5f00\u59cb");
        for (i = 0; i < info.getEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = info.getEntrys().get(i).getReceivableBill();
            PledgeRevokeBillEntryInfo pledgeRevokeBillEntryInfo = info.getEntrys().get(i);
            if (idSet != null && !idSet.contains(pledgeRevokeBillEntryInfo.getReceivableBill().getId().toString()) || pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
            String detailSeqID = recInfo.getDetailSeqID();
            logger.error((Object)("\u5e94\u6536\u7968\u636eID \uff1a " + recInfo.getId().toString() + " \uff0cdetailSeqID \uff1a " + detailSeqID));
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (detailSeqID == null || !detailSeqID.equals(detail.getDetailSeqID())) continue;
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName())) {
                    logger.error((Object)"\u5339\u914d\u5230Detail\uff0c\u7ed3\u679c\u4e3a\u4ea4\u6613\u6210\u529f");
                    logger.error((Object)("detail.getReservedFiled2() = " + detail.getReservedFiled2()));
                    if ("REMOVE_PLEDGE".equalsIgnoreCase(detail.getReservedFiled2())) {
                        this.receivableDispledge(ctx, recInfo);
                    } else if ("NOTE_CANCLE".equalsIgnoreCase(detail.getReservedFiled2()) && pledgeRevokeBillEntryInfo.isRevokeCancel()) {
                        info.getEntrys().get(i).setRevokeCancelSucceed(true);
                        recSet.add(recInfo.getId().toString());
                    }
                } else if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName())) {
                    if ("REMOVE_PLEDGE".equalsIgnoreCase(detail.getReservedFiled2())) {
                        logger.error((Object)"\u5339\u914d\u5230Detail\uff0c\u7ed3\u679c\u4e3a\u4ea4\u6613\u5931\u8d25");
                        recSet.add(recInfo.getId().toString());
                        logger.error((Object)("recSet = " + recSet.toString()));
                    } else if ("NOTE_CANCLE".equalsIgnoreCase(detail.getReservedFiled2()) && pledgeRevokeBillEntryInfo.isRevokeCancel()) {
                        recInfo.setIsPledge(true);
                        info.getEntrys().get(i).setRevokeCancel(false);
                    }
                }
                try {
                    if (recInfo.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                        ElecBillStatusEnum elecBillStatusEnum = null;
                        elecBillStatusEnum = info.getEntrys().get(i).isRevokeCancel() ? BillServerUtil.setElecBillStatus("disPledge_Cancle", recInfo, detail) : BillServerUtil.setElecBillStatus("disPledge", recInfo, detail);
                        if (!EmptyUtil.isEmpty((Object)((Object)elecBillStatusEnum))) {
                            info.getEntrys().get(i).setElecBillStatus(elecBillStatusEnum);
                        }
                    } else if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                        recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                        info.getEntrys().get(i).setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                info.getEntrys().get(i).setBankReturnMsg(detail.getBankStatusMsg());
                info.getEntrys().get(i).setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                recColl.add((CoreBaseInfo)recInfo);
            }
        }
    }

    private NoteReceivableDetail[] queryRec(Context ctx, NoteReceivableOpUtil recOpUtil, List<ReceivableBillInfo> infoList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryNoteReceivable(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    @Override
    protected Map _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        PledgeRevokeBillCollection coll = this.getPledgeRevokeBillCollection(ctx, evi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("billStatus"));
        StringBuffer errorMessage = new StringBuffer();
        int successCount = 0;
        for (int i = 0; i < coll.size(); ++i) {
            PledgeRevokeBillInfo info = coll.get(i);
            if (info.getBillStatus() == FinBillStatusEnum.SUBMIT) {
                info.setBillStatus(FinBillStatusEnum.AUDITED);
                this.updatePartial(ctx, info, selectors);
                ++successCount;
                continue;
            }
            errorMessage.append(info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"554_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()) + "\n");
        }
        return this.produceReturnMessage(ctx, ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"555_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()), idSet.size(), successCount, errorMessage);
    }

    @Override
    protected Map _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        PledgeRevokeBillCollection coll = this.getPledgeRevokeBillCollection(ctx, evi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("billStatus"));
        StringBuffer errorMessage = new StringBuffer();
        int successCount = 0;
        for (int i = 0; i < coll.size(); ++i) {
            PledgeRevokeBillInfo info = coll.get(i);
            if (info.getBillStatus() == FinBillStatusEnum.AUDITED) {
                info.setBillStatus(FinBillStatusEnum.SAVE);
                this.updatePartial(ctx, info, selectors);
                ++successCount;
                continue;
            }
            errorMessage.append(info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"556_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()) + "\n");
        }
        return this.produceReturnMessage(ctx, ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"557_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()), idSet.size(), successCount, errorMessage);
    }

    private Map produceReturnMessage(Context ctx, String operationType, int billCount, int successCount, StringBuffer errMessage) {
        HashMap<String, Comparable<Integer>> retMap = new HashMap<String, Comparable<Integer>>();
        int errorCode = billCount == successCount ? 0 : (successCount == 0 ? 2 : 1);
        retMap.put("errorCode", Integer.valueOf(errorCode));
        StringBuffer messageHeader = null;
        messageHeader = errorCode == 0 ? new StringBuffer(operationType + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"243_BondsContractListUI", (Locale)ctx.getLocale())) : (errorCode == 1 ? new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"558_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()) + operationType + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"559_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale())) : new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"560_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()) + operationType + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"559_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale())));
        retMap.put("messageHeader", messageHeader);
        retMap.put("errMessage", errMessage);
        return retMap;
    }

    @Override
    protected Map _auditWF(Context ctx, IObjectPK pk, IObjectPK auditorID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _antiAuditWF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _addSrcRelations(Context ctx, Set srcIDSet, String destID) throws BOSException, EASBizException {
        ArrayList srcIdList = new ArrayList(srcIDSet);
        BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)destID);
    }

    @Override
    protected Map _submit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        PledgeRevokeBillCollection coll = this.getPledgeRevokeBillCollection(ctx, evi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("billStatus"));
        StringBuffer errorMessage = new StringBuffer();
        int successCount = 0;
        for (int i = 0; i < coll.size(); ++i) {
            PledgeRevokeBillInfo info = coll.get(i);
            if (info.getBillStatus() == FinBillStatusEnum.SAVE) {
                info.setBillStatus(FinBillStatusEnum.SUBMIT);
                this.updatePartial(ctx, info, selectors);
                ++successCount;
                continue;
            }
            errorMessage.append(info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"561_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()) + "\n");
        }
        return this.produceReturnMessage(ctx, ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"562_PledgeRevokeBillControllerBean", (Locale)ctx.getLocale()), idSet.size(), successCount, errorMessage);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        this._submit(ctx, idSet);
        return pk;
    }

    @Override
    protected void _editStatus(Context ctx, List statusList) throws BOSException, EASBizException {
        ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
        Map listmap = (Map)statusList.get(0);
        String recId = (String)listmap.get("id");
        HashMap<String, PledgeRevokeBillEntryInfo> entryMap = new HashMap<String, PledgeRevokeBillEntryInfo>();
        PledgeRevokeBillInfo info = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            idSet.add(id);
        }
        PledgeRevokeBillEntryInfo entryInfo = null;
        if (!EmptyUtil.isEmpty(idSet)) {
            PledgeRevokeBillEntryCollection entryColl = this.getPledgeRevokeBillEntryCollectionById(ctx, idSet);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)entryColl)) {
                info = this.getPledgeRevokeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(entryColl.get(0).getParent().getId()), this.getSelectors4EditStatus());
                PledgeRevokeBillEntryCollection newEntryColl = info.getEntrys();
                for (int i = 0; i < newEntryColl.size(); ++i) {
                    PledgeRevokeBillEntryInfo entry = newEntryColl.get(i);
                    entryMap.put(entry.getReceivableBill().getId().toString(), entry);
                }
            }
            for (int i = 0; i < statusList.size(); ++i) {
                Map map = (Map)statusList.get(i);
                String id = (String)map.get("id");
                if (!entryMap.containsKey(id)) continue;
                entryInfo = (PledgeRevokeBillEntryInfo)entryMap.get(id);
                if (entryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) {
                    throw new BEException(BEException.UPDATESTATEERROR1);
                }
                entryInfo.getReceivableBill().setBankReturnStatus((BankReturnStatusEnum)((Object)map.get("bankReturnStatus")));
                entryInfo.setBankReturnStatus((BankReturnStatusEnum)((Object)map.get("bankReturnStatus")));
                updateList.add(entryInfo.getReceivableBill());
            }
            logger.debug((Object)"begin to updateBeStatus wageInfo");
            NoteUpdateStautsUtil util = new NoteUpdateStautsUtil();
            NoteStatusBody body = new NoteStatusBody();
            body.setTotalCount(String.valueOf(updateList.size()));
            body.setDetails(this.parseUpdteDetail(ctx, updateList));
            try {
                NoteStatusDetail[] details = util.updateNoteStatus(ctx, null, body);
                this.afterProcess4Update(ctx, info, updateList, details);
            }
            catch (BEException e) {
                throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
            }
            catch (ServiceException e) {
                throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
            }
            catch (Exception err) {
                if (err.getCause() instanceof ConnectException) {
                    throw new BEException(BEException.GETSERVICEFAILURE);
                }
                logger.error((Object)err);
                throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
            }
        }
    }

    private PledgeRevokeBillInfo getPledgeRevokeBillInfoById(Context ctx, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.detailSeqID"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.batchSeqID"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.bankReturnStatus"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.bankReturnMsg"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.elecBillStatus"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.company.id"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        PledgeRevokeBillCollection coll = PledgeRevokeBillFactory.getLocalInstance(ctx).getPledgeRevokeBillCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private PledgeRevokeBillEntryCollection getPledgeRevokeBillEntryCollectionById(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("receivableBill", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("revokeCancelSucceed", (Object)new Integer(0)));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("receivableBill.detailSeqID"));
        sic.add(new SelectorItemInfo("receivableBill.batchSeqID"));
        sic.add(new SelectorItemInfo("receivableBill.bankReturnStatus"));
        sic.add(new SelectorItemInfo("receivableBill.bankReturnMsg"));
        sic.add(new SelectorItemInfo("receivableBill.elecBillStatus"));
        sic.add(new SelectorItemInfo("receivableBill.company.id"));
        view.setSelector(sic);
        PledgeRevokeBillEntryCollection coll = PledgeRevokeBillEntryFactory.getLocalInstance(ctx).getPledgeRevokeBillEntryCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll;
        }
        return null;
    }

    private void afterProcess4Update(Context ctx, PledgeRevokeBillInfo info, List<ReceivableBillInfo> updateList, NoteStatusDetail[] details) throws EASBizException, BOSException {
        int i;
        CoreBaseCollection recColl = new CoreBaseCollection();
        CoreBaseCollection pledgeRevokeBillColl = new CoreBaseCollection();
        HashSet<String> recSet = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>();
        int count = updateList.size();
        for (i = 0; i < count; ++i) {
            idSet.add(updateList.get(i).getId().toString());
        }
        for (i = 0; i < info.getEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = info.getEntrys().get(i).getReceivableBill();
            PledgeRevokeBillEntryInfo pledgeRevokeBillEntryInfo = info.getEntrys().get(i);
            if (idSet != null && !idSet.contains(pledgeRevokeBillEntryInfo.getReceivableBill().getId().toString()) || pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || pledgeRevokeBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteStatusDetail detail = details[j];
                if (detailSeqID == null || !detailSeqID.equals(detail.getDetailSeqID())) continue;
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName())) {
                    logger.error((Object)("\u8d28\u62bc\u64a4\u9500 \u662f\u5426\u6210\u529f detail.getReservedFiled2() = " + pledgeRevokeBillEntryInfo.isRevokeCancel()));
                    if (pledgeRevokeBillEntryInfo.isRevokeCancel()) {
                        pledgeRevokeBillEntryInfo.setElecBillStatus(ElecBillStatusEnum.NT180006);
                        recInfo.setElecBillStatus(ElecBillStatusEnum.NT180006);
                    } else {
                        this.receivableDispledge(ctx, recInfo);
                    }
                } else if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName())) {
                    if (pledgeRevokeBillEntryInfo.isRevokeCancel()) {
                        recInfo.setIsPledge(true);
                        info.getEntrys().get(i).setRevokeCancel(false);
                    } else {
                        recSet.add(recInfo.getId().toString());
                    }
                }
                try {
                    if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                        recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                        info.getEntrys().get(i).setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                info.getEntrys().get(i).setBankReturnMsg(detail.getBankStatusMsg());
                info.getEntrys().get(i).setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        pledgeRevokeBillColl.add((CoreBaseInfo)info);
        this.updateBatchData(ctx, pledgeRevokeBillColl);
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recColl);
        if (!EmptyUtil.isEmpty(recSet)) {
            IWageBillEntry wageEntryFactory = WageBillEntryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo wageEntryEv = new EntityViewInfo();
            FilterInfo wageEntryFilter = new FilterInfo();
            wageEntryFilter.getFilterItems().add(new FilterItemInfo("receivableBill.id", recSet, CompareType.INCLUDE));
            wageEntryEv.setFilter(wageEntryFilter);
            WageBillEntryCollection wageBillEntryColl = wageEntryFactory.getWageBillEntryCollection(wageEntryEv);
            HashSet<String> wageEntryIds = new HashSet<String>();
            for (int i2 = 0; i2 < wageBillEntryColl.size(); ++i2) {
                wageEntryIds.add(wageBillEntryColl.get(i2).getId().toString());
            }
            this.updatePledgeBill(ctx, wageEntryIds, false);
        }
    }

    private void receivableDispledge(Context ctx, ReceivableBillInfo recInfo) {
        recInfo.setIsPledge(false);
        recInfo.setDigest(null);
        recInfo.setTransferDate(null);
        boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()));
        logger.error((Object)("\u53c2\u6570NTO11 = " + NT011));
        if (NT011) {
            recInfo.setBillState(BillStateEnum.Audit);
        } else {
            recInfo.setBillState(BillStateEnum.SAVED);
        }
    }

    private NoteStatusDetail[] parseUpdteDetail(Context ctx, List<ReceivableBillInfo> updateList) {
        NoteStatusDetail[] details = new NoteStatusDetail[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            NoteStatusDetail detail = new NoteStatusDetail();
            detail.setDetailSeqID(recInfo.getDetailSeqID());
            detail.setBatchSeqID(recInfo.getBatchSeqID());
            detail.setEbStatus(recInfo.getBankReturnStatus().getName());
            detail.setEbNoteType("noteRecivable");
            detail.setUpdateReason(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"065_EDITBESTATUS_BYHAND"));
            detail.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            detail.setOrganizationName(ContextUtil.getCurrentFIUnit((Context)ctx).getName());
            details[i] = detail;
        }
        return details;
    }

    @Override
    protected void _noteCancels(Context ctx, IObjectPK pk, HashSet idSet) throws BOSException, EASBizException {
        PledgeRevokeBillInfo info = this.getPledgeRevokeBillInfo(ctx, pk, this.getSelectors());
        HashMap wageMap = new HashMap();
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (!idSet.contains(info.getEntrys().get(i).getId().toString())) continue;
            ReceivableBillInfo entry = info.getEntrys().get(i).getReceivableBill();
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
        }
        for (String accNo : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                totalAmount = totalAmount.add(entry.getBillAmt());
            }
            this.doNoteCancle(ctx, accNo, totalAmount, infoList, info, idSet);
        }
    }

    private void doNoteCancle(Context ctx, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, PledgeRevokeBillInfo info, HashSet idSet) throws BOSException, EASBizException {
        logger.debug((Object)"begin to noteCancle WageInfo");
        try {
            String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
            CoreBaseCollection recBillCollection = new CoreBaseCollection();
            StringBuffer noteNumber = new StringBuffer();
            for (int i = 0; i < infoList.size(); ++i) {
                ReceivableBillInfo receivableBillInfo = infoList.get(i);
                receivableBillInfo.setLastBatchSeq(receivableBillInfo.getBatchSeqID());
                receivableBillInfo.setLastDetailSeq(receivableBillInfo.getDetailSeqID());
                receivableBillInfo.setDetailSeqID(serialNos[i]);
                receivableBillInfo.setBatchSeqID(serialNos[0]);
                if (i < infoList.size() - 1) {
                    noteNumber.append(receivableBillInfo.getDraftNumber()).append(";");
                } else {
                    noteNumber.append(receivableBillInfo.getDraftNumber());
                }
                recBillCollection.add((CoreBaseInfo)receivableBillInfo);
            }
            ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recBillCollection);
            logger.error((Object)("\u8d28\u62bc\u5355\u7684\u7968\u636e\u53f7\u7801 = " + noteNumber.toString()));
            NoteReceivableOpUtil noteReceivableOpUtil = new NoteReceivableOpUtil();
            NoteReceivableBody noteReceivableBody = this.parseNoteReceivableBody(ctx, totalAmount, infoList, info);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.NOTE_CANCLE);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014before REMOVE_PLEDGE\u2014\u2014\u2014\u2014\u2014\u2014");
            NoteReceivableDetail[] noteReceivableDetails = noteReceivableOpUtil.noteRecOp(ctx, bizInfo, noteReceivableBody);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014end REMOVE_PLEDGE\u2014\u2014\u2014\u2014\u2014\u2014");
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                PledgeRevokeBillEntryInfo pledgeRevokeBillEntryInfo = info.getEntrys().get(i);
                if (!idSet.contains(pledgeRevokeBillEntryInfo.getId().toString())) continue;
                pledgeRevokeBillEntryInfo.setRevokeCancel(true);
            }
            this.afterProcess(ctx, info, infoList, noteReceivableDetails);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    private NoteReceivableBody parseNoteReceivableBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, PledgeRevokeBillInfo info) throws NTException {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseNoteReceiableDetail(ctx, infoList, info));
        return body;
    }

    private NoteReceivableDetail[] parseNoteReceiableDetail(Context ctx, List<ReceivableBillInfo> infoList, PledgeRevokeBillInfo info) throws NTException {
        NoteReceivableDetail[] details = new NoteReceivableDetail[infoList.size()];
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo entry = infoList.get(i);
            NoteReceivableDetail detail = new NoteReceivableDetail();
            detail.setDetailSeqID(entry.getDetailSeqID());
            detail.setDetailBizNo(entry.getDetailSeqID());
            detail.setOppAccNo(entry.getAcceptorAccountName());
            detail.setOppAccName(entry.getAcceptorName());
            detail.setOppBankName(entry.getAcceptorBankName());
            detail.setOppCnapsCode(entry.getAcceptorBankNum());
            detail.setOppAmount(info.getAmount().setScale(2, 4).toString());
            detail.setBillNo(entry.getDraftNumber());
            detail.setDraftType(entry.getNtType().getGroup().equals((Object)NTTypeGroupEnum.PAYABLE_BankAccept) ? "AC01" : "AC02");
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0cDetail\u94f6\u884c\u53c2\u8003\u53f7\u4e3a\uff1a " + detail.getBankRefKey()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636eID\u4e3a\uff1a " + entry.getId().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636eNTPYPEID\u4e3a\uff1a " + entry.getNtType().getId().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636e\u7684\u7968\u636e\u7c7b\u578b\u5206\u7ec4\u4e3a\uff1a " + entry.getNtType().getGroup().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0cDraftType \u4e3a\uff1a " + detail.getDraftType()));
            if ("AC02".equals(detail.getDraftType()) && "33333333-3333-3333-3333-3333333333331C9A9013".equals(entry.getNtType().getId().toString())) {
                logger.error((Object)"reWriting DraftType to  AC01");
                detail.setDraftType("AC01");
            }
            detail.setTransferFlag(entry.isIsTransfer() ? "EM00" : "EM01");
            detail.setBookingDate(DraftBEUtil.date2String(entry.getIssuesDate(), "yyyyMMddHHmmss"));
            detail.setDueDate(DraftBEUtil.date2String(entry.getExpiredDate(), "yyyyMMdd"));
            detail.setIssueDate(DraftBEUtil.date2String(entry.getIssuesDate(), "yyyyMMdd"));
            if (entry.getElecBillStatus() != null) {
                detail.setNoteStatus(entry.getElecBillStatus().getValue());
            }
            detail.setDesc(info.getDescription());
            detail.setOperationCode("19");
            detail.setOperationName("\u8d28\u62bc\u89e3\u9664\u7533\u8bf7\u64a4\u9500");
            ArrayList receivableId = new ArrayList();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            AbstractReceivableBillInfo receInfo = null;
            try {
                receivableId = BOTRelationFactory.getLocalInstance((Context)ctx).getSrcObjIdBySrcType(info.getId().toString(), new ReceivableBillInfo().getBOSType().toString());
                if (!EmptyUtil.isEmpty((Collection)receivableId)) {
                    receInfo = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(receivableId.get(0).toString()), selector);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"beginDiscountCommitToBe error EASBizException");
                e.printStackTrace();
            }
            catch (BOSException e) {
                logger.error((Object)"beginDiscountCommitToBe error BOSException");
                e.printStackTrace();
            }
            if (!EmptyUtil.isEmpty(receInfo)) {
                detail.setReservedFiled2(receInfo.getDrawerName() + "|" + receInfo.getDrawerAccountName() + "|" + receInfo.getDrawerBankName());
                logger.error((Object)("DrawerName = " + receInfo.getDrawerName() + "DrawerAccountName = " + receInfo.getDrawerAccountName() + "DrawerBankName = " + receInfo.getDrawerBankName()));
                logger.error((Object)("detail.getReservedFiled2() = " + detail.getReservedFiled2()));
            } else {
                logger.error((Object)"EmptyUtil.isEmpty(receInfo)");
                logger.error((Object)"\u5e94\u6536\u7968\u636e \u4e3a\u7a7a");
                logger.error((Object)("detail.getReservedFiled2() = " + detail.getReservedFiled2()));
            }
            if (entry.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                BillServerUtil.setKeepFlag(detail, entry);
            }
            details[i] = detail;
        }
        return details;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.currency.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.holderAccount.*"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.company.id"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.billstate"));
        sic.add(new SelectorItemInfo("entrys.receivableBill.isNoteCancel"));
        return sic;
    }

    @Override
    protected Map _updatePledgeBill(Context ctx, Set idSet, boolean isRevoke) throws BOSException, EASBizException {
        logger.error((Object)("\u8d28\u62bc\u5206\u5f55IDset= " + idSet.toString() + " isRevoke =" + isRevoke));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        WageBillEntryCollection coll = new WageBillEntryCollection();
        IWageBillEntry IWage2 = WageBillEntryFactory.getLocalInstance((Context)ctx);
        coll = IWage2.getWageBillEntryCollection(view);
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            WageBillEntryInfo info = coll.get(i);
            info.setPledgeRevoked(isRevoke);
            coreColl.add((CoreBaseInfo)info);
        }
        IWage2.updateBatchData(coreColl);
        return null;
    }

    private Map updateReceivableBill(Context ctx, Set idSet, boolean isRevoke) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        ReceivableBillCollection coll = new ReceivableBillCollection();
        IReceivableBill IWage2 = ReceivableBillFactory.getLocalInstance(ctx);
        coll = IWage2.getReceivableBillCollection(view);
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = coll.get(i);
            info.setIsPledge(false);
            coreColl.add((CoreBaseInfo)info);
        }
        IWage2.updateBatchData(coreColl);
        return null;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IPledgeRevokeBillEntry entryFactory = PledgeRevokeBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> ids = new HashSet<String>();
        ids.add(pk.toString());
        filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        ev.setSelector(this.getSelectors());
        PledgeRevokeBillCollection coll = this.getPledgeRevokeBillCollection(ctx, ev);
        HashSet<String> enrtySet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PledgeRevokeBillInfo info = coll.get(i);
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                enrtySet.add(info.getEntrys().get(j).getId().toString());
            }
        }
        EntityViewInfo entryEv = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", enrtySet, CompareType.INCLUDE));
        entryEv.setFilter(filter);
        entryEv.setSelector(this.getEntrySelectors());
        PledgeRevokeBillEntryCollection entryColl = entryFactory.getPledgeRevokeBillEntryCollection(entryEv);
        HashSet<String> recIDs = new HashSet<String>();
        HashSet<String> wageIDs = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            PledgeRevokeBillEntryInfo entry = entryColl.get(i);
            ReceivableBillInfo recBill = entry.getReceivableBill();
            recIDs.add(recBill.getId().toString());
            wageIDs.add(recBill.getWageId().getId().toString());
        }
        IWageBillEntry wageEntryFactory = WageBillEntryFactory.getLocalInstance((Context)ctx);
        EntityViewInfo wageEntryEv = new EntityViewInfo();
        FilterInfo wageEntryFilter = new FilterInfo();
        wageEntryFilter.getFilterItems().add(new FilterItemInfo("parent.id", wageIDs, CompareType.INCLUDE));
        wageEntryFilter.getFilterItems().add(new FilterItemInfo("receivableBill.id", recIDs, CompareType.INCLUDE));
        wageEntryEv.setFilter(wageEntryFilter);
        WageBillEntryCollection wageEntryColl = wageEntryFactory.getWageBillEntryCollection(wageEntryEv);
        HashSet<String> wageEntryIds = new HashSet<String>();
        for (int i = 0; i < wageEntryColl.size(); ++i) {
            wageEntryIds.add(wageEntryColl.get(i).getId().toString());
        }
        this.updatePledgeBill(ctx, wageEntryIds, false);
        super._delete(ctx, pk);
    }

    public SelectorItemCollection getEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("receivableBill.wageId.*"));
        return sic;
    }
}

