/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.RecChequeFactory;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;

public class RecChequeBookBuilder
extends DefaultBookNotifyBuilder {
    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("payeeBank.*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.account.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("payerS.name"));
        sic.add(new SelectorItemInfo("payerS.number"));
        sic.add(new SelectorItemInfo("payerC.name"));
        sic.add(new SelectorItemInfo("payerC.number"));
        sic.add(new SelectorItemInfo("remitterS.name"));
        sic.add(new SelectorItemInfo("remitterS.number"));
        sic.add(new SelectorItemInfo("remitterC.name"));
        sic.add(new SelectorItemInfo("remitterC.number"));
        sic.add(new SelectorItemInfo("receiptAcct.*"));
        sic.add(new SelectorItemInfo("oppAcct.*"));
        return sic;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection jColl = new JournalCollection();
        RecChequeInfo info = RecChequeFactory.getLocalInstance(ctx).getRecChequeInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelectors());
        NTTypeInfo ntType = info.getNtType();
        if (ntType.isIsCash()) {
            jColl.add(this.getCashDebitJournal(ctx, info));
        } else {
            jColl.add(this.getBankDebitJournal(ctx, info));
        }
        return jColl;
    }

    private JournalInfo getCashDebitJournal(Context ctx, RecChequeInfo info) throws BOSException, EASBizException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, info);
        journalInfo.setType(JournalTypeEnum.CASH);
        return journalInfo;
    }

    private JournalInfo getBankDebitJournal(Context ctx, RecChequeInfo info) throws BOSException, EASBizException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, info);
        String oppUnit = info.getPayerS() != null ? info.getPayerS().getName() : (info.getPayerC() != null ? info.getPayerC().getName() : info.getPayer());
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getPayeeBankAcct());
        journalInfo.setOppUnit(oppUnit);
        journalInfo.setOppBank(info.getPayerBank());
        journalInfo.setOppAcctNumber(info.getPayerBankAcct());
        return journalInfo;
    }

    private JournalInfo createBaseJouranl(Context ctx, RecChequeInfo bill) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setId(BOSUuid.create((BOSObjectType)journalInfo.getBOSType()));
        journalInfo.setCompany(bill.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(bill.getId().toString());
        journalInfo.setBizDate(bill.getReceiptDate());
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"currPeriod")});
        }
        Date bookDate = bill.getReceiptDate();
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setBillType(BillTypeEnum.RecCheque);
        journalInfo.setBillNumber(bill.getNumber());
        journalInfo.setSettlementNumber(bill.getNumber());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)bill.getNtType().getId().toString()));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        journalInfo.setSettlementType(type);
        journalInfo.setCurrency(bill.getCurrency());
        journalInfo.setDebitAmount(bill.getReceiptAmount());
        journalInfo.setCreditAmount(Constants.ZERO);
        journalInfo.setDescription(bill.getDescription());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setAccountView(bill.getReceiptAcct());
        journalInfo.setOppAccountView(bill.getOppAcct());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        return journalInfo;
    }
}

