/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ReceivableBillImportVerify {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)ReceivableBillImportVerify.class.getName());

    public void verifyHead(Context ctx, CoreBaseInfo head) throws TaskExternalException {
        if (!(head instanceof ReceivableBillInfo)) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"61_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        ReceivableBillInfo info = (ReceivableBillInfo)head;
        this.checkEmpty(info.getNumber(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"62_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getDraftNumber(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"453_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getCompany(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"63_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        CompanyOrgUnitInfo companyInfo = info.getCompany();
        this.checkEmpty(info.getIssuesDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"64_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        if (info.isIsNoUsed()) {
            this.checkEmpty(info.getDrawerName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"65_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        }
        if (info.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept)) {
            this.checkEmpty(info.getDrawerBankName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"553_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        }
        if (info.getBillMedium() == BillMediumEnum.ELECTRONIC) {
            this.checkEmpty(info.getDrawerBankNum(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"544_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
            this.checkEmpty(info.getPayeeBankNum(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"545_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
            this.checkEmpty(info.getAcceptorName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"549_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
            this.checkEmpty(info.getAcceptorAccountName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"546_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
            this.checkEmpty(info.getAcceptorBankNum(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"547_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        }
        this.checkEmpty(info.getBillAmt(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"67_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getExpiredDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"68_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getTakeDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"69_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getDeliverName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"70_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getCurrency(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"71_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getExchangeRate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"72_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty((Object)info.getBillState(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"73_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        CurrencyInfo currency = info.getCurrency();
        if (info.getExchangeRate().compareTo(Constants.ZERO) < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"74_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (info.getBillAmt().compareTo(Constants.ZERO) < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"75_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo localCurrency = companyInfo.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId()) && info.getExchangeRate().compareTo(Constants.ONE) != 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"76_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (info.getNumber().length() > 80) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"455_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (!EmptyUtil.isEmpty((Object)info.getSubStartNumber()) && info.getSubStartNumber().compareTo(new BigDecimal("999999999999")) > 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"639_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (info.getExpiredDate().before(info.getIssuesDate()) || info.getExpiredDate().equals(info.getIssuesDate())) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"77_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private void checkEmpty(Object obj, String msg, Context ctx) throws TaskExternalException {
        if (obj == null) {
            throw new TaskExternalException(msg + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"79_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
    }
}

