/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.nt.AbstractEndorsementBillInfo;
import com.kingdee.eas.fm.nt.EndorsementBillFactory;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class ReceivableBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        ReceivableBillInfo info = this.getInfo(ctx, billId);
        if (FMHelper.isEmpty((CoreBaseInfo)info.getInnerAccount()) || EmptyUtil.isEmpty((CoreBaseInfo)info.getInnerAccount().getCompany()) || !info.getInnerAccount().getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
            return new SubsidiaryLedgerCollection();
        }
        SubsidiaryLedgerInfo subInfo = new SubsidiaryLedgerInfo();
        subInfo.setBizType(SubsidiaryBillTypeEnum.RECEIVABLEBILL);
        subInfo.setCompany(info.getInnerAccount().getCompany());
        subInfo.setApplyUnit(info.getInnerAccount().getApplyUnit());
        subInfo.setInnerAccount(info.getInnerAccount());
        subInfo.setCurrency(info.getCurrency());
        subInfo.setBillId(info.getId());
        subInfo.setBillNumber(info.getNumber());
        subInfo.setDate(info.getTakeDate());
        subInfo.setCpCurrency(info.getCurrency());
        subInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"81_ReceivableBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
        AbstractEndorsementBillInfo endBillInfo = null;
        if (info.getSourceBillId() != null) {
            endBillInfo = EndorsementBillFactory.getLocalInstance(ctx).getEndorsementBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        }
        if (endBillInfo != null) {
            subInfo.setDebitAmount(info.getBillAmt().multiply(Constants.ONE.subtract(endBillInfo.getFeeRate())));
        } else {
            subInfo.setDebitAmount(info.getBillAmt());
        }
        subInfo.setExchangeRate(info.getExchangeRate());
        subInfo.setBookkeeper(info.getCreator());
        subInfo.setIsDownLoad(false);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        coll.add(subInfo);
        return coll;
    }

    private ReceivableBillInfo getInfo(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("innerAccount.*");
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance(ctx);
        return iReceivableBill.getReceivableBillInfo((IObjectPK)pk, sic);
    }
}

