/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.app.AbstractRptPayableMatureFacadeControllerBean;
import com.kingdee.eas.fm.nt.app.RptReceivableMatureFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class RptPayableMatureFacadeControllerBean
extends AbstractRptPayableMatureFacadeControllerBean {
    private String loc;
    private Set companyIdSet;
    private Date dateFrom;
    private Date dateTo;
    private CurrencyInfo currency;
    private Set bankIdSet;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.dateFrom = (Date)params.getObject("dateFrom");
        this.dateTo = (Date)params.getObject("dateTo");
        this.currency = (CurrencyInfo)params.getObject("currency");
        this.bankIdSet = (Set)params.getObject("bank");
        SchemaSource ss = new SchemaSource();
        ss.setDataItem("Fact", this.getFactSql(ctx, params), null);
        String[] name = this.getDimensionNames();
        String[] sqls = this.getDimensionSqls();
        for (int i = 0; i < name.length; ++i) {
            ss.setDataItem(name[i], sqls[i], null);
        }
        ss.setMdx(this.getMDX(ctx, params));
        ss.setFilename(this.getConfigXML());
        ss.setCaller(RptReceivableMatureFacadeControllerBean.class);
        return ss;
    }

    private String getFactSql(Context ctx, RptParams param) {
        StringBuffer sql = new StringBuffer(2048);
        sql.append("select P.FID as FID,\n");
        sql.append("(YEAR(P.FExpiredDate)*1000 + DAYOFYEAR(P.FExpiredDate)) as FDateID, \n");
        sql.append("P.FInstitutionID as FBankID,\n");
        sql.append("P.FAmount as FAmount \n");
        sql.append("from T_NT_PayableBill as P \n");
        sql.append(this.getFilter());
        return sql.toString();
    }

    private String[] getDimensionSqls() {
        StringBuffer bank = new StringBuffer(256);
        bank.append("select FID,FParentID,FName_" + this.loc + " AS FName from T_BD_Bank");
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            bank.append(" where FID in ");
            bank.append(FMHelper.setTran2String((Set)this.bankIdSet));
        }
        StringBuffer sql = new StringBuffer(2048);
        sql.append("select \n");
        sql.append("distinct (YEAR(P.FExpiredDate)*1000 + DAYOFYEAR(P.FExpiredDate)) as FID, \n");
        sql.append("TOCHAR(P.FExpiredDate,'yyyy-MM-dd') as FDate\n");
        sql.append("from T_NT_PayableBill as P \n");
        sql.append(this.getFilter());
        sql.append("union all \n");
        sql.append("select 12345 as FID,\n");
        sql.append("NULL as FDate \n");
        String[] sqls = new String[]{bank.toString(), sql.toString()};
        return sqls;
    }

    private String getFilter() {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("where \n");
        sql.append("(P.FBillState = 0 \n");
        sql.append("or P.FBillState = 5 \n");
        sql.append("or P.FBillState = 2 \n");
        sql.append("or P.FBillState = 3 \n");
        sql.append("or P.FBillState = 6 \n");
        sql.append("or P.FBillState = 7) \n");
        sql.append("and P.FCompanyID in ");
        sql.append(FMHelper.setTran2String((Set)this.companyIdSet));
        sql.append("and P.FExpiredDate >= {ts'" + TypeConversionUtils.objToDate((Object)DateTimeUtils.truncateDate((Date)this.dateFrom)).toString() + " 00:00:00'} \n");
        sql.append("and P.FExpiredDate <= {ts'" + TypeConversionUtils.objToDate((Object)DateTimeUtils.truncateDate((Date)this.dateTo)).toString() + " 23:59:59'} \n");
        if (this.currency != null) {
            sql.append("and P.FCurrencyID = '" + this.currency.getId() + "' \n");
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            sql.append("and P.FInstitutionID in ");
            sql.append(FMHelper.setTran2String((Set)this.bankIdSet));
        }
        return sql.toString();
    }

    private String[] getDimensionNames() {
        return new String[]{"Bank", "PeriodRType"};
    }

    private String getConfigXML() {
        return "RptPayableMature.xml";
    }

    private String getMDX(Context ctx, RptParams params) {
        StringBuffer mdx = new StringBuffer(1024);
        mdx.append("WITH member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)'\n");
        mdx.append(" member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)'\n");
        mdx.append(" member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)'\n");
        mdx.append("select  {[Measures].members} on columns,");
        mdx.append(" non empty {[Bank].members*{[PeriodRType].members,[PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]},[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]*[PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} on rows\n");
        mdx.append("from Fact");
        return mdx.toString();
    }
}

