/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.app.AbstractRptRecChequeSummaryFacadeControllerBean;
import com.kingdee.eas.fm.nt.app.RptReceivableMatureFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.util.LocaleUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class RptRecChequeSummaryFacadeControllerBean
extends AbstractRptRecChequeSummaryFacadeControllerBean {
    private String loc;
    private Set companyIdSet;
    private Date dateFrom;
    private Date dateTo;
    private CurrencyInfo currency;
    private Set bankIdSet;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.dateFrom = (Date)params.getObject("dateFrom");
        this.dateTo = (Date)params.getObject("dateTo");
        this.currency = (CurrencyInfo)params.getObject("currency");
        this.bankIdSet = (Set)params.getObject("bank");
        SchemaSource ss = new SchemaSource();
        ss.setDataItem("Fact", this.getFactSql(ctx, params), null);
        String[] name = this.getDimensionNames();
        String[] sqls = this.getDimensionSqls();
        for (int i = 0; i < name.length; ++i) {
            ss.setDataItem(name[i], sqls[i], null);
        }
        ss.setMdx(this.getMDX(ctx, params));
        ss.setFilename(this.getConfigXML());
        ss.setCaller(RptReceivableMatureFacadeControllerBean.class);
        return ss;
    }

    private String getFactSql(Context ctx, RptParams param) {
        StringBuffer sql = new StringBuffer();
        sql.append("select R.FID as FID,\n");
        sql.append("R.FAmount as Amount,\n");
        sql.append("R.FReceiptAmount as ReceiptAmount,\n");
        sql.append("R.REndorseAmount as EndorseAmount,\n");
        sql.append("R.FBankID as BankID,\n");
        sql.append("R.FBankAcctID as BankAcctID,\n");
        sql.append("R.FNtTypeID as NTTypeID \n");
        sql.append("FROM T_NT_RecCheque \n");
        sql.append("WHERE \n");
        sql.append("AND R.FCompanyID in ");
        sql.append(FMHelper.setTran2String((Set)this.companyIdSet));
        sql.append("AND R.FExpiredDate >= {ts'" + DateUtil.formatDate((Date)this.dateFrom) + "'} \n");
        sql.append("AND R.FExpiredDate < {ts'" + DateUtil.formatDate((Date)this.dateTo) + "'} \n");
        if (this.currency != null) {
            sql.append("and R.FCurrencyID = '" + this.currency.getId() + "' \n");
        }
        if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
            sql.append("and FPayeeBankID in ");
            sql.append(FMHelper.setTran2String((Set)this.bankIdSet));
        }
        return sql.toString();
    }

    private String[] getDimensionSqls() {
        StringBuffer sql = new StringBuffer();
        String[] sqls = new String[3];
        sql.append("select FID,FParentID,FName_" + this.loc + " as FName from T_BD_Bank");
        sqls[0] = sql.toString();
        sql.setLength(0);
        sql.append("select FID,FName_" + this.loc + " as FName from T_BD_AccountBanks");
        sqls[1] = sql.toString();
        sql.setLength(0);
        sql.append("select FID,FName_" + this.loc + " as FName from T_NT_NTType");
        sqls[2] = sql.toString();
        return sqls;
    }

    private String[] getDimensionNames() {
        return new String[]{"Bank", "BankAcct", "NTType"};
    }

    private String getConfigXML() {
        return "RptRecChequeSummary.xml";
    }

    private String getMDX(Context ctx, RptParams params) {
        return null;
    }
}

