/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.app.AbstractRptReceivableMatureFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class RptReceivableMatureFacadeControllerBean
extends AbstractRptReceivableMatureFacadeControllerBean {
    private String loc;
    private Set companyIdSet;
    private Date dateFrom;
    private Date dateTo;
    private CurrencyInfo currency;
    private Set bankSet;
    private Object billmedium;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.dateFrom = (Date)params.getObject("dateFrom");
        this.dateTo = (Date)params.getObject("dateTo");
        this.currency = (CurrencyInfo)params.getObject("currency");
        this.bankSet = (Set)params.getObject("bank");
        this.billmedium = params.getObjectElement("billMedium");
        SchemaSource ss = new SchemaSource();
        ss.setDataItem("Fact", this.getFactSql(ctx, params), null);
        String[] name = this.getDimensionNames();
        String[] sqls = this.getDimensionSqls();
        for (int i = 0; i < name.length; ++i) {
            ss.setDataItem(name[i], sqls[i], null);
        }
        ss.setMdx(this.getMDX(ctx, params));
        ss.setFilename(this.getConfigXML());
        ss.setCaller(RptReceivableMatureFacadeControllerBean.class);
        return ss;
    }

    private String getFactSql(Context ctx, RptParams param) {
        StringBuffer sql = new StringBuffer(2048);
        sql.append("select R.FID as FID,\n");
        sql.append("(YEAR(R.FExpiredDate)*1000 + DAYOFYEAR(R.FExpiredDate)) as FDateID, \n");
        sql.append("R.FAcceptanceBankName as FBankID,\n");
        sql.append("R.FBillAmt as FAmount \n");
        sql.append("from T_NT_ReceivableBill as R \n");
        sql.append(this.getFilter());
        return sql.toString();
    }

    private String[] getDimensionSqls() {
        StringBuffer bank = new StringBuffer(256);
        bank.append("select distinct R.FAcceptanceBankName as FID,\n");
        bank.append("R.FAcceptanceBankName as FName,\n");
        bank.append("NULL as FParentID \n");
        bank.append("from T_NT_ReceivableBill as R \n");
        bank.append(this.getFilter());
        bank.append("union\n");
        bank.append("select n'$#Q%##@#%#' as FID,\n");
        bank.append("NULL as FName,\n");
        bank.append("NULL as FParentID \n");
        StringBuffer sql = new StringBuffer(2048);
        sql.append("select \n");
        sql.append("distinct (YEAR(R.FExpiredDate)*1000 + DAYOFYEAR(R.FExpiredDate)) as FID, \n");
        sql.append("TOCHAR(R.FExpiredDate,'yyyy-MM-dd') as FDate\n");
        sql.append("from T_NT_ReceivableBill as R \n");
        sql.append(this.getFilter());
        sql.append("union all \n");
        sql.append("select 12345 as FID,\n");
        sql.append("NULL as FDate \n");
        String[] sqls = new String[]{bank.toString(), sql.toString()};
        return sqls;
    }

    private String getFilter() {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("where \n");
        sql.append("R.FAcceptanceBankName is not null \n");
        sql.append("and (R.FBillState = 1 \n");
        sql.append("or R.FBillState = 8) \n");
        sql.append("and R.FCompanyID in ");
        sql.append(FMHelper.setTran2String((Set)this.companyIdSet));
        sql.append("and R.FExpiredDate >= {ts'" + DateUtil.formatDate((Date)this.dateFrom) + "'} \n");
        sql.append("and R.FExpiredDate <= {ts'" + DateUtil.formatDate((Date)this.dateTo) + "'} \n");
        if (this.currency != null) {
            sql.append("and R.FCurrencyID = '" + this.currency.getId() + "' \n");
        }
        if (this.bankSet != null && this.bankSet.size() > 0) {
            sql.append("and ");
            sql.append(FMHelper.transToLikeSql((String)"R.FAcceptanceBankName", (Set)this.bankSet));
        }
        if (this.billmedium != null) {
            sql.append("and FBillMedium=" + this.billmedium + "");
        }
        return sql.toString();
    }

    private String[] getDimensionNames() {
        return new String[]{"Bank", "PeriodRType"};
    }

    private String getConfigXML() {
        return "RptReceivableMature.xml";
    }

    private String getMDX(Context ctx, RptParams params) {
        StringBuffer mdx = new StringBuffer(1024);
        mdx.append("WITH member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)'\n");
        mdx.append(" member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)'\n");
        mdx.append(" member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)'\n");
        mdx.append("select  {[Measures].members} on columns,");
        mdx.append(" non empty {[Bank].levels(0).members*{[PeriodRType].members,[PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"xiaoji", (Locale)ctx.getLocale())).append("]},[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]*[PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]} on rows\n");
        mdx.append("from Fact");
        return mdx.toString();
    }
}

