/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.IWage;
import com.kingdee.eas.fm.fin.WageCollection;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReceivablePledgeDetailCollection;
import com.kingdee.eas.fm.nt.ReceivablePledgeDetailFactory;
import com.kingdee.eas.fm.nt.ReceivablePledgeDetailInfo;
import com.kingdee.eas.fm.nt.app.AbstractWageWebFacadeControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WageWebFacadeControllerBean
extends AbstractWageWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.nt.app.WageWebFacadeControllerBean");

    private IWage getBizInterface(Context ctx) throws BOSException {
        return WageFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected Map _audit(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + WageWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            WageCollection colls = this.getWageCollByIdSet(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                WageInfo info = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"RECEIVABLEPledge_14Audit");
                    if (!isPermission) {
                        throw new BOSException(WageWebFacadeControllerBean.getResource(ctx, "278_ReceivableBill", new String[]{info.getCompany().getName()}));
                    }
                    if (info.getBillStatus() != FinBillStatusEnum.SUBMIT && info.getBillStatus() != FinBillStatusEnum.SAVE) {
                        throw new FMException(FMException.SELECT_SUBMITED_BILL);
                    }
                    HashSet<String> auditSet = new HashSet<String>();
                    auditSet.add(info.getId().toString());
                    this.getBizInterface(ctx).audit(auditSet);
                    ++success;
                    continue;
                }
                catch (WfBizException e) {
                    result.getDetailMsgList().add(WageWebFacadeControllerBean.getResource(ctx, "198_ReceivableBill", new String[]{info.getNumber()}) + CASWebUtil.getResource((Context)ctx, (String)"ALREADY_IN_WORKFLOW"));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(WageWebFacadeControllerBean.getResource(ctx, "198_ReceivableBill", new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(WageWebFacadeControllerBean.getResource(ctx, "279_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? WageWebFacadeControllerBean.getResource(ctx, "200_ReceivableBill", null) : summary + WageWebFacadeControllerBean.getResource(ctx, "201_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _antiAudit(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + WageWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            WageCollection colls = this.getWageCollByIdSet(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                WageInfo info = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"RECEIVABLEPledge_15AntAudit");
                    if (!isPermission) {
                        throw new BOSException(WageWebFacadeControllerBean.getResource(ctx, "280_ReceivableBill", new String[]{info.getCompany().getName()}));
                    }
                    HashSet<String> antiAuditSet = new HashSet<String>();
                    antiAuditSet.add(info.getId().toString());
                    this.getBizInterface(ctx).antiAudit(antiAuditSet);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(WageWebFacadeControllerBean.getResource(ctx, "203_ReceivableBill", new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(WageWebFacadeControllerBean.getResource(ctx, "281_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? WageWebFacadeControllerBean.getResource(ctx, "205_ReceivableBill", null) : summary + WageWebFacadeControllerBean.getResource(ctx, "206_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _batchSubmit(Context ctx, Map idMap) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _submit(Context ctx, WageInfo info) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        ObjectUuidPK rstID = null;
        try {
            ReceivableBillCollection receivableColl = new ReceivableBillCollection();
            receivableColl = (ReceivableBillCollection)((Object)info.getRelatedRecBills().clone());
            info.setLocalCurExRate(receivableColl.get(0).getExchangeRate());
            info.setAmountlocalcur(info.getAmount().multiply(info.getLocalCurExRate()));
            info.setExpireddate(receivableColl.get(0).getExpiredDate());
            if (EmptyUtil.isEmpty((Object)info.getId()) || !this.getBizInterface(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                info.setId(null);
                info.getRelatedRecBills().clear();
            } else {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"RECEIVABLEPledge_07Edit");
                if (!isPermission) {
                    throw new BOSException(WageWebFacadeControllerBean.getResource(ctx, "282_ReceivableBill", new String[]{info.getCompany().getName()}));
                }
                WageInfo oldInfo = this.getBizInterface(ctx).getWageInfo("select * where id='" + info.getId().toString() + "'");
                if (oldInfo.getBillStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
                    throw new NTException(NTException.NOT_SUBMIT);
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String s = sdf.format(info.getIssuedate());
            info.setIssuedate(sdf.parse(s));
            ReceivableBillFactory.getLocalInstance(ctx).pledge((IObjectCollection)receivableColl, info);
            rstID = new ObjectUuidPK(info.getId());
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        catch (ParseException e3) {
            result.put("MsgStr", e3.getMessage());
            e3.printStackTrace();
            logger.debug((Object)e3);
            return result;
        }
        result.put("MsgStr", CASWebHelper.getCASMsg((Context)ctx, (String)"SAVE_Successfully"));
        result.put("OPStatus", "success");
        result.put("IdAfterSave", (String)rstID);
        return result;
    }

    @Override
    protected Map _cancelPledge(Context ctx, Map idMap) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        HashSet idSet = new HashSet(idList);
        summary = summary + WageWebFacadeControllerBean.getResource(ctx, "197_ReceivableBill", new String[]{idSet.size() + ""});
        try {
            WageCollection colls = this.getWageCollByIdSet(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                WageInfo info = colls.get(i);
                try {
                    this.relaCancelPledge(ctx, info);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(WageWebFacadeControllerBean.getResource(ctx, "283_ReceivableBill", new String[]{info.getNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(WageWebFacadeControllerBean.getResource(ctx, "284_ReceivableBill", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == idSet.size() ? WageWebFacadeControllerBean.getResource(ctx, "285_ReceivableBill", null) : summary + WageWebFacadeControllerBean.getResource(ctx, "286_ReceivableBill", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void relaCancelPledge(Context ctx, WageInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"RECEIVABLEPledge_04Remove");
        if (!isPermission) {
            throw new BOSException(WageWebFacadeControllerBean.getResource(ctx, "287_ReceivableBill", new String[]{info.getCompany().getName()}));
        }
        if (info.getBillStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
            throw new BOSException(WageWebFacadeControllerBean.getResource(ctx, "288_ReceivableBill", null));
        }
        ArrayList<ReceivableBillInfo> idList = new ArrayList<ReceivableBillInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("wage", (Object)info.getId().toString()));
        view.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivable.*"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        ReceivablePledgeDetailCollection coll = ReceivablePledgeDetailFactory.getLocalInstance(ctx).getReceivablePledgeDetailCollection(view);
        if (!EmptyUtil.isEmpty((Object)((Object)coll))) {
            for (int i = 0; i < coll.size(); ++i) {
                ReceivablePledgeDetailInfo pledgeDetail = (ReceivablePledgeDetailInfo)coll.getObject(i);
                ReceivableBillInfo recBillInfo = pledgeDetail.getReceivable();
                recBillInfo.setIsDisPledge(pledgeDetail.isIsDisPledge());
                recBillInfo.setIsPledge(pledgeDetail.isIsPledge());
                recBillInfo.setClose(pledgeDetail.isIsClose());
                recBillInfo.setLastWageId(pledgeDetail.getLastWageId());
                recBillInfo.setPledgeDetailId(pledgeDetail.getId().toString());
                idList.add(recBillInfo);
                if (!recBillInfo.isClose()) continue;
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"369_ReceivablePledgeListUI", (Locale)ctx.getLocale()));
            }
        }
        ReceivableBillFactory.getLocalInstance(ctx).cancelPledge(idList, info.getId().toString());
    }

    private WageCollection getWageCollByIdSet(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("relatedRecBills.*"));
        sic.add(new SelectorItemInfo("company.*"));
        entityViewInfo.setSelector(sic);
        return this.getBizInterface(ctx).getWageCollection(entityViewInfo);
    }

    @Override
    protected Map _singelAudit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            WageInfo wageInfo = this.getBizInterface(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(id));
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(wageInfo.getCompany().getId()), (String)"RECEIVABLEPledge_14Audit");
            if (!isPermission) {
                throw new BOSException(WageWebFacadeControllerBean.getResource(ctx, "278_ReceivableBill", new String[]{wageInfo.getCompany().getName()}));
            }
            if (wageInfo.getBillStatus() != FinBillStatusEnum.SUBMIT && wageInfo.getBillStatus() != FinBillStatusEnum.SAVE) {
                throw new FMException(FMException.SELECT_SUBMITED_BILL);
            }
            HashSet<String> auditSet = new HashSet<String>();
            auditSet.add(wageInfo.getId().toString());
            this.getBizInterface(ctx).audit(auditSet);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", WageWebFacadeControllerBean.getResource(ctx, "222_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _singelAntAudit(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            WageInfo wageInfo = this.getBizInterface(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(id));
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(wageInfo.getCompany().getId()), (String)"RECEIVABLEPledge_15AntAudit");
            if (!isPermission) {
                throw new BOSException(WageWebFacadeControllerBean.getResource(ctx, "280_ReceivableBill", new String[]{wageInfo.getCompany().getName()}));
            }
            HashSet<String> antiAuditSet = new HashSet<String>();
            antiAuditSet.add(wageInfo.getId().toString());
            this.getBizInterface(ctx).antiAudit(antiAuditSet);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", WageWebFacadeControllerBean.getResource(ctx, "223_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    @Override
    protected Map _singelCancelPledge(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            WageInfo wageInfo = this.getBizInterface(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(id));
            this.relaCancelPledge(ctx, wageInfo);
        }
        catch (EASBizException e1) {
            result.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return result;
        }
        catch (BOSException e2) {
            result.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return result;
        }
        result.put("MsgStr", WageWebFacadeControllerBean.getResource(ctx, "289_ReceivableBill", null));
        result.put("OPStatus", "success");
        return result;
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }
}

