/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ebservice.NotePayableDetail;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.CommitToBe;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.HorizonTypeEnum;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.app.BillServerUtil;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PayableBillCommitToBEUtil {
    public static Map<String, PayableBillCollection> getPayableBillColl4BE(Context ctx, Set<String> idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("OutBankAccount.*");
        view.getSelector().add("payee.*");
        view.getSelector().add("ntType.*");
        view.getSelector().add("Currency.*");
        view.getSelector().add("acceptorBank.*");
        view.getSelector().add("OutBankAccount.*");
        view.getSelector().add("Institution.*");
        PayableBillCollection coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
        HashMap<String, PayableBillCollection> payableCollMap = new HashMap<String, PayableBillCollection>();
        String accNo = null;
        for (int i = 0; i < coll.size(); ++i) {
            accNo = coll.get(i).getOutBankAccount().getBankAccountNumber() + "-" + coll.get(i).getContractNumber();
            if (payableCollMap.containsKey(accNo)) {
                ((PayableBillCollection)((Object)payableCollMap.get(accNo))).add(coll.get(i));
                continue;
            }
            PayableBillCollection payableColl = new PayableBillCollection();
            payableColl.add(coll.get(i));
            payableCollMap.put(accNo, payableColl);
        }
        return payableCollMap;
    }

    public static String getAccNoByKey(String key) {
        String[] accCons = key.split("-");
        return accCons[0];
    }

    public static PayableBillCollection updateBatchSeqIDAndDetailseqID(Context ctx, PayableBillCollection coll, String commitType) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)coll.size());
        CoreBaseCollection payableBillCollection = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            info.setLastBatchSeqID(info.getBatchSeqID());
            info.setLastDetailSeqID(info.getDetailSeqID());
            info.setDetailSeqID(serialNos[i]);
            info.setBatchSeqID(serialNos[0]);
            if ("remit_register".equals(commitType)) {
                info.setCommitToBe(CommitToBe.ISSUE_REGISTER);
            } else if ("remit_revocation".equals(commitType)) {
                info.setCommitToBe(CommitToBe.CANCEL_ISSUE);
            } else if ("remit_accept".equals(commitType)) {
                info.setCommitToBe(CommitToBe.PROMPT_ACCEPT);
            } else if ("remit_receive".equals(commitType)) {
                info.setCommitToBe(CommitToBe.PROMPT_RECBILL);
            } else if ("note_cancle".equals(commitType)) {
                info.setCommitToBe(CommitToBe.NOTE_CANCLE);
            } else if ("remit_confirm".equals(commitType)) {
                info.setCommitToBe(CommitToBe.REMIT_CONFIRM);
            }
            payableBillCollection.add((CoreBaseInfo)info);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("lastBatchSeqID");
        sic.add("lastDetailSeqID");
        sic.add("detailSeqID");
        sic.add("batchSeqID");
        sic.add("commitToBe");
        PayableBillFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)payableBillCollection, sic);
        return coll;
    }

    public static void afterCommitToBESuc(Context ctx, NotePayableDetail[] details, String commitType) throws EASBizException, BOSException {
        if (details.length > 0) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            for (int i = 0; i < details.length; ++i) {
                Object[] reserveds;
                NotePayableDetail detail = details[i];
                PayableBillInfo info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo("where detailSeqID = '" + detail.getDetailSeqID() + "'");
                info.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                if (!EmptyUtil.isEmpty((String)detail.getBookingDate()) && !EmptyUtil.isEmpty((String)detail.getDueDate())) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    try {
                        info.setIssueDate(DateTimeUtils.truncateDate((Date)format.parse(detail.getBookingDate())));
                        info.setExpiredDate(DateTimeUtils.truncateDate((Date)format.parse(detail.getDueDate())));
                    }
                    catch (ParseException e) {
                        throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR, new Object[]{e.getMessage()});
                    }
                } else if (info.getIssueDate() == null || info.getExpiredDate() == null) {
                    Date nowDate = new Date();
                    info.setIssueDate(DateTimeUtils.truncateDate((Date)nowDate));
                    Calendar c = Calendar.getInstance();
                    c.setTime(nowDate);
                    if (info.getHorizonType() == HorizonTypeEnum.Mouths) {
                        c.add(2, info.getHorizon().intValue());
                    } else {
                        c.add(6, info.getHorizon().intValue());
                    }
                    info.setExpiredDate(DateTimeUtils.truncateDate((Date)c.getTime()));
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    info.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                }
                info.setBankReturnInfo(detail.getEbStatusMsg());
                if ("remit_register".equals(commitType)) {
                    info.setDraftNumber(detail.getBillNo());
                }
                if (!EmptyUtil.isEmpty((Object[])(reserveds = detail.getReserveds()))) {
                    for (int a = 0; a < reserveds.length; ++a) {
                        String returnValue = ((String)reserveds[a]).trim();
                        if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefKey=".toUpperCase(Locale.ENGLISH)) || EmptyUtil.isEmpty((String)returnValue.substring("bankRefKey=".length()))) continue;
                        info.setBankRefKey(returnValue.substring("bankRefKey=".length()));
                    }
                }
                baseColl.add((CoreBaseInfo)info);
            }
            PayableBillFactory.getLocalInstance(ctx).update(baseColl);
        }
    }

    public static void afterCommitToBEFail(Context ctx, PayableBillCollection coll) throws EASBizException, BOSException {
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            info.setBatchSeqID(null);
            info.setDetailSeqID(null);
            info.setBankReturnStatus(BankReturnStatusEnum.COMMIT_FAIL);
            baseColl.add((CoreBaseInfo)info);
        }
        PayableBillFactory.getLocalInstance(ctx).update(baseColl);
    }

    public static void afterQueryNotePayable(Context ctx, NotePayableDetail[] details) throws EASBizException, BOSException {
        if (details.length > 0) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            CoreBaseCollection paymentColl = new CoreBaseCollection();
            StringBuffer settleNumber = new StringBuffer("");
            for (int i = 0; i < details.length; ++i) {
                Object[] reserveds;
                NotePayableDetail detail = details[i];
                PayableBillCollection coll = PayableBillCommitToBEUtil.getPayableCollByDetailID(ctx, detail.getDetailSeqID());
                if (coll == null || coll.size() <= 0) continue;
                PayableBillInfo info = coll.get(0);
                info.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                if (!EmptyUtil.isEmpty((String)detail.getBillNo())) {
                    info.setDraftNumber(detail.getBillNo());
                }
                if (!EmptyUtil.isEmpty((Object[])(reserveds = detail.getReserveds()))) {
                    for (int a = 0; a < reserveds.length; ++a) {
                        String returnValue = ((String)reserveds[a]).trim();
                        if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("fileName=".toUpperCase(Locale.ENGLISH))) {
                            info.setContractNumber(returnValue.substring("fileName=".length()));
                        }
                        if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("fileId=".toUpperCase(Locale.ENGLISH))) {
                            info.setContractId(returnValue.substring("fileId=".length()));
                        }
                        if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("clientref=".toUpperCase(Locale.ENGLISH))) {
                            info.setClientref(returnValue.substring("clientref=".length()));
                        }
                        if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("srvrId=".toUpperCase(Locale.ENGLISH))) {
                            info.setSrvrId(returnValue.substring("srvrId=".length()));
                        }
                        if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefKey=".toUpperCase(Locale.ENGLISH)) && !EmptyUtil.isEmpty((String)returnValue.substring("bankRefKey=".length()))) {
                            info.setBankRefKey(returnValue.substring("bankRefKey=".length()));
                        }
                        if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefDate=".toUpperCase(Locale.ENGLISH)) || EmptyUtil.isEmpty((String)returnValue.substring("bankRefDate=".length()))) continue;
                        info.setBankRefDate(returnValue.substring("bankRefDate=".length()));
                    }
                }
                PaymentBillInfo paymentInfo = null;
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    if (info.getDraftSource().equals((Object)BillSourceEnum.BYNEW)) {
                        BillServerUtil.setPayElecBillStatus(info, detail);
                    } else {
                        info.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                    }
                    ArrayList srcIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getSrcObjIdBySrcType(info.getId().toString(), new PaymentBillInfo().getBOSType().toString());
                    ArrayList paymentBillId = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(info.getId().toString(), new PaymentBillInfo().getBOSType().toString());
                    if (!EmptyUtil.isEmpty((Collection)srcIdList) && srcIdList.size() == 1) {
                        paymentInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo("where id = '" + srcIdList.get(0) + "'");
                        ArrayList desIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(paymentInfo.getId().toString(), new PayableBillInfo().getBOSType().toString());
                        if (desIdList.size() == 1) {
                            paymentInfo.setElecBillStatus(info.getElecBillStatus());
                            paymentInfo.setSettlementNumber(info.getDraftNumber());
                            paymentColl.add((CoreBaseInfo)paymentInfo);
                        } else if (desIdList.size() > 1) {
                            String paySettle;
                            String string = paySettle = paymentInfo.getSettlementNumber() == null ? "" : paymentInfo.getSettlementNumber();
                            if (info.getDraftNumber() != null && paySettle.indexOf(info.getDraftNumber()) == -1) {
                                String[] setttleArray;
                                settleNumber.append(paySettle).append(info.getDraftNumber());
                                if (settleNumber.length() > 79) {
                                    settleNumber.substring(0, 75);
                                    settleNumber.append("...");
                                }
                                if ((setttleArray = settleNumber.toString().split(";")).length < desIdList.size()) {
                                    settleNumber.append(";");
                                }
                                paymentInfo.setSettlementNumber(settleNumber.toString());
                            }
                            paymentColl.add((CoreBaseInfo)paymentInfo);
                        }
                    } else if (!EmptyUtil.isEmpty((Collection)srcIdList) && srcIdList.size() > 1) {
                        PaymentBillCollection paymentInfoColl = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection("where id in " + FMHelper.setTran2String(new HashSet(srcIdList)));
                        for (int index = 0; index < paymentInfoColl.size(); ++index) {
                            paymentInfo = paymentInfoColl.get(index);
                            paymentInfo.setElecBillStatus(info.getElecBillStatus());
                            paymentInfo.setSettlementNumber(info.getDraftNumber());
                            paymentColl.add((CoreBaseInfo)paymentInfo);
                        }
                    } else if (!EmptyUtil.isEmpty((Collection)paymentBillId)) {
                        paymentInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo("where id = '" + paymentBillId.get(0) + "'");
                        paymentInfo.setElecBillStatus(info.getElecBillStatus());
                        paymentInfo.setSettlementNumber(info.getDraftNumber() == null ? "" : info.getDraftNumber());
                        paymentColl.add((CoreBaseInfo)paymentInfo);
                    }
                }
                info.setBankReturnInfo(detail.getBankStatusMsg());
                if (!EmptyUtil.isEmpty((String)detail.getBookingDate()) && !EmptyUtil.isEmpty((String)detail.getDueDate())) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    try {
                        info.setIssueDate(DateTimeUtils.truncateDate((Date)format.parse(detail.getBookingDate())));
                        info.setExpiredDate(DateTimeUtils.truncateDate((Date)format.parse(detail.getDueDate())));
                    }
                    catch (ParseException e) {
                        throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR, new Object[]{e.getMessage()});
                    }
                }
                PayableBillCommitToBEUtil.checkdraftNumberDup(ctx, info);
                baseColl.add((CoreBaseInfo)info);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("bankReturnStatus");
            sic.add("draftnumber");
            sic.add("ContractNumber");
            sic.add("contractId");
            sic.add("clientref");
            sic.add("srvrId");
            sic.add("cirStatus");
            sic.add("noteStatus");
            sic.add("elecBillStatus");
            sic.add("bankReturnInfo");
            sic.add("IssueDate");
            sic.add("ExpiredDate");
            sic.add("bankRefKey");
            sic.add("bankRefDate");
            PayableBillFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)baseColl, sic);
            SelectorItemCollection pSic = new SelectorItemCollection();
            pSic.add("elecBillStatus");
            pSic.add("settlementNumber");
            PaymentBillFactory.getLocalInstance((Context)ctx).updatePartialBatchData((IObjectCollection)paymentColl, pSic);
        }
    }

    protected static void checkdraftNumberDup(Context ctx, PayableBillInfo info) throws EASBizException, BOSException {
        FilterInfo f1 = FMHelper.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
        if (PayableBillFactory.getLocalInstance(ctx).exists(f1)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"170_BankDraftEditUI", (Locale)ctx.getLocale())));
        }
        if (info.isIsFromSub() || info.isIsFromEntrust()) {
            return;
        }
        if (info.getMakeType().getValue() != 2 && info.getDraftNumber() != null && (2 != info.getBillMedium().getValue() || info.getDraftNumber() != null)) {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("draftNumber", (Object)info.getDraftNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (info.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
                filter.setMaskString("#0  and #1 ");
            }
            if (FilterUtility.hasFilterItem((FilterInfo)PayableBillCommitToBEUtil.getFilterForCheckNumber((CoreBillBaseInfo)info))) {
                filter.mergeFilter(PayableBillCommitToBEUtil.getFilterForCheckNumber((CoreBillBaseInfo)info), "AND");
            }
            if (PayableBillFactory.getLocalInstance(ctx).exists(filter)) {
                throw new NTException(NTException.ISEXISTDRAFTNUMBER, new Object[]{info.getDraftNumber(), ""});
            }
        }
    }

    protected static FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)model.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static void afterQueryNotePayable(Context ctx, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        if (details.length > 0) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            CoreBaseCollection paymentColl = new CoreBaseCollection();
            StringBuffer settleNumber = new StringBuffer("");
            for (int i = 0; i < details.length; ++i) {
                NoteReceivableDetail detail = details[i];
                PayableBillCollection coll = PayableBillCommitToBEUtil.getPayableCollByDetailID(ctx, detail.getDetailSeqID());
                if (coll == null || coll.size() <= 0) continue;
                PayableBillInfo info = coll.get(0);
                info.setBankReturnStatus(DraftBEUtil.transferState(detail.getEbStatus()));
                if (!EmptyUtil.isEmpty((String)detail.getBillNo())) {
                    info.setDraftNumber(detail.getBillNo());
                }
                PaymentBillInfo paymentInfo = null;
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    info.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getNoteStatus()));
                    ArrayList srcIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getSrcObjIdBySrcType(info.getId().toString(), new PaymentBillInfo().getBOSType().toString());
                    ArrayList paymentBillId = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(info.getId().toString(), new PaymentBillInfo().getBOSType().toString());
                    if (!EmptyUtil.isEmpty((Collection)srcIdList) && srcIdList.size() == 1) {
                        paymentInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo("where id = '" + srcIdList.get(0) + "'");
                        ArrayList desIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(paymentInfo.getId().toString(), new PayableBillInfo().getBOSType().toString());
                        if (desIdList.size() == 1) {
                            paymentInfo.setElecBillStatus(info.getElecBillStatus());
                            paymentInfo.setSettlementNumber(info.getDraftNumber());
                            paymentColl.add((CoreBaseInfo)paymentInfo);
                        } else if (desIdList.size() > 1) {
                            String paySettle;
                            String string = paySettle = paymentInfo.getSettlementNumber() == null ? "" : paymentInfo.getSettlementNumber();
                            if (info.getDraftNumber() != null && paySettle.indexOf(info.getDraftNumber()) == -1) {
                                String[] setttleArray;
                                settleNumber.append(paySettle).append(info.getDraftNumber());
                                if (settleNumber.length() > 79) {
                                    settleNumber.substring(0, 75);
                                    settleNumber.append("...");
                                }
                                if ((setttleArray = settleNumber.toString().split(";")).length < desIdList.size()) {
                                    settleNumber.append(";");
                                }
                                paymentInfo.setSettlementNumber(settleNumber.toString());
                            }
                            paymentColl.add((CoreBaseInfo)paymentInfo);
                        }
                    } else if (!EmptyUtil.isEmpty((Collection)srcIdList) && srcIdList.size() > 1) {
                        PaymentBillCollection paymentInfoColl = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection("where id in " + FMHelper.setTran2String(new HashSet(srcIdList)));
                        for (int index = 0; index < paymentInfoColl.size(); ++index) {
                            paymentInfo = paymentInfoColl.get(index);
                            paymentInfo.setElecBillStatus(info.getElecBillStatus());
                            paymentInfo.setSettlementNumber(info.getDraftNumber());
                            paymentColl.add((CoreBaseInfo)paymentInfo);
                        }
                    } else if (!EmptyUtil.isEmpty((Collection)paymentBillId)) {
                        paymentInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo("where id = '" + paymentBillId.get(0) + "'");
                        paymentInfo.setElecBillStatus(info.getElecBillStatus());
                        paymentInfo.setSettlementNumber(info.getDraftNumber() == null ? "" : info.getDraftNumber());
                        paymentColl.add((CoreBaseInfo)paymentInfo);
                    }
                }
                info.setBankReturnInfo(detail.getBankStatusMsg() + " " + detail.getEbStatusMsg());
                if (!EmptyUtil.isEmpty((String)detail.getBookingDate()) && !EmptyUtil.isEmpty((String)detail.getDueDate())) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    try {
                        info.setIssueDate(DateTimeUtils.truncateDate((Date)format.parse(detail.getBookingDate())));
                        info.setExpiredDate(DateTimeUtils.truncateDate((Date)format.parse(detail.getDueDate())));
                    }
                    catch (ParseException e) {
                        throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR, new Object[]{e.getMessage()});
                    }
                }
                baseColl.add((CoreBaseInfo)info);
            }
            Result result = PayableBillFactory.getLocalInstance(ctx).update(baseColl);
            if (result.size() > 0) {
                for (int index = 0; index < result.size(); ++index) {
                    boolean isSucc = result.getLineResult(index).isSucess();
                    if (isSucc) continue;
                    NTException e = (NTException)((Object)result.getLineResult(index).getException());
                    throw e;
                }
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)paymentColl)) {
                    PaymentBillFactory.getLocalInstance((Context)ctx).update(paymentColl);
                }
            }
        }
    }

    private static PayableBillCollection getPayableCollByDetailID(Context ctx, String detailSeqlID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("detailseqID", (Object)detailSeqlID));
        view.setFilter(filter);
        PayableBillCollection coll = PayableBillFactory.getLocalInstance(ctx).getPayableBillCollection(view);
        return coll;
    }

    public static void afterCommit4Exception(Context ctx, PayableBillCollection coll) throws EASBizException, BOSException {
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            info.setBatchSeqID(null);
            info.setDetailSeqID(null);
            info.setBankReturnStatus(BankReturnStatusEnum.COMMIT_FAIL);
            baseColl.add((CoreBaseInfo)info);
        }
        PayableBillFactory.getLocalInstance(ctx).update(baseColl);
    }

    public static Set<String> getAllBatchSeqIDs(PayableBillCollection coll) {
        HashSet<String> batchSeqIDSet = new HashSet<String>();
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                batchSeqIDSet.add(coll.get(i).getBatchSeqID());
            }
        }
        return batchSeqIDSet;
    }

    public static void afterNoteCancle(Context ctx, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        if (details.length > 0) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            for (int i = 0; i < details.length; ++i) {
                NoteReceivableDetail detail = details[i];
                PayableBillInfo info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo("where draftNumber = '" + detail.getBillNo() + "'");
                info.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getEbStatus()));
                info.setBankReturnInfo(detail.getBankStatusMsg());
                baseColl.add((CoreBaseInfo)info);
            }
            PayableBillFactory.getLocalInstance(ctx).update(baseColl);
        }
    }

    public static void afterNoteCancle(Context ctx, NotePayableDetail[] details) throws EASBizException, BOSException {
        if (details.length > 0) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            for (int i = 0; i < details.length; ++i) {
                NotePayableDetail detail = details[i];
                PayableBillInfo info = PayableBillFactory.getLocalInstance(ctx).getPayableBillInfo("where detailSeqID = '" + detail.getDetailSeqID() + "'");
                info.setElecBillStatus(ElecBillStatusEnum.getEnum(detail.getEbStatus()));
                info.setBankReturnInfo(detail.getBankStatusMsg());
                baseColl.add((CoreBaseInfo)info);
            }
            PayableBillFactory.getLocalInstance(ctx).update(baseColl);
        }
    }
}

