/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app.util;

import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.app.util.DBCPConUtils;
import com.kingdee.eas.fm.be.bean.EReceiptDBInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.app.util.IPayableBillJDBCTool;
import com.kingdee.eas.fm.nt.vo.PayableBillVO;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayableBillJDBC
implements IPayableBillJDBCTool {
    private Logger logger = Logger.getLogger(PayableBillJDBC.class);

    @Override
    public Map<String, byte[]> getBatchEReceiptPDFValues(List contractIdList, CompareType compareType, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws Exception {
        HashMap<String, byte[]> hashMap;
        HashMap<String, byte[]> fileValueMap = new HashMap<String, byte[]>();
        Statement st = null;
        PreparedStatement ps = null;
        ResultSet rs1 = null;
        Connection conn = null;
        try {
            this.logger.error((Object)("\u5408\u540c \u67e5\u8be2\u5f00\u59cb\uff0c\u5408\u540cid\uff1a" + contractIdList.toArray().toString()));
            conn = this.getConnection(eReceiptStorageSettingInfo);
            ps = conn.prepareStatement("select FID,EASID,FILEVALUE from T_NT_CONTRACT where EASID " + compareType.getAlias() + FMHelper.setTran2String((Set)FMHelper.list2Set((List)contractIdList)));
            this.logger.error((Object)"\u5408\u540c \u67e5\u8be2\u6267\u884c");
            rs1 = ps.executeQuery();
            this.logger.error((Object)"\u5408\u540c \u67e5\u8be2\u6267\u884c\u7ed3\u679c\u8fd4\u56de");
            String dbName = conn.getMetaData().getDatabaseProductName();
            this.logger.error((Object)("\u6570\u636e\u5e93\u540d\u79f0\u4e3a\uff1a" + dbName));
            byte[] fileValue = null;
            String id = null;
            while (rs1.next()) {
                fileValue = null;
                id = rs1.getString("EASID");
                if (dbName.equals("MySQL")) {
                    fileValue = rs1.getBytes("FILEVALUE");
                } else if (dbName.equals("Oracle")) {
                    Blob blob = null;
                    blob = rs1.getBlob("FILEVALUE");
                    fileValue = this.blobToBytes(blob);
                } else {
                    throw new Exception("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u662fMySQL\u6216Oracle");
                }
                fileValueMap.put(id, fileValue);
            }
            hashMap = fileValueMap;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DBCPConUtils.release(conn, st, ps);
                throw throwable;
            }
        }
        DBCPConUtils.release((Connection)conn, st, (PreparedStatement)ps);
        return hashMap;
    }

    private Connection getConnection(EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws SQLException {
        EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
        eReceiptDBInfo.setDbType(eReceiptStorageSettingInfo.getDbType());
        eReceiptDBInfo.setDbIP(eReceiptStorageSettingInfo.getDbIP());
        eReceiptDBInfo.setDbPort(eReceiptStorageSettingInfo.getDbPort());
        eReceiptDBInfo.setDbName(eReceiptStorageSettingInfo.getDbName());
        eReceiptDBInfo.setDbUserName(eReceiptStorageSettingInfo.getDbUserName());
        eReceiptDBInfo.setDbUserPwd(eReceiptStorageSettingInfo.getDbPwd());
        Connection conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
        this.logger.error((Object)"\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] blobToBytes(Blob blob) {
        InputStream is = null;
        byte[] b = null;
        try {
            is = blob.getBinaryStream();
            b = new byte[(int)blob.length()];
            is.read(b);
            byte[] byArray = b;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    @Override
    public void insertEReceipt(PayableBillVO payableBillVO, EReceiptStorageSettingInfo eReceiptStorageSettingInfo) throws Exception, SQLException {
        Statement st = null;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            this.logger.error((Object)"\u5408\u540c PDF\u6570\u636e\u5e93\u65b0\u589ePDF\u5f00\u59cb");
            this.logger.error((Object)"\u5f00\u59cb\u83b7\u53d6 PDF\u6570\u636e\u5e93\u7684\u8fde\u63a5");
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(eReceiptStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(eReceiptStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(eReceiptStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(eReceiptStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(eReceiptStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(eReceiptStorageSettingInfo.getDbPwd());
            conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
            this.logger.error((Object)"\u83b7\u53d6PDF\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
            ps = conn.prepareStatement("insert into T_NT_CONTRACT(FID,EASID,FILEVALUE,FILENAME) values(?,?,?,?)");
            ps.setString(1, payableBillVO.getFID());
            ps.setString(2, payableBillVO.getEASID());
            ps.setBinaryStream(3, payableBillVO.getFILEVALUE(), payableBillVO.getFILEVALUE().available());
            ps.setString(4, payableBillVO.getFILENAME());
            this.logger.error((Object)"\u4fdd\u5b58\u5408\u540cPDF");
            ps.executeUpdate();
            this.logger.error((Object)"\u63d0\u4ea4MySQL\u4e8b\u52a1");
            conn.commit();
            this.logger.error((Object)"\u5408\u540c Mysql\u65b0\u589ePDF\u6210\u529f 1\u6761");
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"\u5408\u540c Mysql\u65b0\u589ePDF\u5931\u8d25 1\u6761");
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                DBCPConUtils.release(conn, st, ps);
                this.logger.info((Object)"\u5408\u540c MySql\u65b0\u589e\u5355\u6761 \u91ca\u653e\u6210\u529f");
                throw throwable;
            }
        }
        DBCPConUtils.release((Connection)conn, st, (PreparedStatement)ps);
        this.logger.info((Object)"\u5408\u540c MySql\u65b0\u589e\u5355\u6761 \u91ca\u653e\u6210\u529f");
    }
}

