/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;

public class ReceivableBillCommitToBEUtil {
    public static void updateBatchSeqIDAndDetailseqID(Context ctx, ReceivableBillCollection coll) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)coll.size());
        CoreBaseCollection recBillCollection = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = coll.get(i);
            info.setDetailSeqID(serialNos[i]);
            info.setBatchSeqID(serialNos[0]);
            recBillCollection.add((CoreBaseInfo)info);
        }
        ReceivableBillFactory.getLocalInstance(ctx).updateBatchData(recBillCollection);
    }

    public static void afterCommitToBEFail(Context ctx, ReceivableBillCollection coll) throws EASBizException, BOSException {
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = coll.get(i);
            info.setBankReturnStatus(BankReturnStatusEnum.COMMIT_FAIL);
        }
        ReceivableBillFactory.getLocalInstance(ctx).update(baseColl);
    }

    public static void afterCommit4Exception(Context ctx, ReceivableBillCollection coll) throws EASBizException, BOSException {
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = coll.get(i);
            info.setBatchSeqID(null);
            info.setDetailSeqID(null);
            info.setBankReturnStatus(BankReturnStatusEnum.COMMIT_FAIL);
            baseColl.add((CoreBaseInfo)info);
        }
        ReceivableBillFactory.getLocalInstance(ctx).update(baseColl);
    }

    public static void afterCommitToBESuc(Context ctx, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        if (details.length > 0) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            for (int i = 0; i < details.length; ++i) {
                NoteReceivableDetail detail = details[i];
                ReceivableBillInfo info = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo("where detailseqID = '" + detail.getDetailSeqID() + "'");
                info.setBankReturnStatus(BankReturnStatusEnum.EB_PROCESSING);
                baseColl.add((CoreBaseInfo)info);
            }
            ReceivableBillFactory.getLocalInstance(ctx).update(baseColl);
        }
    }

    public static void afterQueryNoteRec(Context ctx, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        if (details.length > 0) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            for (int i = 0; i < details.length; ++i) {
                NoteReceivableDetail detail = details[i];
                ReceivableBillInfo info = ReceivableBillFactory.getLocalInstance(ctx).getReceivableBillInfo("where detailseqID = '" + detail.getDetailSeqID() + "'");
                if ("BANK_SUCCESS".equals(detail.getEbStatus())) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_SUCCESS);
                    info.setElecBillStatus(ElecBillStatusEnum.NT180006);
                } else if ("BANK_PROCESSING".equals(detail.getEbStatus())) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_PROCESSING);
                } else if ("BANK_FAIL".equals(detail.getEbStatus())) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_FAIL);
                } else if ("BANK_EXCEPTION".equals(detail.getEbStatus())) {
                    info.setBankReturnStatus(BankReturnStatusEnum.BANK_EXCEPTION);
                } else {
                    info.setBankReturnStatus(BankReturnStatusEnum.EB_PROCESSING);
                }
                info.setBankReturnMsg(detail.getBankStatusMsg());
                baseColl.add((CoreBaseInfo)info);
            }
            ReceivableBillFactory.getLocalInstance(ctx).update(baseColl);
        }
    }
}

