/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmBatchCalculator;
import com.kingdee.eas.fm.nt.RecChequeDataEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NtReceivableBatchCalculator
extends FmBatchCalculator
implements ICalculator,
IMethodBatchQuery {
    private List paramList = new ArrayList();
    private Map companyMap = new HashMap(400);
    private Map currencyMap = new HashMap(50);

    public NtReceivableBatchCalculator() {
    }

    public NtReceivableBatchCalculator(ICalculateContextProvider calProvider, Context context) {
        this.context = calProvider;
        this.serverCtx = context;
    }

    public void execute(SortedParameterArray params) {
        this.initParam(params);
        this.calculate();
        this.handleResult(params);
    }

    public Object ntReceivable(String orgUnitNumber, String currencyNumber, String bankNumber, String beginDate, String endDate, String dataType) {
        return null;
    }

    private void initParam(SortedParameterArray params) {
        this.cacheData();
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            Parameter param = params.getParameter(i);
            Param p = new Param(param);
            p.init();
            this.paramList.add(p);
        }
    }

    private void cacheData() {
        EntityViewInfo evi = this.getEvi();
        try {
            CompanyOrgUnitCollection comColl = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitCollection(evi);
            int size = comColl.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo comInfo = comColl.get(i);
                this.companyMap.put(comInfo.getNumber(), comInfo.getId().toString());
            }
            CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)this.serverCtx).getCurrencyCollection(evi);
            int size2 = currencyColl.size();
            for (int i = 0; i < size2; ++i) {
                CurrencyInfo currencyInfo = currencyColl.get(i);
                this.currencyMap.put(currencyInfo.getNumber(), currencyInfo.getId().toString());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private EntityViewInfo getEvi() {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        evi.setSelector(sic);
        return evi;
    }

    private void calculate() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(FId) cnt, SUM(FBillAmt) sumAmt FROM T_NT_ReceivableBill \n").append("\tWHERE FCurrencyId = ? \n").append("\tAND FExpiredDate >= ?  AND FExpiredDate <= ? \n").append("\tAND (FTransferDate IS NULL OR FTransferDate > ? )");
        SQLUtil builder = null;
        Param param = null;
        ResultSet rs = null;
        for (int i = 0; i < this.paramList.size(); ++i) {
            param = (Param)this.paramList.get(i);
            builder = new SQLUtil();
            builder.appendSql(sql.toString());
            builder.addParam((Object)param.getCurrencyId());
            builder.addParam((Object)param.getBeginDate());
            builder.addParam((Object)param.getEndDate());
            builder.addParam((Object)param.getEndDate());
            builder.appendSql(" AND ");
            builder.appendParam("FCompanyId", param.getCompanyIdSet().toArray());
            if (param.getBankNumber() != null && param.getBankNumber().length > 0) {
                builder.appendSql(" AND (1 <> 1");
                for (int j = 0; j < param.getBankNumber().length; ++j) {
                    builder.appendSql(" OR ");
                    builder.appendSql("FAcceptanceBankName LIKE ? ");
                    builder.addParam((Object)("%" + param.getBankNumber()[j] + "%"));
                }
                builder.appendSql(")");
            }
            try {
                rs = builder.exeQuery(this.serverCtx);
                if (!rs.next()) continue;
                if (param.getData().equals((Object)RecChequeDataEnum.COUNT)) {
                    param.setResult(new Integer(rs.getInt("cnt")));
                    continue;
                }
                if (!param.getData().equals((Object)RecChequeDataEnum.AMOUNT)) continue;
                param.setResult(rs.getBigDecimal("sumAmt"));
                continue;
            }
            catch (SQLException e) {
                ExceptionHandler.handle((Throwable)e);
                param.setException(e);
                continue;
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
                param.setException((Exception)((Object)e1));
            }
        }
    }

    private void handleResult(SortedParameterArray params) {
        for (int i = 0; i < this.paramList.size(); ++i) {
            Parameter param = params.getParameter(i);
            Param result = (Param)this.paramList.get(i);
            if (result.isHasException()) {
                param.setValue((Object)result.getException().getMessage());
                continue;
            }
            if (result.getResult() == null) {
                param.setValue((Object)Constants.ZERO);
                continue;
            }
            param.setValue(result.getResult());
        }
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = context.getServerContext();
    }

    public boolean batchQuery(Map methods) {
        super.batchQuery(methods);
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    private class Param {
        private final Parameter param;
        private Set companyIdSet = new HashSet();
        private String currencyId;
        private String[] bankNumber;
        private Date beginDate;
        private Date endDate;
        private RecChequeDataEnum data;
        private boolean hasException = false;
        private Exception ex;
        private Object result;

        public Param(Parameter param) {
            this.param = param;
        }

        public Set getCompanyIdSet() {
            return this.companyIdSet;
        }

        public void setCompanyIdSet(Set companyIdSet) {
            this.companyIdSet = companyIdSet;
        }

        public String getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(String currencyId) {
            this.currencyId = currencyId;
        }

        public String[] getBankNumber() {
            return this.bankNumber;
        }

        public void setBankNumber(String[] bankNumber) {
            this.bankNumber = bankNumber;
        }

        public Date getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(Date beginDate) {
            this.beginDate = beginDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public RecChequeDataEnum getData() {
            return this.data;
        }

        public void setData(RecChequeDataEnum data) {
            this.data = data;
        }

        public boolean isHasException() {
            return this.hasException;
        }

        public void setHasException(boolean hasException) {
            this.hasException = hasException;
        }

        public void setException(Exception ex) {
            this.ex = ex;
            this.hasException = true;
        }

        public Exception getException() {
            return this.ex;
        }

        public Parameter getParam() {
            return this.param;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public void init() {
            Object[] args = this.param.getArgs();
            String companyNums = args[0].toString();
            String currencyNum = args[1].toString();
            String payerBankNums = args[2].toString();
            String beginDateStr = args[3].toString();
            String endDateStr = args[4].toString();
            String type = args[5].toString();
            this.initCompanyIdSet(companyNums);
            this.initCurrencyId(currencyNum);
            this.initBankNumber(payerBankNums);
            this.initDates(beginDateStr, endDateStr);
            this.initDataType(type);
        }

        private void initBankNumber(String payerBankNums) {
            if (FMHelper.isEmpty((String)payerBankNums)) {
                return;
            }
            this.bankNumber = payerBankNums.split(";");
        }

        private void initDataType(String type) {
            if (!StringUtils.isEmpty((String)type)) {
                this.data = RecChequeDataEnum.getEnum(type);
                if (this.data == null) {
                    this.setHasException(true);
                    this.setException((Exception)((Object)new BOSException("Data Type Error!")));
                }
            } else {
                this.setHasException(true);
                this.setException((Exception)((Object)new BOSException("Data Type Null!")));
            }
        }

        private void initDates(String beginDateStr, String endDateStr) {
            this.beginDate = !StringUtils.isEmpty((String)beginDateStr) ? DateUtil.stringToDate((String)beginDateStr) : (Date)NtReceivableBatchCalculator.this.context.getReportAdapter().getReportProperty("Report_StartDate");
            this.endDate = !StringUtils.isEmpty((String)endDateStr) ? DateUtil.stringToDate((String)endDateStr) : (Date)NtReceivableBatchCalculator.this.context.getReportAdapter().getReportProperty("Report_EndDate");
        }

        private void initCurrencyId(String currencyNum) {
            if (!StringUtils.isEmpty((String)currencyNum)) {
                this.currencyId = (String)NtReceivableBatchCalculator.this.currencyMap.get(currencyNum);
            } else {
                String sheetName = this.param.getSheetName();
                String sheetCurrencyNum = NtReceivableBatchCalculator.this.context.getReportVariables().getStringValue("Currency", sheetName);
                if (!StringUtils.isEmpty((String)sheetCurrencyNum)) {
                    String sheetCurrencyId;
                    this.currencyId = sheetCurrencyId = (String)NtReceivableBatchCalculator.this.currencyMap.get(sheetCurrencyNum);
                } else {
                    String reportCurrencyId;
                    String repostCurrencyNum = (String)NtReceivableBatchCalculator.this.context.getReportAdapter().getReportProperty("Currency.Number");
                    this.currencyId = reportCurrencyId = (String)NtReceivableBatchCalculator.this.currencyMap.get(repostCurrencyNum);
                }
            }
            if (this.currencyId == null) {
                this.setHasException(true);
                this.setException((Exception)((Object)new BOSException("CURRENCY NUMBER ERROR!")));
            }
        }

        private void initCompanyIdSet(String companyNums) {
            if (!StringUtils.isEmpty((String)companyNums)) {
                String[] companyNum = companyNums.split(";");
                for (int i = 0; i < companyNum.length; ++i) {
                    Object companyId = NtReceivableBatchCalculator.this.companyMap.get(companyNum[i].trim());
                    this.companyIdSet.add(companyId);
                    if (companyId != null) continue;
                    this.setHasException(true);
                    this.setException((Exception)((Object)new BOSException("One Or More Company Number Is Invalid!")));
                }
            } else {
                String reportCompanyId = (String)NtReceivableBatchCalculator.this.context.getReportAdapter().getReportProperty("Company.ID");
                this.companyIdSet.add(reportCompanyId);
            }
        }
    }
}

