/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ntp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NoteDetail;
import com.kingdee.bos.ebservice.NoteDetailRequestBody;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.app.service.PaperNoteRecOpUtil;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.ntp.BillPoolJournalFactory;
import com.kingdee.eas.fm.ntp.BillPoolJournalInfo;
import com.kingdee.eas.fm.ntp.BillTransBizType;
import com.kingdee.eas.fm.ntp.BizProcessTypeEnum;
import com.kingdee.eas.fm.ntp.DirectionEnum;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.fm.ntp.NTPUtil;
import com.kingdee.eas.fm.ntp.NTPVerifyHelper;
import com.kingdee.eas.fm.ntp.PledgeBillStatusEnum;
import com.kingdee.eas.fm.ntp.PoolTypeEnum;
import com.kingdee.eas.fm.ntp.TrusteeInBillCollection;
import com.kingdee.eas.fm.ntp.TrusteeInBillInfo;
import com.kingdee.eas.fm.ntp.app.AbstractTrusteeInBillControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class TrusteeInBillControllerBean
extends AbstractTrusteeInBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ntp.app.TrusteeInBillControllerBean");
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String NTP_RESOURCE = "com.kingdee.eas.fm.ntp.NtpResource";
    private ReceivableBillCollection recCollForLog;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TrusteeInBillControllerBean.submit");
        IObjectPK pk = super._submit(ctx, model);
        PerfLogRecorder.endRecord((String)pfLogId);
        TrusteeInBillInfo element = (TrusteeInBillInfo)model;
        String pfLogId_afterSubmit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TrusteeInBillControllerBean.afterSubmit");
        this.afterSubmit(ctx, element);
        PerfLogRecorder.endRecord((String)pfLogId_afterSubmit);
        return pk;
    }

    private void afterSubmit(Context ctx, TrusteeInBillInfo element) throws EASBizException, BOSException {
        ReceivableBillCollection coll = element.getReceivableEntrys();
        ArrayList<String> srcList = new ArrayList<String>();
        ReceivableBillInfo info = null;
        CoreBaseCollection coreColl = new CoreBaseCollection();
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                srcList.add(info.getId().toString());
                info.setTrusteeInBill(element);
                info.setIsPoolTrustee(true);
                info.setTrusteeOutBill(null);
                coreColl.add((CoreBaseInfo)info);
            }
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(coreColl);
            FMHelper.saveBOTRelation((Context)ctx, srcList, (String)element.getId().toString());
            String pfLogId_afterSubmit_addlog = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"TrusteeInBillControllerBean.afterSubmit_addlog");
            NTPUtil.addBillTransLogByColl(ctx, coll, BillTransBizType.TRUSTEEIN_SUBMIT);
            PerfLogRecorder.endRecord((String)pfLogId_afterSubmit_addlog);
        }
    }

    @Override
    protected Map _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeInBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection baseColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        UserInfo auditUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        TrusteeInBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeinbill_03audit")) {
                    throw new NTPException(NTPException.NO_AUDIT_AUTHRIZED);
                }
                if (PledgeBillStatusEnum.SUBMIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEINBILL_CANNOT_AUDIT);
                }
                info.setBillState(PledgeBillStatusEnum.AUDIT);
                info.setAuditor(auditUser);
                info.setAuditDate(DATE_FORMAT.parse(DATE_FORMAT.format(new Date())));
                baseColl.add((CoreBaseInfo)info);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"091_TRUSTEEINBILL_AUDIT_FAIL", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (baseColl.size() > 0) {
            this.updateBatchData(ctx, baseColl);
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEEIN_AUDIT);
        }
        if (baseColl.size() == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"ALL_AUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(baseColl.size()), String.valueOf(coll.size() - baseColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeInBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection baseColl = new CoreBaseCollection();
        this.recCollForLog = new ReceivableBillCollection();
        TrusteeInBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeinbill_04unaudit")) {
                    throw new NTPException(NTPException.NO_UNAUDIT_AUTHRIZED);
                }
                if (PledgeBillStatusEnum.AUDIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEINBILL_CANNOT_UNAUDIT);
                }
                if (!NTPUtil.isAllPaperBillFailed(ctx, info.getReceivableEntrys())) {
                    throw new NTPException(NTPException.BE_CANNOT_UNAUDIT);
                }
                info.setBillState(PledgeBillStatusEnum.SUBMIT);
                info.setAuditor(null);
                info.setAuditDate(null);
                baseColl.add((CoreBaseInfo)info);
                this.recCollForLog.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"092_TRUSTEEINBILL_UNAUDIT_FAIL", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (baseColl.size() > 0) {
            this.updateBatchData(ctx, baseColl);
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEEIN_UNAUDIT);
        }
        if (baseColl.size() == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"ALL_UNAUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(baseColl.size()), String.valueOf(coll.size() - baseColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _delete(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        StringBuffer truIdsBuffer = new StringBuffer("(");
        StringBuffer recIdsBuffer = new StringBuffer("(");
        int deletedIdsCount = 0;
        TrusteeInBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        TrusteeInBillInfo info = null;
        ReceivableBillCollection recColl = null;
        this.recCollForLog = new ReceivableBillCollection();
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeinbill_02delete")) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                if (PledgeBillStatusEnum.SUBMIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEINBILL_CANNOT_DELETE);
                }
                ++deletedIdsCount;
                DbUtil.execute((Context)ctx, (String)("delete from T_bot_relation  where FDESTOBJECTID = '" + info.getId().toString() + "' and FDESTENTITYID ='" + info.getBOSType().toString() + "'"));
                truIdsBuffer.append("'" + info.getId().toString() + "',");
                recColl = info.getReceivableEntrys();
                this.recCollForLog.addCollection(recColl);
                for (int j = 0; j < recColl.size(); ++j) {
                    recIdsBuffer.append("'" + recColl.get(j).getId().toString() + "',");
                }
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"093_TRUSTEEINBILL_DELETE_FAIL", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        if (deletedIdsCount > 0) {
            truIdsBuffer.deleteCharAt(truIdsBuffer.length() - 1);
            truIdsBuffer.append(")");
            DbUtil.execute((Context)ctx, (String)("delete from T_NTP_TrusteeInBill  where FID in " + truIdsBuffer.toString()));
            recIdsBuffer.deleteCharAt(recIdsBuffer.length() - 1);
            recIdsBuffer.append(")");
            DbUtil.execute((Context)ctx, (String)("update t_nt_ReceivableBill set FTrusteeInBillID=null,FIsPoolTrustee=0 ,FBatchSeqID=null,FDetailSeqID=null,FElecBillStatus=null,FBankReturnMsg=null,FBankReturnStatus=null where FID in " + recIdsBuffer.toString()));
            NTPUtil.addBillTransLogByColl(ctx, this.recCollForLog, BillTransBizType.TRUSTEEIN_DELETE);
        }
        if (deletedIdsCount == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(deletedIdsCount), String.valueOf(coll.size() - deletedIdsCount)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _inPoolConfirm(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeInBillCollection coll = this.getCollByIDSet(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        CoreBaseCollection recCoreColl = new CoreBaseCollection();
        CoreBaseCollection trusteeInBillCoreColl = new CoreBaseCollection();
        CoreBaseCollection journalColl = new CoreBaseCollection();
        ReceivableBillCollection recColl = new ReceivableBillCollection();
        TrusteeInBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                ReceivableBillCollection entryColl = coll.get(i).getReceivableEntrys();
                info = coll.get(i);
                if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeinbill_05confirm")) {
                    throw new NTPException(NTPException.NO_POOLCONFIRM_PERMISSION);
                }
                if (PledgeBillStatusEnum.AUDIT != info.getBillState()) {
                    throw new NTPException(NTPException.TRUSTEEINBILL_CANNOT_INPOOL);
                }
                this.setValue4TrusteeInBill(ctx, info, trusteeInBillCoreColl, true);
                this.updateBillPoolJournal(ctx, info, journalColl);
                this.setValue4ReceivableBill(ctx, info, recCoreColl, true);
                recColl.addCollection(info.getReceivableEntrys());
                continue;
            }
            catch (Exception e) {
                String errorMsg = FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"094_TRUSTEEINBILL_INPOOL_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()});
                result.getDetailMsgList().add(errorMsg);
            }
        }
        if (trusteeInBillCoreColl.size() > 0) {
            this.updateBatchData(ctx, trusteeInBillCoreColl);
            BillPoolJournalFactory.getLocalInstance(ctx).addnewBatchData(journalColl);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recCoreColl);
            NTPUtil.addBillTransLogByColl(ctx, recColl, BillTransBizType.TRUSTEEIN_CONFIRM);
        }
        if (trusteeInBillCoreColl.size() == coll.size()) {
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"095_ALL_INPOOL_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"096_INPOOL_RESULT", (String[])new String[]{String.valueOf(trusteeInBillCoreColl.size()), String.valueOf(coll.size() - trusteeInBillCoreColl.size())});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _cancelInPoolConfirm(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeInBillInfo info = this.getInfoById(ctx, id);
        if (!NTPVerifyHelper.verifyPermission(ctx, info.getCompany().getId(), "ntp_trusteeinbill_06cancelconfirm")) {
            throw new NTPException(NTPException.NO_CANCELPOOLCONFIRM_PERMISSION);
        }
        if (PledgeBillStatusEnum.INPOOL != info.getBillState()) {
            throw new NTPException(NTPException.CANNOT_CANCELTRUSTEEINPOOL);
        }
        ReceivableBillCollection recColl = info.getReceivableEntrys();
        CoreBaseCollection recCoreColl = new CoreBaseCollection();
        ReceivableBillInfo recInfo = null;
        for (int i = 0; i < recColl.size(); ++i) {
            try {
                recInfo = recColl.get(i);
                NTPVerifyHelper.verifyIsTrusteeOut(recInfo.getTrusteeOutBill());
                NTPVerifyHelper.verifyIsPoolTrustee(recInfo.getBillState());
                NTPVerifyHelper.verifyIsCollect(recInfo.isIsCollect());
                NTPVerifyHelper.verifyIsTrusteeToPledge(recInfo.getTrusteeToPledgeBill());
                NTPVerifyHelper.verifyIsPledgeToTrustee(recInfo.isIsPledgeToTrustee());
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"759_TrusteeInBillControllerBean", (Locale)ctx.getLocale()) + recInfo.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"760_TrusteeInBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (result.getDetailMsgList().size() == 0) {
            this.setValue4TrusteeInBill(ctx, info, null, false);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
            DbUtil.execute((Context)ctx, (String)("delete from T_NTP_BillPoolJournal  where FBillID = '" + id + "'"));
            this.setValue4ReceivableBill(ctx, info, recCoreColl, false);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recCoreColl);
            NTPUtil.addBillTransLogByColl(ctx, recColl, BillTransBizType.TRUSTEEIN_CANCELCONFIRM);
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"761_TrusteeInBillControllerBean", (Locale)ctx.getLocale()));
        } else {
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"762_TrusteeInBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private void setValue4TrusteeInBill(Context ctx, TrusteeInBillInfo info, CoreBaseCollection trusteeInBillCoreColl, boolean isInPoolConfirm) throws EASBizException, BOSException {
        if (isInPoolConfirm) {
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            info.setBillState(PledgeBillStatusEnum.INPOOL);
            info.setConfirmor(userInfo);
            info.setConfirmDate(DateUtil.getDayBegin());
            trusteeInBillCoreColl.add((CoreBaseInfo)info);
        } else {
            info.setBillState(PledgeBillStatusEnum.AUDIT);
            info.setConfirmor(null);
            info.setConfirmDate(null);
        }
    }

    private void updateBillPoolJournal(Context ctx, TrusteeInBillInfo info, CoreBaseCollection journalColl) throws EASBizException, BOSException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getTrusteeDate());
        journalInfo.setCreateDate(info.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEE_IN);
        journalInfo.setDirection(DirectionEnum.INFLOW);
        journalInfo.setInAmount(info.getTotalAmout());
        journalInfo.setCooperativeBank(info.getTrustee());
        journalInfo.setCooperativeBankName(info.getTrustee().getName());
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        journalColl.add((CoreBaseInfo)journalInfo);
    }

    private void setValue4ReceivableBill(Context ctx, TrusteeInBillInfo info, CoreBaseCollection recCoreColl, boolean isInPoolConfirm) {
        ReceivableBillCollection coll = info.getReceivableEntrys();
        ReceivableBillInfo recInfo = null;
        if (isInPoolConfirm) {
            for (int i = 0; i < coll.size(); ++i) {
                recInfo = coll.get(i);
                recInfo.setBillState(BillStateEnum.POOLTRUSTEE);
                recInfo.setInPoolDate(DateUtil.getDayBegin());
                recInfo.setCooperativeBank(info.getTrustee());
                recInfo.setCooperativeBankName(info.getTrustee().getName());
                recCoreColl.add((CoreBaseInfo)recInfo);
            }
        } else {
            boolean isNeedAudit = NTHelper.getParam4Boolean(null, (String)"NT011", (boolean)true);
            for (int i = 0; i < coll.size(); ++i) {
                recInfo = coll.get(i);
                if (isNeedAudit) {
                    recInfo.setBillState(BillStateEnum.Audit);
                } else {
                    recInfo.setBillState(BillStateEnum.SAVED);
                }
                recInfo.setInPoolDate(null);
                recInfo.setCooperativeBank(null);
                recInfo.setCooperativeBankName(null);
                recCoreColl.add((CoreBaseInfo)recInfo);
            }
        }
    }

    private TrusteeInBillCollection getCollByIDSet(Context ctx, Set idSet) throws BOSException {
        SelectorItemCollection sellector = this.getSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sellector);
        TrusteeInBillCollection coll = this.getTrusteeInBillCollection(ctx, evi);
        return coll;
    }

    private TrusteeInBillInfo getInfoById(Context ctx, String id) throws BOSException {
        SelectorItemCollection sellector = this.getSelector();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sellector);
        return this.getTrusteeInBillCollection(ctx, evi).get(0);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("billState");
        selector.add("auditor.id");
        selector.add("auditDate");
        selector.add("company.id");
        selector.add("trustee.id");
        selector.add("trusteeDate");
        selector.add("confirmDate");
        selector.add("totalAmout");
        selector.add("count");
        selector.add("currency.id");
        selector.add("trustee.name");
        selector.add("receivableEntrys.id");
        selector.add("receivableEntrys.billState");
        selector.add("receivableEntrys.draftNumber");
        selector.add("receivableEntrys.holder.id");
        selector.add("receivableEntrys.inPoolDate");
        selector.add("receivableEntrys.isCollect");
        selector.add("receivableEntrys.isPledge");
        selector.add("receivableEntrys.isTrustee");
        selector.add("receivableEntrys.isPledge");
        selector.add("receivableEntrys.isDisPledge");
        selector.add("receivableEntrys.isPledgeToTrustee");
        selector.add("receivableEntrys.billAmt");
        selector.add("receivableEntrys.cooperativeBankName");
        selector.add("receivableEntrys.cooperativeBank.id");
        selector.add("receivableEntrys.trusteeOutBill.id");
        selector.add("receivableEntrys.trusteeToPledgeBill.id");
        selector.add("receivableEntrys.bankReturnStatus");
        selector.add("receivableEntrys.bankReturnMsg");
        return selector;
    }

    @Override
    protected Map _synStatus(Context ctx, Set ids) throws BOSException, EASBizException {
        logger.error((Object)"_synStatus enter ... ...");
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{ids.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivableEntrys.*"));
        sic.add(new SelectorItemInfo("receivableEntrys.draftNumber"));
        sic.add(new SelectorItemInfo("receivableEntrys.ntType.group"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.id"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.name"));
        sic.add(new SelectorItemInfo("receivableEntrys.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("receivableEntrys.currency.id"));
        sic.add(new SelectorItemInfo("receivableEntrys.currency.isoCode"));
        view.setSelector(sic);
        int success = 0;
        TrusteeInBillCollection colls = this.getTrusteeInBillCollection(ctx, view);
        PaperNoteRecOpUtil recOpUtil = new PaperNoteRecOpUtil(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            TrusteeInBillInfo info = colls.get(i);
            if (PledgeBillStatusEnum.AUDIT != info.getBillState()) {
                throw new NTPException(NTPException.NO_AUDIT_SYNSTATUE, new Object[]{info.getNumber()});
            }
            try {
                this.doSyncStatus(ctx, recOpUtil, info.getReceivableEntrys());
                this._isAllBankSuccess(ctx, (IObjectValue)info);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.size() - success)});
        result.setSummaryMsg(summary);
        logger.error((Object)"_synStatus out ... ...");
        return result;
    }

    private void doSyncStatus(Context ctx, PaperNoteRecOpUtil recOpUtil, ReceivableBillCollection coll) throws EASBizException, BOSException {
        for (int i = 0; i < coll.size(); ++i) {
            NoteDetail[] details = this.queryRec(ctx, recOpUtil, coll.get(i));
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess(ctx, coll.get(i), details);
        }
    }

    private void afterProcess(Context ctx, ReceivableBillInfo recInfo, NoteDetail[] details) throws EASBizException, BOSException {
        logger.error((Object)"afterProcess enter ... ...");
        CoreBaseCollection recColl = new CoreBaseCollection();
        String draftNumber = recInfo.getDraftNumber();
        logger.error((Object)("draftNumber:" + draftNumber));
        for (int j = 0; j < details.length; ++j) {
            NoteDetail detail = details[j];
            logger.error((Object)("detail.getNoteNo():" + detail.getNoteNo()));
            logger.error((Object)("draftNumber.equals(detail.getNoteNo()):" + draftNumber.equals(detail.getNoteNo())));
            if (!draftNumber.equals(detail.getNoteNo())) continue;
            logger.error((Object)("detail.getNoteState():" + detail.getNoteState()));
            logger.error((Object)("draftNumber.equals(detail.getNoteNo()):" + draftNumber.equals(detail.getNoteNo())));
            logger.error((Object)("ElecBillStatusEnum.STS000_VALUE.equals(detail.getNoteState()):" + "STS000".equals(detail.getNoteState())));
            logger.error((Object)("ElecBillStatusEnum.UNKNOWN_VALUE.equals(detail.getNoteState()):" + "UNKNOWN".equals(detail.getNoteState())));
            if ("STS000".equals(detail.getNoteState())) {
                recInfo.setBankReturnStatus(BankReturnStatusEnum.BANK_SUCCESS);
                recInfo.setElecBillStatus(ElecBillStatusEnum.STS000);
                continue;
            }
            if ("UNKNOWN".equals(detail.getNoteState())) {
                recInfo.setBankReturnStatus(BankReturnStatusEnum.BANK_FAIL);
                recInfo.setElecBillStatus(ElecBillStatusEnum.UNKNOWN);
                continue;
            }
            recInfo.setBankReturnStatus(BankReturnStatusEnum.BANK_FAIL);
            recInfo.setElecBillStatus(ElecBillStatusEnum.UNKNOWN);
        }
        recColl.add((CoreBaseInfo)recInfo);
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
        logger.error((Object)"afterProcess out ... ...");
    }

    private NoteDetail[] queryRec(Context ctx, PaperNoteRecOpUtil recOpUtil, ReceivableBillInfo info) throws BEException {
        logger.error((Object)"queryRec enter ... ...");
        NoteDetail[] details = null;
        NoteDetailRequestBody body = new NoteDetailRequestBody();
        body.setNoteNo(info.getDraftNumber());
        body.setTranType("0");
        body.setDraftType(info.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
        String accNo = info.getHolderAccount().getBankAccountNumber();
        String isoCode = info.getCurrency().getIsoCode();
        try {
            details = recOpUtil.queryPaperNoteDetail(ctx, accNo, isoCode, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        logger.error((Object)"queryRec enter ... ...");
        return details;
    }

    @Override
    protected void _editStatus(Context ctx, List statusList) throws BOSException, EASBizException {
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
        ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            ReceivableBillInfo recInfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (recInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) {
                throw new BEException(BEException.UPDATESTATEERROR1);
            }
            recInfo.setBankReturnStatus((BankReturnStatusEnum)map.get("bankReturnStatus"));
            updateList.add(recInfo);
        }
        logger.debug((Object)"begin to updateBeStatus TrusteeInBillInfo");
        PaperNoteRecOpUtil util = new PaperNoteRecOpUtil();
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList));
        try {
            NoteStatusDetail[] details = util.updatePaperNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private NoteStatusDetail[] parseUpdteDetail(Context ctx, List<ReceivableBillInfo> updateList) {
        NoteStatusDetail[] details = new NoteStatusDetail[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            NoteStatusDetail detail = new NoteStatusDetail();
            detail.setDetailSeqID(recInfo.getDetailSeqID());
            detail.setBatchSeqID(recInfo.getBatchSeqID());
            detail.setEbStatus(recInfo.getBankReturnStatus().getName());
            detail.setEbNoteType("noteRecivable");
            detail.setUpdateReason(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"065_EDITBESTATUS_BYHAND"));
            detail.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            detail.setOrganizationName(ContextUtil.getCurrentFIUnit((Context)ctx).getName());
            details[i] = detail;
        }
        return details;
    }

    private void afterProcess4Update(Context ctx, List<ReceivableBillInfo> updateList, NoteStatusDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteStatusDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.NT100006);
                }
                recInfo.setBankReturnMsg(detail.getEbStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
    }

    @Override
    protected Map _releaseFailedBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        TrusteeInBillInfo info = this.getTrusteeInBillInfo(ctx, pk, this.getSelector());
        ReceivableBillCollection coll = this.getFailedRecBill(info);
        if (coll.size() > 0 && coll.size() < info.getReceivableEntrys().size()) {
            StringBuffer buffer = new StringBuffer("(");
            for (int i = 0; i < coll.size(); ++i) {
                buffer.append("'" + coll.get(i).getId() + "',");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(")");
            DbUtil.execute((Context)ctx, (String)("update t_nt_ReceivableBill set FIsPoolTrustee=0,FTrusteeInBillID=null,FBatchSeqID=null,FDetailSeqID=null,FElecBillStatus=null,FBankReturnMsg=null,FBankReturnStatus=null where FID in " + buffer.toString()));
            int newCount = info.getReceivableEntrys().size() - coll.size();
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < coll.size(); ++i) {
                amount = i == 0 ? coll.get(i).getBillAmt() : amount.add(coll.get(i).getBillAmt());
            }
            amount = info.getTotalAmout().subtract(amount);
            DbUtil.execute((Context)ctx, (String)("update t_ntp_trusteeInBill set Fcount = " + newCount + ",FTotalAmout = " + amount + " where FID= '" + info.getId() + "'"));
            this._isAllBankSuccess(ctx, (IObjectValue)info);
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"731_PledgeBillControllerBean", (Locale)ctx.getLocale()) + coll.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"608_EndorsementBillListUI", (Locale)ctx.getLocale()));
        } else {
            result.getDetailMsgList().add(EASResource.getString((String)NTP_RESOURCE, (String)"132_CONDITION_CAN_RELEASE"));
            result.setSummaryMsg(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"728_PledgeBillControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private ReceivableBillCollection getFailedRecBill(TrusteeInBillInfo info) {
        ReceivableBillCollection coll = new ReceivableBillCollection();
        ReceivableBillCollection entryColl = info.getReceivableEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            ReceivableBillInfo recInfo = entryColl.get(i);
            if (recInfo.getBankReturnStatus() != null && !BankReturnStatusEnum.BANK_FAIL.equals((Object)recInfo.getBankReturnStatus())) continue;
            coll.add(recInfo);
        }
        return coll;
    }

    @Override
    protected void _isAllBankSuccess(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        TrusteeInBillInfo trusteeInfo = (TrusteeInBillInfo)info;
        boolean flag = true;
        ReceivableBillCollection entryColl = trusteeInfo.getReceivableEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            ReceivableBillInfo recInfo = entryColl.get(i);
            if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) continue;
            flag = false;
            break;
        }
        if (flag) {
            trusteeInfo.setBillState(PledgeBillStatusEnum.INPOOL);
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            trusteeInfo.setConfirmor(userInfo);
            trusteeInfo.setConfirmDate(DateUtil.getDayBegin());
            this.update(ctx, (IObjectPK)new ObjectUuidPK(trusteeInfo.getId()), (CoreBaseInfo)trusteeInfo);
            BillPoolJournalInfo journalInfo = this.buildJournalInfo(ctx, trusteeInfo);
            BillPoolJournalFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)journalInfo);
            CoreBaseCollection receivableColl = this.getReceivableBillColls(ctx, trusteeInfo);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(receivableColl);
        }
    }

    private BillPoolJournalInfo buildJournalInfo(Context ctx, TrusteeInBillInfo info) throws BOSException, EASBizException {
        BillPoolJournalInfo journalInfo = new BillPoolJournalInfo();
        journalInfo.setCompany(info.getCompany());
        journalInfo.setBillID(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getTrusteeDate());
        journalInfo.setCreateDate(info.getConfirmDate());
        journalInfo.setPoolType(PoolTypeEnum.TRUSTEE);
        journalInfo.setBizProcessType(BizProcessTypeEnum.TRUSTEE_IN);
        journalInfo.setDirection(DirectionEnum.INFLOW);
        journalInfo.setInAmount(info.getTotalAmout());
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getTrustee())) {
            BankInfo bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getTrustee().getId().toString()));
            journalInfo.setCooperativeBank(bankInfo);
            journalInfo.setCooperativeBankName(bankInfo.getName());
        }
        journalInfo.setCount(info.getCount());
        journalInfo.setCurrency(info.getCurrency());
        return journalInfo;
    }

    private CoreBaseCollection getReceivableBillColls(Context ctx, TrusteeInBillInfo info) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < info.getReceivableEntrys().size(); ++i) {
            idSet.add(info.getReceivableEntrys().get(i).getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        Date currentDate = DateUtil.getDayBegin();
        BankInfo bankInfo = new BankInfo();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getTrustee())) {
            bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getTrustee().getId().toString()));
        }
        CoreBaseCollection receivableColl = ReceivableBillFactory.getLocalInstance((Context)ctx).getCollection(evi);
        for (int i = 0; i < receivableColl.size(); ++i) {
            ReceivableBillInfo receivableInfo = (ReceivableBillInfo)receivableColl.get(i);
            receivableInfo.setBillState(BillStateEnum.POOLTRUSTEE);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
                receivableInfo.setCooperativeBank(bankInfo);
                receivableInfo.setCooperativeBankName(bankInfo.getName());
            }
            receivableInfo.setInPoolDate(currentDate);
        }
        return receivableColl;
    }
}

