/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.pp.FMAccountBankBalanceHelper;
import com.kingdee.eas.fm.pp.FundFlowBalanceFactory;
import com.kingdee.eas.fm.pp.FundFlowBalanceInfo;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryCollection;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryFactory;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryInfo;
import com.kingdee.eas.fm.pp.FundFlowSetAcctBankCollection;
import com.kingdee.eas.fm.pp.FundFlowSetAcctBankFactory;
import com.kingdee.eas.fm.pp.FundFlowSetAcctBankInfo;
import com.kingdee.eas.fm.pp.FundFlowSetInnerAcctCollection;
import com.kingdee.eas.fm.pp.FundFlowSetInnerAcctFactory;
import com.kingdee.eas.fm.pp.FundFlowSetInnerAcctInfo;
import com.kingdee.eas.fm.pp.FundFlowSetNtTypeCollection;
import com.kingdee.eas.fm.pp.FundFlowSetNtTypeFactory;
import com.kingdee.eas.fm.pp.FundFlowSetNtTypeInfo;
import com.kingdee.eas.fm.pp.OrgScheduleCollection;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PayPlanBillCollection;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.RecPlanBillCollection;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.UserDefinedPeriodInfo;
import com.kingdee.eas.fm.pp.app.AbstractAutoFundFlowBalanceFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoFundFlowBalanceFacadeControllerBean
extends AbstractAutoFundFlowBalanceFacadeControllerBean {
    private static final long serialVersionUID = 5368522805541267163L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.AutoFundFlowBalanceFacadeControllerBean");
    private Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
    private Date beforeDate = DateUtil.getBeforeDay((Date)DateTimeUtils.truncateDate((Date)new Date()));
    private static final String paper_bank = "NVri2OoBSH6c30+2JTeQwNyc97k=";
    private static final String paper_business = "leFPhjgWSR6d90GGE/tdktyc97k=";
    private static final String elect_bank = "TvDo7KKQQ5+cimNZA91Rd9yc97k=";
    private static final String elect_business = "y73skr+HRl6EW7DN97x79Nyc97k=";
    private static final String bankType = "33333333-3333-3333-3333-3333333333331C9A9013";
    private static final String businessType = "44444444-4444-4444-4444-4444444444441C9A9013";
    private static final String currencyNumber = "BB01";
    private static final BigDecimal zero = BigDecimal.ZERO;
    Set companyIdSet = new HashSet();
    Set fundEntryIdSet = new HashSet();
    Set ntFundEntryIdSet = new HashSet();
    Set inAcctFundEntryIdSet = new HashSet();
    Set acctBankIdSet = new HashSet();
    Set ntTypeIdSet = new HashSet();
    Set paperInnerAcctIdSet = new HashSet();
    Map com_ParamMap = new HashMap();
    Map com_PeriodMap = new HashMap();
    Map com_CurrencyMap = new HashMap();
    Map fund_AcctBanksMap = new HashMap();
    Map fund_NtTypesMap = new HashMap();
    Map fund_InnerAcctsMap = new HashMap();
    Map beAcctBankMap = new HashMap();
    Map noBeAcctBankMap = new HashMap();
    Map cashInAcctMap = new HashMap();
    Map comCur_ExcMap = new HashMap();
    Map comType_AmtMap = new HashMap();
    Map com_CasInAcctsMap = new HashMap();
    Map com_ParInAcctsMap = new HashMap();
    Map date_comMap = new HashMap();
    Map fund_BeAmtMap = new HashMap();
    Map fund_NoBeAmtMap = new HashMap();
    Map fund_CasInAmtMap = new HashMap();
    Map fund_PKAmtMap = new HashMap();
    Map fund_PSAmtMap = new HashMap();
    Map fund_EKAmtMap = new HashMap();
    Map fund_ESAmtMap = new HashMap();
    Map fund_ParInAmtMap = new HashMap();
    Map inAcct_ParInAmtMap = new HashMap();
    Map inAcct_CasInAmtMap = new HashMap();
    Map com_CasNoPayAmtMap = new HashMap();
    Map com_CasNoRecAmtMap = new HashMap();
    Map com_ParNoPayAmtMap = new HashMap();
    Map com_ParNoRecAmtMap = new HashMap();

    @Override
    public void autoFundFlowBalance(Context ctx) throws BOSException, EASBizException {
        long original = System.currentTimeMillis();
        logger.error((Object)("AutoFundFlowBalanceFacadeControllerBean\u8d44\u91d1\u6d41\u91cf\u9879\u76ee\u4f59\u989d\u8ba1\u7b97 \u540e\u53f0\u4e8b\u52a1\u5f00\u59cb" + new Date()));
        long begin = System.currentTimeMillis();
        this.initScheduleCompany(ctx);
        logger.error((Object)("1.\u53d6\u51fa\u8bbe\u7f6e\u4e86\u4ed8\u6b3e\u6392\u7a0b\u7684\u6240\u6709\u516c\u53f8 initScheduleCompany \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        if (this.companyIdSet.size() == 0) {
            return;
        }
        begin = System.currentTimeMillis();
        this.initCompanyParam(ctx);
        logger.error((Object)("2.\u53d6\u6240\u6709\u516c\u53f8\u7684\u53c2\u6570NT011 \u503c initCompanyParam \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.initCompanyBaseCurreny(ctx);
        logger.error((Object)("3.\u53d6\u6240\u6709\u516c\u53f8\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01 initCompanyBaseCurreny \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        EntityViewInfo fundView = new EntityViewInfo();
        FilterInfo fundFilter = new FilterInfo();
        SelectorItemCollection fundSelector = new SelectorItemCollection();
        fundSelector.add("*");
        fundSelector.add("FundFolwSettingEntry.company.id");
        fundFilter.getFilterItems().add(new FilterItemInfo("FundFolwSettingEntry.company.id", (Object)this.companyIdSet, CompareType.INCLUDE));
        fundView.setFilter(fundFilter);
        fundView.setSelector(fundSelector);
        begin = System.currentTimeMillis();
        this.getFundFlowSetAcctBank(ctx, fundView);
        logger.error((Object)("4.1\u671f\u521d\u73b0\u6b3e\u53d6\u503c\u8bbe\u7f6e(\u94f6\u884c\u8d26\u6237)\u5206\u7ec4 getFundFlowSetAcctBank \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.groupByAcctBank(ctx);
        logger.error((Object)("4.2\u6279\u91cf\u53d6\u6240\u6709\u94f6\u884c\u8d26\u6237\u6570\u636e\u5e93\u4fe1\u606f  groupByAcctBank \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.cashAcctBankbalance(ctx);
        logger.error((Object)("4.3\u73b0\u6b3e\u53d6\u503c\u8bbe\u7f6e(\u94f6\u884c\u8d26\u6237)\u7684\u4f59\u989d\u8ba1\u7b97  cashAcctBankbalance \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.getFundFlowSetNtType(ctx, fundView);
        logger.error((Object)("5.1\u671f\u521d\u7968\u636e\u53d6\u503c\u8bbe\u7f6e(\u7968\u636e\u7c7b\u578b)  getFundFlowSetNtType \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.paperTypeBalance(ctx);
        logger.error((Object)("5.2\u7968\u636e\u53d6\u503c\u8bbe\u7f6e(\u7968\u636e\u7c7b\u578b)\u7684\u4f59\u989d\u8ba1\u7b97  paperTypeBalance \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.getFundFlowSetInnerAcct(ctx, fundView);
        logger.error((Object)("6.1\u671f\u521d\u7968\u636e\u53d6\u503c\u8bbe\u7f6e(\u5185\u90e8\u8d26\u6237) getFundFlowSetInnerAcct \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.parInAcctBalance(ctx);
        logger.error((Object)("6.2\u671f\u521d\u7968\u636e\u53d6\u503c\u8bbe\u7f6e(\u5185\u90e8\u8d26\u6237)\u7684\u4f59\u989d\u8ba1\u7b97  parInAcctBalance \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.groupByCompany();
        logger.error((Object)("7\u6309\u81ea\u5b9a\u4e49\u5468\u671f\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u5206\u7ec4\u516c\u53f8  groupByCompany \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.getNoPayAmount(ctx);
        logger.error((Object)("8\u73b0\u6b3e\u672a\u4ed8\u91d1\u989d \u3001\u7968\u636e\u672a\u4ed8\u91d1\u989d\u8ba1\u7b97  getNoPayAmount \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.getNoRecAmount(ctx);
        logger.error((Object)("9\u73b0\u6b3e\u672a\u6536\u91d1\u989d \u3001\u7968\u636e\u672a\u6536\u91d1\u989d\u8ba1\u7b97   getNoRecAmount \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        begin = System.currentTimeMillis();
        this.creatFundBalanceInfo(ctx);
        logger.error((Object)("10\u6309\u8d44\u91d1\u6d41\u91cf\u9879\u76ee\u5206\u5f55\u6c47\u603b\u6240\u6709\u91d1\u989d\uff0c\u751f\u6210\u8d44\u6d41\u4f59\u989d\u8868\u6570\u636e  creatFundBalanceInfo \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        this.setLog();
        logger.error((Object)(new Date() + "\u8d44\u6d41\u4f59\u989d\u8868\u6570\u636e\u6574\u4e2a\u540e\u53f0\u4e8b\u52a1\u5b8c\u6210  autoFundFlowBalance \u8017\u65f6: " + (System.currentTimeMillis() - original) + "ms"));
    }

    private void initScheduleCompany(Context ctx) throws BOSException {
        EntityViewInfo orgView = new EntityViewInfo();
        SelectorItemCollection orgSelector = new SelectorItemCollection();
        orgSelector.add("*");
        orgSelector.add("userDefinedPeriod.startDate");
        orgSelector.add("userDefinedPeriod.endDate");
        FilterInfo orgFilter = new FilterInfo();
        orgFilter.getFilterItems().add(new FilterItemInfo("status", (Object)8, CompareType.NOTEQUALS));
        orgView.setSelector(orgSelector);
        orgView.setFilter(orgFilter);
        OrgScheduleCollection orgScheColl = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleCollection(orgView);
        if (orgScheColl != null && orgScheColl.size() > 0) {
            for (int i = 0; i < orgScheColl.size(); ++i) {
                OrgScheduleInfo orgScheduleInfo = orgScheColl.get(i);
                String companyId = orgScheduleInfo.getCompany().getId().toString();
                Date startDate = orgScheduleInfo.getUserDefinedPeriod().getStartDate();
                Date endDate = orgScheduleInfo.getUserDefinedPeriod().getEndDate();
                if ((!this.currentDate.after(startDate) || !this.currentDate.before(endDate)) && !this.currentDate.equals(startDate) && !this.currentDate.equals(endDate)) continue;
                this.com_PeriodMap.put(companyId, orgScheduleInfo.getUserDefinedPeriod());
                this.companyIdSet.add(companyId);
            }
        }
    }

    private void initCompanyParam(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add("NT011");
        ArrayList paramlist = ParamControlFactory.getLocalInstance((Context)ctx).getParamListPatch(paramNumberList, new ArrayList(this.companyIdSet));
        for (ParamSimpleInfo paramSimple : paramlist) {
            String paramValue = paramSimple.getParamValue();
            String comPanyId = paramSimple.getOrgUnitPK().toString();
            this.com_ParamMap.put(comPanyId, Boolean.parseBoolean(paramValue));
        }
    }

    private void initCompanyBaseCurreny(Context ctx) throws BOSException {
        EntityViewInfo comView = new EntityViewInfo();
        SelectorItemCollection comSelector = new SelectorItemCollection();
        comSelector.add("id");
        comSelector.add("baseCurrency.id");
        comSelector.add("baseCurrency.name");
        comSelector.add("baseCurrency.number");
        comSelector.add("baseCurrency.precision");
        FilterInfo comFilter = new FilterInfo();
        comFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.companyIdSet, CompareType.INCLUDE));
        comView.setSelector(comSelector);
        comView.setFilter(comFilter);
        CompanyOrgUnitCollection comColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(comView);
        for (int i = 0; i < comColl.size(); ++i) {
            CompanyOrgUnitInfo companyInfo = comColl.get(i);
            String companyId = companyInfo.getId().toString();
            CurrencyInfo currency = companyInfo.getBaseCurrency();
            this.com_CurrencyMap.put(companyId, currency);
        }
    }

    private void getFundFlowSetAcctBank(Context ctx, EntityViewInfo fundView) throws BOSException {
        FundFlowSetAcctBankCollection fundAcctBankColl = FundFlowSetAcctBankFactory.getLocalInstance(ctx).getFundFlowSetAcctBankCollection(fundView);
        if (fundAcctBankColl != null && fundAcctBankColl.size() > 0) {
            for (int i = 0; i < fundAcctBankColl.size(); ++i) {
                FundFlowSetAcctBankInfo fundAcctBankInfo = fundAcctBankColl.get(i);
                String acctBankId = fundAcctBankInfo.getAccountBank().getId().toString();
                String fundEntryId = fundAcctBankInfo.getFundFolwSettingEntry().getId().toString();
                List acctBankList = (List)this.fund_AcctBanksMap.get(fundEntryId);
                if (acctBankList == null) {
                    ArrayList<String> abList = new ArrayList<String>();
                    abList.add(acctBankId);
                    this.fund_AcctBanksMap.put(fundEntryId, abList);
                } else {
                    acctBankList.add(acctBankId);
                }
                this.acctBankIdSet.add(acctBankId);
                this.fundEntryIdSet.add(fundEntryId);
            }
        }
    }

    private void groupByAcctBank(Context ctx) throws BOSException {
        EntityViewInfo abView = new EntityViewInfo();
        SelectorItemCollection abSelector = new SelectorItemCollection();
        abSelector.add("*");
        abSelector.add("company.id");
        abSelector.add("bank.inGroup");
        abSelector.add("isSetBankInterface");
        abSelector.add("innerAcct.*");
        abSelector.add("innerAcct.type.name");
        abSelector.add("innerAcct.company.id");
        abSelector.add("currency.id");
        abSelector.add("currency.number");
        abSelector.add("currency.precision");
        FilterInfo abFilter = new FilterInfo();
        abFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.acctBankIdSet, CompareType.INCLUDE));
        abView.setSelector(abSelector);
        abView.setFilter(abFilter);
        AccountBankCollection acctBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(abView);
        if (acctBankColl != null && acctBankColl.size() > 0) {
            for (int i = 0; i < acctBankColl.size(); ++i) {
                AccountBankInfo acctBankInfo = acctBankColl.get(i);
                boolean isBank = acctBankInfo.isIsSetBankInterface();
                boolean isInGroup = acctBankInfo.getBank().isInGroup();
                if (isBank && !isInGroup) {
                    this.beAcctBankMap.put(acctBankInfo.getId().toString(), acctBankInfo);
                    continue;
                }
                if (!isBank && !isInGroup) {
                    this.noBeAcctBankMap.put(acctBankInfo.getId().toString(), acctBankInfo);
                    continue;
                }
                if (!isInGroup || !"\u6d3b\u671f".equals(acctBankInfo.getInnerAcct().getType().getName())) continue;
                InnerAccountInfo inAcctInfo = acctBankInfo.getInnerAcct();
                this.cashInAcctMap.put(acctBankInfo.getId().toString(), inAcctInfo);
                List casInAcctList = (List)this.com_CasInAcctsMap.get(inAcctInfo.getCompany().getId().toString());
                if (casInAcctList == null) {
                    ArrayList<String> ciList = new ArrayList<String>();
                    ciList.add(inAcctInfo.getId().toString());
                    this.com_CasInAcctsMap.put(inAcctInfo.getCompany().getId().toString(), ciList);
                    continue;
                }
                casInAcctList.add(inAcctInfo.getId().toString());
            }
        }
    }

    private void cashAcctBankbalance(Context ctx) throws BOSException, EASBizException {
        long begin = System.currentTimeMillis();
        this.inAcctBalance(ctx, this.com_CasInAcctsMap, this.inAcct_CasInAmtMap);
        logger.error((Object)("\u73b0\u6b3e\u53d6\u503c \u53d6\u51fa\u6bcf\u4e2a\u5185\u90e8\u8d26\u6237\u7684\u4f59\u989d  inAcctBalance \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        EntityViewInfo fundEntryView = new EntityViewInfo();
        FilterInfo fundEntryFilter = new FilterInfo();
        fundEntryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.fundEntryIdSet, CompareType.INCLUDE));
        fundEntryView.setFilter(fundEntryFilter);
        FundFlowItemSettingEntryCollection fundEntryColl = FundFlowItemSettingEntryFactory.getLocalInstance(ctx).getFundFlowItemSettingEntryCollection(fundEntryView);
        if (fundEntryColl != null && fundEntryColl.size() > 0) {
            for (int i = 0; i < fundEntryColl.size(); ++i) {
                FundFlowItemSettingEntryInfo fundEntryInfo = fundEntryColl.get(i);
                String fundEntryId = fundEntryInfo.getId().toString();
                String companyId = fundEntryInfo.getCompany().getId().toString();
                List acctBankList = (List)this.fund_AcctBanksMap.get(fundEntryId);
                if (acctBankList == null || acctBankList.size() <= 0) continue;
                for (int j = 0; j < acctBankList.size(); ++j) {
                    BigDecimal balance;
                    String acctBankId = (String)acctBankList.get(j);
                    AccountBankInfo beAcctBank = (AccountBankInfo)this.beAcctBankMap.get(acctBankId);
                    if (beAcctBank != null) {
                        BigDecimal beAcctAmt;
                        BigDecimal balance2;
                        CurrencyInfo currency = beAcctBank.getCurrency();
                        CurrencyInfo baseCurrency = (CurrencyInfo)this.com_CurrencyMap.get(companyId);
                        if (!beAcctBank.isIsByCurrency()) {
                            currency = baseCurrency;
                        }
                        if ((balance2 = FMAccountBankBalanceHelper.getBeAcctBankBalance(ctx, acctBankId, currency)).compareTo(zero) != 0 && beAcctBank.isIsByCurrency() && !baseCurrency.getId().toString().equals(currency.getId().toString())) {
                            balance2 = this.getLocAmount(ctx, companyId, currency.getId().toString(), baseCurrency, balance2);
                        }
                        if ((beAcctAmt = (BigDecimal)this.fund_BeAmtMap.get(fundEntryId)) == null) {
                            beAcctAmt = zero;
                        }
                        beAcctAmt = beAcctAmt.add(balance2);
                        this.fund_BeAmtMap.put(fundEntryId, beAcctAmt);
                        continue;
                    }
                    AccountBankInfo noBeAcctBank = (AccountBankInfo)this.noBeAcctBankMap.get(acctBankId);
                    if (noBeAcctBank != null) {
                        BigDecimal noBeAcctAmt;
                        CurrencyInfo currency = noBeAcctBank.getCurrency();
                        CurrencyInfo baseCurrency = (CurrencyInfo)this.com_CurrencyMap.get(companyId);
                        if (!noBeAcctBank.isIsByCurrency()) {
                            currency = baseCurrency;
                        }
                        if ((balance = FMAccountBankBalanceHelper.getNoBeAcctBankBalance(ctx, companyId, acctBankId, currency, this.currentDate, this.currentDate, CashDataTypeEnum.C)).compareTo(zero) != 0 && noBeAcctBank.isIsByCurrency() && !baseCurrency.getId().toString().equals(currency.getId().toString())) {
                            balance = this.getLocAmount(ctx, companyId, currency.getId().toString(), baseCurrency, balance);
                        }
                        if ((noBeAcctAmt = (BigDecimal)this.fund_NoBeAmtMap.get(fundEntryId)) == null) {
                            noBeAcctAmt = zero;
                        }
                        noBeAcctAmt = noBeAcctAmt.add(balance);
                        this.fund_NoBeAmtMap.put(fundEntryId, noBeAcctAmt);
                        continue;
                    }
                    InnerAccountInfo cashInAcct = (InnerAccountInfo)this.cashInAcctMap.get(acctBankId);
                    if (cashInAcct == null) continue;
                    String casInAcctId = cashInAcct.getId().toString();
                    balance = (BigDecimal)this.inAcct_CasInAmtMap.get(casInAcctId);
                    if (balance == null) {
                        balance = zero;
                    } else {
                        CurrencyInfo currency = (CurrencyInfo)this.com_CurrencyMap.get(cashInAcct.getCompany().getId().toString());
                        CurrencyInfo baseCurrency = (CurrencyInfo)this.com_CurrencyMap.get(companyId);
                        if (!baseCurrency.getId().toString().equals(currency.getId().toString())) {
                            balance = this.getLocAmount(ctx, companyId, currency.getId().toString(), baseCurrency, balance);
                        }
                    }
                    BigDecimal casInAmt = (BigDecimal)this.fund_CasInAmtMap.get(fundEntryId);
                    if (casInAmt == null) {
                        casInAmt = zero;
                    }
                    casInAmt = casInAmt.add(balance);
                    this.fund_CasInAmtMap.put(fundEntryId, casInAmt);
                }
            }
        }
    }

    private void getFundFlowSetNtType(Context ctx, EntityViewInfo fundView) throws BOSException {
        FundFlowSetNtTypeCollection fundNtTypeColl = FundFlowSetNtTypeFactory.getLocalInstance(ctx).getFundFlowSetNtTypeCollection(fundView);
        if (fundNtTypeColl != null && fundNtTypeColl.size() > 0) {
            for (int i = 0; i < fundNtTypeColl.size(); ++i) {
                FundFlowSetNtTypeInfo fundNtTypeInfo = fundNtTypeColl.get(i);
                String ntTypeId = fundNtTypeInfo.getNtType().getId().toString();
                String fundEntryId = fundNtTypeInfo.getFundFolwSettingEntry().getId().toString();
                List nttypeList = (List)this.fund_NtTypesMap.get(fundEntryId);
                if (nttypeList == null) {
                    ArrayList<String> ntList = new ArrayList<String>();
                    ntList.add(ntTypeId);
                    this.fund_NtTypesMap.put(fundEntryId, ntList);
                } else {
                    nttypeList.add(ntTypeId);
                }
                this.ntTypeIdSet.add(ntTypeId);
                this.fundEntryIdSet.add(fundEntryId);
                this.ntFundEntryIdSet.add(fundEntryId);
            }
        }
    }

    private void paperTypeBalance(Context ctx) throws BOSException {
        EntityViewInfo fundEntryView = new EntityViewInfo();
        FilterInfo fundEntryFilter = new FilterInfo();
        fundEntryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ntFundEntryIdSet, CompareType.INCLUDE));
        fundEntryView.setFilter(fundEntryFilter);
        FundFlowItemSettingEntryCollection fundEntryColl = FundFlowItemSettingEntryFactory.getLocalInstance(ctx).getFundFlowItemSettingEntryCollection(fundEntryView);
        if (fundEntryColl != null && fundEntryColl.size() > 0) {
            for (int i = 0; i < fundEntryColl.size(); ++i) {
                FundFlowItemSettingEntryInfo fundEntryInfo = fundEntryColl.get(i);
                String fundEntryId = fundEntryInfo.getId().toString();
                String companyId = fundEntryInfo.getCompany().getId().toString();
                List nttypeList = (List)this.fund_NtTypesMap.get(fundEntryId);
                for (int j = 0; j < nttypeList.size(); ++j) {
                    String ntTypeId = (String)nttypeList.get(j);
                    if (paper_bank.equals(ntTypeId)) {
                        BigDecimal paperBankAmount = this.getPaperTypeAmount(ctx, companyId, 1, bankType, "paper_bank");
                        this.fund_PKAmtMap.put(fundEntryId, paperBankAmount);
                        continue;
                    }
                    if (paper_business.equals(ntTypeId)) {
                        BigDecimal paperBusinessAmount = this.getPaperTypeAmount(ctx, companyId, 1, businessType, "paper_business");
                        this.fund_PSAmtMap.put(fundEntryId, paperBusinessAmount);
                        continue;
                    }
                    if (elect_bank.equals(ntTypeId)) {
                        BigDecimal electBankAmount = this.getPaperTypeAmount(ctx, companyId, 2, bankType, "elect_bank");
                        this.fund_EKAmtMap.put(fundEntryId, electBankAmount);
                        continue;
                    }
                    if (!elect_business.equals(ntTypeId)) continue;
                    BigDecimal electBusinessAmount = this.getPaperTypeAmount(ctx, companyId, 2, businessType, "elect_business");
                    this.fund_ESAmtMap.put(fundEntryId, electBusinessAmount);
                }
            }
        }
    }

    private void getFundFlowSetInnerAcct(Context ctx, EntityViewInfo fundView) throws BOSException {
        fundView.getSelector().add("innerAccount.company.id");
        FundFlowSetInnerAcctCollection fundInnerAcctColl = FundFlowSetInnerAcctFactory.getLocalInstance(ctx).getFundFlowSetInnerAcctCollection(fundView);
        if (fundInnerAcctColl != null && fundInnerAcctColl.size() > 0) {
            for (int i = 0; i < fundInnerAcctColl.size(); ++i) {
                FundFlowSetInnerAcctInfo fundInnerAcctInfo = fundInnerAcctColl.get(i);
                String fundEntryId = fundInnerAcctInfo.getFundFolwSettingEntry().getId().toString();
                String innerAcctId = fundInnerAcctInfo.getInnerAccount().getId().toString();
                String inActCompanyId = fundInnerAcctInfo.getInnerAccount().getCompany().getId().toString();
                List innerAcctList = (List)this.fund_InnerAcctsMap.get(fundEntryId);
                if (innerAcctList == null) {
                    ArrayList<String> iaList = new ArrayList<String>();
                    iaList.add(innerAcctId);
                    this.fund_InnerAcctsMap.put(fundEntryId, iaList);
                } else {
                    innerAcctList.add(innerAcctId);
                }
                this.paperInnerAcctIdSet.add(innerAcctId);
                this.fundEntryIdSet.add(fundEntryId);
                this.inAcctFundEntryIdSet.add(fundEntryId);
                this.cashInAcctMap.put(innerAcctId, fundInnerAcctInfo.getInnerAccount());
                List inAcctList = (List)this.com_ParInAcctsMap.get(inActCompanyId);
                if (inAcctList == null) {
                    ArrayList<String> iaList = new ArrayList<String>();
                    iaList.add(innerAcctId);
                    this.com_ParInAcctsMap.put(inActCompanyId, iaList);
                    continue;
                }
                inAcctList.add(innerAcctId);
            }
        }
    }

    private void parInAcctBalance(Context ctx) throws BOSException, EASBizException {
        long begin = System.currentTimeMillis();
        this.inAcctBalance(ctx, this.com_ParInAcctsMap, this.inAcct_ParInAmtMap);
        logger.error((Object)("\u7968\u636e\u53d6\u503c \u53d6\u51fa\u6bcf\u4e2a\u5185\u90e8\u8d26\u6237\u7684\u4f59\u989d  inAcctBalance \u65f6\u95f4: " + (System.currentTimeMillis() - begin) + "ms"));
        EntityViewInfo fundEntryView = new EntityViewInfo();
        FilterInfo fundEntryFilter = new FilterInfo();
        fundEntryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.inAcctFundEntryIdSet, CompareType.INCLUDE));
        fundEntryView.setFilter(fundEntryFilter);
        FundFlowItemSettingEntryCollection fundEntryColl = FundFlowItemSettingEntryFactory.getLocalInstance(ctx).getFundFlowItemSettingEntryCollection(fundEntryView);
        if (fundEntryColl != null && fundEntryColl.size() > 0) {
            for (int i = 0; i < fundEntryColl.size(); ++i) {
                FundFlowItemSettingEntryInfo fundEntryInfo = fundEntryColl.get(i);
                String fundEntryId = fundEntryInfo.getId().toString();
                String companyId = fundEntryInfo.getCompany().getId().toString();
                List inAcctList = (List)this.fund_InnerAcctsMap.get(fundEntryId);
                for (int j = 0; j < inAcctList.size(); ++j) {
                    String inAcctBankId = (String)inAcctList.get(j);
                    BigDecimal balance = (BigDecimal)this.inAcct_ParInAmtMap.get(inAcctBankId);
                    if (balance == null) {
                        balance = zero;
                    } else {
                        InnerAccountInfo cashInAcct = (InnerAccountInfo)this.cashInAcctMap.get(inAcctBankId);
                        CurrencyInfo currency = (CurrencyInfo)this.com_CurrencyMap.get(cashInAcct.getCompany().getId().toString());
                        CurrencyInfo baseCurrency = (CurrencyInfo)this.com_CurrencyMap.get(companyId);
                        if (!baseCurrency.getId().toString().equals(currency.getId().toString())) {
                            balance = this.getLocAmount(ctx, companyId, currency.getId().toString(), baseCurrency, balance);
                        }
                    }
                    BigDecimal parInAmt = (BigDecimal)this.fund_ParInAmtMap.get(fundEntryId);
                    if (parInAmt == null) {
                        parInAmt = zero;
                    }
                    parInAmt = parInAmt.add(balance);
                    this.fund_ParInAmtMap.put(fundEntryId, parInAmt);
                }
            }
        }
    }

    private void inAcctBalance(Context ctx, Map com_InAcctsMap, Map inAcct_InAmtMap) throws EASBizException, BOSException {
        Map ComInacctCur_BalanceMap = FMAccountBankBalanceHelper.batchGetinnerAcctBalance(ctx, com_InAcctsMap, this.beforeDate);
        Set ComInacctCurSet = ComInacctCur_BalanceMap.keySet();
        if (ComInacctCurSet != null) {
            for (Object ComInacctCur : ComInacctCurSet) {
                BigDecimal balance = (BigDecimal)ComInacctCur_BalanceMap.get(ComInacctCur);
                String comInacctCur = (String)ComInacctCur;
                String[] array = comInacctCur.split(";");
                String companyID = array[0];
                String innerAcctID = array[1];
                String currencyID = array[2];
                CurrencyInfo baseCurrency = (CurrencyInfo)this.com_CurrencyMap.get(companyID);
                if (baseCurrency == null) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("baseCurrency.id");
                    selector.add("baseCurrency.name");
                    selector.add("baseCurrency.number");
                    selector.add("baseCurrency.precision");
                    baseCurrency = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), selector).getBaseCurrency();
                    this.com_CurrencyMap.put(companyID, baseCurrency);
                }
                balance = this.getLocAmount(ctx, companyID, currencyID, baseCurrency, balance);
                BigDecimal amount = (BigDecimal)inAcct_InAmtMap.get(innerAcctID);
                if (amount == null) {
                    amount = zero;
                }
                balance = balance.add(amount);
                inAcct_InAmtMap.put(innerAcctID, balance);
            }
        }
    }

    private void groupByCompany() {
        for (Object companyId : this.companyIdSet) {
            UserDefinedPeriodInfo periodInfo = (UserDefinedPeriodInfo)this.com_PeriodMap.get(companyId);
            String startDate = periodInfo.getStartDate().toString();
            String endDate = periodInfo.getEndDate().toString();
            List companyIdList = (List)this.date_comMap.get(startDate + ";" + endDate);
            if (companyIdList == null) {
                ArrayList comList = new ArrayList();
                comList.add(companyId);
                this.date_comMap.put(startDate + ";" + endDate, comList);
                continue;
            }
            companyIdList.add(companyId);
        }
    }

    private void getNoPayAmount(Context ctx) throws BOSException, EASBizException {
        for (Object dateString : this.date_comMap.keySet()) {
            List companyIdList = (List)this.date_comMap.get(dateString);
            HashSet companySet = new HashSet(companyIdList);
            String[] dateArr = ((String)dateString).split(";");
            Date startDate = new Date(dateArr[0].replace('-', '/'));
            Date endDate = DateUtil.getAfterDay((Date)new Date(dateArr[1].replace('-', '/')));
            EntityViewInfo payPlanView = new EntityViewInfo();
            FilterInfo payPlanFilter = new FilterInfo();
            SelectorItemCollection payPlanSelector = new SelectorItemCollection();
            payPlanSelector.add("company.id");
            payPlanSelector.add("currency.id");
            payPlanSelector.add("cashSchdlLockAmt");
            payPlanSelector.add("cashVerifyAmt");
            payPlanSelector.add("paperSchdlLockAmt");
            payPlanSelector.add("paperVerifyAmt");
            payPlanFilter.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
            payPlanFilter.getFilterItems().add(new FilterItemInfo("payableDate", (Object)startDate, CompareType.GREATER_EQUALS));
            payPlanFilter.getFilterItems().add(new FilterItemInfo("payableDate", (Object)endDate, CompareType.LESS));
            payPlanView.setFilter(payPlanFilter);
            payPlanView.setSelector(payPlanSelector);
            PayPlanBillCollection payPlanColl = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillCollection(payPlanView);
            if (payPlanColl == null || payPlanColl.size() <= 0) continue;
            for (int i = 0; i < payPlanColl.size(); ++i) {
                BigDecimal totalParAmt;
                BigDecimal totalCasAmt;
                BigDecimal CasNoPayAmt;
                BigDecimal PaperVerifyAmt;
                BigDecimal PaperSchdlLockAmt;
                BigDecimal CashVerifyAmt;
                PayPlanBillInfo payPlanBillInfo = payPlanColl.get(i);
                String companyId = payPlanBillInfo.getCompany().getId().toString();
                String currencyId = payPlanBillInfo.getCurrency().getId().toString();
                CurrencyInfo baseCurrency = (CurrencyInfo)this.com_CurrencyMap.get(companyId);
                BigDecimal CashSchdlLockAmt = payPlanBillInfo.getCashSchdlLockAmt();
                if (CashSchdlLockAmt == null) {
                    CashSchdlLockAmt = zero;
                }
                if ((CashVerifyAmt = payPlanBillInfo.getCashVerifyAmt()) == null) {
                    CashVerifyAmt = zero;
                }
                if ((PaperSchdlLockAmt = payPlanBillInfo.getPaperSchdlLockAmt()) == null) {
                    PaperSchdlLockAmt = zero;
                }
                if ((PaperVerifyAmt = payPlanBillInfo.getPaperVerifyAmt()) == null) {
                    PaperVerifyAmt = zero;
                }
                if ((CasNoPayAmt = CashSchdlLockAmt.subtract(CashVerifyAmt)).compareTo(zero) != 0) {
                    CasNoPayAmt = this.getLocAmount(ctx, companyId, currencyId, baseCurrency, CasNoPayAmt);
                }
                if ((totalCasAmt = (BigDecimal)this.com_CasNoPayAmtMap.get(companyId)) == null) {
                    totalCasAmt = zero;
                }
                totalCasAmt = totalCasAmt.add(CasNoPayAmt);
                this.com_CasNoPayAmtMap.put(companyId, totalCasAmt);
                BigDecimal ParNoPayAmt = PaperSchdlLockAmt.subtract(PaperVerifyAmt);
                if (ParNoPayAmt.compareTo(zero) != 0) {
                    ParNoPayAmt = this.getLocAmount(ctx, companyId, currencyId, baseCurrency, ParNoPayAmt);
                }
                if ((totalParAmt = (BigDecimal)this.com_ParNoPayAmtMap.get(companyId)) == null) {
                    totalParAmt = zero;
                }
                totalParAmt = totalParAmt.add(ParNoPayAmt);
                this.com_ParNoPayAmtMap.put(companyId, totalParAmt);
            }
        }
    }

    private void getNoRecAmount(Context ctx) throws BOSException {
        for (Object dateString : this.date_comMap.keySet()) {
            List companyIdList = (List)this.date_comMap.get(dateString);
            HashSet companySet = new HashSet(companyIdList);
            String[] dateArr = ((String)dateString).split(";");
            Date endDate = DateUtil.getAfterDay((Date)new Date(dateArr[1].replace('-', '/')));
            EntityViewInfo recPlanView = new EntityViewInfo();
            FilterInfo recPlanFilter = new FilterInfo();
            SelectorItemCollection recPlanSelector = new SelectorItemCollection();
            recPlanSelector.add("company.id");
            recPlanSelector.add("recLocAmount");
            recPlanSelector.add("settlementType.ntType.superGroup");
            recPlanFilter.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
            recPlanFilter.getFilterItems().add(new FilterItemInfo("recableDate", (Object)this.currentDate, CompareType.GREATER_EQUALS));
            recPlanFilter.getFilterItems().add(new FilterItemInfo("recableDate", (Object)endDate, CompareType.LESS));
            recPlanView.setFilter(recPlanFilter);
            recPlanView.setSelector(recPlanSelector);
            RecPlanBillCollection recPlanColl = RecPlanBillFactory.getLocalInstance(ctx).getRecPlanBillCollection(recPlanView);
            if (recPlanColl == null || recPlanColl.size() <= 0) continue;
            for (int i = 0; i < recPlanColl.size(); ++i) {
                NTTypeGroupEnum typeGroup;
                RecPlanBillInfo recPlanBillInfo = recPlanColl.get(i);
                String companyId = recPlanBillInfo.getCompany().getId().toString();
                BigDecimal recLocAmount = recPlanBillInfo.getRecLocAmount();
                SettlementTypeInfo settlementType = recPlanBillInfo.getSettlementType();
                if (settlementType != null && settlementType.getNtType() != null && (NTTypeGroupEnum.PAYABLE == (typeGroup = settlementType.getNtType().getSuperGroup()) || NTTypeGroupEnum.RECEIVABLE == typeGroup)) {
                    BigDecimal totalAmt = (BigDecimal)this.com_ParNoRecAmtMap.get(companyId);
                    if (totalAmt == null) {
                        totalAmt = zero;
                    }
                    totalAmt = totalAmt.add(recLocAmount);
                    this.com_ParNoRecAmtMap.put(companyId, totalAmt);
                    continue;
                }
                BigDecimal totalAmt = (BigDecimal)this.com_CasNoRecAmtMap.get(companyId);
                if (totalAmt == null) {
                    totalAmt = zero;
                }
                totalAmt = totalAmt.add(recLocAmount);
                this.com_CasNoRecAmtMap.put(companyId, totalAmt);
            }
        }
    }

    private void creatFundBalanceInfo(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo fundEntryView = new EntityViewInfo();
        FilterInfo fundEntryFilter = new FilterInfo();
        SelectorItemCollection fundEntrySelector = new SelectorItemCollection();
        fundEntrySelector.add("*");
        fundEntryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)this.fundEntryIdSet, CompareType.INCLUDE));
        fundEntryView.setFilter(fundEntryFilter);
        fundEntryView.setSelector(fundEntrySelector);
        FundFlowItemSettingEntryCollection fundEntryColl = FundFlowItemSettingEntryFactory.getLocalInstance(ctx).getFundFlowItemSettingEntryCollection(fundEntryView);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        if (fundEntryColl != null && fundEntryColl.size() > 0) {
            CoreBaseCollection fundBalanceColl = new CoreBaseCollection();
            for (int i = 0; i < fundEntryColl.size(); ++i) {
                FundFlowItemSettingEntryInfo fundEntryInfo = fundEntryColl.get(i);
                String fundEntryId = fundEntryInfo.getId().toString();
                String companyId = fundEntryInfo.getCompany().getId().toString();
                FundFlowBalanceInfo fundBalanceInfo = new FundFlowBalanceInfo();
                fundBalanceInfo.setCompany(fundEntryInfo.getCompany());
                fundBalanceInfo.setFundFlowItem(fundEntryInfo.getFundFlowItem());
                fundBalanceInfo.setCurrency((CurrencyInfo)this.com_CurrencyMap.get(companyId));
                fundBalanceInfo.setBalanceData(this.beforeDate);
                BigDecimal BeAmt = (BigDecimal)this.fund_BeAmtMap.get(fundEntryId);
                fundBalanceInfo.setBeAcctAmt(BeAmt);
                BigDecimal NoBeAmt = (BigDecimal)this.fund_NoBeAmtMap.get(fundEntryId);
                fundBalanceInfo.setNoBeAcctAmt(NoBeAmt);
                BigDecimal CasInAmt = (BigDecimal)this.fund_CasInAmtMap.get(fundEntryId);
                fundBalanceInfo.setCashInAcctAmt(CasInAmt);
                BigDecimal PKAmt = (BigDecimal)this.fund_PKAmtMap.get(fundEntryId);
                fundBalanceInfo.setPaperBankAmt(PKAmt);
                BigDecimal PSAmt = (BigDecimal)this.fund_PSAmtMap.get(fundEntryId);
                fundBalanceInfo.setPaperBusinessAmt(PSAmt);
                BigDecimal EKAmt = (BigDecimal)this.fund_EKAmtMap.get(fundEntryId);
                fundBalanceInfo.setElectronicBankAmt(EKAmt);
                BigDecimal ESAmt = (BigDecimal)this.fund_ESAmtMap.get(fundEntryId);
                fundBalanceInfo.setElectronicBusinessAmt(ESAmt);
                BigDecimal ParInAmt = (BigDecimal)this.fund_ParInAmtMap.get(fundEntryId);
                fundBalanceInfo.setPaperAcctAmt(ParInAmt);
                BigDecimal CasNoPayAmt = (BigDecimal)this.com_CasNoPayAmtMap.get(companyId);
                fundBalanceInfo.setCashNoPayAmt(CasNoPayAmt);
                BigDecimal CasNoRecAmt = (BigDecimal)this.com_CasNoRecAmtMap.get(companyId);
                fundBalanceInfo.setCashNoRecAmt(CasNoRecAmt);
                BigDecimal ParNoPayAmt = (BigDecimal)this.com_ParNoPayAmtMap.get(companyId);
                fundBalanceInfo.setPaperNoPayAmt(ParNoPayAmt);
                BigDecimal ParNoRecAmt = (BigDecimal)this.com_ParNoRecAmtMap.get(companyId);
                fundBalanceInfo.setPaperNoRecAmt(ParNoRecAmt);
                fundBalanceInfo.setCreator(userInfo);
                fundBalanceInfo.setCreateTime(currTime);
                this.fillFundFlowBalance(fundBalanceInfo);
                fundBalanceColl.add((CoreBaseInfo)fundBalanceInfo);
            }
            FilterInfo deleteFilter = new FilterInfo();
            deleteFilter.getFilterItems().add(new FilterItemInfo("balanceData", (Object)this.beforeDate));
            FundFlowBalanceFactory.getLocalInstance(ctx).delete(deleteFilter);
            FundFlowBalanceFactory.getLocalInstance(ctx).saveBatchData(fundBalanceColl);
        }
    }

    private BigDecimal getPaperTypeAmount(Context ctx, String companyId, int billMedium, String NTtypeId, String type) throws BOSException {
        BigDecimal typeAmount = (BigDecimal)this.comType_AmtMap.get(companyId + type);
        if (typeAmount != null) {
            return typeAmount;
        }
        BigDecimal paperTypeAmount = BigDecimal.ZERO;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currencyNumber));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("billMedium", (Object)billMedium));
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)NTtypeId));
        filter.getFilterItems().add(new FilterItemInfo("expiredDate", (Object)this.currentDate, CompareType.GREATER));
        if (((Boolean)this.com_ParamMap.get(companyId)).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)8));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("billState", (Object)1));
        }
        view.setSelector(selector);
        view.setFilter(filter);
        ReceivableBillCollection receivableColl = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillCollection(view);
        if (receivableColl != null && receivableColl.size() > 0) {
            for (int i = 0; i < receivableColl.size(); ++i) {
                ReceivableBillInfo info = receivableColl.get(i);
                BigDecimal naturalAmt = info.getNaturalAmt();
                paperTypeAmount = paperTypeAmount.add(naturalAmt);
            }
        }
        this.comType_AmtMap.put(companyId + type, paperTypeAmount);
        return paperTypeAmount;
    }

    private BigDecimal getLocAmount(Context ctx, String companyId, String currencyId, CurrencyInfo baseCurrency, BigDecimal balance) throws EASBizException, BOSException {
        BigDecimal value;
        BigDecimal locAmount = BigDecimal.ZERO;
        Map exchangeRate = (Map)this.comCur_ExcMap.get(companyId + currencyId);
        if (exchangeRate == null) {
            exchangeRate = CASCommonWebFacadeFactory.getLocalInstance((Context)ctx).getExchangeRate(companyId, currencyId, this.beforeDate);
            this.comCur_ExcMap.put(companyId + currencyId, exchangeRate);
        }
        if ((value = (BigDecimal)exchangeRate.get("exchangeRate")).doubleValue() == 0.0) {
            value = new BigDecimal("1");
        }
        boolean isIndirectRate = (Integer)exchangeRate.get("isIndirectRate") == Integer.valueOf(1);
        int precision = baseCurrency.getPrecision();
        locAmount = isIndirectRate ? balance.divide(value, precision, 4) : balance.multiply(value);
        locAmount = locAmount.setScale(precision, 4);
        return balance;
    }

    private void fillFundFlowBalance(FundFlowBalanceInfo fundBalanceInfo) {
        BigDecimal PaperNoRecAmt;
        BigDecimal PaperAcctAmt;
        BigDecimal ElectronicBusinessAmt;
        BigDecimal ElectronicBankAmt;
        BigDecimal PaperBusinessAmt;
        BigDecimal PaperBankAmt;
        BigDecimal CashNoRecAmt;
        BigDecimal CashInAcctAmt;
        BigDecimal NoBeAcctAmt;
        BigDecimal BeAcctAmt = fundBalanceInfo.getBeAcctAmt();
        if (BeAcctAmt == null) {
            BeAcctAmt = zero;
            fundBalanceInfo.setBeAcctAmt(zero);
        }
        if ((NoBeAcctAmt = fundBalanceInfo.getNoBeAcctAmt()) == null) {
            NoBeAcctAmt = zero;
            fundBalanceInfo.setNoBeAcctAmt(zero);
        }
        if ((CashInAcctAmt = fundBalanceInfo.getCashInAcctAmt()) == null) {
            CashInAcctAmt = zero;
            fundBalanceInfo.setCashInAcctAmt(zero);
        }
        BigDecimal CashAmount = BeAcctAmt.add(NoBeAcctAmt).add(CashInAcctAmt);
        fundBalanceInfo.setCashAmount(CashAmount);
        BigDecimal CashNoPayAmt = fundBalanceInfo.getCashNoPayAmt();
        if (CashNoPayAmt == null) {
            fundBalanceInfo.setCashNoPayAmt(zero);
        }
        if ((CashNoRecAmt = fundBalanceInfo.getCashNoRecAmt()) == null) {
            fundBalanceInfo.setCashNoRecAmt(zero);
        }
        if ((PaperBankAmt = fundBalanceInfo.getPaperBankAmt()) == null) {
            PaperBankAmt = zero;
            fundBalanceInfo.setPaperBankAmt(zero);
        }
        if ((PaperBusinessAmt = fundBalanceInfo.getPaperBusinessAmt()) == null) {
            PaperBusinessAmt = zero;
            fundBalanceInfo.setPaperBusinessAmt(zero);
        }
        if ((ElectronicBankAmt = fundBalanceInfo.getElectronicBankAmt()) == null) {
            ElectronicBankAmt = zero;
            fundBalanceInfo.setElectronicBankAmt(zero);
        }
        if ((ElectronicBusinessAmt = fundBalanceInfo.getElectronicBusinessAmt()) == null) {
            ElectronicBusinessAmt = zero;
            fundBalanceInfo.setElectronicBusinessAmt(zero);
        }
        if ((PaperAcctAmt = fundBalanceInfo.getPaperAcctAmt()) == null) {
            PaperAcctAmt = zero;
            fundBalanceInfo.setPaperAcctAmt(zero);
        }
        BigDecimal PaperAmount = PaperBankAmt.add(PaperBusinessAmt).add(ElectronicBankAmt).add(ElectronicBusinessAmt).add(PaperAcctAmt);
        fundBalanceInfo.setPaperAmount(PaperAmount);
        BigDecimal PaperNoPayAmt = fundBalanceInfo.getPaperNoPayAmt();
        if (PaperNoPayAmt == null) {
            PaperNoPayAmt = zero;
            fundBalanceInfo.setPaperNoPayAmt(zero);
        }
        if ((PaperNoRecAmt = fundBalanceInfo.getPaperNoRecAmt()) == null) {
            PaperNoRecAmt = zero;
            fundBalanceInfo.setPaperNoRecAmt(zero);
        }
    }

    private String setToString(Set set) {
        ArrayList list = new ArrayList(set);
        StringBuffer ids = new StringBuffer();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String id = (String)list.get(i);
                ids.append("'");
                ids.append(id);
                ids.append("'");
                if (i >= list.size() - 1) continue;
                ids.append(",");
            }
        }
        return ids.toString();
    }

    private void setLog() {
        String companys = this.setToString(this.companyIdSet);
        logger.error((Object)("\u8bbe\u7f6e\u4ed8\u6b3e\u6392\u7a0b\u516c\u53f8id\uff1a" + companys));
        String fundEntrys = this.setToString(this.fundEntryIdSet);
        logger.error((Object)("\u8d44\u91d1\u6d41\u91cf\u9879\u76ee\u671f\u521d\u5206\u5f55\u8bbe\u7f6eid\uff1a" + fundEntrys));
    }
}

