/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.pp.BalanceTypeEnum;
import com.kingdee.eas.fm.pp.BgAmountCollection;
import com.kingdee.eas.fm.pp.BgAmountFactory;
import com.kingdee.eas.fm.pp.BgAmountInfo;
import com.kingdee.eas.fm.pp.CapitalBalanceCollection;
import com.kingdee.eas.fm.pp.CapitalBalanceFactory;
import com.kingdee.eas.fm.pp.CapitalBalanceInfo;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryCollection;
import com.kingdee.eas.fm.pp.FundFlowItemSettingEntryInfo;
import com.kingdee.eas.fm.pp.FundFlowItemSettingFactory;
import com.kingdee.eas.fm.pp.FundFlowItemSettingInfo;
import com.kingdee.eas.fm.pp.IBgAmount;
import com.kingdee.eas.fm.pp.OrgScheduleCollection;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PPScheduleSettingCollection;
import com.kingdee.eas.fm.pp.PPScheduleSettingFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.fm.pp.SetFundPropertyCollection;
import com.kingdee.eas.fm.pp.SetFundPropertyFactory;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.fm.pp.StandbyAmountCollection;
import com.kingdee.eas.fm.pp.StandbyAmountFactory;
import com.kingdee.eas.fm.pp.StatusEnum;
import com.kingdee.eas.fm.pp.UserDefinedPeriodCollection;
import com.kingdee.eas.fm.pp.UserDefinedPeriodEnum;
import com.kingdee.eas.fm.pp.UserDefinedPeriodFactory;
import com.kingdee.eas.fm.pp.ValueTypeEnum;
import com.kingdee.eas.fm.pp.app.AbstractCapitalBalanceWebFacadeControllerBean;
import com.kingdee.eas.fm.pp.vo.BgControlRow;
import com.kingdee.eas.fm.pp.vo.CapitalBalanceRow;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgCtrlSetRuleEnum;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalBalanceWebFacadeControllerBean
extends AbstractCapitalBalanceWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.CapitalBalanceWebFacadeControllerBean");

    @Override
    public Map _queryCapitalBalanceData(Context ctx, String orgScheduleId) throws BOSException, EASBizException {
        OrgScheduleInfo info = this.getOrgScheduleInfo(ctx, orgScheduleId);
        String title = this.getTitle(ctx, info);
        Map colConfig = this.getColConfigByStatus(info.getStatus());
        Map toolConfig = this.setToolButtonHide();
        String sql = "select main.*,t1.FNUMBER ,t1.FNAME_l2 fname ,t1.FLongNumber from T_PP_CapitalBalance main left join T_CAS_FundFlowItem t1 on main.fundflowitemid=t1.fid where main.forgScheduleId=? order by main.flevelseq  ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgScheduleId});
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<CapitalBalanceRow> rowList = new ArrayList<CapitalBalanceRow>();
        try {
            while (set.next()) {
                CapitalBalanceRow row = new CapitalBalanceRow();
                row.setLevelSeq(set.getInt("FLevelSeq"));
                row.setFundFlowItem(set.getString("FundFlowItemID"));
                row.setLongnumber(set.getString("FLongNumber"));
                row.setFundFlowItemName(set.getString("fname"));
                row.setFundFlowItemNumber(set.getString("FNUMBER"));
                row.setType(BalanceTypeEnum.getEnum(set.getInt("FBalanceType")));
                row.setCashAmount(set.getBigDecimal("FCashAmount"));
                row.setCashAuditAmount(set.getBigDecimal("FCashAuditAmount"));
                row.setCashCurAdjustAmt(set.getBigDecimal("FCashCurAdjustAmt"));
                row.setCashCurAuditAmt(set.getBigDecimal("FCashCurAuditAmt"));
                row.setCashAdjustSumAmt(set.getBigDecimal("FCashAdjustSumAmt"));
                row.setCashSumAmt(set.getBigDecimal("FCashSumAmt"));
                row.setCashAuditSumAmt(set.getBigDecimal("FCashAuditSumAmt"));
                row.setBillAmount(set.getBigDecimal("FBillAmount"));
                row.setBillAuditAmount(set.getBigDecimal("FBillAuditAmount"));
                row.setBillCurAdjustAmt(set.getBigDecimal("FBillCurAdjustAmt"));
                row.setBillCurAuditAmt(set.getBigDecimal("FBillCurAuditAmt"));
                row.setBillAdjustSumAmt(set.getBigDecimal("FBillAdjustSumAmt"));
                row.setBillSumAmt(set.getBigDecimal("FBillSumAmt"));
                row.setBillAuditSumAmt(set.getBigDecimal("FBillAuditSumAmt"));
                row.setCapitalAmt(set.getBigDecimal("FCapitalAmt"));
                row.setCapitalAuditAmt(set.getBigDecimal("FCapitalAuditAmt"));
                row.setCapitalAdjustAmt(set.getBigDecimal("FCapitalAdjustAmt"));
                row.setCapitalAdjustAuditAmt(set.getBigDecimal("FCapitalAdjustAuditAmt"));
                row.setCapitalSumAmt(set.getBigDecimal("FCapitalSumAmt"));
                row.setCapitalAuditSumAmt(set.getBigDecimal("FCapitalAuditSumAmt"));
                rowList.add(row);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        HashMap emptyMap = new HashMap();
        result.put("colConfig", colConfig);
        result.put("toolConfig", toolConfig);
        result.put("tabTitle", title);
        result.put("rowList", rowList);
        result.put("cashConfig", emptyMap);
        result.put("billConfig", emptyMap);
        result.put("editCol", emptyMap);
        result.put("precision", info.getCompany().getBaseCurrency().getPrecision());
        result.put("status", info.getStatus().getValue());
        return result;
    }

    @Override
    public Map _buildCapitalBalanceData(Context ctx, String orgScheduleId) throws BOSException, EASBizException {
        Map<String, Map> result = new HashMap();
        String sql = "select main.*,t1.FNUMBER ,t1.FNAME_l2 fname ,t1.FLongNumber  from T_PP_CapitalBalance main left join T_CAS_FundFlowItem t1 on main.fundflowitemid=t1.fid where main.forgScheduleId=? order by main.flevelseq  ";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgScheduleId});
        if (set.size() <= 0) {
            result = this.getCapitalBalanceData(ctx, orgScheduleId, null);
        } else {
            OrgScheduleInfo info = this.getOrgScheduleInfo(ctx, orgScheduleId);
            String companyId = info.getCompany().getId().toString();
            String title = this.getTitle(ctx, info);
            Map colConfig = this.getColConfigByStatus(info.getStatus());
            Map toolConfig = this.getToolConfigByStatus(info.getStatus());
            Map editCol = this.getEditCol(info.getStatus());
            HashMap<String, String> cashRowConfig = new HashMap<String, String>();
            HashMap<String, String> billRowConfig = new HashMap<String, String>();
            ArrayList<CapitalBalanceRow> rowList = new ArrayList<CapitalBalanceRow>();
            HashMap<String, CapitalBalanceRow> rowData = new HashMap<String, CapitalBalanceRow>();
            HashSet<String> cashEditItemSet = new HashSet<String>();
            HashSet<String> billEditItemSet = new HashSet<String>();
            this.dealFundFlowItemEditConfig(ctx, companyId, cashEditItemSet, billEditItemSet);
            try {
                while (set.next()) {
                    CapitalBalanceRow row = new CapitalBalanceRow();
                    row.setLevelSeq(set.getInt("FLevelSeq"));
                    row.setFundFlowItem(set.getString("FundFlowItemID"));
                    row.setLongnumber(set.getString("FLongNumber"));
                    row.setFundFlowItemName(set.getString("fname"));
                    row.setFundFlowItemNumber(set.getString("FNUMBER"));
                    row.setType(BalanceTypeEnum.getEnum(set.getInt("FBalanceType")));
                    row.setCashAmount(set.getBigDecimal("FCashAmount"));
                    row.setCashAuditAmount(set.getBigDecimal("FCashAuditAmount"));
                    row.setCashCurAdjustAmt(set.getBigDecimal("FCashCurAdjustAmt"));
                    row.setCashCurAuditAmt(set.getBigDecimal("FCashCurAuditAmt"));
                    row.setCashAdjustSumAmt(set.getBigDecimal("FCashAdjustSumAmt"));
                    row.setCashSumAmt(set.getBigDecimal("FCashSumAmt"));
                    row.setCashAuditSumAmt(set.getBigDecimal("FCashAuditSumAmt"));
                    row.setBillAmount(set.getBigDecimal("FBillAmount"));
                    row.setBillAuditAmount(set.getBigDecimal("FBillAuditAmount"));
                    row.setBillCurAdjustAmt(set.getBigDecimal("FBillCurAdjustAmt"));
                    row.setBillCurAuditAmt(set.getBigDecimal("FBillCurAuditAmt"));
                    row.setBillAdjustSumAmt(set.getBigDecimal("FBillAdjustSumAmt"));
                    row.setBillSumAmt(set.getBigDecimal("FBillSumAmt"));
                    row.setBillAuditSumAmt(set.getBigDecimal("FBillAuditSumAmt"));
                    row.setCapitalAmt(set.getBigDecimal("FCapitalAmt"));
                    row.setCapitalAuditAmt(set.getBigDecimal("FCapitalAuditAmt"));
                    row.setCapitalAdjustAmt(set.getBigDecimal("FCapitalAdjustAmt"));
                    row.setCapitalAdjustAuditAmt(set.getBigDecimal("FCapitalAdjustAuditAmt"));
                    row.setCapitalSumAmt(set.getBigDecimal("FCapitalSumAmt"));
                    row.setCapitalAuditSumAmt(set.getBigDecimal("FCapitalAuditSumAmt"));
                    rowList.add(row);
                    rowData.put(set.getString("FundFlowItemID"), row);
                    if (cashEditItemSet.contains(set.getString("FundFlowItemID"))) {
                        cashRowConfig.put(String.valueOf(set.getInt("FLevelSeq")), set.getString("FundFlowItemID"));
                    }
                    if (!billEditItemSet.contains(set.getString("FundFlowItemID"))) continue;
                    billRowConfig.put(String.valueOf(set.getInt("FLevelSeq")), set.getString("FundFlowItemID"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            result.put("colConfig", colConfig);
            result.put("toolConfig", toolConfig);
            result.put("tabTitle", (Map)((Object)title));
            result.put("rowList", (Map)((Object)rowList));
            result.put("cashConfig", cashRowConfig);
            result.put("billConfig", billRowConfig);
            result.put("editCol", editCol);
            result.put("precision", (Map)((Object)Integer.valueOf(info.getCompany().getBaseCurrency().getPrecision())));
            result.put("status", (Map)((Object)Integer.valueOf(info.getStatus().getValue())));
        }
        return result;
    }

    @Override
    public Map _calculateCapitalBalanceData(Context ctx, String orgScheduleId, Map editData) throws BOSException, EASBizException {
        return this.getCapitalBalanceData(ctx, orgScheduleId, editData);
    }

    @Override
    protected void _verifyOperation(Context ctx, String orgScheduleId, String operation) throws BOSException, EASBizException {
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId));
        if (operation.equals("beforeAuditCalculate") && !info.getStatus().equals((Object)StatusEnum.NOT_SCHEDULE) && !info.getStatus().equals((Object)StatusEnum.SCHEDULEING) && !info.getStatus().equals((Object)StatusEnum.ADJUSTING)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_CALCULATE);
        }
        if (operation.equals("afterAuditCalculate") && !info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT) && !info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_CALCULATE);
        }
        if (operation.equals("save") && !info.getStatus().equals((Object)StatusEnum.SCHEDULEING) && !info.getStatus().equals((Object)StatusEnum.NOT_SCHEDULE) && !info.getStatus().equals((Object)StatusEnum.ADJUSTING)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_SAVE);
        }
        if (operation.equals("submit") && !info.getStatus().equals((Object)StatusEnum.SCHEDULEING) && !info.getStatus().equals((Object)StatusEnum.ADJUSTING)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_SUBMIT);
        }
        if (operation.equals("auditEdit") && !info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT) && !info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_AUDIT);
        }
        if (operation.equals("audit") && !info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT) && !info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_AUDIT);
        }
        if (operation.equals("back") && !info.getStatus().equals((Object)StatusEnum.SCHEDULE_SUBMIT) && !info.getStatus().equals((Object)StatusEnum.ADJUST_SUBMIT)) {
            throw new PPException(PPException.CAPITALBALANCE_CANNOT_BACK);
        }
    }

    public Map getCapitalBalanceData(Context ctx, String orgScheduleId, Map editData) throws BOSException, EASBizException {
        CapitalBalanceRow row;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        OrgScheduleInfo info = this.getOrgScheduleInfo(ctx, orgScheduleId);
        String companyId = info.getCompany().getId().toString();
        int count = info.getCount();
        String title = this.getTitle(ctx, info);
        Map colConfig = this.getColConfigByStatus(info.getStatus());
        Map toolConfig = this.getToolConfigByStatus(info.getStatus());
        Map editCol = this.getEditCol(info.getStatus());
        HashMap<String, FundFlowItemSettingEntryInfo> startMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> inMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> outMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> pettyMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> financeMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> endMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, String> cashConfig = new HashMap<String, String>();
        HashMap<String, String> billConfig = new HashMap<String, String>();
        HashMap<String, CapitalBalanceRow> rowData = new HashMap<String, CapitalBalanceRow>();
        ArrayList<CapitalBalanceRow> rowList = new ArrayList<CapitalBalanceRow>();
        int rowId = 10;
        String settingSql = String.format("select *,entries.*,entries.fundflowitem.* where company.id='%s' ", companyId);
        boolean exists = FundFlowItemSettingFactory.getLocalInstance(ctx).exists(settingSql);
        if (!exists) {
            throw new PPException(PPException.CAPITALBALANCE_NO_FFSETTING);
        }
        FundFlowItemSettingInfo setting = FundFlowItemSettingFactory.getLocalInstance(ctx).getFundFlowItemSettingInfo(settingSql);
        FundFlowItemSettingEntryCollection setCol = setting.getEntries();
        block10: for (int i2 = 0; i2 < setCol.size(); ++i2) {
            FundFlowItemSettingEntryInfo setInfo = setCol.get(i2);
            switch (setInfo.getType().getValue()) {
                case 1: {
                    startMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 2: {
                    endMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 3: {
                    inMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 4: {
                    outMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 5: {
                    pettyMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 6: {
                    financeMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                }
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String startDateS = sdf.format(info.getUserDefinedPeriod().getStartDate());
        String endDateS = sdf.format(info.getUserDefinedPeriod().getEndDate());
        Date startDate = new Date();
        Date endDate = new Date();
        try {
            startDate = sdf.parse(startDateS);
            endDate = sdf.parse(endDateS);
            Calendar c = Calendar.getInstance();
            c.setTime(endDate);
            c.add(5, 1);
            endDate = c.getTime();
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        ArrayList<CapitalBalanceRow> tempStart = new ArrayList<CapitalBalanceRow>();
        ArrayList<CapitalBalanceRow> tempIn = new ArrayList<CapitalBalanceRow>();
        ArrayList<CapitalBalanceRow> tempOut = new ArrayList<CapitalBalanceRow>();
        Boolean calculateAll = info.getStatus().equals((Object)StatusEnum.NOT_SCHEDULE) || info.getStatus().equals((Object)StatusEnum.SCHEDULEING);
        if (calculateAll.booleanValue()) {
            this.putSettingData(ctx, orgScheduleId, startMap, BalanceTypeEnum.PERIOD_BEGIN, rowData, tempStart);
            this.buildInData(ctx, orgScheduleId, rowData, tempIn, companyId, startDate, endDate, null);
            this.putSettingData(ctx, orgScheduleId, inMap, BalanceTypeEnum.INCOME, rowData, tempIn);
            this.putSettingData(ctx, orgScheduleId, financeMap, BalanceTypeEnum.FINANC_INCOME, rowData, tempIn);
            this.buildOutData(ctx, orgScheduleId, rowData, tempOut, companyId, count, startDate, endDate, null);
            this.putSettingData(ctx, orgScheduleId, outMap, BalanceTypeEnum.SPENDING, rowData, tempOut);
            this.putSettingData(ctx, orgScheduleId, pettyMap, BalanceTypeEnum.STANDBYAMOUNT, rowData, tempOut);
        } else {
            this.getUsedBalanceData(ctx, orgScheduleId, tempStart, tempIn, tempOut, rowData);
            this.buildInData(ctx, orgScheduleId, rowData, tempIn, companyId, startDate, endDate, null);
            this.buildOutData(ctx, orgScheduleId, rowData, tempOut, companyId, count, startDate, endDate, null);
        }
        this.sortListByLongNumber(tempStart);
        rowList.addAll(tempStart);
        for (i = 0; i < tempStart.size(); ++i) {
            row = (CapitalBalanceRow)tempStart.get(i);
            row.setLevelSeq(rowId);
            rowId += 10;
            this.dealPeriodStart(ctx, row.getFundFlowItem(), startMap, cashConfig, billConfig, rowData, editData, companyId, calculateAll);
            this.calculateSum(row);
            this.addNewRowDealParent(ctx, orgScheduleId, row.getLevelSeq(), row, row.getLongnumber(), rowData, rowList);
        }
        this.sortListByLongNumber(tempIn);
        rowList.addAll(tempIn);
        for (i = 0; i < tempIn.size(); ++i) {
            row = (CapitalBalanceRow)tempIn.get(i);
            row.setLevelSeq(rowId);
            rowId += 10;
            this.dealSettingInData(ctx, row.getFundFlowItem(), inMap, cashConfig, billConfig, rowData, editData);
            this.dealFinanceData(ctx, row.getFundFlowItem(), orgScheduleId, financeMap, cashConfig, billConfig, rowData, editData, count);
            this.calculateSum(row);
            this.addNewRowDealParent(ctx, orgScheduleId, row.getLevelSeq(), row, row.getLongnumber(), rowData, rowList);
        }
        this.sortListByLongNumber(tempOut);
        rowList.addAll(tempOut);
        for (i = 0; i < tempOut.size(); ++i) {
            row = (CapitalBalanceRow)tempOut.get(i);
            row.setLevelSeq(rowId);
            rowId += 10;
            this.dealSettingOutData(ctx, row.getFundFlowItem(), outMap, cashConfig, billConfig, rowData, editData);
            this.dealPettyCashData(ctx, row.getFundFlowItem(), companyId, pettyMap, cashConfig, billConfig, rowData, editData, calculateAll);
            this.calculateSum(row);
            this.addNewRowDealParent(ctx, orgScheduleId, row.getLevelSeq(), row, row.getLongnumber(), rowData, rowList);
        }
        ArrayList<CapitalBalanceRow> tempAll = new ArrayList<CapitalBalanceRow>();
        tempAll.addAll(tempStart);
        tempAll.addAll(tempIn);
        tempAll.addAll(tempOut);
        rowId = this.buildPeriodEndData(ctx, rowId, orgScheduleId, endMap, cashConfig, billConfig, rowData, rowList, tempAll);
        Collections.sort(rowList, new Comparator<CapitalBalanceRow>(){

            @Override
            public int compare(CapitalBalanceRow o1, CapitalBalanceRow o2) {
                return o1.getLevelSeq() - o2.getLevelSeq();
            }
        });
        result.put("tabTitle", title);
        result.put("colConfig", colConfig);
        result.put("toolConfig", toolConfig);
        result.put("rowList", rowList);
        result.put("editCol", editCol);
        result.put("cashConfig", cashConfig);
        result.put("billConfig", billConfig);
        result.put("precision", info.getCompany().getBaseCurrency().getPrecision());
        return result;
    }

    public Map getCapitalBalanceDataByDepartment(Context ctx, String orgScheduleId, Map editData, String departmentId) throws BOSException, EASBizException {
        CapitalBalanceRow row;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        OrgScheduleInfo info = this.getOrgScheduleInfo(ctx, orgScheduleId);
        String companyId = info.getCompany().getId().toString();
        int count = info.getCount();
        String title = this.getTitle(ctx, info);
        Map colConfig = this.getColConfigByStatus(info.getStatus());
        Map toolConfig = this.getToolConfigByStatus(info.getStatus());
        Map editCol = this.getEditCol(info.getStatus());
        HashMap<String, FundFlowItemSettingEntryInfo> startMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> inMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> outMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> pettyMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> financeMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, FundFlowItemSettingEntryInfo> endMap = new HashMap<String, FundFlowItemSettingEntryInfo>();
        HashMap<String, String> cashConfig = new HashMap<String, String>();
        HashMap<String, String> billConfig = new HashMap<String, String>();
        HashMap<String, CapitalBalanceRow> rowData = new HashMap<String, CapitalBalanceRow>();
        ArrayList<CapitalBalanceRow> rowList = new ArrayList<CapitalBalanceRow>();
        int rowId = 10;
        String settingSql = String.format("select *,entries.*,entries.fundflowitem.* where company.id='%s' ", companyId);
        boolean exists = FundFlowItemSettingFactory.getLocalInstance(ctx).exists(settingSql);
        if (!exists) {
            throw new PPException(PPException.CAPITALBALANCE_NO_FFSETTING);
        }
        FundFlowItemSettingInfo setting = FundFlowItemSettingFactory.getLocalInstance(ctx).getFundFlowItemSettingInfo(settingSql);
        FundFlowItemSettingEntryCollection setCol = setting.getEntries();
        block10: for (int i2 = 0; i2 < setCol.size(); ++i2) {
            FundFlowItemSettingEntryInfo setInfo = setCol.get(i2);
            switch (setInfo.getType().getValue()) {
                case 1: {
                    startMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 2: {
                    endMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 3: {
                    inMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 4: {
                    outMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 5: {
                    pettyMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                    continue block10;
                }
                case 6: {
                    financeMap.put(setInfo.getFundFlowItem().getId().toString(), setInfo);
                }
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String startDateS = sdf.format(info.getUserDefinedPeriod().getStartDate());
        String endDateS = sdf.format(info.getUserDefinedPeriod().getEndDate());
        Date startDate = new Date();
        Date endDate = new Date();
        try {
            startDate = sdf.parse(startDateS);
            endDate = sdf.parse(endDateS);
            Calendar c = Calendar.getInstance();
            c.setTime(endDate);
            c.add(5, 1);
            endDate = c.getTime();
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        ArrayList<CapitalBalanceRow> tempStart = new ArrayList<CapitalBalanceRow>();
        ArrayList<CapitalBalanceRow> tempIn = new ArrayList<CapitalBalanceRow>();
        ArrayList<CapitalBalanceRow> tempOut = new ArrayList<CapitalBalanceRow>();
        this.buildInData(ctx, orgScheduleId, rowData, tempIn, companyId, startDate, endDate, departmentId);
        this.buildOutData(ctx, orgScheduleId, rowData, tempOut, companyId, count, startDate, endDate, departmentId);
        this.sortListByLongNumber(tempStart);
        rowList.addAll(tempStart);
        for (i = 0; i < tempStart.size(); ++i) {
            row = (CapitalBalanceRow)tempStart.get(i);
            row.setLevelSeq(rowId);
            rowId += 10;
            this.dealPeriodStart(ctx, row.getFundFlowItem(), startMap, cashConfig, billConfig, rowData, editData, companyId, false);
            this.calculateSum(row);
            this.addNewRowDealParent(ctx, orgScheduleId, row.getLevelSeq(), row, row.getLongnumber(), rowData, rowList);
        }
        this.sortListByLongNumber(tempIn);
        rowList.addAll(tempIn);
        for (i = 0; i < tempIn.size(); ++i) {
            row = (CapitalBalanceRow)tempIn.get(i);
            row.setLevelSeq(rowId);
            rowId += 10;
            this.dealSettingInData(ctx, row.getFundFlowItem(), inMap, cashConfig, billConfig, rowData, editData);
            this.dealFinanceData(ctx, row.getFundFlowItem(), orgScheduleId, financeMap, cashConfig, billConfig, rowData, editData, count);
            this.calculateSum(row);
            this.addNewRowDealParent(ctx, orgScheduleId, row.getLevelSeq(), row, row.getLongnumber(), rowData, rowList);
        }
        this.sortListByLongNumber(tempOut);
        rowList.addAll(tempOut);
        for (i = 0; i < tempOut.size(); ++i) {
            row = (CapitalBalanceRow)tempOut.get(i);
            row.setLevelSeq(rowId);
            rowId += 10;
            this.dealSettingOutData(ctx, row.getFundFlowItem(), outMap, cashConfig, billConfig, rowData, editData);
            this.dealPettyCashData(ctx, row.getFundFlowItem(), companyId, pettyMap, cashConfig, billConfig, rowData, editData, false);
            this.calculateSum(row);
            this.addNewRowDealParent(ctx, orgScheduleId, row.getLevelSeq(), row, row.getLongnumber(), rowData, rowList);
        }
        ArrayList<CapitalBalanceRow> tempAll = new ArrayList<CapitalBalanceRow>();
        tempAll.addAll(tempIn);
        tempAll.addAll(tempOut);
        Collections.sort(rowList, new Comparator<CapitalBalanceRow>(){

            @Override
            public int compare(CapitalBalanceRow o1, CapitalBalanceRow o2) {
                return o1.getLevelSeq() - o2.getLevelSeq();
            }
        });
        result.put("tabTitle", title);
        result.put("colConfig", colConfig);
        result.put("toolConfig", toolConfig);
        result.put("rowList", rowList);
        result.put("editCol", editCol);
        result.put("cashConfig", cashConfig);
        result.put("billConfig", billConfig);
        result.put("precision", info.getCompany().getBaseCurrency().getPrecision());
        return result;
    }

    public void putSettingData(Context ctx, String orgScheduleId, Map<String, FundFlowItemSettingEntryInfo> settingMap, BalanceTypeEnum balanceType, Map<String, CapitalBalanceRow> rowData, List<CapitalBalanceRow> rowList) throws BOSException, EASBizException {
        for (String key : settingMap.keySet()) {
            CapitalBalanceRow row;
            FundFlowItemSettingEntryInfo setInfo = settingMap.get(key);
            String fundFlowItemId = setInfo.getFundFlowItem().getId().toString();
            if (rowData.containsKey(fundFlowItemId)) {
                row = rowData.get(fundFlowItemId);
                continue;
            }
            row = new CapitalBalanceRow();
            row.setType(balanceType);
            row.setFundFlowItem(fundFlowItemId);
            row.setLongnumber(setInfo.getFundFlowItem().getLongNumber());
            row.setFundFlowItemName(setInfo.getFundFlowItem().getName());
            row.setFundFlowItemNumber(setInfo.getFundFlowItem().getNumber());
            rowData.put(fundFlowItemId, row);
            rowList.add(row);
        }
    }

    protected void dealPeriodStart(Context ctx, String fundFlowItemId, Map<String, FundFlowItemSettingEntryInfo> setMap, Map<String, String> cashConfig, Map<String, String> billConfig, Map<String, CapitalBalanceRow> rowData, Map editData, String companyId, Boolean calculateAll) throws BOSException, EASBizException {
        if (setMap.containsKey(fundFlowItemId)) {
            IRowSet rs;
            String sql;
            Map editRow;
            FundFlowItemSettingEntryInfo setInfo = setMap.get(fundFlowItemId);
            CapitalBalanceRow row = rowData.get(fundFlowItemId);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            String filterDateS = sdf.format(new Date());
            Date filterDate = new Date();
            try {
                filterDate = sdf.parse(filterDateS);
                Calendar c = Calendar.getInstance();
                c.setTime(filterDate);
                c.add(5, -1);
                filterDate = c.getTime();
            }
            catch (ParseException e) {
                logger.error((Object)e);
            }
            if (setInfo.getCashOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                cashConfig.put(row.getId(), setInfo.getFundFlowItem().getId().toString());
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setCashAmount(new BigDecimal(editRow.get("cashAmt").equals("") ? "0" : editRow.get("cashAmt").toString()));
                    row.setCashAuditAmount(new BigDecimal(editRow.get("cashAuditAmt").equals("") ? "0" : editRow.get("cashAuditAmt").toString()));
                    row.setCashCurAdjustAmt(new BigDecimal(editRow.get("cashCurAdjustAmt").equals("") ? "0" : editRow.get("cashCurAdjustAmt").toString()));
                    row.setCashCurAuditAmt(new BigDecimal(editRow.get("cashCurAuditAmt").equals("") ? "0" : editRow.get("cashCurAuditAmt").toString()));
                }
            } else if (calculateAll.booleanValue()) {
                sql = " select FCashAmount,FCashNoPayAmt,FCashNoRecAmt from T_PP_FundFlowBalance where FundFlowItemID=? and FCompanyID=? and FBalanceData=? ";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fundFlowItemId, companyId, new Timestamp(filterDate.getTime())});
                try {
                    while (rs.next()) {
                        BigDecimal cashAmt = rs.getBigDecimal("FCashAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("FCashAmount");
                        BigDecimal cashNoPayAmt = rs.getBigDecimal("FCashNoPayAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("FCashNoPayAmt");
                        BigDecimal cashNoRecAmt = rs.getBigDecimal("FCashNoRecAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("FCashNoRecAmt");
                        row.setCashAmount(cashAmt.subtract(cashNoPayAmt).add(cashNoRecAmt));
                        row.setCashAuditAmount(row.getCashAmount());
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (setInfo.getPaperOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                billConfig.put(row.getId(), setInfo.getFundFlowItem().getId().toString());
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setBillAmount(new BigDecimal(editRow.get("billAmt").equals("") ? "0" : editRow.get("billAmt").toString()));
                    row.setBillAuditAmount(new BigDecimal(editRow.get("billAuditAmt").equals("") ? "0" : editRow.get("billAuditAmt").toString()));
                    row.setBillCurAdjustAmt(new BigDecimal(editRow.get("billCurAdjustAmt").equals("") ? "0" : editRow.get("billCurAdjustAmt").toString()));
                    row.setBillCurAuditAmt(new BigDecimal(editRow.get("billCurAuditAmt").equals("") ? "0" : editRow.get("billCurAuditAmt").toString()));
                }
            } else if (calculateAll.booleanValue()) {
                sql = " select FPaperAmount,FPaperNoPayAmt,FPaperNoRecAmt from T_PP_FundFlowBalance where FundFlowItemID=? and FCompanyID=? and FBalanceData=? ";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fundFlowItemId, companyId, new Timestamp(filterDate.getTime())});
                try {
                    while (rs.next()) {
                        BigDecimal billAmt = rs.getBigDecimal("FPaperAmount") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPaperAmount");
                        BigDecimal billNoPayAmt = rs.getBigDecimal("FPaperNoPayAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPaperNoPayAmt");
                        BigDecimal billNoRecAmt = rs.getBigDecimal("FPaperNoRecAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPaperNoRecAmt");
                        row.setBillAmount(billAmt.subtract(billNoPayAmt).add(billNoRecAmt));
                        row.setBillAuditAmount(row.getBillAmount());
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    protected void dealSettingInData(Context ctx, String fundFlowItemId, Map<String, FundFlowItemSettingEntryInfo> inMap, Map<String, String> cashConfig, Map<String, String> billConfig, Map<String, CapitalBalanceRow> rowData, Map editData) throws BOSException, EASBizException {
        if (inMap.containsKey(fundFlowItemId)) {
            Map editRow;
            FundFlowItemSettingEntryInfo setInfo = inMap.get(fundFlowItemId);
            CapitalBalanceRow row = rowData.get(fundFlowItemId);
            if (setInfo.getCashOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                cashConfig.put(row.getId(), fundFlowItemId);
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setCashAmount(new BigDecimal(editRow.get("cashAmt").equals("") ? "0" : editRow.get("cashAmt").toString()));
                    row.setCashAuditAmount(new BigDecimal(editRow.get("cashAuditAmt").equals("") ? "0" : editRow.get("cashAuditAmt").toString()));
                    row.setCashCurAdjustAmt(new BigDecimal(editRow.get("cashCurAdjustAmt").equals("") ? "0" : editRow.get("cashCurAdjustAmt").toString()));
                    row.setCashCurAuditAmt(new BigDecimal(editRow.get("cashCurAuditAmt").equals("") ? "0" : editRow.get("cashCurAuditAmt").toString()));
                }
            }
            if (setInfo.getPaperOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                billConfig.put(row.getId(), fundFlowItemId);
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setBillAmount(new BigDecimal(editRow.get("billAmt").equals("") ? "0" : editRow.get("billAmt").toString()));
                    row.setBillAuditAmount(new BigDecimal(editRow.get("billAuditAmt").equals("") ? "0" : editRow.get("billAuditAmt").toString()));
                    row.setBillCurAdjustAmt(new BigDecimal(editRow.get("billCurAdjustAmt").equals("") ? "0" : editRow.get("billCurAdjustAmt").toString()));
                    row.setBillCurAuditAmt(new BigDecimal(editRow.get("billCurAuditAmt").equals("") ? "0" : editRow.get("billCurAuditAmt").toString()));
                }
            }
        }
    }

    protected void dealFinanceData(Context ctx, String fundFlowItemId, String orgScheduleId, Map<String, FundFlowItemSettingEntryInfo> financeMap, Map<String, String> cashConfig, Map<String, String> billConfig, Map<String, CapitalBalanceRow> rowData, Map editData, int adjustNum) throws BOSException, EASBizException {
        if (financeMap.containsKey(fundFlowItemId)) {
            Map editRow;
            FundFlowItemSettingEntryInfo setInfo = financeMap.get(fundFlowItemId);
            CapitalBalanceRow row = rowData.get(fundFlowItemId);
            if (setInfo.getCashOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                cashConfig.put(row.getId(), fundFlowItemId);
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setCashAmount(new BigDecimal(editRow.get("cashAmt").equals("") ? "0" : editRow.get("cashAmt").toString()));
                    row.setCashAuditAmount(new BigDecimal(editRow.get("cashAuditAmt").equals("") ? "0" : editRow.get("cashAuditAmt").toString()));
                    row.setCashCurAdjustAmt(new BigDecimal(editRow.get("cashCurAdjustAmt").equals("") ? "0" : editRow.get("cashCurAdjustAmt").toString()));
                    row.setCashCurAuditAmt(new BigDecimal(editRow.get("cashCurAuditAmt").equals("") ? "0" : editRow.get("cashCurAuditAmt").toString()));
                }
            }
            if (setInfo.getPaperOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                billConfig.put(row.getId(), fundFlowItemId);
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setBillAmount(new BigDecimal(editRow.get("billAmt").equals("") ? "0" : editRow.get("billAmt").toString()));
                    row.setBillAuditAmount(new BigDecimal(editRow.get("billAuditAmt").equals("") ? "0" : editRow.get("billAuditAmt").toString()));
                    row.setBillCurAdjustAmt(new BigDecimal(editRow.get("billCurAdjustAmt").equals("") ? "0" : editRow.get("billCurAdjustAmt").toString()));
                    row.setBillCurAuditAmt(new BigDecimal(editRow.get("billCurAuditAmt").equals("") ? "0" : editRow.get("billCurAuditAmt").toString()));
                }
            } else {
                StringBuilder sql = new StringBuilder();
                sql.append(" SELECT sum(AMT) AMT,sum(AuditAMT) AuditAMT, FPaySchDetailNumber  from ( ");
                sql.append(" SELECT main.FNtLocAmt  AMT, main.FNtAuditedLocAmt  AuditAMT, main.FPaySchDetailNumber");
                sql.append(" FROM T_PP_PaySchDetailBill main ");
                sql.append(" left join T_BD_SettlementType  t1  on main.FNtSettleTypeID = t1.fid ");
                sql.append(" left join T_NT_NTType          t2  on t1.FNTTYPEID=t2.fid ");
                sql.append(" where t2.FSUPERGROUP = 5 and main.ForgScheduleId=? ) temp");
                sql.append(" group by FPaySchDetailNumber order by FPaySchDetailNumber asc ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgScheduleId});
                try {
                    while (rs.next()) {
                        BigDecimal auditAmt;
                        int num = rs.getInt("FPaySchDetailNumber");
                        BigDecimal amt = rs.getBigDecimal("AMT") == null ? BigDecimal.ZERO : rs.getBigDecimal("AMT");
                        BigDecimal bigDecimal = auditAmt = rs.getBigDecimal("AuditAMT") == null ? BigDecimal.ZERO : rs.getBigDecimal("AuditAMT");
                        if (num == 0) {
                            row.setBillAmount(amt);
                            row.setBillAuditAmount(auditAmt);
                            continue;
                        }
                        if (num < adjustNum) {
                            row.setBillAdjustSumAmt(row.getBillAdjustSumAmt().add(auditAmt));
                            continue;
                        }
                        row.setBillCurAdjustAmt(amt);
                        row.setBillCurAuditAmt(auditAmt);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                StringBuilder backSql = new StringBuilder();
                backSql.append(" SELECT sum(backAmt) backAmt,FBackCount  from ( ");
                backSql.append(" SELECT main.FNtBackLocAmt  backAmt, main.FBackCount");
                backSql.append(" FROM T_PP_PaySchDetailBill main ");
                backSql.append(" left join T_BD_SettlementType  t1  on main.FNtSettleTypeID = t1.fid ");
                backSql.append(" left join T_NT_NTType          t2  on t1.FNTTYPEID=t2.fid ");
                backSql.append(" where t2.FSUPERGROUP = 5 and main.ForgScheduleId=? and main.FBackCount is not null ) temp");
                backSql.append(" group by FBackCount order by FBackCount asc ");
                IRowSet backRS = DbUtil.executeQuery((Context)ctx, (String)backSql.toString(), (Object[])new Object[]{orgScheduleId});
                try {
                    while (backRS.next()) {
                        BigDecimal backAmt;
                        int num = rs.getInt("FBackCount");
                        BigDecimal bigDecimal = backAmt = backRS.getBigDecimal("backAmt") == null ? BigDecimal.ZERO : backRS.getBigDecimal("backAmt");
                        if (num < adjustNum) {
                            row.setBillAdjustSumAmt(row.getBillAdjustSumAmt().subtract(backAmt));
                            continue;
                        }
                        row.setBillCurAdjustAmt(row.getBillCurAdjustAmt().subtract(backAmt));
                        row.setBillCurAuditAmt(row.getBillCurAuditAmt().subtract(backAmt));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public void buildInData(Context ctx, String orgScheduleId, Map<String, CapitalBalanceRow> rowData, List<CapitalBalanceRow> rowList, String companyId, Date startTime, Date endTime, String departmentId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT sum(AMT) AMT,FundFlowItemID,fundFlowItemName,FNUMBER,FTYPE,FLONGNUMBER from ( ");
        sql.append(" SELECT main.FRecLocAmount AMT,t3.FundFlowItemID FundFlowItemID,t4.FNAME_l2 FundFlowItemName,t4.FNUMBER FNUMBER ,t4.FLONGNUMBER FLONGNUMBER,");
        sql.append(" CASE t2.FSUPERGROUP WHEN '4' THEN 'bill' WHEN '5' THEN 'bill' ELSE 'cash' END FTYPE");
        sql.append(" FROM T_PP_RecPlanBill main ");
        sql.append(" left join T_BD_SettlementType  t1  on main.FSettlementTypeID=t1.fid ");
        sql.append(" left join T_PP_SetFundProperty t3  on main.FSetFundPropertyID=t3.fid ");
        sql.append(" left join T_NT_NTType          t2  on t1.FNTTYPEID=t2.fid ");
        sql.append(" left join T_CAS_FundFlowItem   t4  on t3.FundFlowItemID=t4.fid ");
        sql.append(" where  t4.FDIRECTION=1 and main.fcompanyid=? and main.FRecableDate>=? and main.FRecableDate<? and (main.FBillStatus=? or main.FBillStatus=? )");
        if (!EmptyUtil.isEmpty((String)departmentId)) {
            sql.append(" and main.FdepartmentId=? ");
        }
        sql.append(" ) temp");
        sql.append(" group by FundFlowItemID,fundFlowItemName,FNUMBER,FTYPE,FLONGNUMBER order by FLONGNUMBER ");
        try {
            IRowSet rs = null;
            rs = !EmptyUtil.isEmpty((String)departmentId) ? DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, new Timestamp(startTime.getTime()), new Timestamp(endTime.getTime()), 5, 3, departmentId}) : DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, new Timestamp(startTime.getTime()), new Timestamp(endTime.getTime()), 5, 3});
            while (rs.next()) {
                CapitalBalanceRow row;
                String fundFlowItemId = rs.getString("FundFlowItemID");
                if (EmptyUtil.isEmpty((String)fundFlowItemId)) continue;
                String type = rs.getString("FTYPE");
                BigDecimal amt = rs.getBigDecimal("AMT") == null ? BigDecimal.ZERO : rs.getBigDecimal("AMT");
                String fundFlowItemName = rs.getString("fundFlowItemName");
                String fundFlowItemNumber = rs.getString("FNUMBER");
                String longnumber = rs.getString("FLONGNUMBER");
                if (rowData.containsKey(fundFlowItemId)) {
                    row = rowData.get(fundFlowItemId);
                    if (type.equals("cash")) {
                        row.setCashAmount(amt);
                        row.setCashAuditAmount(amt);
                        continue;
                    }
                    row.setBillAmount(amt);
                    row.setBillAuditAmount(amt);
                    continue;
                }
                row = new CapitalBalanceRow();
                if (type.equals("cash")) {
                    row.setCashAmount(amt);
                    row.setCashAuditAmount(amt);
                } else {
                    row.setBillAmount(amt);
                    row.setBillAuditAmount(amt);
                }
                row.setFundFlowItem(fundFlowItemId);
                row.setLongnumber(longnumber);
                row.setFundFlowItemName(fundFlowItemName);
                row.setFundFlowItemNumber(fundFlowItemNumber);
                row.setType(BalanceTypeEnum.RECPLAN);
                rowData.put(fundFlowItemId, row);
                rowList.add(row);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void dealSettingOutData(Context ctx, String fundFlowItemId, Map<String, FundFlowItemSettingEntryInfo> outMap, Map<String, String> cashConfig, Map<String, String> billConfig, Map<String, CapitalBalanceRow> rowData, Map editData) throws BOSException {
        if (outMap.containsKey(fundFlowItemId)) {
            Map editRow;
            FundFlowItemSettingEntryInfo setInfo = outMap.get(fundFlowItemId);
            CapitalBalanceRow row = rowData.get(fundFlowItemId);
            if (setInfo.getCashOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                cashConfig.put(row.getId(), fundFlowItemId);
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setCashAmount(new BigDecimal(editRow.get("cashAmt").equals("") ? "0" : editRow.get("cashAmt").toString()));
                    row.setCashAuditAmount(new BigDecimal(editRow.get("cashAuditAmt").equals("") ? "0" : editRow.get("cashAuditAmt").toString()));
                    row.setCashCurAdjustAmt(new BigDecimal(editRow.get("cashCurAdjustAmt").equals("") ? "0" : editRow.get("cashCurAdjustAmt").toString()));
                    row.setCashCurAuditAmt(new BigDecimal(editRow.get("cashCurAuditAmt").equals("") ? "0" : editRow.get("cashCurAuditAmt").toString()));
                }
            }
            if (setInfo.getPaperOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                billConfig.put(row.getId(), fundFlowItemId);
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    editRow = (Map)editData.get(fundFlowItemId);
                    row.setBillAmount(new BigDecimal(editRow.get("billAmt").equals("") ? "0" : editRow.get("billAmt").toString()));
                    row.setBillAuditAmount(new BigDecimal(editRow.get("billAuditAmt").equals("") ? "0" : editRow.get("billAuditAmt").toString()));
                    row.setBillCurAdjustAmt(new BigDecimal(editRow.get("billCurAdjustAmt").equals("") ? "0" : editRow.get("billCurAdjustAmt").toString()));
                    row.setBillCurAuditAmt(new BigDecimal(editRow.get("billCurAuditAmt").equals("") ? "0" : editRow.get("billCurAuditAmt").toString()));
                }
            }
        }
    }

    protected void dealPettyCashData(Context ctx, String fundFlowItemId, String companyId, Map<String, FundFlowItemSettingEntryInfo> pettyMap, Map<String, String> cashConfig, Map<String, String> billConfig, Map<String, CapitalBalanceRow> rowData, Map editData, Boolean calculateAll) throws BOSException, EASBizException {
        if (pettyMap.containsKey(fundFlowItemId)) {
            FundFlowItemSettingEntryInfo setInfo = pettyMap.get(fundFlowItemId);
            CapitalBalanceRow row = rowData.get(fundFlowItemId);
            if (setInfo.getCashOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                cashConfig.put(row.getId(), fundFlowItemId);
                if (!EmptyUtil.isEmpty((Object)editData) && editData.containsKey(fundFlowItemId)) {
                    Map editRow = (Map)editData.get(fundFlowItemId);
                    row.setCashAmount(new BigDecimal(editRow.get("cashAmt").equals("") ? "0" : editRow.get("cashAmt").toString()));
                    row.setCashAuditAmount(new BigDecimal(editRow.get("cashAuditAmt").equals("") ? "0" : editRow.get("cashAuditAmt").toString()));
                    row.setCashCurAdjustAmt(new BigDecimal(editRow.get("cashCurAdjustAmt").equals("") ? "0" : editRow.get("cashCurAdjustAmt").toString()));
                    row.setCashCurAuditAmt(new BigDecimal(editRow.get("cashCurAuditAmt").equals("") ? "0" : editRow.get("cashCurAuditAmt").toString()));
                }
            } else if (calculateAll.booleanValue()) {
                String filter = "where company.id='" + companyId + "'";
                StandbyAmountCollection col = StandbyAmountFactory.getLocalInstance(ctx).getStandbyAmountCollection(filter);
                for (int i = 0; i < col.size(); ++i) {
                    row.setCashAmount(col.get(i).getAmount());
                    row.setCashAuditAmount(col.get(i).getAmount());
                }
            }
        }
    }

    public void buildOutData(Context ctx, String orgScheduleId, Map<String, CapitalBalanceRow> rowData, List<CapitalBalanceRow> rowList, String companyId, int count, Date startTime, Date endTime, String departmentId) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT sum(cashAmt) cashAmt,sum(cashAuditAmt) cashAuditAmt,sum(ntAMT) ntAMT,sum(ntAuditAMT) ntAuditAMT, ");
        sql.append(" FundFlowItemID,fundFlowItemName,FNUMBER,FLONGNUMBER,FPaySchDetailNumber  from ( ");
        sql.append(" SELECT  main.FCashLocAmt  cashAmt,main.FCashAuditedLocAmt  cashAuditAmt,main.FNtLocAmt ntAMT,main.FNtAuditedLocAmt ntAuditAMT, ");
        sql.append(" t3.FundFlowItemID FundFlowItemID,t4.FNAME_l2 FundFlowItemName,t4.FNUMBER FNUMBER ,t4.FLONGNUMBER FLONGNUMBER , main.FPaySchDetailNumber ");
        sql.append(" FROM T_PP_PaySchDetailBill main ");
        sql.append(" left join T_PP_SetFundProperty t3  on main.FSetFundPropertyID=t3.fid ");
        sql.append(" left join T_CAS_FundFlowItem   t4  on t3.FundFlowItemID=t4.fid ");
        sql.append(" where  t4.FDIRECTION=2 and main.FOrgScheduleId=? ");
        if (!EmptyUtil.isEmpty((String)departmentId)) {
            sql.append(" and main.FdepartmentId=? ");
        }
        sql.append(" ) temp");
        sql.append(" group by FundFlowItemID,fundFlowItemName,FNUMBER,FLONGNUMBER,FPaySchDetailNumber ");
        sql.append(" order by FLONGNUMBER,FPaySchDetailNumber ");
        IRowSet rs = null;
        rs = !EmptyUtil.isEmpty((String)departmentId) ? DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgScheduleId, departmentId}) : DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgScheduleId});
        try {
            while (rs.next()) {
                CapitalBalanceRow row;
                String fundFlowItemId = rs.getString("FundFlowItemID");
                if (EmptyUtil.isEmpty((String)fundFlowItemId)) continue;
                int num = rs.getInt("FPaySchDetailNumber");
                BigDecimal cashAmt = rs.getBigDecimal("cashAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("cashAmt");
                BigDecimal cashAuditAmt = rs.getBigDecimal("cashAuditAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("cashAuditAmt");
                BigDecimal ntAmt = rs.getBigDecimal("ntAMT") == null ? BigDecimal.ZERO : rs.getBigDecimal("ntAMT");
                BigDecimal ntAuditAmt = rs.getBigDecimal("ntAuditAMT") == null ? BigDecimal.ZERO : rs.getBigDecimal("ntAuditAMT");
                String fundFlowItemName = rs.getString("fundFlowItemName");
                String fundFlowItemNumber = rs.getString("FNUMBER");
                String longnumber = rs.getString("FLONGNUMBER");
                if (rowData.containsKey(fundFlowItemId)) {
                    row = rowData.get(fundFlowItemId);
                } else {
                    row = new CapitalBalanceRow();
                    row.setFundFlowItem(fundFlowItemId);
                    row.setLongnumber(longnumber);
                    row.setFundFlowItemName(fundFlowItemName);
                    row.setFundFlowItemNumber(fundFlowItemNumber);
                    row.setType(BalanceTypeEnum.PAYSCHDETAIL);
                    rowData.put(fundFlowItemId, row);
                    rowList.add(row);
                }
                if (num == 0) {
                    row.setCashAmount(cashAmt);
                    row.setCashAuditAmount(cashAuditAmt);
                    row.setBillAmount(ntAmt);
                    row.setBillAuditAmount(ntAuditAmt);
                    continue;
                }
                if (num < count) {
                    row.setCashAdjustSumAmt(row.getCashAdjustSumAmt().add(cashAuditAmt));
                    row.setBillAdjustSumAmt(row.getBillAdjustSumAmt().add(ntAuditAmt));
                    continue;
                }
                row.setCashCurAdjustAmt(row.getCashCurAdjustAmt().add(cashAmt));
                row.setCashCurAuditAmt(row.getCashCurAuditAmt().add(cashAuditAmt));
                row.setBillCurAdjustAmt(row.getBillCurAdjustAmt().add(ntAmt));
                row.setBillCurAuditAmt(row.getBillCurAuditAmt().add(ntAuditAmt));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        StringBuilder backSql = new StringBuilder();
        backSql.append(" SELECT sum(cashBackAmt) cashBackAmt, ");
        backSql.append(" FundFlowItemID,fundFlowItemName,FNUMBER,FLONGNUMBER,FBackCount  from ( ");
        backSql.append(" SELECT  main.FCashBackLocAmt  cashBackAmt,main.FNtBackLocAmt ntBackAmt, ");
        backSql.append(" t3.FundFlowItemID FundFlowItemID,t4.FNAME_l2 FundFlowItemName,t4.FNUMBER FNUMBER ,t4.FLONGNUMBER FLONGNUMBER , main.FBackCount ");
        backSql.append(" FROM T_PP_PaySchDetailBill main ");
        backSql.append(" left join T_PP_SetFundProperty t3  on main.FSetFundPropertyID=t3.fid ");
        backSql.append(" left join T_CAS_FundFlowItem   t4  on t3.FundFlowItemID=t4.fid ");
        backSql.append(" where  t4.FDIRECTION=2 and main.FOrgScheduleId=? and main.FBackCount is not null ");
        if (!EmptyUtil.isEmpty((String)departmentId)) {
            backSql.append(" and main.FdepartmentId = ? ");
        }
        backSql.append(" ) temp");
        backSql.append(" group by FundFlowItemID,fundFlowItemName,FNUMBER,FLONGNUMBER,FBackCount ");
        backSql.append(" order by FLONGNUMBER,FBackCount ");
        IRowSet backRS = null;
        backRS = !EmptyUtil.isEmpty((String)departmentId) ? DbUtil.executeQuery((Context)ctx, (String)backSql.toString(), (Object[])new Object[]{orgScheduleId, departmentId}) : DbUtil.executeQuery((Context)ctx, (String)backSql.toString(), (Object[])new Object[]{orgScheduleId});
        try {
            while (backRS.next()) {
                CapitalBalanceRow row;
                String fundFlowItemId = backRS.getString("FundFlowItemID");
                int backNum = backRS.getInt("FBackCount");
                if (EmptyUtil.isEmpty((String)fundFlowItemId)) continue;
                BigDecimal cashBackAmt = backRS.getBigDecimal("cashBackAmt") == null ? BigDecimal.ZERO : backRS.getBigDecimal("cashBackAmt");
                String fundFlowItemName = backRS.getString("fundFlowItemName");
                String fundFlowItemNumber = backRS.getString("FNUMBER");
                String longnumber = backRS.getString("FLONGNUMBER");
                if (rowData.containsKey(fundFlowItemId)) {
                    row = rowData.get(fundFlowItemId);
                } else {
                    row = new CapitalBalanceRow();
                    row.setFundFlowItem(fundFlowItemId);
                    row.setLongnumber(longnumber);
                    row.setFundFlowItemName(fundFlowItemName);
                    row.setFundFlowItemNumber(fundFlowItemNumber);
                    row.setType(BalanceTypeEnum.PAYSCHDETAIL);
                    rowData.put(fundFlowItemId, row);
                    rowList.add(row);
                }
                if (backNum < count) {
                    row.setCashAdjustSumAmt(row.getCashAdjustSumAmt().subtract(cashBackAmt));
                    continue;
                }
                row.setCashCurAdjustAmt(row.getCashCurAdjustAmt().subtract(cashBackAmt));
                row.setCashCurAuditAmt(row.getCashCurAuditAmt().subtract(cashBackAmt));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        StringBuilder ntbackSql = new StringBuilder();
        ntbackSql.append(" SELECT sum(ntBackAmt) ntBackAmt, ");
        ntbackSql.append(" FundFlowItemID,fundFlowItemName,FNUMBER,FLONGNUMBER,FNtBackCount  from ( ");
        ntbackSql.append(" SELECT  main.FCashBackLocAmt  cashBackAmt,main.FNtBackLocAmt ntBackAmt, ");
        ntbackSql.append(" t3.FundFlowItemID FundFlowItemID,t4.FNAME_l2 FundFlowItemName,t4.FNUMBER FNUMBER ,t4.FLONGNUMBER FLONGNUMBER , main.FNtBackCount ");
        ntbackSql.append(" FROM T_PP_PaySchDetailBill main ");
        ntbackSql.append(" left join T_PP_SetFundProperty t3  on main.FSetFundPropertyID=t3.fid ");
        ntbackSql.append(" left join T_CAS_FundFlowItem   t4  on t3.FundFlowItemID=t4.fid ");
        ntbackSql.append(" where  t4.FDIRECTION=2 and main.FOrgScheduleId=? and main.FNtBackCount is not null ");
        if (!EmptyUtil.isEmpty((String)departmentId)) {
            ntbackSql.append(" and main.FdepartmentId = ? ");
        }
        ntbackSql.append(" ) temp");
        ntbackSql.append(" group by FundFlowItemID,fundFlowItemName,FNUMBER,FLONGNUMBER,FNtBackCount ");
        ntbackSql.append(" order by FLONGNUMBER,FNtBackCount ");
        IRowSet ntbackRS = null;
        ntbackRS = !EmptyUtil.isEmpty((String)departmentId) ? DbUtil.executeQuery((Context)ctx, (String)ntbackSql.toString(), (Object[])new Object[]{orgScheduleId, departmentId}) : DbUtil.executeQuery((Context)ctx, (String)ntbackSql.toString(), (Object[])new Object[]{orgScheduleId});
        try {
            while (ntbackRS.next()) {
                CapitalBalanceRow row;
                String fundFlowItemId = ntbackRS.getString("FundFlowItemID");
                int backNum = ntbackRS.getInt("FNtBackCount");
                if (EmptyUtil.isEmpty((String)fundFlowItemId)) continue;
                BigDecimal ntBackAmt = ntbackRS.getBigDecimal("ntBackAmt") == null ? BigDecimal.ZERO : ntbackRS.getBigDecimal("ntBackAmt");
                String fundFlowItemName = ntbackRS.getString("fundFlowItemName");
                String fundFlowItemNumber = ntbackRS.getString("FNUMBER");
                String longnumber = ntbackRS.getString("FLONGNUMBER");
                if (rowData.containsKey(fundFlowItemId)) {
                    row = rowData.get(fundFlowItemId);
                } else {
                    row = new CapitalBalanceRow();
                    row.setFundFlowItem(fundFlowItemId);
                    row.setLongnumber(longnumber);
                    row.setFundFlowItemName(fundFlowItemName);
                    row.setFundFlowItemNumber(fundFlowItemNumber);
                    row.setType(BalanceTypeEnum.PAYSCHDETAIL);
                    rowData.put(fundFlowItemId, row);
                    rowList.add(row);
                }
                if (backNum < count) {
                    row.setBillAdjustSumAmt(row.getBillAdjustSumAmt().subtract(ntBackAmt));
                    continue;
                }
                row.setBillCurAdjustAmt(row.getBillCurAdjustAmt().subtract(ntBackAmt));
                row.setBillCurAuditAmt(row.getBillCurAuditAmt().subtract(ntBackAmt));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public int buildPeriodEndData(Context ctx, int rowId, String orgScheduleId, Map<String, FundFlowItemSettingEntryInfo> setMap, Map<String, String> cashConfig, Map<String, String> billConfig, Map<String, CapitalBalanceRow> rowData, List<CapitalBalanceRow> rowList, List<CapitalBalanceRow> calculateList) throws BOSException {
        for (String key : setMap.keySet()) {
            FundFlowItemSettingEntryInfo setInfo = setMap.get(key);
            CapitalBalanceRow row = new CapitalBalanceRow();
            row.setLevelSeq(rowId);
            row.setType(BalanceTypeEnum.PERIOD_END);
            row.setLongnumber(setInfo.getFundFlowItem().getLongNumber());
            row.setFundFlowItem(setInfo.getFundFlowItem().getId().toString());
            row.setFundFlowItemName(setInfo.getFundFlowItem().getName());
            row.setFundFlowItemNumber(setInfo.getFundFlowItem().getNumber());
            for (int i = 0; i < calculateList.size(); ++i) {
                CapitalBalanceRow calRow = calculateList.get(i);
                if (calRow.getType().equals((Object)BalanceTypeEnum.PERIOD_BEGIN) || calRow.getType().equals((Object)BalanceTypeEnum.INCOME) || calRow.getType().equals((Object)BalanceTypeEnum.FINANC_INCOME) || calRow.getType().equals((Object)BalanceTypeEnum.RECPLAN)) {
                    row.setCashAmount(row.getCashAmount().add(calRow.getCashAmount()));
                    row.setCashAuditAmount(row.getCashAuditAmount().add(calRow.getCashAuditAmount()));
                    row.setCashCurAdjustAmt(row.getCashCurAdjustAmt().add(calRow.getCashCurAdjustAmt()));
                    row.setCashCurAuditAmt(row.getCashCurAuditAmt().add(calRow.getCashCurAuditAmt()));
                    row.setCashAdjustSumAmt(row.getCashAdjustSumAmt().add(calRow.getCashAdjustSumAmt()));
                    row.setCashSumAmt(row.getCashSumAmt().add(calRow.getCashSumAmt()));
                    row.setCashAuditSumAmt(row.getCashAuditSumAmt().add(calRow.getCashAuditSumAmt()));
                    row.setBillAmount(row.getBillAmount().add(calRow.getBillAmount()));
                    row.setBillAuditAmount(row.getBillAuditAmount().add(calRow.getBillAuditAmount()));
                    row.setBillCurAdjustAmt(row.getBillCurAdjustAmt().add(calRow.getBillCurAdjustAmt()));
                    row.setBillCurAuditAmt(row.getBillCurAuditAmt().add(calRow.getBillCurAuditAmt()));
                    row.setBillAdjustSumAmt(row.getBillAdjustSumAmt().add(calRow.getBillAdjustSumAmt()));
                    row.setBillSumAmt(row.getBillSumAmt().add(calRow.getBillSumAmt()));
                    row.setBillAuditSumAmt(row.getBillAuditSumAmt().add(calRow.getBillAuditSumAmt()));
                    row.setCapitalAmt(row.getCapitalAmt().add(calRow.getCapitalAmt()));
                    row.setCapitalAuditAmt(row.getCapitalAuditAmt().add(calRow.getCapitalAuditAmt()));
                    row.setCapitalAdjustAmt(row.getCapitalAdjustAmt().add(calRow.getCapitalAdjustAmt()));
                    row.setCapitalAdjustAuditAmt(row.getCapitalAdjustAuditAmt().add(calRow.getCapitalAdjustAuditAmt()));
                    row.setCapitalSumAmt(row.getCapitalSumAmt().add(calRow.getCapitalSumAmt()));
                    row.setCapitalAuditSumAmt(row.getCapitalAuditSumAmt().add(calRow.getCapitalAuditSumAmt()));
                    continue;
                }
                row.setCashAmount(row.getCashAmount().subtract(calRow.getCashAmount()));
                row.setCashAuditAmount(row.getCashAuditAmount().subtract(calRow.getCashAuditAmount()));
                row.setCashCurAdjustAmt(row.getCashCurAdjustAmt().subtract(calRow.getCashCurAdjustAmt()));
                row.setCashCurAuditAmt(row.getCashCurAuditAmt().subtract(calRow.getCashCurAuditAmt()));
                row.setCashAdjustSumAmt(row.getCashAdjustSumAmt().subtract(calRow.getCashAdjustSumAmt()));
                row.setCashSumAmt(row.getCashSumAmt().subtract(calRow.getCashSumAmt()));
                row.setCashAuditSumAmt(row.getCashAuditSumAmt().subtract(calRow.getCashAuditSumAmt()));
                row.setBillAmount(row.getBillAmount().subtract(calRow.getBillAmount()));
                row.setBillAuditAmount(row.getBillAuditAmount().subtract(calRow.getBillAuditAmount()));
                row.setBillCurAdjustAmt(row.getBillCurAdjustAmt().subtract(calRow.getBillCurAdjustAmt()));
                row.setBillCurAuditAmt(row.getBillCurAuditAmt().subtract(calRow.getBillCurAuditAmt()));
                row.setBillAdjustSumAmt(row.getBillAdjustSumAmt().subtract(calRow.getBillAdjustSumAmt()));
                row.setBillSumAmt(row.getBillSumAmt().subtract(calRow.getBillSumAmt()));
                row.setBillAuditSumAmt(row.getBillAuditSumAmt().subtract(calRow.getBillAuditSumAmt()));
                row.setCapitalAmt(row.getCapitalAmt().subtract(calRow.getCapitalAmt()));
                row.setCapitalAuditAmt(row.getCapitalAuditAmt().subtract(calRow.getCapitalAuditAmt()));
                row.setCapitalAdjustAmt(row.getCapitalAdjustAmt().subtract(calRow.getCapitalAdjustAmt()));
                row.setCapitalAdjustAuditAmt(row.getCapitalAdjustAuditAmt().subtract(calRow.getCapitalAdjustAuditAmt()));
                row.setCapitalSumAmt(row.getCapitalSumAmt().subtract(calRow.getCapitalSumAmt()));
                row.setCapitalAuditSumAmt(row.getCapitalAuditSumAmt().subtract(calRow.getCapitalAuditSumAmt()));
            }
            rowData.put(setInfo.getFundFlowItem().getId().toString(), row);
            rowList.add(row);
            rowId += 10;
        }
        return rowId;
    }

    public void dealFundFlowItemEditConfig(Context ctx, String companyId, Set<String> cashEditItemSet, Set<String> billEditItemSet) throws EASBizException, BOSException {
        String settingSql = String.format("select *,entries.*,entries.fundflowitem.* where company.id='%s' ", companyId);
        boolean exists = FundFlowItemSettingFactory.getLocalInstance(ctx).exists(settingSql);
        if (!exists) {
            throw new PPException(PPException.CAPITALBALANCE_NO_FFSETTING);
        }
        FundFlowItemSettingInfo setting = FundFlowItemSettingFactory.getLocalInstance(ctx).getFundFlowItemSettingInfo(settingSql);
        FundFlowItemSettingEntryCollection setCol = setting.getEntries();
        for (int i = 0; i < setCol.size(); ++i) {
            FundFlowItemSettingEntryInfo setInfo = setCol.get(i);
            if (setInfo.getCashOfValue().equals((Object)ValueTypeEnum.ENTRY)) {
                cashEditItemSet.add(setInfo.getFundFlowItem().getId().toString());
            }
            if (!setInfo.getPaperOfValue().equals((Object)ValueTypeEnum.ENTRY)) continue;
            billEditItemSet.add(setInfo.getFundFlowItem().getId().toString());
        }
    }

    public void addNewRowDealParent(Context ctx, String orgScheduleId, int rowId, CapitalBalanceRow row, String longnumber, Map<String, CapitalBalanceRow> rowData, List<CapitalBalanceRow> rowList) throws EASBizException, BOSException {
        boolean isTop = false;
        if (!longnumber.contains("!")) {
            isTop = true;
            return;
        }
        longnumber = longnumber.substring(0, longnumber.lastIndexOf("!"));
        String sql = "where LONGNUMBER ='" + longnumber + "'";
        FundFlowItemInfo info = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemInfo(sql);
        String id = info.getId().toString();
        if (rowData.containsKey(id)) {
            CapitalBalanceRow qrow = rowData.get(id);
            qrow.setCashAmount(qrow.getCashAmount().add(row.getCashAmount()));
            qrow.setCashAuditAmount(qrow.getCashAuditAmount().add(row.getCashAuditAmount()));
            qrow.setCashCurAdjustAmt(qrow.getCashCurAdjustAmt().add(row.getCashCurAdjustAmt()));
            qrow.setCashCurAuditAmt(qrow.getCashCurAuditAmt().add(row.getCashCurAuditAmt()));
            qrow.setCashAdjustSumAmt(qrow.getCashAdjustSumAmt().add(row.getCashAdjustSumAmt()));
            qrow.setCashSumAmt(qrow.getCashSumAmt().add(row.getCashSumAmt()));
            qrow.setCashAuditSumAmt(qrow.getCashAuditSumAmt().add(row.getCashAuditSumAmt()));
            qrow.setBillAmount(qrow.getBillAmount().add(row.getBillAmount()));
            qrow.setBillAuditAmount(qrow.getBillAuditAmount().add(row.getBillAuditAmount()));
            qrow.setBillCurAdjustAmt(qrow.getBillCurAdjustAmt().add(row.getBillCurAdjustAmt()));
            qrow.setBillCurAuditAmt(qrow.getBillCurAuditAmt().add(row.getBillCurAuditAmt()));
            qrow.setBillAdjustSumAmt(qrow.getBillAdjustSumAmt().add(row.getBillAdjustSumAmt()));
            qrow.setBillSumAmt(qrow.getBillSumAmt().add(row.getBillSumAmt()));
            qrow.setBillAuditSumAmt(qrow.getBillAuditSumAmt().add(row.getBillAuditSumAmt()));
            qrow.setCapitalAdjustAmt(qrow.getCapitalAdjustAmt().add(row.getCapitalAdjustAmt()));
            qrow.setCapitalAdjustAuditAmt(qrow.getCapitalAdjustAuditAmt().add(row.getCapitalAdjustAuditAmt()));
            qrow.setCapitalAmt(qrow.getCapitalAmt().add(row.getCapitalAmt()));
            qrow.setCapitalAuditAmt(qrow.getCapitalAuditAmt().add(row.getCapitalAuditAmt()));
            qrow.setCapitalAuditSumAmt(qrow.getCapitalAuditSumAmt().add(row.getCapitalAuditSumAmt()));
            qrow.setCapitalSumAmt(qrow.getCapitalSumAmt().add(row.getCapitalSumAmt()));
        } else {
            CapitalBalanceRow qrow = new CapitalBalanceRow();
            qrow.setLevelSeq(--rowId);
            qrow.setFundFlowItem(id);
            qrow.setLongnumber(info.getLongNumber());
            qrow.setFundFlowItemName(info.getName());
            qrow.setFundFlowItemNumber(info.getNumber());
            qrow.setCashAmount(row.getCashAmount());
            qrow.setCashAuditAmount(row.getCashAuditAmount());
            qrow.setCashCurAdjustAmt(row.getCashCurAdjustAmt());
            qrow.setCashCurAuditAmt(row.getCashCurAuditAmt());
            qrow.setCashAdjustSumAmt(row.getCashAdjustSumAmt());
            qrow.setCashSumAmt(row.getCashSumAmt());
            qrow.setCashAuditSumAmt(row.getCashAuditSumAmt());
            qrow.setBillAmount(row.getBillAmount());
            qrow.setBillAuditAmount(row.getBillAuditAmount());
            qrow.setBillCurAdjustAmt(row.getBillCurAdjustAmt());
            qrow.setBillCurAuditAmt(row.getBillCurAuditAmt());
            qrow.setBillAdjustSumAmt(row.getBillAdjustSumAmt());
            qrow.setBillSumAmt(row.getBillSumAmt());
            qrow.setBillAuditSumAmt(row.getBillAuditSumAmt());
            qrow.setCapitalAdjustAmt(row.getCapitalAdjustAmt());
            qrow.setCapitalAdjustAuditAmt(row.getCapitalAdjustAuditAmt());
            qrow.setCapitalAmt(row.getCapitalAmt());
            qrow.setCapitalAuditAmt(row.getCapitalAuditAmt());
            qrow.setCapitalAuditSumAmt(row.getCapitalAuditSumAmt());
            qrow.setCapitalSumAmt(row.getCapitalSumAmt());
            qrow.setType(row.getType());
            rowData.put(id, qrow);
            rowList.add(qrow);
        }
        if (info.getDirection().equals((Object)FundFlowDirection.IN_OUT) || isTop || !longnumber.contains("!")) {
            return;
        }
        this.addNewRowDealParent(ctx, orgScheduleId, rowId, row, info.getLongNumber(), rowData, rowList);
    }

    protected OrgScheduleInfo getOrgScheduleInfo(Context ctx, String orgScheduleId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.*");
        sic.add("company.baseCurrency.*");
        sic.add("userDefinedPeriod.*");
        OrgScheduleInfo info = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheduleId), sic);
        return info;
    }

    protected String getTitle(Context ctx, OrgScheduleInfo info) {
        String companyName = info.getCompany().getName();
        String currencyName = info.getCompany().getBaseCurrency().getName();
        String baseUnit = info.getCompany().getBaseCurrency().getBaseUnit();
        String title = CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"title", (String[])new String[]{companyName, currencyName, info.getUserDefinedPeriod().getStartDate().toString(), info.getUserDefinedPeriod().getEndDate().toString(), baseUnit});
        return title;
    }

    protected Map getColConfigByStatus(StatusEnum status) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        switch (status.getValue()) {
            case 1: 
            case 2: {
                result.put("cashAmount", false);
                result.put("cashAuditAmount", true);
                result.put("cashCurAdjustAmt", true);
                result.put("cashCurAuditAmt", true);
                result.put("cashAdjustSumAmt", true);
                result.put("cashSumAmt", true);
                result.put("cashAuditSumAmt", true);
                result.put("billAmount", false);
                result.put("billAuditAmount", true);
                result.put("billCurAdjustAmt", true);
                result.put("billCurAuditAmt", true);
                result.put("billAdjustSumAmt", true);
                result.put("billSumAmt", true);
                result.put("billAuditSumAmt", true);
                result.put("capitalAmt", false);
                result.put("capitalAuditAmt", true);
                result.put("capitalAdjustAmt", true);
                result.put("capitalAdjustAuditAmt", true);
                result.put("capitalSumAmt", true);
                result.put("capitalAuditSumAmt", true);
                break;
            }
            case 3: {
                result.put("cashAmount", false);
                result.put("cashAuditAmount", false);
                result.put("cashCurAdjustAmt", true);
                result.put("cashCurAuditAmt", true);
                result.put("cashAdjustSumAmt", true);
                result.put("cashSumAmt", true);
                result.put("cashAuditSumAmt", true);
                result.put("billAmount", false);
                result.put("billAuditAmount", false);
                result.put("billCurAdjustAmt", true);
                result.put("billCurAuditAmt", true);
                result.put("billAdjustSumAmt", true);
                result.put("billSumAmt", true);
                result.put("billAuditSumAmt", true);
                result.put("capitalAmt", false);
                result.put("capitalAuditAmt", false);
                result.put("capitalAdjustAmt", true);
                result.put("capitalAdjustAuditAmt", true);
                result.put("capitalSumAmt", true);
                result.put("capitalAuditSumAmt", true);
                break;
            }
            case 4: {
                result.put("cashAmount", false);
                result.put("cashAuditAmount", false);
                result.put("cashCurAdjustAmt", true);
                result.put("cashCurAuditAmt", true);
                result.put("cashAdjustSumAmt", true);
                result.put("cashSumAmt", true);
                result.put("cashAuditSumAmt", true);
                result.put("billAmount", false);
                result.put("billAuditAmount", false);
                result.put("billCurAdjustAmt", true);
                result.put("billCurAuditAmt", true);
                result.put("billAdjustSumAmt", true);
                result.put("billSumAmt", true);
                result.put("billAuditSumAmt", true);
                result.put("capitalAmt", false);
                result.put("capitalAuditAmt", false);
                result.put("capitalAdjustAmt", true);
                result.put("capitalAdjustAuditAmt", true);
                result.put("capitalSumAmt", true);
                result.put("capitalAuditSumAmt", true);
                break;
            }
            case 5: {
                result.put("cashAmount", true);
                result.put("cashAuditAmount", false);
                result.put("cashCurAdjustAmt", false);
                result.put("cashCurAuditAmt", true);
                result.put("cashAdjustSumAmt", false);
                result.put("cashSumAmt", false);
                result.put("cashAuditSumAmt", true);
                result.put("billAmount", true);
                result.put("billAuditAmount", false);
                result.put("billCurAdjustAmt", false);
                result.put("billCurAuditAmt", true);
                result.put("billAdjustSumAmt", false);
                result.put("billSumAmt", false);
                result.put("billAuditSumAmt", true);
                result.put("capitalAmt", true);
                result.put("capitalAuditAmt", false);
                result.put("capitalAdjustAmt", false);
                result.put("capitalAdjustAuditAmt", true);
                result.put("capitalSumAmt", false);
                result.put("capitalAuditSumAmt", true);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                result.put("cashAmount", true);
                result.put("cashAuditAmount", false);
                result.put("cashCurAdjustAmt", false);
                result.put("cashCurAuditAmt", false);
                result.put("cashAdjustSumAmt", false);
                result.put("cashSumAmt", true);
                result.put("cashAuditSumAmt", false);
                result.put("billAmount", true);
                result.put("billAuditAmount", false);
                result.put("billCurAdjustAmt", false);
                result.put("billCurAuditAmt", false);
                result.put("billAdjustSumAmt", false);
                result.put("billSumAmt", true);
                result.put("billAuditSumAmt", false);
                result.put("capitalAmt", false);
                result.put("capitalAuditAmt", true);
                result.put("capitalAdjustAmt", false);
                result.put("capitalAdjustAuditAmt", true);
                result.put("capitalSumAmt", true);
                result.put("capitalAuditSumAmt", false);
            }
        }
        return result;
    }

    protected Map setToolButtonHide() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("beforeCalBtn", true);
        result.put("afterCalBtn", true);
        result.put("saveBtn", true);
        result.put("submitBtn", true);
        result.put("auditEditBtn", true);
        result.put("auditBtn", true);
        result.put("backBtn", true);
        return result;
    }

    protected Map getToolConfigByStatus(StatusEnum status) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        switch (status.getValue()) {
            case 1: 
            case 2: {
                result.put("beforeCalBtn", false);
                result.put("afterCalBtn", true);
                result.put("saveBtn", false);
                result.put("submitBtn", false);
                result.put("auditEditBtn", true);
                result.put("auditBtn", true);
                result.put("backBtn", true);
                break;
            }
            case 3: {
                result.put("beforeCalBtn", true);
                result.put("afterCalBtn", false);
                result.put("saveBtn", true);
                result.put("submitBtn", true);
                result.put("auditEditBtn", false);
                result.put("auditBtn", false);
                result.put("backBtn", false);
                break;
            }
            case 4: {
                result.put("beforeCalBtn", true);
                result.put("afterCalBtn", true);
                result.put("saveBtn", true);
                result.put("submitBtn", true);
                result.put("auditEditBtn", true);
                result.put("auditBtn", true);
                result.put("backBtn", true);
                break;
            }
            case 5: {
                result.put("beforeCalBtn", false);
                result.put("afterCalBtn", true);
                result.put("saveBtn", false);
                result.put("submitBtn", false);
                result.put("auditEditBtn", true);
                result.put("auditBtn", true);
                result.put("backBtn", true);
                break;
            }
            case 6: {
                result.put("beforeCalBtn", true);
                result.put("afterCalBtn", false);
                result.put("saveBtn", true);
                result.put("submitBtn", true);
                result.put("auditEditBtn", false);
                result.put("auditBtn", false);
                result.put("backBtn", false);
                break;
            }
            case 7: 
            case 8: {
                result.put("beforeCalBtn", true);
                result.put("afterCalBtn", true);
                result.put("saveBtn", true);
                result.put("submitBtn", true);
                result.put("auditEditBtn", true);
                result.put("auditBtn", true);
                result.put("backBtn", true);
            }
        }
        return result;
    }

    protected void calculateSum(CapitalBalanceRow row) {
        row.setCashSumAmt(row.getCashAuditAmount().add(row.getCashAdjustSumAmt()).add(row.getCashCurAdjustAmt()));
        row.setCashAuditSumAmt(row.getCashAuditAmount().add(row.getCashAdjustSumAmt()).add(row.getCashCurAuditAmt()));
        row.setBillSumAmt(row.getBillAuditAmount().add(row.getBillAdjustSumAmt()).add(row.getBillCurAdjustAmt()));
        row.setBillAuditSumAmt(row.getBillAuditAmount().add(row.getBillAdjustSumAmt()).add(row.getBillCurAuditAmt()));
        row.setCapitalAmt(row.getCashAmount().add(row.getBillAmount()));
        row.setCapitalAuditAmt(row.getCashAuditAmount().add(row.getBillAuditAmount()));
        row.setCapitalAdjustAmt(row.getCashAdjustSumAmt().add(row.getCashCurAdjustAmt()).add(row.getBillAdjustSumAmt()).add(row.getBillCurAdjustAmt()));
        row.setCapitalAdjustAuditAmt(row.getCashAdjustSumAmt().add(row.getCashCurAuditAmt()).add(row.getBillAdjustSumAmt()).add(row.getBillCurAuditAmt()));
        row.setCapitalSumAmt(row.getCapitalAuditAmt().add(row.getCapitalAdjustAmt()));
        row.setCapitalAuditSumAmt(row.getCapitalAuditAmt().add(row.getCapitalAdjustAuditAmt()));
    }

    protected Map getEditCol(StatusEnum status) {
        HashMap<String, Boolean> editCol = new HashMap<String, Boolean>();
        switch (status.getValue()) {
            case 1: 
            case 2: {
                editCol.put("cashAmount", true);
                editCol.put("cashAuditAmount", false);
                editCol.put("cashCurAdjustAmt", false);
                editCol.put("cashCurAuditAmt", false);
                editCol.put("billAmount", true);
                editCol.put("billAuditAmount", false);
                editCol.put("billCurAdjustAmt", false);
                editCol.put("billCurAuditAmt", false);
                break;
            }
            case 3: {
                editCol.put("cashAmount", false);
                editCol.put("cashAuditAmount", true);
                editCol.put("cashCurAdjustAmt", false);
                editCol.put("cashCurAuditAmt", false);
                editCol.put("billAmount", false);
                editCol.put("billAuditAmount", true);
                editCol.put("billCurAdjustAmt", false);
                editCol.put("billCurAuditAmt", false);
                break;
            }
            case 4: 
            case 5: {
                editCol.put("cashAmount", false);
                editCol.put("cashAuditAmount", false);
                editCol.put("cashCurAdjustAmt", true);
                editCol.put("cashCurAuditAmt", false);
                editCol.put("billAmount", false);
                editCol.put("billAuditAmount", false);
                editCol.put("billCurAdjustAmt", true);
                editCol.put("billCurAuditAmt", false);
                break;
            }
            case 6: {
                editCol.put("cashAmount", false);
                editCol.put("cashAuditAmount", false);
                editCol.put("cashCurAdjustAmt", false);
                editCol.put("cashCurAuditAmt", true);
                editCol.put("billAmount", false);
                editCol.put("billAuditAmount", false);
                editCol.put("billCurAdjustAmt", false);
                editCol.put("billCurAuditAmt", true);
                break;
            }
            case 7: 
            case 8: {
                editCol.put("cashAmount", false);
                editCol.put("cashAuditAmount", false);
                editCol.put("cashCurAdjustAmt", false);
                editCol.put("cashCurAuditAmt", false);
                editCol.put("billAmount", false);
                editCol.put("billAuditAmount", false);
                editCol.put("billCurAdjustAmt", false);
                editCol.put("billCurAuditAmt", false);
            }
        }
        return editCol;
    }

    protected void sortListByLongNumber(List<CapitalBalanceRow> list) {
        Collections.sort(list, new Comparator<CapitalBalanceRow>(){

            @Override
            public int compare(CapitalBalanceRow o1, CapitalBalanceRow o2) {
                return o1.getLongnumber().compareTo(o2.getLongnumber());
            }
        });
    }

    protected void getUsedBalanceData(Context ctx, String orgScheduleId, List<CapitalBalanceRow> tempStart, List<CapitalBalanceRow> tempIn, List<CapitalBalanceRow> tempOut, Map<String, CapitalBalanceRow> rowData) throws BOSException, EASBizException {
        String balanceSql = String.format("select *,fundFlowItem.* where orgScheduleId='%s' order by levelseq asc ", orgScheduleId);
        CapitalBalanceCollection col = CapitalBalanceFactory.getLocalInstance(ctx).getCapitalBalanceCollection(balanceSql);
        block8: for (int i = 0; i < col.size(); ++i) {
            CapitalBalanceInfo balanceInfo = col.get(i);
            CapitalBalanceRow row = new CapitalBalanceRow();
            row.setLevelSeq(balanceInfo.getLevelSeq());
            row.setType(balanceInfo.getBalanceType());
            row.setFundFlowItem(balanceInfo.getFundFlowItem().getId().toString());
            row.setFundFlowItemName(balanceInfo.getFundFlowItem().getName());
            row.setFundFlowItemNumber(balanceInfo.getFundFlowItem().getNumber());
            row.setLongnumber(balanceInfo.getFundFlowItem().getLongNumber());
            row.setCashAmount(balanceInfo.getCashAmount());
            row.setCashAuditAmount(balanceInfo.getCashAuditAmount());
            row.setCashAdjustSumAmt(balanceInfo.getCashAdjustSumAmt());
            row.setCashCurAdjustAmt(balanceInfo.getCashCurAdjustAmt());
            row.setCashCurAuditAmt(balanceInfo.getCashCurAuditAmt());
            row.setCashSumAmt(balanceInfo.getCashSumAmt());
            row.setCashAuditSumAmt(balanceInfo.getCashAuditSumAmt());
            row.setBillAmount(balanceInfo.getBillAmount());
            row.setBillAuditAmount(balanceInfo.getBillAuditAmount());
            row.setBillAdjustSumAmt(balanceInfo.getBillAdjustSumAmt());
            row.setBillCurAdjustAmt(balanceInfo.getBillCurAdjustAmt());
            row.setBillCurAuditAmt(balanceInfo.getBillCurAuditAmt());
            row.setBillSumAmt(balanceInfo.getBillSumAmt());
            row.setBillAuditSumAmt(balanceInfo.getBillAuditSumAmt());
            row.setCapitalAmt(balanceInfo.getCapitalAmt());
            row.setCapitalAuditAmt(balanceInfo.getCapitalAuditAmt());
            row.setCapitalAdjustAmt(balanceInfo.getCapitalAdjustAmt());
            row.setCapitalAdjustAuditAmt(balanceInfo.getCapitalAdjustAuditAmt());
            row.setCapitalSumAmt(balanceInfo.getCapitalSumAmt());
            row.setCapitalAuditSumAmt(balanceInfo.getCapitalAuditSumAmt());
            if (balanceInfo.getLevelSeq() % 10 != 0) continue;
            switch (balanceInfo.getBalanceType().getValue()) {
                case 1: {
                    tempStart.add(row);
                    rowData.put(balanceInfo.getFundFlowItem().getId().toString(), row);
                    continue block8;
                }
                case 7: {
                    continue block8;
                }
                case 3: {
                    tempIn.add(row);
                    rowData.put(balanceInfo.getFundFlowItem().getId().toString(), row);
                    continue block8;
                }
                case 6: {
                    row.setBillAdjustSumAmt(BigDecimal.ZERO);
                    row.setBillCurAdjustAmt(BigDecimal.ZERO);
                    row.setBillCurAuditAmt(BigDecimal.ZERO);
                    tempIn.add(row);
                    rowData.put(balanceInfo.getFundFlowItem().getId().toString(), row);
                    continue block8;
                }
                case 8: {
                    continue block8;
                }
                case 4: 
                case 5: {
                    tempOut.add(row);
                    rowData.put(balanceInfo.getFundFlowItem().getId().toString(), row);
                    continue block8;
                }
            }
        }
    }

    @Override
    public Map _buildBgControlData(Context ctx, String orgScheduleId, Map map, boolean isView) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isMonth = false;
        OrgScheduleInfo info = this.getOrgScheduleInfo(ctx, orgScheduleId);
        boolean ps303 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS303", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (ps303) {
            boolean ps304 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS304", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            boolean ps304_1 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS304_1", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            String title = null;
            Map<Object, Object> colConfig = new HashMap();
            isMonth = info.getUserDefinedPeriod().getPeriodType().equals((Object)UserDefinedPeriodEnum.MONTH);
            title = this.getBgTitle(ctx, info, isMonth);
            colConfig = this.getBgColConfig(info, isMonth, ps304);
            FilterInfo settingFilter = new FilterInfo();
            settingFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
            SelectorItemCollection settingSic = new SelectorItemCollection();
            settingSic.add("isByDepartment");
            EntityViewInfo settingEvi = new EntityViewInfo();
            settingEvi.setFilter(settingFilter);
            settingEvi.setSelector(settingSic);
            PPScheduleSettingCollection setting = PPScheduleSettingFactory.getLocalInstance(ctx).getPPScheduleSettingCollection(settingEvi);
            if (setting != null && setting.size() > 0 && setting.get(0).isIsByDepartment()) {
                List<String> schDepartment = this.getSchDepartment(ctx, info);
                result.put("allDepartment", schDepartment);
                result.put("departmentData", this.getDepartment(ctx, info, schDepartment));
            }
            List<BgControlRow> rowList = this.getBgControlRowList(ctx, info, isMonth, ps304, ps304_1, map, isView, null);
            result.put("colConfig", colConfig);
            result.put("tabTitle", title);
            result.put("rowList", rowList);
        }
        return result;
    }

    @Override
    protected Map _buildBgControlDataByDepartment(Context ctx, String orgScheduleId, Map map, boolean isView, String departmentId) throws BOSException, EASBizException {
        Map result = new HashMap();
        HashMap editData = new HashMap();
        HashMap<String, Object> bgResult = new HashMap<String, Object>();
        OrgScheduleInfo info = this.getOrgScheduleInfo(ctx, orgScheduleId);
        boolean ps303 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS303", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (ps303) {
            result = this.getCapitalBalanceDataByDepartment(ctx, orgScheduleId, editData, departmentId);
            boolean ps304 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS304", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            boolean ps304_1 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS304_1", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            String title = null;
            Map<Object, Object> colConfig = new HashMap();
            boolean isMonth = false;
            isMonth = info.getUserDefinedPeriod().getPeriodType().equals((Object)UserDefinedPeriodEnum.MONTH);
            title = this.getBgTitle(ctx, info, isMonth);
            colConfig = this.getBgColConfig(info, isMonth, ps304);
            List<BgControlRow> rowList = this.getBgControlRowListByDepartment(ctx, info, isMonth, ps304, ps304_1, result, isView, departmentId);
            bgResult.put("colConfig", colConfig);
            bgResult.put("tabTitle", title);
            bgResult.put("rowList", rowList);
        }
        return bgResult;
    }

    protected List getDepartment(Context ctx, OrgScheduleInfo info, List<String> allDepartment) throws BOSException, EASBizException {
        ArrayList departmentDataSource = new ArrayList();
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("value", "company");
        item.put("alias", "\u5f53\u524d\u7ec4\u7ec7");
        departmentDataSource.add(item);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "SELECT po.FADMINORGUNITID as FADMINORGUNITID ,ta.FNAME_l2 as FNAME  FROM t_pm_user u   LEFT OUTER JOIN T_org_positionMember pm on u.FPERSONID = pm.FPERSONID   LEFT OUTER JOIN T_org_position  po on po.FID =pm.fpositionid  inner join t_org_admin ta on ta.fid  = po.FADMINORGUNITID  where u.FID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString()});
        try {
            while (rs.next()) {
                String ID = rs.getString("FADMINORGUNITID");
                String name = rs.getString("FNAME");
                if (EmptyUtil.isEmpty((String)ID) || !allDepartment.contains(ID)) continue;
                HashMap<String, String> newItem = new HashMap<String, String>();
                newItem.put("value", ID);
                newItem.put("alias", name);
                departmentDataSource.add(newItem);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return departmentDataSource;
    }

    protected List<String> getSchDepartment(Context ctx, OrgScheduleInfo info) throws BOSException, EASBizException {
        HashSet dSet = new HashSet();
        ArrayList<String> department = new ArrayList<String>();
        String sSql = "SELECT distinct FDEPARTMENTID  as FDEPARTMENTID FROM  T_PP_PaySchDetailBill where ForgScheduleId = ?  and FDEPARTMENTID is not null";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sSql, (Object[])new Object[]{info.getId().toString()});
        try {
            while (row.next()) {
                department.add(row.getString("FDEPARTMENTID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return department;
    }

    protected String getBgTitle(Context ctx, OrgScheduleInfo info, boolean isMonth) {
        String companyName = info.getCompany().getName();
        String currencyName = info.getCompany().getBaseCurrency().getName();
        String baseUnit = info.getCompany().getBaseCurrency().getBaseUnit();
        String title = null;
        title = isMonth ? CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"title", (String[])new String[]{companyName, currencyName, this.getFirstYearDate(info.getUserDefinedPeriod().getStartDate()), this.getLastYearDate(info.getUserDefinedPeriod().getStartDate()), baseUnit}) : CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"title", (String[])new String[]{companyName, currencyName, this.getFirstDayOfMonth(info.getUserDefinedPeriod().getStartDate()).toString(), this.getLastDayOfMonth(info.getUserDefinedPeriod().getStartDate()).toString(), baseUnit});
        return title;
    }

    protected Map<String, Boolean> getBgColConfig(OrgScheduleInfo info, boolean isMonth, boolean ps304) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (isMonth) {
            result.put("yearCapitalRental", false);
            result.put("janExecute", false);
            result.put("febExecute", false);
            result.put("marExecture", false);
            result.put("aprExecture", false);
            result.put("mayExecture", false);
            result.put("junExecture", false);
            result.put("julExecture", false);
            result.put("augExecture", false);
            result.put("sepExecture", false);
            result.put("octExecture", false);
            result.put("nouExecture", false);
            result.put("decExecture", false);
            result.put("capitalTotal", false);
            result.put("capitalExectureTotal", false);
        } else if (!ps304) {
            result.put("mouthBgControl", false);
            for (int i = 0; i < info.getUserDefinedPeriod().getWeekNumber().getValue(); ++i) {
                result.put("weekExecute" + (i + 1), false);
            }
            result.put("executeTotal", false);
            result.put("executeBalance", false);
        } else {
            result.put("mouthBgControl", false);
            result.put("mouthCash", false);
            result.put("mouthNt", false);
            for (int i = 0; i < info.getUserDefinedPeriod().getWeekNumber().getValue(); ++i) {
                result.put("weekCashExecute" + (i + 1), false);
                result.put("weekNtExecute" + (i + 1), false);
            }
            result.put("cashExecuteTotal", false);
            result.put("ntExecuteTotal", false);
            result.put("executeTotal", false);
            result.put("cashExecuteBalance", false);
            result.put("ntExecuteBalance", false);
        }
        return result;
    }

    protected List<BgControlRow> getBgControlRowList(Context ctx, OrgScheduleInfo info, boolean isMonth, boolean ps304, boolean ps304_1, Map capitalBalanceMap, boolean isView, String departmentId) throws BOSException, EASBizException {
        Set userDefinedPeriodIdSet = this.getUserDefinedPeriodIdSet(ctx, info, isMonth, 0);
        HashSet orgSet = new HashSet();
        this.getOrgScheduleIdSet(ctx, info.getCompany().getId().toString(), orgSet, userDefinedPeriodIdSet);
        String sql = "select u.fmonth,u.fweekCount,o.fstatus,main.*,t1.FNUMBER ,t1.FNAME_l2 fname ,t1.FLongNumber from T_PP_CapitalBalance main left join T_CAS_FundFlowItem t1 on main.fundflowitemid=t1.fid left join T_PP_OrgSchedule o on main.forgScheduleId = o.fid left join T_PP_UserDefinedPeriod u on o.FUserDefinedPeriodID = u.fid where main.forgScheduleId in " + FMHelper.setTran2String(orgSet);
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set.size() == 0 && EmptyUtil.isEmpty((Object)capitalBalanceMap)) {
            return new ArrayList<BgControlRow>();
        }
        ArrayList<BgControlRow> rowList = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempStart = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempIn = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempOut = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempEnd = new ArrayList<BgControlRow>();
        HashMap<String, BgControlRow> rowMap = new HashMap<String, BgControlRow>();
        HashSet<String> fundFlowItemIdSet = new HashSet<String>();
        HashMap<String, BgAmountInfo> bgMap = new HashMap<String, BgAmountInfo>();
        int rowId = 10;
        try {
            BgControlRow row;
            int i;
            while (set.next()) {
                String fundFlowItemID = set.getString("FundFlowItemID");
                if (set.getInt("FLevelSeq") % 10 != 0) continue;
                fundFlowItemIdSet.add(fundFlowItemID);
            }
            if (!EmptyUtil.isEmpty((Object)capitalBalanceMap)) {
                this.setFundFlowItemIdSetByCapitalBalan(ctx, fundFlowItemIdSet, capitalBalanceMap);
            }
            this.getBgBalance(ctx, info, fundFlowItemIdSet, bgMap, isMonth, isView, departmentId);
            this.getNewBgControlRow(ctx, info, isMonth, ps304, ps304_1, capitalBalanceMap, rowMap, bgMap);
            set.beforeFirst();
            while (set.next()) {
                Object row2 = new BgControlRow();
                String fundFlowItemID = set.getString("FundFlowItemID");
                if (set.getInt("FLevelSeq") % 10 != 0) continue;
                if (rowMap.containsKey(fundFlowItemID)) {
                    row2 = (BgControlRow)rowMap.get(fundFlowItemID);
                } else {
                    ((BgControlRow)row2).setFundFlowItemId(set.getString("FundFlowItemID"));
                    ((BgControlRow)row2).setFundFlowItemName(set.getString("fname"));
                    ((BgControlRow)row2).setFundFlowItemNumber(set.getString("fnumber"));
                    ((BgControlRow)row2).setLongnumber(set.getString("fLongNumber"));
                }
                if (isMonth) {
                    if (EmptyUtil.isEmpty((Object)capitalBalanceMap) || !EmptyUtil.isEmpty((Object)capitalBalanceMap) && info.getUserDefinedPeriod().getMonth() != set.getInt("fmonth")) {
                        this.setBgControlMonthRow(ctx, set, (BgControlRow)row2, bgMap);
                    }
                } else if (EmptyUtil.isEmpty((Object)capitalBalanceMap) || !EmptyUtil.isEmpty((Object)capitalBalanceMap) && info.getUserDefinedPeriod().getWeekCount() != set.getInt("fweekCount")) {
                    this.setBgControlWeekRow(ctx, set, (BgControlRow)row2, ps304, ps304_1, bgMap);
                }
                ((BgControlRow)row2).setBgBalanceType(BalanceTypeEnum.getEnum(set.getInt("fbalanceType")));
                rowMap.put(fundFlowItemID, (BgControlRow)row2);
            }
            for (String key : rowMap.keySet()) {
                BgControlRow row3 = (BgControlRow)rowMap.get(key);
                if (BalanceTypeEnum.PERIOD_BEGIN.equals((Object)row3.getBgBalanceType())) {
                    tempStart.add(row3);
                    continue;
                }
                if (BalanceTypeEnum.RECPLAN.equals((Object)row3.getBgBalanceType()) || BalanceTypeEnum.INCOME.equals((Object)row3.getBgBalanceType()) || BalanceTypeEnum.FINANC_INCOME.equals((Object)row3.getBgBalanceType())) {
                    tempIn.add(row3);
                    continue;
                }
                if (BalanceTypeEnum.PAYSCHDETAIL.equals((Object)row3.getBgBalanceType()) || BalanceTypeEnum.SPENDING.equals((Object)row3.getBgBalanceType()) || BalanceTypeEnum.STANDBYAMOUNT.equals((Object)row3.getBgBalanceType())) {
                    row3.setControl(bgMap.get(row3.getFundFlowItemNumber()) != null ? ((BgAmountInfo)bgMap.get(row3.getFundFlowItemNumber())).isIsControl() : false);
                    tempOut.add(row3);
                    continue;
                }
                tempEnd.add(row3);
            }
            this.sortBgListByLongNumber(tempStart);
            rowList.addAll(tempStart);
            for (i = 0; i < tempStart.size(); ++i) {
                row = (BgControlRow)tempStart.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            this.sortBgListByLongNumber(tempIn);
            rowList.addAll(tempIn);
            for (i = 0; i < tempIn.size(); ++i) {
                row = (BgControlRow)tempIn.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            this.sortBgListByLongNumber(tempOut);
            rowList.addAll(tempOut);
            for (i = 0; i < tempOut.size(); ++i) {
                row = (BgControlRow)tempOut.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            this.sortBgListByLongNumber(tempEnd);
            rowList.addAll(tempEnd);
            for (i = 0; i < tempEnd.size(); ++i) {
                row = (BgControlRow)tempEnd.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            Collections.sort(rowList, new Comparator<BgControlRow>(){

                @Override
                public int compare(BgControlRow o1, BgControlRow o2) {
                    return o1.getLevelSeq() - o2.getLevelSeq();
                }
            });
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return rowList;
    }

    protected List<BgControlRow> getBgControlRowListByDepartment(Context ctx, OrgScheduleInfo info, boolean isMonth, boolean ps304, boolean ps304_1, Map capitalBalanceMap, boolean isView, String departmentId) throws BOSException, EASBizException {
        Set userDefinedPeriodIdSet = this.getUserDefinedPeriodIdSet(ctx, info, isMonth, 0);
        HashSet orgSet = new HashSet();
        this.getOrgScheduleIdSet(ctx, info.getCompany().getId().toString(), orgSet, userDefinedPeriodIdSet);
        ArrayList<BgControlRow> rowList = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempStart = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempIn = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempOut = new ArrayList<BgControlRow>();
        ArrayList<BgControlRow> tempEnd = new ArrayList<BgControlRow>();
        HashMap<String, BgControlRow> rowMap = new HashMap<String, BgControlRow>();
        HashSet<String> fundFlowItemIdSet = new HashSet<String>();
        HashMap<String, BgAmountInfo> bgMap = new HashMap<String, BgAmountInfo>();
        int rowId = 10;
        try {
            BgControlRow row;
            int i;
            if (!EmptyUtil.isEmpty((Object)capitalBalanceMap)) {
                this.setFundFlowItemIdSetByCapitalBalan(ctx, fundFlowItemIdSet, capitalBalanceMap);
            }
            this.getBgBalance(ctx, info, fundFlowItemIdSet, bgMap, isMonth, isView, departmentId);
            this.getNewBgControlRow(ctx, info, isMonth, ps304, ps304_1, capitalBalanceMap, rowMap, bgMap);
            List orgList = FMHelper.set2List(orgSet);
            HashMap<String, Object> result = new HashMap();
            HashMap editData = new HashMap();
            HashMap bgResult = new HashMap();
            for (int i2 = 0; i2 < orgList.size(); ++i2) {
                String orgId = (String)orgList.get(i2);
                if (info.getId().toString().equals(orgId)) continue;
                result = this.getCapitalBalanceDataByDepartment(ctx, orgId, editData, departmentId);
                OrgScheduleInfo orginfo = this.getOrgScheduleInfo(ctx, orgId);
                if (isMonth) {
                    this.setBgControlMonthRowByDepartment(ctx, result, rowMap, bgMap, orginfo);
                    continue;
                }
                this.setBgControlWeekRowByDepartment(ctx, result, ps304, ps304_1, rowMap, bgMap, orginfo);
            }
            for (String key : rowMap.keySet()) {
                BgControlRow row2 = (BgControlRow)rowMap.get(key);
                if (BalanceTypeEnum.PERIOD_BEGIN.equals((Object)row2.getBgBalanceType())) {
                    tempStart.add(row2);
                    continue;
                }
                if (BalanceTypeEnum.RECPLAN.equals((Object)row2.getBgBalanceType()) || BalanceTypeEnum.INCOME.equals((Object)row2.getBgBalanceType()) || BalanceTypeEnum.FINANC_INCOME.equals((Object)row2.getBgBalanceType())) {
                    tempIn.add(row2);
                    continue;
                }
                if (BalanceTypeEnum.PAYSCHDETAIL.equals((Object)row2.getBgBalanceType()) || BalanceTypeEnum.SPENDING.equals((Object)row2.getBgBalanceType()) || BalanceTypeEnum.STANDBYAMOUNT.equals((Object)row2.getBgBalanceType())) {
                    row2.setControl(bgMap.get(row2.getFundFlowItemNumber()) != null ? ((BgAmountInfo)bgMap.get(row2.getFundFlowItemNumber())).isIsControl() : false);
                    tempOut.add(row2);
                    continue;
                }
                tempEnd.add(row2);
            }
            this.sortBgListByLongNumber(tempStart);
            rowList.addAll(tempStart);
            for (i = 0; i < tempStart.size(); ++i) {
                row = (BgControlRow)tempStart.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            this.sortBgListByLongNumber(tempIn);
            rowList.addAll(tempIn);
            for (i = 0; i < tempIn.size(); ++i) {
                row = (BgControlRow)tempIn.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            this.sortBgListByLongNumber(tempOut);
            rowList.addAll(tempOut);
            for (i = 0; i < tempOut.size(); ++i) {
                row = (BgControlRow)tempOut.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            this.sortBgListByLongNumber(tempEnd);
            rowList.addAll(tempEnd);
            for (i = 0; i < tempEnd.size(); ++i) {
                row = (BgControlRow)tempEnd.get(i);
                row.setLevelSeq(rowId);
                rowId += 10;
                this.addNewBgRowDealParent(ctx, row, row.getLongnumber(), rowMap, row.getLevelSeq(), rowList, isMonth, ps304);
            }
            Collections.sort(rowList, new Comparator<BgControlRow>(){

                @Override
                public int compare(BgControlRow o1, BgControlRow o2) {
                    return o1.getLevelSeq() - o2.getLevelSeq();
                }
            });
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return rowList;
    }

    protected void setFundFlowItemIdSetByCapitalBalan(Context ctx, Set<String> fundFlowItemIdSet, Map capitalBalanceMap) throws BOSException, EASBizException {
        List rowList = (List)capitalBalanceMap.get("rowList");
        for (int i = 0; i < rowList.size(); ++i) {
            fundFlowItemIdSet.add(((CapitalBalanceRow)rowList.get(i)).getFundFlowItem());
        }
    }

    protected void getNewBgControlRow(Context ctx, OrgScheduleInfo info, boolean isMonth, boolean ps304, boolean ps304_1, Map capitalBalanceMap, Map<String, BgControlRow> rowMap, Map<String, BgAmountInfo> bgMap) throws BOSException, EASBizException {
        if (capitalBalanceMap != null) {
            List rowList = (List)capitalBalanceMap.get("rowList");
            for (int i = 0; i < rowList.size(); ++i) {
                BgControlRow row = new BgControlRow();
                CapitalBalanceRow capitalBalanceRow = (CapitalBalanceRow)rowList.get(i);
                if (capitalBalanceRow.getLevelSeq() % 10 != 0) continue;
                row.setFundFlowItemId(capitalBalanceRow.getFundFlowItem());
                row.setFundFlowItemName(capitalBalanceRow.getFundFlowItemName());
                row.setFundFlowItemNumber(capitalBalanceRow.getFundFlowItemNumber());
                row.setLongnumber(capitalBalanceRow.getLongnumber());
                try {
                    if (isMonth) {
                        this.setNewBgControlMonthRow(ctx, info, bgMap, row, capitalBalanceRow);
                    } else {
                        this.setNewBgControlWeekRow(ctx, info, ps304, ps304_1, bgMap, row, capitalBalanceRow);
                    }
                    row.setBgBalanceType(capitalBalanceRow.getType());
                    rowMap.put(capitalBalanceRow.getFundFlowItem(), row);
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    protected void setNewBgControlWeekRow(Context ctx, OrgScheduleInfo info, boolean ps304, boolean ps304_1, Map<String, BgAmountInfo> bgMap, BgControlRow row, CapitalBalanceRow capitalBalanceRow) throws BOSException, EASBizException, SQLException {
        if (!ps304) {
            row.setMouthBgControl(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "all"));
            switch (info.getUserDefinedPeriod().getWeekCount()) {
                case 1: {
                    row.setWeekExecute1(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute1()));
                    break;
                }
                case 2: {
                    row.setWeekExecute2(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute2()));
                    break;
                }
                case 3: {
                    row.setWeekExecute3(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute3()));
                    break;
                }
                case 4: {
                    row.setWeekExecute4(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute4()));
                    break;
                }
                case 5: {
                    row.setWeekExecute5(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute5()));
                    break;
                }
                case 6: {
                    row.setWeekExecute6(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute6()));
                    break;
                }
            }
            row.setExecuteBalance(row.getMouthBgControl().subtract(row.getExecuteTotal()));
        } else {
            row.setMouthCash(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "cas"));
            row.setMouthNt(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "nt"));
            row.setMouthBgControl(row.getMouthCash().add(row.getMouthNt()));
            switch (info.getUserDefinedPeriod().getWeekCount()) {
                case 1: {
                    row.setWeekCashExecute1(this.getNewExecute(ctx, capitalBalanceRow, info, false, true));
                    row.setWeekNtExecute1(this.getNewExecute(ctx, capitalBalanceRow, info, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute1()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute1()));
                    break;
                }
                case 2: {
                    row.setWeekCashExecute2(this.getNewExecute(ctx, capitalBalanceRow, info, false, true));
                    row.setWeekNtExecute2(this.getNewExecute(ctx, capitalBalanceRow, info, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute2()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute2()));
                    break;
                }
                case 3: {
                    row.setWeekCashExecute3(this.getNewExecute(ctx, capitalBalanceRow, info, false, true));
                    row.setWeekNtExecute3(this.getNewExecute(ctx, capitalBalanceRow, info, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute3()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute3()));
                    break;
                }
                case 4: {
                    row.setWeekCashExecute4(this.getNewExecute(ctx, capitalBalanceRow, info, false, true));
                    row.setWeekNtExecute4(this.getNewExecute(ctx, capitalBalanceRow, info, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute4()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute4()));
                    break;
                }
                case 5: {
                    row.setWeekCashExecute5(this.getNewExecute(ctx, capitalBalanceRow, info, false, true));
                    row.setWeekNtExecute5(this.getNewExecute(ctx, capitalBalanceRow, info, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute5()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute5()));
                    break;
                }
                case 6: {
                    row.setWeekCashExecute6(this.getNewExecute(ctx, capitalBalanceRow, info, false, true));
                    row.setWeekNtExecute6(this.getNewExecute(ctx, capitalBalanceRow, info, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute6()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute6()));
                    break;
                }
            }
            row.setExecuteTotal(row.getCashExecuteTotal().add(row.getNtExecuteTotal()));
            row.setCashExecuteBalance(row.getMouthCash().subtract(row.getCashExecuteTotal()));
            row.setNtExecuteBalance(row.getMouthCash().add(row.getMouthNt()).subtract(row.getCashExecuteTotal()).subtract(row.getNtExecuteTotal()));
            if (!ps304_1) {
                row.setNtExecuteBalance(row.getNtExecuteBalance().subtract(row.getCashExecuteBalance()));
            }
        }
    }

    protected void setNewBgControlMonthRow(Context ctx, OrgScheduleInfo info, Map<String, BgAmountInfo> bgMap, BgControlRow row, CapitalBalanceRow capitalBalanceRow) throws BOSException, EASBizException, SQLException {
        row.setYearCapitalRental(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "all"));
        switch (info.getUserDefinedPeriod().getMonth()) {
            case 1: {
                row.setJanExecute(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getJanExecute()));
                break;
            }
            case 2: {
                row.setFebExecute(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getFebExecute()));
                break;
            }
            case 3: {
                row.setMarExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getMarExecture()));
                break;
            }
            case 4: {
                row.setAprExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getAprExecture()));
                break;
            }
            case 5: {
                row.setMayExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getMayExecture()));
                break;
            }
            case 6: {
                row.setJunExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getJunExecture()));
                break;
            }
            case 7: {
                row.setJulExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getJulExecture()));
                break;
            }
            case 8: {
                row.setAugExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getAugExecture()));
                break;
            }
            case 9: {
                row.setSepExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getSepExecture()));
                break;
            }
            case 10: {
                row.setOctExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getOctExecture()));
                break;
            }
            case 11: {
                row.setNouExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getNouExecture()));
                break;
            }
            case 12: {
                row.setDecExecture(this.getNewExecute(ctx, capitalBalanceRow, info, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getDecExecture()));
                break;
            }
        }
        row.setCapitalExectureTotal(row.getYearCapitalRental().subtract(row.getCapitalTotal()));
    }

    protected BigDecimal getNewExecute(Context ctx, CapitalBalanceRow capitalBalanceRow, OrgScheduleInfo info, boolean isAll, boolean isCash) throws BOSException, EASBizException, SQLException {
        BigDecimal amount = BigDecimal.ZERO;
        switch (info.getStatus().getValue()) {
            case 1: {
                break;
            }
            case 2: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAmt();
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAmount();
                    break;
                }
                amount = capitalBalanceRow.getBillAmount();
                break;
            }
            case 3: 
            case 4: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAuditAmt();
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAuditAmount();
                    break;
                }
                amount = capitalBalanceRow.getBillAuditAmount();
                break;
            }
            case 5: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAuditAmt().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getCashCurAdjustAmt()).add(capitalBalanceRow.getBillCurAdjustAmt());
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAuditAmount().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getCashCurAdjustAmt());
                    break;
                }
                amount = capitalBalanceRow.getBillAuditAmount().add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getBillCurAdjustAmt());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAuditAmt().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getCashCurAuditAmt()).add(capitalBalanceRow.getBillCurAuditAmt());
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAuditAmount().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getCashCurAuditAmt());
                    break;
                }
                amount = capitalBalanceRow.getBillAuditAmount().add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getBillCurAuditAmt());
                break;
            }
        }
        return amount;
    }

    protected void setBgControlWeekRow(Context ctx, IRowSet set, BgControlRow row, boolean ps304, boolean ps304_1, Map<String, BgAmountInfo> bgMap) throws BOSException, EASBizException, SQLException {
        if (!ps304) {
            row.setMouthBgControl(this.getBgControl(ctx, set.getString("fnumber"), bgMap, "all"));
            switch (set.getInt("fweekCount")) {
                case 1: {
                    row.setWeekExecute1(this.getExecute(ctx, set, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute1()));
                    break;
                }
                case 2: {
                    row.setWeekExecute2(this.getExecute(ctx, set, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute2()));
                    break;
                }
                case 3: {
                    row.setWeekExecute3(this.getExecute(ctx, set, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute3()));
                    break;
                }
                case 4: {
                    row.setWeekExecute4(this.getExecute(ctx, set, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute4()));
                    break;
                }
                case 5: {
                    row.setWeekExecute5(this.getExecute(ctx, set, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute5()));
                    break;
                }
                case 6: {
                    row.setWeekExecute6(this.getExecute(ctx, set, true, true));
                    row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute6()));
                    break;
                }
            }
            row.setExecuteBalance(row.getMouthBgControl().subtract(row.getExecuteTotal()));
        } else {
            row.setMouthCash(this.getBgControl(ctx, set.getString("fnumber"), bgMap, "cas"));
            row.setMouthNt(this.getBgControl(ctx, set.getString("fnumber"), bgMap, "nt"));
            row.setMouthBgControl(row.getMouthCash().add(row.getMouthNt()));
            switch (set.getInt("fweekCount")) {
                case 1: {
                    row.setWeekCashExecute1(this.getExecute(ctx, set, false, true));
                    row.setWeekNtExecute1(this.getExecute(ctx, set, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute1()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute1()));
                    break;
                }
                case 2: {
                    row.setWeekCashExecute2(this.getExecute(ctx, set, false, true));
                    row.setWeekNtExecute2(this.getExecute(ctx, set, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute2()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute2()));
                    break;
                }
                case 3: {
                    row.setWeekCashExecute3(this.getExecute(ctx, set, false, true));
                    row.setWeekNtExecute3(this.getExecute(ctx, set, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute3()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute3()));
                    break;
                }
                case 4: {
                    row.setWeekCashExecute4(this.getExecute(ctx, set, false, true));
                    row.setWeekNtExecute4(this.getExecute(ctx, set, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute4()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute4()));
                    break;
                }
                case 5: {
                    row.setWeekCashExecute5(this.getExecute(ctx, set, false, true));
                    row.setWeekNtExecute5(this.getExecute(ctx, set, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute5()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute5()));
                    break;
                }
                case 6: {
                    row.setWeekCashExecute6(this.getExecute(ctx, set, false, true));
                    row.setWeekNtExecute6(this.getExecute(ctx, set, false, false));
                    row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute6()));
                    row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute6()));
                    break;
                }
            }
            row.setExecuteTotal(row.getCashExecuteTotal().add(row.getNtExecuteTotal()));
            row.setCashExecuteBalance(row.getMouthCash().subtract(row.getCashExecuteTotal()));
            row.setNtExecuteBalance(row.getMouthCash().add(row.getMouthNt()).subtract(row.getCashExecuteTotal()).subtract(row.getNtExecuteTotal()));
            if (!ps304_1) {
                row.setNtExecuteBalance(row.getNtExecuteBalance().subtract(row.getCashExecuteBalance()));
            }
        }
    }

    protected void setBgControlWeekRowByDepartment(Context ctx, Map<String, Object> capitalBalanceMap, boolean ps304, boolean ps304_1, Map<String, BgControlRow> rowMap, Map<String, BgAmountInfo> bgMap, OrgScheduleInfo orginfo) throws BOSException, EASBizException, SQLException {
        if (capitalBalanceMap != null) {
            List rowList = (List)capitalBalanceMap.get("rowList");
            for (int i = 0; i < rowList.size(); ++i) {
                CapitalBalanceRow capitalBalanceRow = (CapitalBalanceRow)rowList.get(i);
                if (capitalBalanceRow.getLevelSeq() % 10 != 0) continue;
                BgControlRow row = new BgControlRow();
                if (rowMap.containsKey(capitalBalanceRow.getFundFlowItem())) {
                    row = rowMap.get(capitalBalanceRow.getFundFlowItem());
                } else {
                    row.setFundFlowItemId(capitalBalanceRow.getFundFlowItem());
                    row.setFundFlowItemName(capitalBalanceRow.getFundFlowItemName());
                    row.setFundFlowItemNumber(capitalBalanceRow.getFundFlowItemNumber());
                    row.setLongnumber(capitalBalanceRow.getLongnumber());
                }
                if (!ps304) {
                    row.setMouthBgControl(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "all"));
                    switch (orginfo.getUserDefinedPeriod().getWeekCount()) {
                        case 1: {
                            row.setWeekExecute1(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                            row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute1()));
                            break;
                        }
                        case 2: {
                            row.setWeekExecute2(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                            row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute2()));
                            break;
                        }
                        case 3: {
                            row.setWeekExecute3(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                            row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute3()));
                            break;
                        }
                        case 4: {
                            row.setWeekExecute4(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                            row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute4()));
                            break;
                        }
                        case 5: {
                            row.setWeekExecute5(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                            row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute5()));
                            break;
                        }
                        case 6: {
                            row.setWeekExecute6(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                            row.setExecuteTotal(row.getExecuteTotal().add(row.getWeekExecute6()));
                            break;
                        }
                    }
                    row.setExecuteBalance(row.getMouthBgControl().subtract(row.getExecuteTotal()));
                } else {
                    row.setMouthCash(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "cas"));
                    row.setMouthNt(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "nt"));
                    row.setMouthBgControl(row.getMouthCash().add(row.getMouthNt()));
                    switch (orginfo.getUserDefinedPeriod().getWeekCount()) {
                        case 1: {
                            row.setWeekCashExecute1(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, true));
                            row.setWeekNtExecute1(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, false));
                            row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute1()));
                            row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute1()));
                            break;
                        }
                        case 2: {
                            row.setWeekCashExecute2(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, true));
                            row.setWeekNtExecute2(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, false));
                            row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute2()));
                            row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute2()));
                            break;
                        }
                        case 3: {
                            row.setWeekCashExecute3(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, true));
                            row.setWeekNtExecute3(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, false));
                            row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute3()));
                            row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute3()));
                            break;
                        }
                        case 4: {
                            row.setWeekCashExecute4(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, true));
                            row.setWeekNtExecute4(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, false));
                            row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute4()));
                            row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute4()));
                            break;
                        }
                        case 5: {
                            row.setWeekCashExecute5(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, true));
                            row.setWeekNtExecute5(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, false));
                            row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute5()));
                            row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute5()));
                            break;
                        }
                        case 6: {
                            row.setWeekCashExecute6(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, true));
                            row.setWeekNtExecute6(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), false, false));
                            row.setCashExecuteTotal(row.getCashExecuteTotal().add(row.getWeekCashExecute6()));
                            row.setNtExecuteTotal(row.getNtExecuteTotal().add(row.getWeekNtExecute6()));
                            break;
                        }
                    }
                    row.setExecuteTotal(row.getCashExecuteTotal().add(row.getNtExecuteTotal()));
                    row.setCashExecuteBalance(row.getMouthCash().subtract(row.getCashExecuteTotal()));
                    row.setNtExecuteBalance(row.getMouthCash().add(row.getMouthNt()).subtract(row.getCashExecuteTotal()).subtract(row.getNtExecuteTotal()));
                    if (!ps304_1) {
                        row.setNtExecuteBalance(row.getNtExecuteBalance().subtract(row.getCashExecuteBalance()));
                    }
                }
                rowMap.put(capitalBalanceRow.getFundFlowItem(), row);
            }
        }
    }

    protected void setBgControlMonthRow(Context ctx, IRowSet set, BgControlRow row, Map<String, BgAmountInfo> bgMap) throws BOSException, EASBizException, SQLException {
        row.setYearCapitalRental(this.getBgControl(ctx, set.getString("fnumber"), bgMap, "all"));
        switch (set.getInt("fmonth")) {
            case 1: {
                row.setJanExecute(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getJanExecute()));
                break;
            }
            case 2: {
                row.setFebExecute(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getFebExecute()));
                break;
            }
            case 3: {
                row.setMarExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getMarExecture()));
                break;
            }
            case 4: {
                row.setAprExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getAprExecture()));
                break;
            }
            case 5: {
                row.setMayExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getMayExecture()));
                break;
            }
            case 6: {
                row.setJunExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getJunExecture()));
                break;
            }
            case 7: {
                row.setJulExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getJulExecture()));
                break;
            }
            case 8: {
                row.setAugExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getAugExecture()));
                break;
            }
            case 9: {
                row.setSepExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getSepExecture()));
                break;
            }
            case 10: {
                row.setOctExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getOctExecture()));
                break;
            }
            case 11: {
                row.setNouExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getNouExecture()));
                break;
            }
            case 12: {
                row.setDecExecture(this.getExecute(ctx, set, true, true));
                row.setCapitalTotal(row.getCapitalTotal().add(row.getDecExecture()));
                break;
            }
        }
        row.setCapitalExectureTotal(row.getYearCapitalRental().subtract(row.getCapitalTotal()));
    }

    private void setBgControlMonthRowByDepartment(Context ctx, Map<String, Object> capitalBalanceMap, Map<String, BgControlRow> rowMap, Map<String, BgAmountInfo> bgMap, OrgScheduleInfo orginfo) throws BOSException, EASBizException, SQLException {
        if (capitalBalanceMap != null) {
            List rowList = (List)capitalBalanceMap.get("rowList");
            for (int i = 0; i < rowList.size(); ++i) {
                CapitalBalanceRow capitalBalanceRow = (CapitalBalanceRow)rowList.get(i);
                if (capitalBalanceRow.getLevelSeq() % 10 != 0) continue;
                BgControlRow row = new BgControlRow();
                if (rowMap.containsKey(capitalBalanceRow.getFundFlowItem())) {
                    row = rowMap.get(capitalBalanceRow.getFundFlowItem());
                } else {
                    row.setFundFlowItemId(capitalBalanceRow.getFundFlowItem());
                    row.setFundFlowItemName(capitalBalanceRow.getFundFlowItemName());
                    row.setFundFlowItemNumber(capitalBalanceRow.getFundFlowItemNumber());
                    row.setLongnumber(capitalBalanceRow.getLongnumber());
                }
                row.setYearCapitalRental(this.getBgControl(ctx, capitalBalanceRow.getFundFlowItemNumber(), bgMap, "all"));
                switch (orginfo.getUserDefinedPeriod().getMonth()) {
                    case 1: {
                        row.setJanExecute(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getJanExecute()));
                        break;
                    }
                    case 2: {
                        row.setFebExecute(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getFebExecute()));
                        break;
                    }
                    case 3: {
                        row.setMarExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getMarExecture()));
                        break;
                    }
                    case 4: {
                        row.setAprExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getAprExecture()));
                        break;
                    }
                    case 5: {
                        row.setMayExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getMayExecture()));
                        break;
                    }
                    case 6: {
                        row.setJunExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getJunExecture()));
                        break;
                    }
                    case 7: {
                        row.setJulExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getJulExecture()));
                        break;
                    }
                    case 8: {
                        row.setAugExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getAugExecture()));
                        break;
                    }
                    case 9: {
                        row.setSepExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getSepExecture()));
                        break;
                    }
                    case 10: {
                        row.setOctExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getOctExecture()));
                        break;
                    }
                    case 11: {
                        row.setNouExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getNouExecture()));
                        break;
                    }
                    case 12: {
                        row.setDecExecture(this.getExecuteByDepartment(ctx, capitalBalanceRow, orginfo.getStatus().getValue(), true, true));
                        row.setCapitalTotal(row.getCapitalTotal().add(row.getDecExecture()));
                        break;
                    }
                }
                row.setCapitalExectureTotal(row.getYearCapitalRental().subtract(row.getCapitalTotal()));
                rowMap.put(capitalBalanceRow.getFundFlowItem(), row);
            }
        }
    }

    protected BigDecimal getExecute(Context ctx, IRowSet set, boolean isAll, boolean isCash) throws BOSException, EASBizException, SQLException {
        BigDecimal amount = BigDecimal.ZERO;
        switch (set.getInt("fstatus")) {
            case 1: {
                break;
            }
            case 2: {
                if (isAll) {
                    amount = set.getBigDecimal("fcapitalAmt");
                    break;
                }
                if (isCash) {
                    amount = set.getBigDecimal("fcashAmount");
                    break;
                }
                amount = set.getBigDecimal("fbillAmount");
                break;
            }
            case 3: 
            case 4: {
                if (isAll) {
                    amount = set.getBigDecimal("fcapitalAuditAmt");
                    break;
                }
                if (isCash) {
                    amount = set.getBigDecimal("fcashAuditAmount");
                    break;
                }
                amount = set.getBigDecimal("fbillAuditAmount");
                break;
            }
            case 5: {
                if (isAll) {
                    amount = set.getBigDecimal("fcapitalAuditAmt").add(set.getBigDecimal("fcashAdjustSumAmt")).add(set.getBigDecimal("fbillAdjustSumAmt")).add(set.getBigDecimal("fcashCurAdjustAmt")).add(set.getBigDecimal("fbillCurAdjustAmt"));
                    break;
                }
                if (isCash) {
                    amount = set.getBigDecimal("fcashAuditAmount").add(set.getBigDecimal("fcashAdjustSumAmt")).add(set.getBigDecimal("fcashCurAdjustAmt"));
                    break;
                }
                amount = set.getBigDecimal("fbillAuditAmount").add(set.getBigDecimal("fbillAdjustSumAmt")).add(set.getBigDecimal("fbillCurAdjustAmt"));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (isAll) {
                    amount = set.getBigDecimal("fcapitalAuditAmt").add(set.getBigDecimal("fcashAdjustSumAmt")).add(set.getBigDecimal("fbillAdjustSumAmt")).add(set.getBigDecimal("fcashCurAuditAmt")).add(set.getBigDecimal("fbillCurAuditAmt"));
                    break;
                }
                if (isCash) {
                    amount = set.getBigDecimal("fcashAuditAmount").add(set.getBigDecimal("fcashAdjustSumAmt")).add(set.getBigDecimal("fcashCurAuditAmt"));
                    break;
                }
                amount = set.getBigDecimal("fbillAuditAmount").add(set.getBigDecimal("fbillAdjustSumAmt")).add(set.getBigDecimal("fbillCurAuditAmt"));
                break;
            }
        }
        return amount;
    }

    protected BigDecimal getExecuteByDepartment(Context ctx, CapitalBalanceRow capitalBalanceRow, int status, boolean isAll, boolean isCash) throws BOSException, EASBizException, SQLException {
        BigDecimal amount = BigDecimal.ZERO;
        switch (status) {
            case 1: {
                break;
            }
            case 2: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAmt();
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAmount();
                    break;
                }
                amount = capitalBalanceRow.getBillAmount();
                break;
            }
            case 3: 
            case 4: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAuditAmt();
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAuditAmount();
                    break;
                }
                amount = capitalBalanceRow.getBillAuditAmount();
                break;
            }
            case 5: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAuditAmt().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getCashCurAdjustAmt()).add(capitalBalanceRow.getBillCurAdjustAmt());
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAuditAmount().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getCashCurAdjustAmt());
                    break;
                }
                amount = capitalBalanceRow.getBillAuditAmount().add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getBillCurAdjustAmt());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (isAll) {
                    amount = capitalBalanceRow.getCapitalAuditAmt().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getCashCurAuditAmt()).add(capitalBalanceRow.getBillCurAuditAmt());
                    break;
                }
                if (isCash) {
                    amount = capitalBalanceRow.getCashAuditAmount().add(capitalBalanceRow.getCashAdjustSumAmt()).add(capitalBalanceRow.getCashCurAuditAmt());
                    break;
                }
                amount = capitalBalanceRow.getBillAuditAmount().add(capitalBalanceRow.getBillAdjustSumAmt()).add(capitalBalanceRow.getBillCurAuditAmt());
                break;
            }
        }
        return amount;
    }

    protected Set getUserDefinedPeriodIdSet(Context ctx, OrgScheduleInfo info, boolean isMonth, int count) throws BOSException {
        String cuID = null;
        FilterInfo settingFilter = new FilterInfo();
        settingFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
        EntityViewInfo settingView = new EntityViewInfo();
        SelectorItemCollection settingSic = new SelectorItemCollection();
        settingSic.add("id");
        settingSic.add("cu");
        settingView.setFilter(settingFilter);
        settingView.setSelector(settingSic);
        PPScheduleSettingCollection settingColl = PPScheduleSettingFactory.getLocalInstance(ctx).getPPScheduleSettingCollection(settingView);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)settingColl)) {
            cuID = settingColl.get(0).getCU().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        Calendar c = Calendar.getInstance();
        c.setTime(info.getUserDefinedPeriod().getStartDate());
        int year = c.get(1);
        if (isMonth) {
            filter.getFilterItems().add(new FilterItemInfo("startdate", (Object)DateHelper.getFirstYearDate((int)year), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("enddate", (Object)DateHelper.getLastYearDate((int)year), CompareType.LESS_EQUALS));
            if (count != 0) {
                filter.getFilterItems().add(new FilterItemInfo("month", (Object)count));
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("startdate", (Object)DateHelper.getFirstDayOfMonth((Date)info.getUserDefinedPeriod().getStartDate()), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("enddate", (Object)DateHelper.getLastDayOfMonth((Date)info.getUserDefinedPeriod().getStartDate()), CompareType.LESS_EQUALS));
            if (count != 0) {
                filter.getFilterItems().add(new FilterItemInfo("weekCount", (Object)count));
                filter.getFilterItems().add(new FilterItemInfo("month", (Object)info.getUserDefinedPeriod().getMonth()));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuID, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("weekCount");
        view.setFilter(filter);
        view.setSelector(sic);
        UserDefinedPeriodCollection userDefinedPeriodColl = UserDefinedPeriodFactory.getLocalInstance(ctx).getUserDefinedPeriodCollection(view);
        HashSet<String> userDefinedPeriodIdSet = new HashSet<String>();
        if (userDefinedPeriodColl.size() > 0) {
            for (int i = 0; i < userDefinedPeriodColl.size(); ++i) {
                userDefinedPeriodIdSet.add(userDefinedPeriodColl.get(i).getId().toString());
            }
        }
        return userDefinedPeriodIdSet;
    }

    protected void addNewBgRowDealParent(Context ctx, BgControlRow row, String longnumber, Map<String, BgControlRow> rowData, int rowId, List<BgControlRow> rowList, boolean isMonth, boolean ps304) throws EASBizException, BOSException {
        boolean isTop = false;
        if (!longnumber.contains("!")) {
            isTop = true;
            return;
        }
        longnumber = longnumber.substring(0, longnumber.lastIndexOf("!"));
        String sql = "where LONGNUMBER ='" + longnumber + "'";
        FundFlowItemInfo info = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemInfo(sql);
        String id = info.getId().toString();
        if (rowData.containsKey(id)) {
            BgControlRow bgrow = rowData.get(id);
            this.setNewBgRow(row, isMonth, ps304, bgrow);
        } else {
            BgControlRow bgrow = new BgControlRow();
            bgrow.setLevelSeq(--rowId);
            bgrow.setFundFlowItemId(id);
            bgrow.setLongnumber(info.getLongNumber());
            bgrow.setFundFlowItemName(info.getName());
            bgrow.setFundFlowItemNumber(info.getNumber());
            bgrow.setBgBalanceType(row.getBgBalanceType());
            bgrow.setParent(true);
            this.setNewBgRow(row, isMonth, ps304, bgrow);
            rowData.put(id, bgrow);
            rowList.add(bgrow);
        }
        if (info.getDirection().equals((Object)FundFlowDirection.IN_OUT) || isTop || !longnumber.contains("!")) {
            return;
        }
        this.addNewBgRowDealParent(ctx, row, info.getLongNumber(), rowData, rowId, rowList, isMonth, ps304);
    }

    protected void setNewBgRow(BgControlRow row, boolean isMonth, boolean ps304, BgControlRow bgrow) {
        if (isMonth) {
            bgrow.setYearCapitalRental(bgrow.getYearCapitalRental().add(row.getYearCapitalRental()));
            bgrow.setJanExecute(bgrow.getJanExecute().add(row.getJanExecute()));
            bgrow.setFebExecute(bgrow.getFebExecute().add(row.getFebExecute()));
            bgrow.setMarExecture(bgrow.getMarExecture().add(row.getMarExecture()));
            bgrow.setAprExecture(bgrow.getAprExecture().add(row.getAprExecture()));
            bgrow.setMayExecture(bgrow.getMayExecture().add(row.getMayExecture()));
            bgrow.setJunExecture(bgrow.getJunExecture().add(row.getJunExecture()));
            bgrow.setJulExecture(bgrow.getJulExecture().add(row.getJulExecture()));
            bgrow.setAugExecture(bgrow.getAugExecture().add(row.getAugExecture()));
            bgrow.setSepExecture(bgrow.getSepExecture().add(row.getSepExecture()));
            bgrow.setOctExecture(bgrow.getOctExecture().add(row.getOctExecture()));
            bgrow.setNouExecture(bgrow.getNouExecture().add(row.getNouExecture()));
            bgrow.setDecExecture(bgrow.getDecExecture().add(row.getDecExecture()));
            bgrow.setCapitalTotal(bgrow.getCapitalTotal().add(row.getCapitalTotal()));
            bgrow.setCapitalExectureTotal(bgrow.getCapitalExectureTotal().add(row.getCapitalExectureTotal()));
        } else if (ps304) {
            bgrow.setMouthCash(bgrow.getMouthCash().add(row.getMouthCash()));
            bgrow.setMouthNt(bgrow.getMouthNt().add(row.getMouthNt()));
            bgrow.setMouthBgControl(bgrow.getMouthBgControl().add(row.getMouthBgControl()));
            bgrow.setWeekCashExecute1(bgrow.getWeekCashExecute1().add(row.getWeekCashExecute1()));
            bgrow.setWeekNtExecute1(bgrow.getWeekNtExecute1().add(row.getWeekNtExecute1()));
            bgrow.setWeekCashExecute2(bgrow.getWeekCashExecute2().add(row.getWeekCashExecute2()));
            bgrow.setWeekNtExecute2(bgrow.getWeekNtExecute2().add(row.getWeekNtExecute2()));
            bgrow.setWeekCashExecute3(bgrow.getWeekCashExecute3().add(row.getWeekCashExecute3()));
            bgrow.setWeekNtExecute3(bgrow.getWeekNtExecute3().add(row.getWeekNtExecute3()));
            bgrow.setWeekCashExecute4(bgrow.getWeekCashExecute4().add(row.getWeekCashExecute4()));
            bgrow.setWeekNtExecute4(bgrow.getWeekNtExecute4().add(row.getWeekNtExecute4()));
            bgrow.setWeekCashExecute5(bgrow.getWeekCashExecute5().add(row.getWeekCashExecute5()));
            bgrow.setWeekNtExecute5(bgrow.getWeekNtExecute5().add(row.getWeekNtExecute5()));
            bgrow.setWeekCashExecute6(bgrow.getWeekCashExecute6().add(row.getWeekCashExecute6()));
            bgrow.setWeekNtExecute6(bgrow.getWeekNtExecute6().add(row.getWeekNtExecute6()));
            bgrow.setCashExecuteTotal(bgrow.getCashExecuteTotal().add(row.getCashExecuteTotal()));
            bgrow.setNtExecuteTotal(bgrow.getNtExecuteTotal().add(row.getNtExecuteTotal()));
            bgrow.setExecuteTotal(bgrow.getExecuteTotal().add(row.getExecuteTotal()));
            bgrow.setCashExecuteBalance(bgrow.getCashExecuteBalance().add(row.getCashExecuteBalance()));
            bgrow.setNtExecuteBalance(bgrow.getNtExecuteBalance().add(row.getNtExecuteBalance()));
        } else {
            bgrow.setMouthBgControl(bgrow.getMouthBgControl().add(row.getMouthBgControl()));
            bgrow.setWeekExecute1(bgrow.getWeekExecute1().add(row.getWeekExecute1()));
            bgrow.setWeekExecute2(bgrow.getWeekExecute2().add(row.getWeekExecute2()));
            bgrow.setWeekExecute3(bgrow.getWeekExecute3().add(row.getWeekExecute3()));
            bgrow.setWeekExecute4(bgrow.getWeekExecute4().add(row.getWeekExecute4()));
            bgrow.setWeekExecute5(bgrow.getWeekExecute5().add(row.getWeekExecute5()));
            bgrow.setWeekExecute6(bgrow.getWeekExecute6().add(row.getWeekExecute6()));
            bgrow.setExecuteTotal(bgrow.getExecuteTotal().add(row.getExecuteTotal()));
            bgrow.setExecuteBalance(bgrow.getExecuteBalance().add(row.getExecuteBalance()));
        }
    }

    protected void sortBgListByLongNumber(List<BgControlRow> list) {
        Collections.sort(list, new Comparator<BgControlRow>(){

            @Override
            public int compare(BgControlRow o1, BgControlRow o2) {
                return o1.getLongnumber().compareTo(o2.getLongnumber());
            }
        });
    }

    protected String getFirstYearDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        return DateFormat.getDateInstance(2).format(c.getTime());
    }

    protected String getLastYearDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        c.set(1, year);
        c.set(2, 11);
        c.set(5, 31);
        return DateFormat.getDateInstance(2).format(c.getTime());
    }

    protected String getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return DateFormat.getDateInstance(2).format(cal.getTime());
    }

    protected String getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return DateFormat.getDateInstance(2).format(calendar.getTime());
    }

    protected BigDecimal getBgControl(Context ctx, String fundFlowItemNumber, Map<String, BgAmountInfo> bgMap, String type) throws BOSException, EASBizException {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal ntamount = BigDecimal.ZERO;
        BgAmountInfo bgAmountInfo = bgMap.get(fundFlowItemNumber);
        BigDecimal casamount = BigDecimal.ZERO;
        if (bgAmountInfo != null) {
            ntamount = bgAmountInfo.getBgNtAmount();
            casamount = bgAmountInfo.getBgCashAmount();
        }
        amount = ntamount.add(casamount);
        if (type.equals("nt")) {
            return ntamount;
        }
        if (type.equals("cas")) {
            return casamount;
        }
        return amount;
    }

    protected void getBgBalance(Context ctx, OrgScheduleInfo info, Set<String> fundFlowItemIdSet, Map<String, BgAmountInfo> bgMap, boolean isMonth, boolean isView, String departmentId) throws BOSException, EASBizException {
        HashMap<String, FundFlowItemInfo> fundFlowItemMap = new HashMap<String, FundFlowItemInfo>();
        CompanyOrgUnitInfo company = info.getCompany();
        Calendar c = Calendar.getInstance();
        c.setTime(info.getUserDefinedPeriod().getStartDate());
        int year = c.get(1);
        Date date = isMonth ? DateHelper.getFirstYearDate((int)year) : DateHelper.getFirstDayOfMonth((Date)info.getUserDefinedPeriod().getStartDate());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fundFlowItemId", fundFlowItemIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)date));
        filter.getFilterItems().add(new FilterItemInfo("companyId", (Object)company.getId()));
        IBgAmount iBgAmount = BgAmountFactory.getLocalInstance(ctx);
        if (isView && (EmptyUtil.isEmpty((String)departmentId) || "company".equals(departmentId))) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            BgAmountCollection coll = iBgAmount.getBgAmountCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                BgAmountInfo bgAmountInfo = coll.get(i);
                bgMap.put(bgAmountInfo.getFundFlowItemNumber(), bgAmountInfo);
            }
        } else {
            String fundFlowItemNumber;
            BigDecimal amount;
            BgAmountInfo bgAmountInfo;
            int i;
            Object adminInfo;
            if (EmptyUtil.isEmpty((String)departmentId) || "company".equals(departmentId)) {
                iBgAmount.delete(filter);
            }
            CurrencyInfo curr = company.getBaseCurrency();
            SettlementTypeInfo ntsett = this.getSettlementType(ctx, CompareType.EQUALS);
            SettlementTypeInfo cashsett = this.getSettlementType(ctx, CompareType.NOTEQUALS);
            PaymentBillInfo ntInfo = new PaymentBillInfo();
            ntInfo.setCompany(company);
            ntInfo.setBizDate(date);
            ntInfo.setSettlementType(ntsett);
            ntInfo.setCurrency(curr);
            PaymentBillInfo csahInfo = new PaymentBillInfo();
            csahInfo.setCompany(company);
            csahInfo.setBizDate(date);
            csahInfo.setSettlementType(cashsett);
            csahInfo.setCurrency(curr);
            if (EmptyUtil.isEmpty((String)departmentId) || "company".equals(departmentId)) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(company.getId());
                adminInfo.setNumber(company.getNumber());
                adminInfo.setName(company.getName());
                ntInfo.setAdminOrgUnit((AdminOrgUnitInfo)adminInfo);
                csahInfo.setAdminOrgUnit((AdminOrgUnitInfo)adminInfo);
            } else if (!EmptyUtil.isEmpty((String)departmentId)) {
                adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(departmentId));
                ntInfo.setAdminOrgUnit((AdminOrgUnitInfo)adminInfo);
                csahInfo.setAdminOrgUnit((AdminOrgUnitInfo)adminInfo);
            }
            for (String id : fundFlowItemIdSet) {
                FundFlowItemInfo fundFlowItemInfo = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(id));
                PaymentBillEntryInfo entry = new PaymentBillEntryInfo();
                entry.setBgCtrlAmt(BigDecimal.ZERO);
                entry.setFundFlowItem(fundFlowItemInfo);
                entry.setActualAmt(BigDecimal.ZERO);
                entry.setActualLocAmt(BigDecimal.ZERO);
                ntInfo.getEntries().add(entry);
                csahInfo.getEntries().add(entry);
                fundFlowItemMap.put(fundFlowItemInfo.getNumber(), fundFlowItemInfo);
            }
            CoreBaseCollection colls = new CoreBaseCollection();
            IBudgetBalance ntBalance = BgControlFacadeFactory.getLocalInstance((Context)ctx).queryBalance((IObjectValue)ntInfo);
            IBudgetBalance casBalance = BgControlFacadeFactory.getLocalInstance((Context)ctx).queryBalance((IObjectValue)csahInfo);
            for (i = 0; i < ntBalance.getBalance().size(); ++i) {
                bgAmountInfo = new BgAmountInfo();
                BgControlParam ntParam = (BgControlParam)ntBalance.getBalance().get(i);
                amount = BgControlUtils.getBudgetValue((BgControlParam)ntParam) != null ? BgControlUtils.getBudgetValue((BgControlParam)ntParam) : BigDecimal.ZERO;
                fundFlowItemNumber = ntParam.getBgIndexNumber().substring(4);
                bgAmountInfo.setCompanyId(company.getId().toString());
                bgAmountInfo.setDate(date);
                bgAmountInfo.setBgCashAmount(BigDecimal.ZERO);
                bgAmountInfo.setFundFlowItemNumber(fundFlowItemNumber);
                bgAmountInfo.setFundFlowItemName(((FundFlowItemInfo)fundFlowItemMap.get(fundFlowItemNumber)).getName());
                bgAmountInfo.setFundFlowItemId(((FundFlowItemInfo)fundFlowItemMap.get(fundFlowItemNumber)).getId().toString());
                if (ntParam.getControlSetting() != null) {
                    if (!ntParam.getControlSetting().isIsAllowAccess()) {
                        bgAmountInfo.setIsControl(true);
                    }
                    if (ntParam.getControlSetting().getCtrlSetRule().equals((Object)BgCtrlSetRuleEnum.Summary)) {
                        if (!EmptyUtil.isEmpty((Object)ntParam.getBudgetDetail()) && !EmptyUtil.isEmpty(ntParam.getBudgetDetail().get(ntParam.getDimItemNumber() + "!" + ntParam.getBgPeriodNumber()))) {
                            BgGroupData bgData = (BgGroupData)ntParam.getBudgetDetail().get(ntParam.getDimItemNumber() + "!" + ntParam.getBgPeriodNumber());
                            amount = bgData.getBudgetValue();
                        } else {
                            amount = BigDecimal.ZERO;
                        }
                    }
                }
                bgAmountInfo.setBgNtAmount(amount);
                bgMap.put(fundFlowItemNumber, bgAmountInfo);
            }
            for (i = 0; i < casBalance.getBalance().size(); ++i) {
                bgAmountInfo = new BgAmountInfo();
                BgControlParam casParam = (BgControlParam)casBalance.getBalance().get(i);
                amount = BgControlUtils.getBudgetValue((BgControlParam)casParam) != null ? BgControlUtils.getBudgetValue((BgControlParam)casParam) : BigDecimal.ZERO;
                fundFlowItemNumber = casParam.getBgIndexNumber().substring(4);
                String fundFlowItemId = ((FundFlowItemInfo)fundFlowItemMap.get(fundFlowItemNumber)).getId().toString();
                if (bgMap.containsKey(fundFlowItemNumber)) {
                    bgAmountInfo = bgMap.get(fundFlowItemNumber);
                } else {
                    bgAmountInfo.setCompanyId(company.getId().toString());
                    bgAmountInfo.setDate(date);
                    bgAmountInfo.setFundFlowItemNumber(fundFlowItemNumber);
                    bgAmountInfo.setFundFlowItemName(((FundFlowItemInfo)fundFlowItemMap.get(fundFlowItemNumber)).getName());
                    bgAmountInfo.setFundFlowItemId(fundFlowItemId);
                    bgAmountInfo.setBgNtAmount(BigDecimal.ZERO);
                    if (casParam.getControlSetting() != null && !casParam.getControlSetting().isIsAllowAccess()) {
                        bgAmountInfo.setIsControl(true);
                    }
                }
                if (casParam.getControlSetting() != null && casParam.getControlSetting().getCtrlSetRule().equals((Object)BgCtrlSetRuleEnum.Summary)) {
                    if (!EmptyUtil.isEmpty((Object)casParam.getBudgetDetail()) && !EmptyUtil.isEmpty(casParam.getBudgetDetail().get(casParam.getDimItemNumber() + "!" + casParam.getBgPeriodNumber()))) {
                        BgGroupData bgData = (BgGroupData)casParam.getBudgetDetail().get(casParam.getDimItemNumber() + "!" + casParam.getBgPeriodNumber());
                        amount = bgData.getBudgetValue();
                    } else {
                        amount = BigDecimal.ZERO;
                    }
                }
                bgAmountInfo.setBgCashAmount(amount);
                bgMap.put(fundFlowItemNumber, bgAmountInfo);
            }
            for (String key : bgMap.keySet()) {
                colls.add((CoreBaseInfo)bgMap.get(key));
            }
            if (EmptyUtil.isEmpty((String)departmentId) || "company".equals(departmentId)) {
                iBgAmount.addnew(colls);
            }
        }
    }

    protected SettlementTypeInfo getSettlementType(Context ctx, CompareType compareType) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("nttype.superGroup", (Object)4, compareType));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        view.setFilter(filter);
        view.setSelector(sic);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        return coll.get(0);
    }

    @Override
    protected Map _viewDetails(Context ctx, String orgScheduleId, String operatorName, String fundFlowItemId, String departmentId) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        boolean isMonth = false;
        String type = "all";
        int count = this.getCount(operatorName, isMonth, type);
        OrgScheduleInfo info = this.getOrgScheduleInfo(ctx, orgScheduleId);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"OrgSchedule_07viewDetails");
        if (!isPermission) {
            throw new PPException(PPException.NOT_VIEWDETAILS, new Object[]{info.getCompany().getName()});
        }
        isMonth = info.getUserDefinedPeriod().getPeriodType().equals((Object)UserDefinedPeriodEnum.MONTH);
        String companyId = info.getCompany().getId().toString();
        HashSet orgSet = new HashSet();
        Set userDefinedPeriodIdSet = this.getUserDefinedPeriodIdSet(ctx, info, isMonth, count);
        this.getOrgScheduleIdSet(ctx, companyId, orgSet, userDefinedPeriodIdSet);
        HashSet setFundPropertyIdSet = new HashSet();
        this.getSetFundProperty(ctx, fundFlowItemId, companyId, setFundPropertyIdSet);
        HashSet<String> paySchDetailBillIdSet = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("orgScheduleId", orgSet, CompareType.INCLUDE));
        if (type.equals("nt")) {
            filter.getFilterItems().add(new FilterItemInfo("ntAmt", (Object)BigDecimal.ZERO, CompareType.GREATER));
        } else if (type.equals("cas")) {
            filter.getFilterItems().add(new FilterItemInfo("cashAmt", (Object)BigDecimal.ZERO, CompareType.GREATER));
        }
        filter.getFilterItems().add(new FilterItemInfo("setFundProperty.id", setFundPropertyIdSet, CompareType.INCLUDE));
        if (!EmptyUtil.isEmpty((String)departmentId) && !"company".equals(departmentId)) {
            filter.getFilterItems().add(new FilterItemInfo("department.id", (Object)departmentId));
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setFilter(filter);
        view.setSelector(sic);
        PaySchDetailBillCollection paySchDetailBillColl = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)paySchDetailBillColl)) {
            for (int i = 0; i < paySchDetailBillColl.size(); ++i) {
                PaySchDetailBillInfo paySchDetailBillinfo = paySchDetailBillColl.get(i);
                paySchDetailBillIdSet.add(paySchDetailBillinfo.getId().toString());
            }
        }
        if (!EmptyUtil.isEmpty(paySchDetailBillIdSet)) {
            result.put("paySchDetailBillIds", ((Object)paySchDetailBillIdSet).toString());
        } else {
            result.put("paySchDetailBillIds", null);
        }
        return result;
    }

    protected void getSetFundProperty(Context ctx, String fundFlowItemId, String companyId, Set setFundPropertyIdSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fundFlowItem.id", (Object)fundFlowItemId));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setFilter(filter);
        view.setSelector(sic);
        SetFundPropertyCollection setFundPropertyColl = SetFundPropertyFactory.getLocalInstance(ctx).getSetFundPropertyCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)setFundPropertyColl)) {
            for (int i = 0; i < setFundPropertyColl.size(); ++i) {
                SetFundPropertyInfo info = setFundPropertyColl.get(i);
                setFundPropertyIdSet.add(info.getId().toString());
            }
        }
    }

    protected int getCount(String operatorName, boolean isMonth, String type) throws BOSException {
        int count = 0;
        if (isMonth) {
            if (operatorName.endsWith("janExecute")) {
                count = 1;
            } else if (operatorName.endsWith("febExecute")) {
                count = 2;
            } else if (operatorName.endsWith("marExecture")) {
                count = 3;
            } else if (operatorName.endsWith("aprExecture")) {
                count = 4;
            } else if (operatorName.endsWith("mayExecture")) {
                count = 5;
            } else if (operatorName.endsWith("junExecture")) {
                count = 6;
            } else if (operatorName.endsWith("julExecture")) {
                count = 7;
            } else if (operatorName.endsWith("augExecture")) {
                count = 8;
            } else if (operatorName.endsWith("sepExecture")) {
                count = 9;
            } else if (operatorName.endsWith("octExecture")) {
                count = 10;
            } else if (operatorName.endsWith("nouExecture")) {
                count = 11;
            } else if (operatorName.endsWith("decExecture")) {
                count = 12;
            } else if (operatorName.endsWith("capitalTotal")) {
                count = 0;
            }
        } else if (operatorName.endsWith("cashExecuteTotal")) {
            type = "cas";
        } else if (operatorName.endsWith("ntExecuteTotal")) {
            type = "nt";
        } else if (operatorName.endsWith("executeTotal")) {
            type = "all";
        } else {
            try {
                count = Integer.parseInt(operatorName.substring(operatorName.length() - 1));
            }
            catch (Exception e) {
                count = 0;
            }
            type = operatorName.indexOf("Nt") > -1 ? "nt" : (operatorName.indexOf("Cash") > -1 ? "cas" : "all");
        }
        return count;
    }

    private void getOrgScheduleIdSet(Context ctx, String companyId, Set orgSet, Set userDefinedPeriodIdSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userDefinedPeriod.id", (Object)userDefinedPeriodIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("userDefinedPeriod.*");
        view.setFilter(filter);
        view.setSelector(sic);
        OrgScheduleCollection orgColl = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)orgColl)) {
            for (int i = 0; i < orgColl.size(); ++i) {
                OrgScheduleInfo oInfo = orgColl.get(i);
                orgSet.add(oInfo.getId().toString());
            }
        }
    }

    @Override
    protected Set _getAuthizedDepartment(Context ctx, String userId) throws BOSException, EASBizException {
        UserInfo userInfo;
        HashSet<String> idSet = new HashSet<String>();
        if (EmptyUtil.isEmpty((String)userId)) {
            userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            userId = userInfo.getId().toString();
        }
        userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "SELECT po.FADMINORGUNITID as FADMINORGUNITID  FROM t_pm_user u   LEFT OUTER JOIN T_org_positionMember pm on u.FPERSONID = pm.FPERSONID   LEFT OUTER JOIN T_org_position  po on po.FID =pm.fpositionid  inner join t_org_admin ta on ta.fid  = po.FADMINORGUNITID  where u.FID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
        try {
            while (rs.next()) {
                String ID = rs.getString("FADMINORGUNITID");
                if (EmptyUtil.isEmpty((String)ID)) continue;
                idSet.add(ID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return idSet;
    }
}

