/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.pp.LockReceivableBillWebFacadeFactory;
import com.kingdee.eas.fm.pp.PPAutoSettingEnum;
import com.kingdee.eas.fm.pp.PPAutoSettingParamEnum;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PPParameterValuesCollection;
import com.kingdee.eas.fm.pp.PPRuleClassificationEnum;
import com.kingdee.eas.fm.pp.PPScheduleSettingAutoEntryCollection;
import com.kingdee.eas.fm.pp.PPScheduleSettingAutoEntryInfo;
import com.kingdee.eas.fm.pp.PPScheduleSettingBalanceType;
import com.kingdee.eas.fm.pp.PPScheduleSettingCollection;
import com.kingdee.eas.fm.pp.PPScheduleSettingFactory;
import com.kingdee.eas.fm.pp.PPScheduleSettingInfo;
import com.kingdee.eas.fm.pp.PPSupplierEntryCollection;
import com.kingdee.eas.fm.pp.PPSupplierEntryInfo;
import com.kingdee.eas.fm.pp.PPSupplierSettingCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillStatuEnum;
import com.kingdee.eas.fm.pp.app.AbstractIntelligentLockBillWebFacadeControllerBean;
import com.kingdee.eas.fm.pp.vo.IntelligentLockBillRow;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class IntelligentLockBillWebFacadeControllerBean
extends AbstractIntelligentLockBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.IntelligentLockBillWebFacadeControllerBean");

    @Override
    protected Map _buildIntelligentLockBillData(Context ctx, List idList, boolean isView) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Object> rowList = new ArrayList();
        HashSet<String> companyIdSet = new HashSet<String>();
        HashSet<String> paySchDetailBillIdSet = new HashSet<String>();
        String orgScheduleId = "";
        if (idList.size() > 0) {
            PaySchDetailBillCollection coll = this.getPaySchDetailBillCollection(ctx, FMHelper.list2Set((List)idList));
            PPScheduleSettingInfo scheduleSettingInfo = this.getPPScheduleSettingInfo(ctx, coll.get(0));
            companyIdSet.add(coll.get(0).getCompany().getId().toString());
            orgScheduleId = coll.get(0).getCompany().getId().toString();
            if (scheduleSettingInfo.getClearingHouse() != null) {
                companyIdSet.add(scheduleSettingInfo.getClearingHouse().getId().toString());
            }
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll) && !EmptyUtil.isEmpty((AbstractObjectCollection)(coll = isView ? this.getExistCollection(ctx, coll) : this.getNotExistCollection(ctx, coll)))) {
                rowList = this.getIntelligentLockBillRow(ctx, coll);
                for (int i = 0; i < coll.size(); ++i) {
                    paySchDetailBillIdSet.add(coll.get(i).getId().toString());
                }
            }
        }
        result.put("rowList", rowList);
        result.put("paySchDetailBillIds", paySchDetailBillIdSet);
        result.put("companyIds", companyIdSet);
        result.put("orgScheduleId", orgScheduleId);
        result.put("PP2020", this.paramPP2020(ctx));
        return result;
    }

    @Override
    protected Map _saveIntelligentLockBillData(Context ctx, List rowList) throws BOSException, EASBizException {
        Map result = new HashMap();
        if (!EmptyUtil.isEmpty((Collection)rowList)) {
            HashMap map = new HashMap();
            for (int i = 0; i < rowList.size(); ++i) {
                Map rowMap = (Map)rowList.get(i);
                IntelligentLockBillRow row = new IntelligentLockBillRow();
                try {
                    row = (IntelligentLockBillRow)IntelligentLockBillWebFacadeControllerBean.mapToObject(rowMap, IntelligentLockBillRow.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                List<String> idList = new ArrayList();
                String paySchDetailBillId = row.getPaySchDetailBillId();
                if (map.containsKey(paySchDetailBillId)) {
                    idList = (List)map.get(paySchDetailBillId);
                }
                if (EmptyUtil.isEmpty((String)row.getReceivableBillId())) continue;
                idList.add(row.getReceivableBillId());
                map.put(paySchDetailBillId, idList);
            }
            if (!EmptyUtil.isEmpty(map)) {
                for (Map.Entry entry : map.entrySet()) {
                    String paySchDetailBillId = (String)entry.getKey();
                    List receivableBillIdList = (List)entry.getValue();
                    HashMap<String, Object> idMap = new HashMap<String, Object>();
                    idMap.put("selectedIds", receivableBillIdList);
                    idMap.put("paySchDetailBillId", paySchDetailBillId);
                    result = LockReceivableBillWebFacadeFactory.getLocalInstance(ctx).batchLock(idMap);
                    IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new PaySchDetailBillInfo().getBOSType(), null, (String)paySchDetailBillId, (String)"pp_paySchDetail_intelligentLockBill");
                    LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                }
            }
        }
        return result;
    }

    @Override
    protected Map _deleteIntelligentLockBillData(Context ctx, Map map) throws BOSException, EASBizException {
        Map<String, ArrayList<Object>> result = new HashMap();
        List rowDate = (List)map.get("rowDate");
        String paySchDetailBillId = (String)map.get("selectedId");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("company.id");
        sic.add("company.name");
        PaySchDetailBillInfo paySchDetailBillInfo = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(paySchDetailBillId), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getCompany().getId()), (String)"paySchDetail_07cancelLockBill");
        if (!isPermission) {
            throw new PPException(PPException.NOT_CANCELLOCKBILL, new Object[]{paySchDetailBillInfo.getCompany().getName()});
        }
        ArrayList<IntelligentLockBillRow> newRowList = new ArrayList<IntelligentLockBillRow>();
        ArrayList<String> receivableBillIdList = new ArrayList<String>();
        if (!EmptyUtil.isEmpty((Collection)rowDate)) {
            for (int i = 0; i < rowDate.size(); ++i) {
                Map rowMap = (Map)rowDate.get(i);
                IntelligentLockBillRow row = new IntelligentLockBillRow();
                try {
                    row = (IntelligentLockBillRow)IntelligentLockBillWebFacadeControllerBean.mapToObject(rowMap, IntelligentLockBillRow.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (row.getPaySchDetailBillId().equals(paySchDetailBillId)) {
                    if (row.getReceivableBillId() == null) continue;
                    receivableBillIdList.add(row.getReceivableBillId());
                    continue;
                }
                newRowList.add(row);
            }
            HashMap<String, Object> idMap = new HashMap<String, Object>();
            idMap.put("selectedIds", receivableBillIdList);
            idMap.put("paySchDetailBillId", paySchDetailBillId);
            result = LockReceivableBillWebFacadeFactory.getLocalInstance(ctx).batchUnLock(idMap);
        }
        result.put("rowList", newRowList);
        return result;
    }

    @Override
    protected Map _intelligentLockBill(Context ctx, Set idSet, String companyId, int days) throws BOSException, EASBizException {
        PaySchDetailBillCollection coll;
        HashMap<String, AbstractCollection> result = new HashMap<String, AbstractCollection>();
        List<Object> rowList = new ArrayList();
        HashSet<String> receivablebillIdSet = new HashSet<String>();
        if (idSet.size() > 0 && !EmptyUtil.isEmpty((AbstractObjectCollection)(coll = this.getPaySchDetailBillCollection(ctx, idSet)))) {
            rowList = this.buildIntelligentLockBillRow(ctx, coll, receivablebillIdSet, companyId, days);
        }
        result.put("rowList", (AbstractCollection)((Object)rowList));
        result.put("receivablebillIdSet", receivablebillIdSet);
        return result;
    }

    private PaySchDetailBillCollection getPaySchDetailBillCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getPaySchDetailBillSelector();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PaySchDetailBillCollection coll = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(view);
        return coll;
    }

    private List<IntelligentLockBillRow> buildIntelligentLockBillRow(Context ctx, PaySchDetailBillCollection coll, Set<String> receivablebillIdSet, String companyId, int days) throws BOSException, EASBizException {
        ArrayList<IntelligentLockBillRow> rowList = new ArrayList<IntelligentLockBillRow>();
        PPScheduleSettingInfo scheduleSettingInfo = this.getPPScheduleSettingInfo(ctx, coll.get(0));
        for (int i = 0; i < coll.size(); ++i) {
            PaySchDetailBillInfo paySchDetailBillInfo = coll.get(i);
            ArrayList<IRowSet> receivableBillrowList = new ArrayList<IRowSet>();
            BigDecimal ntBalance = BigDecimal.ZERO;
            ntBalance = this.buildReceivableBill(ctx, receivableBillrowList, paySchDetailBillInfo, scheduleSettingInfo, companyId, receivablebillIdSet, days);
            IntelligentLockBillRow row = new IntelligentLockBillRow();
            this.buildParent(ctx, row, paySchDetailBillInfo);
            row.setNtSelectAmt(row.getNtAmt().subtract(ntBalance));
            row.setNtBalance(ntBalance);
            row.setExist(false);
            if (!EmptyUtil.isEmpty(receivableBillrowList)) {
                try {
                    for (int n = 0; n < receivableBillrowList.size(); ++n) {
                        IntelligentLockBillRow newRow = new IntelligentLockBillRow();
                        IRowSet set = (IRowSet)receivableBillrowList.get(n);
                        set.beforeFirst();
                        set.last();
                        newRow.addRow(row);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        newRow.setId(set.getString("id"));
                        receivablebillIdSet.add(set.getString("id"));
                        newRow.setReceivableBillId(set.getString("id"));
                        newRow.setDraftNumber(set.getString("draftNumber"));
                        newRow.setDrawerName(set.getString("drawerName"));
                        newRow.setAcceptanceBank(set.getString("acceptanceBankName"));
                        newRow.setBillPayeeBank(set.getString("payeeBankName"));
                        newRow.setBillAmt(set.getBigDecimal("billAmt"));
                        newRow.setIssuesDate(sdf.format(set.getDate("issuesDate")));
                        newRow.setExpiredDate(sdf.format(set.getDate("expiredDate")));
                        newRow.setNtType(set.getString("name"));
                        newRow.setBillMedium(BillMediumEnum.getEnum((int)set.getInt("billMedium")).getAlias());
                        rowList.add(newRow);
                    }
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            row.setId(paySchDetailBillInfo.getId().toString());
            rowList.add(row);
        }
        return rowList;
    }

    private PPScheduleSettingInfo getPPScheduleSettingInfo(Context ctx, PaySchDetailBillInfo paySchDetailBillInfo) throws BOSException, EASBizException {
        PPScheduleSettingInfo scheduleSettingInfo = new PPScheduleSettingInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)paySchDetailBillInfo.getCompany().getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entries.*");
        sic.add("supplierEntry.*");
        sic.add("supplierEntry.parameterValues.id");
        sic.add("supplierEntry.parameterValues.ppBankType.id");
        sic.add("supplierEntry.parameterValues.ppBankType.number");
        sic.add("supplierEntry.parameterValues.ppBankType.name");
        sic.add("supplierEntry.parameterValues.ppBankType.type");
        sic.add("supplierEntry.supplierSetting.id");
        sic.add("supplierEntry.supplierSetting.supplier.id");
        sic.add("supplierEntry.supplierSetting.supplier.name");
        sic.add("supplierEntry.supplierSetting.supplier.number");
        entityViewInfo.setSelector(sic);
        PPScheduleSettingCollection coll = PPScheduleSettingFactory.getLocalInstance(ctx).getPPScheduleSettingCollection(entityViewInfo);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            scheduleSettingInfo = coll.get(0);
        }
        return scheduleSettingInfo;
    }

    private List<IntelligentLockBillRow> getIntelligentLockBillRow(Context ctx, PaySchDetailBillCollection coll) throws BOSException, EASBizException {
        ArrayList<IntelligentLockBillRow> rowList = new ArrayList<IntelligentLockBillRow>();
        for (int i = 0; i < coll.size(); ++i) {
            PaySchDetailBillInfo paySchDetailBillInfo = coll.get(i);
            ReceivableBillCollection receivableBillCollection = this.getReceivableBillByPaySch(ctx, paySchDetailBillInfo);
            IntelligentLockBillRow row = new IntelligentLockBillRow();
            this.buildParent(ctx, row, paySchDetailBillInfo);
            row.setExist(true);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)receivableBillCollection)) {
                for (int m = 0; m < receivableBillCollection.size(); ++m) {
                    ReceivableBillInfo receivableBillinfo = receivableBillCollection.get(m);
                    IntelligentLockBillRow newRow = new IntelligentLockBillRow();
                    newRow.addRow(row);
                    this.buildEntrie(receivableBillinfo, newRow);
                    rowList.add(newRow);
                }
                continue;
            }
            row.setId(paySchDetailBillInfo.getId().toString());
            rowList.add(row);
        }
        return rowList;
    }

    private void buildEntrie(ReceivableBillInfo receivableBillinfo, IntelligentLockBillRow row) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        row.setReceivableBillId(receivableBillinfo.getId().toString());
        row.setDraftNumber(receivableBillinfo.getDraftNumber());
        row.setDrawerName(receivableBillinfo.getDrawerName());
        row.setAcceptanceBank(receivableBillinfo.getAcceptanceBankName());
        row.setBillPayeeBank(receivableBillinfo.getPayeeBankName());
        row.setBillAmt(receivableBillinfo.getBillAmt());
        row.setIssuesDate(sdf.format(receivableBillinfo.getIssuesDate()));
        row.setExpiredDate(sdf.format(receivableBillinfo.getExpiredDate()));
        row.setNtType(receivableBillinfo.getNtType().getName());
        row.setBillMedium(receivableBillinfo.getBillMedium().getAlias());
        row.setId(receivableBillinfo.getId().toString());
    }

    private void buildParent(Context ctx, IntelligentLockBillRow row, PaySchDetailBillInfo paySchDetailBillInfo) throws BOSException, EASBizException {
        row.setPaySchDetailBillId(paySchDetailBillInfo.getId().toString());
        row.setNumber(paySchDetailBillInfo.getNumber());
        row.setCompanyName(paySchDetailBillInfo.getCompany().getName());
        row.setPayPlanNumber(paySchDetailBillInfo.getPayPlan().getNumber());
        row.setNtAmt(paySchDetailBillInfo.getNtAmt());
        row.setNtSelectAmt(paySchDetailBillInfo.getNtSelectAmt());
        row.setNtBalance(paySchDetailBillInfo.getNtBalance());
        row.setAsstActName(paySchDetailBillInfo.getAsstActName());
        row.setPayeeAccountBank(paySchDetailBillInfo.getPayeeAccountBank());
        row.setPayeeBank(paySchDetailBillInfo.getPayeeBank());
        row.setSettlementTypeName(paySchDetailBillInfo.getSettlementType().getName());
        row.setMinExpiredDate(paySchDetailBillInfo.getMinExpiredDate());
    }

    private void buildParentByRow(Context ctx, IntelligentLockBillRow newRow, IntelligentLockBillRow row) throws BOSException, EASBizException {
        newRow.setPaySchDetailBillId(row.getPaySchDetailBillId());
        newRow.setNumber(row.getNumber());
        newRow.setCompanyName(row.getCompanyName());
        newRow.setPayPlanNumber(row.getPayPlanNumber());
        newRow.setNtAmt(row.getNtAmt());
        newRow.setNtSelectAmt(row.getNtSelectAmt());
        newRow.setNtBalance(row.getNtBalance());
        newRow.setAsstActName(row.getAsstActName());
        newRow.setPayeeAccountBank(row.getPayeeAccountBank());
        newRow.setPayeeBank(row.getPayeeBank());
        newRow.setSettlementTypeName(row.getSettlementTypeName());
        newRow.setMinExpiredDate(row.getMinExpiredDate());
    }

    private BigDecimal buildReceivableBill(Context ctx, List<IRowSet> receivableBillrowList, PaySchDetailBillInfo paySchDetailBillInfo, PPScheduleSettingInfo scheduleSettingInfo, String companyId, Set<String> receivablebillIdSet, int days) throws BOSException, EASBizException {
        int i;
        List<PPScheduleSettingAutoEntryInfo> settingParamList = this.getSettingParamList(scheduleSettingInfo);
        boolean flag = false;
        if (settingParamList != null && settingParamList.size() > 0) {
            for (int i2 = 0; i2 < settingParamList.size(); ++i2) {
                PPScheduleSettingAutoEntryInfo info = settingParamList.get(i2);
                if (!info.getSettingParam().equals((Object)PPAutoSettingParamEnum.billAmount)) continue;
                flag = true;
                break;
            }
        }
        BigDecimal billAmt = paySchDetailBillInfo.getNtBalance();
        BigDecimal amt = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((Object)scheduleSettingInfo.getBalance()) && scheduleSettingInfo.getBalance().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal blance = scheduleSettingInfo.getBalance();
            amt = scheduleSettingInfo.getBalanceType().equals((Object)PPScheduleSettingBalanceType.scale) ? billAmt.multiply(blance.divide(new BigDecimal(100))) : blance;
        }
        BigDecimal billBalance = billAmt;
        if (paySchDetailBillInfo.getSummaryFlag() != null) {
            return billBalance;
        }
        int number = 1;
        HashSet<String> billIdSet = new HashSet<String>();
        billIdSet.addAll(receivablebillIdSet);
        for (i = 1; i < 11 && (billBalance = this.getReceivabelbill(ctx, receivableBillrowList, paySchDetailBillInfo, scheduleSettingInfo, billAmt, amt, settingParamList, number, companyId, days, billIdSet, i)).compareTo(amt) > 0; ++i) {
            billIdSet.clear();
            billIdSet.addAll(receivablebillIdSet);
            receivableBillrowList.clear();
        }
        if ((EmptyUtil.isEmpty(receivableBillrowList) || billBalance.compareTo(amt) > 0) && flag && paySchDetailBillInfo.getCashAuditedAmt().compareTo(amt) >= 0) {
            billAmt = billAmt.add(amt);
            for (i = 1; i < 11 && (billBalance = this.getReceivabelbill(ctx, receivableBillrowList, paySchDetailBillInfo, scheduleSettingInfo, billAmt, amt, settingParamList, number, companyId, days, billIdSet, i)).compareTo(amt) > 0; ++i) {
                billIdSet.clear();
                billIdSet.addAll(receivablebillIdSet);
                receivableBillrowList.clear();
            }
        }
        if (!(flag && billBalance.compareTo(amt) <= 0 || billBalance.compareTo(BigDecimal.ZERO) == 0)) {
            receivableBillrowList.clear();
            billBalance = paySchDetailBillInfo.getNtBalance();
        }
        return billBalance;
    }

    private BigDecimal getReceivabelbill(Context ctx, List<IRowSet> rowList, PaySchDetailBillInfo paySchDetailBillInfo, PPScheduleSettingInfo scheduleSettingInfo, BigDecimal billAmt, BigDecimal amt, List<PPScheduleSettingAutoEntryInfo> settingParamList, int number, String companyId, int days, Set<String> billIdSet, int sort) throws BOSException, EASBizException {
        block7: {
            if (number > 3) {
                return billAmt;
            }
            String sql = this.getSql(ctx, paySchDetailBillInfo, scheduleSettingInfo, billAmt, settingParamList, companyId, days, sort, billIdSet);
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (set.next()) {
                    try {
                        rowList.add(set);
                        set.last();
                        BigDecimal newAmt = billAmt.subtract(set.getBigDecimal("billAmt"));
                        billIdSet.add(set.getString("id"));
                        billAmt = newAmt;
                        if (newAmt.compareTo(amt) <= 0) {
                            return billAmt;
                        }
                        billAmt = this.getReceivabelbill(ctx, rowList, paySchDetailBillInfo, scheduleSettingInfo, billAmt, amt, settingParamList, ++number, companyId, days, billIdSet, 1);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    break block7;
                }
                return billAmt;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return billAmt;
    }

    private String getSql(Context ctx, PaySchDetailBillInfo paySchDetailBillInfo, PPScheduleSettingInfo scheduleSettingInfo, BigDecimal billAmt, List<PPScheduleSettingAutoEntryInfo> settingParamList, String companyId, int days, int sort, Set<String> billIdSet) throws BOSException, EASBizException {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(401, "type ASC");
        map.put(402, "expiredDate DESC");
        map.put(403, "billAmt DESC");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT top " + sort + " n.fid as id,n.fDraftNumber as draftNumber,n.fDrawerName as drawerName,n.fAcceptanceBankName as acceptanceBankName, \n").append("n.fPayeeBankName as payeeBankName,n.fBillAmt as billAmt,n.fIssuesDate as issuesDate,n.fExpiredDate as expiredDate, \n").append("n.fBillMedium as billMedium,b.ftype as type,t.FNAME_l2 as name FROM T_NT_ReceivableBill n  \n").append("inner join T_PP_PPBankType b on (case when n.fbillMedium = 1 then substring(n.fdraftNumber,1,3)  when n.fbillMedium = 2 then substring(n.fdraftNumber,2,3) end)  = b.fnumber \n").append("left join T_NT_NTType t on n.fnttypeid = t.fid \n");
        sql.append("where n.fcompanyId = '" + companyId + "' ");
        String orgScheduleId = paySchDetailBillInfo.getCompany().getId().toString();
        if (!companyId.equals(orgScheduleId) && this.paramPP2020(ctx)) {
            sql.append(" AND n.FDistributionOrgUnitID = '" + orgScheduleId + "' \n");
        }
        sql.append("AND (n.fisPledge = 0 OR n.fisPledge = 1 AND n.fisDisPledge = 1) \n");
        sql.append("AND n.fisTrustee = 0 AND n.fisCollect = 0 AND n.fisPoolPledge = 0 AND ((n.fisPoolTrustee <> 1) \n");
        sql.append(" OR (n.fisPoolTrustee IS NULL)) AND n.fisLockByBill = 0 AND n.fisLockByManual = 0 \n");
        boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getCompany().getId()));
        if (NT011) {
            sql.append("AND n.fbillState = 8 \n");
        } else {
            sql.append("AND n.fbillState = 1 \n");
        }
        if (!EmptyUtil.isEmpty((Object)paySchDetailBillInfo.getMinExpiredDate())) {
            int minExpiredDate = paySchDetailBillInfo.getMinExpiredDate();
            Date currdate = new Date();
            Calendar ca = Calendar.getInstance();
            ca.setTime(currdate);
            ca.add(5, minExpiredDate);
            currdate = ca.getTime();
            sql.append("AND n.fexpiredDate <= {" + new Timestamp(currdate.getTime()) + "} \n");
        }
        Date currdate = new Date();
        Calendar ca = Calendar.getInstance();
        ca.setTime(currdate);
        ca.add(5, days);
        currdate = ca.getTime();
        sql.append("AND n.fexpiredDate >= {" + new Timestamp(currdate.getTime()) + "} \n");
        sql.append("and n.fBillAmt <= " + billAmt + " \n");
        HashSet supplierCompanySet = new HashSet();
        HashSet bankTypeSet = new HashSet();
        this.getSetting(supplierCompanySet, bankTypeSet, scheduleSettingInfo);
        if (!EmptyUtil.isEmpty(supplierCompanySet) && supplierCompanySet.contains(paySchDetailBillInfo.getAsstActName())) {
            sql.append("and b.fid in " + FMHelper.setTran2String(bankTypeSet) + "\n");
        }
        if (!EmptyUtil.isEmpty(billIdSet)) {
            sql.append("and n.fid not in " + FMHelper.setTran2String(billIdSet) + "\n");
        }
        if (settingParamList != null && settingParamList.size() > 0) {
            for (int i = 0; i < settingParamList.size(); ++i) {
                PPScheduleSettingAutoEntryInfo info = settingParamList.get(i);
                if (i == 0) {
                    sql.append("order by ").append((String)map.get(info.getSettingParam().getValue()));
                    continue;
                }
                sql.append(",").append((String)map.get(info.getSettingParam().getValue()));
            }
        } else {
            sql.append("order by ").append((String)map.get(403));
        }
        return sql.toString();
    }

    private List<PPScheduleSettingAutoEntryInfo> getSettingParamList(PPScheduleSettingInfo scheduleSettingInfo) {
        PPScheduleSettingAutoEntryCollection coll = scheduleSettingInfo.getEntries();
        ArrayList<PPScheduleSettingAutoEntryInfo> list = new ArrayList<PPScheduleSettingAutoEntryInfo>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int m = 0; m < coll.size(); ++m) {
                PPScheduleSettingAutoEntryInfo info = coll.get(m);
                if (!info.getSettingType().equals((Object)PPAutoSettingEnum.autoReceivableBill)) continue;
                list.add(info);
            }
            Collections.sort(list, new Comparator<PPScheduleSettingAutoEntryInfo>(){

                @Override
                public int compare(PPScheduleSettingAutoEntryInfo o1, PPScheduleSettingAutoEntryInfo o2) {
                    return o1.getPriority() - o2.getPriority();
                }
            });
        }
        return list;
    }

    private void getSetting(Set supplierCompanySet, Set bankTypeSet, PPScheduleSettingInfo scheduleSettingInfo) {
        PPSupplierEntryCollection supplierEntrycoll = scheduleSettingInfo.getSupplierEntry();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)supplierEntrycoll)) {
            for (int n = 0; n < supplierEntrycoll.size(); ++n) {
                int i;
                if (!supplierEntrycoll.get(n).getRuleClassification().equals((Object)PPRuleClassificationEnum.acceptanceBank)) continue;
                PPSupplierEntryInfo info = supplierEntrycoll.get(n);
                PPSupplierSettingCollection suppliercoll = info.getSupplierSetting();
                PPParameterValuesCollection parametercoll = info.getParameterValues();
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)suppliercoll)) {
                    for (i = 0; i < suppliercoll.size(); ++i) {
                        supplierCompanySet.add(suppliercoll.get(i).getSupplier().getName());
                    }
                }
                if (EmptyUtil.isEmpty((AbstractObjectCollection)parametercoll)) continue;
                for (i = 0; i < parametercoll.size(); ++i) {
                    bankTypeSet.add(parametercoll.get(i).getPpBankType().getId().toString());
                }
            }
        }
    }

    private PaySchDetailBillCollection getExistCollection(Context ctx, PaySchDetailBillCollection coll) throws BOSException, EASBizException {
        PaySchDetailBillCollection existColl = new PaySchDetailBillCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PaySchDetailBillInfo paySchDetailBillInfo = coll.get(i);
            if (paySchDetailBillInfo.getNtSelectAmt() == null || paySchDetailBillInfo.getNtSelectAmt().compareTo(BigDecimal.ZERO) <= 0 || !paySchDetailBillInfo.getStatus().equals((Object)PaySchDetailBillStatuEnum.UNGENERATE)) continue;
            existColl.add(paySchDetailBillInfo);
        }
        return existColl;
    }

    private PaySchDetailBillCollection getNotExistCollection(Context ctx, PaySchDetailBillCollection coll) throws BOSException, EASBizException {
        PaySchDetailBillCollection existColl = new PaySchDetailBillCollection();
        for (int i = 0; i < coll.size(); ++i) {
            NTTypeInfo ntInfo;
            PaySchDetailBillInfo paySchDetailBillInfo = coll.get(i);
            if (!EmptyUtil.isEmpty((Object)paySchDetailBillInfo.getNtSelectAmt()) && (paySchDetailBillInfo.getNtSelectAmt() == null || paySchDetailBillInfo.getNtSelectAmt().compareTo(BigDecimal.ZERO) != 0) || !paySchDetailBillInfo.getStatus().equals((Object)PaySchDetailBillStatuEnum.UNGENERATE) || paySchDetailBillInfo.getNtSettleType() == null || paySchDetailBillInfo.getNtSettleType().getNtType() == null || (ntInfo = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getNtSettleType().getNtType().getId()))).getSuperGroup() == null || !ntInfo.getSuperGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE)) continue;
            existColl.add(paySchDetailBillInfo);
        }
        return existColl;
    }

    private ReceivableBillCollection getReceivableBillByPaySch(Context ctx, PaySchDetailBillInfo paySchDetailBillInfo) throws BOSException, EASBizException {
        ReceivableBillCollection receivableBillCollection = new ReceivableBillCollection();
        if (paySchDetailBillInfo.getId() != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("receivableBill.*"));
            sic.add(new SelectorItemInfo("receivableBill.ntType.name"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)paySchDetailBillInfo.getId().toString()));
            view.setFilter(filter);
            PaySchDetailBillNTsCollection ntsColl = PaySchDetailBillNTsFactory.getLocalInstance(ctx).getPaySchDetailBillNTsCollection(view);
            if (ntsColl.size() > 0) {
                for (int i = 0; i < ntsColl.size(); ++i) {
                    receivableBillCollection.add(ntsColl.get(i).getReceivableBill());
                }
            }
        }
        return receivableBillCollection;
    }

    @Override
    protected Map _addReceivableBill(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        List rowDate = (List)map.get("rowDate");
        String rowId = (String)map.get("rowId");
        String receivableBillId = (String)map.get("receivableBillId");
        List receivableBillIdSet = (List)map.get("receivablebillIdSet");
        ArrayList<IntelligentLockBillRow> newRowList = new ArrayList<IntelligentLockBillRow>();
        String paySchDetailBillId = null;
        BigDecimal selectAmt = BigDecimal.ZERO;
        ReceivableBillInfo receivableBillInfo = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(receivableBillId), this.getReceivableBillSelector());
        if (!EmptyUtil.isEmpty((Collection)rowDate)) {
            for (int i = 0; i < rowDate.size(); ++i) {
                Map rowMap = (Map)rowDate.get(i);
                if (rowMap.get("minExpiredDate") != null) {
                    double minExpiredDate = (Double)rowMap.get("minExpiredDate");
                    rowMap.put("minExpiredDate", (int)minExpiredDate);
                }
                IntelligentLockBillRow row = new IntelligentLockBillRow();
                try {
                    row = (IntelligentLockBillRow)IntelligentLockBillWebFacadeControllerBean.mapToObject(rowMap, IntelligentLockBillRow.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (row.getId().equals(rowId)) {
                    paySchDetailBillId = row.getPaySchDetailBillId();
                    selectAmt = row.getNtSelectAmt().add(receivableBillInfo.getBillAmt());
                    IntelligentLockBillRow newRow = new IntelligentLockBillRow();
                    newRow.addRow(row);
                    this.buildEntrie(receivableBillInfo, newRow);
                    if (row.isExist()) {
                        this.lock(ctx, receivableBillInfo.getId().toString(), paySchDetailBillId);
                    }
                    if (!EmptyUtil.isEmpty((Collection)receivableBillIdSet)) {
                        receivableBillIdSet.add(receivableBillInfo.getId().toString());
                    }
                    newRowList.add(newRow);
                } else {
                    newRowList.add(row);
                }
                if (!row.getId().equals(rowId) || row.getReceivableBillId() == null) continue;
                newRowList.add(row);
            }
        }
        this.setNewAmt(newRowList, paySchDetailBillId, selectAmt);
        result.put((Object)"rowList", newRowList);
        result.put((Object)"receivablebillIdSet", (Object)receivableBillIdSet);
        return result;
    }

    @Override
    protected Map _deleteReceivableBill(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        List rowDate = (List)map.get("rowDate");
        ArrayList<IntelligentLockBillRow> newRowList = new ArrayList<IntelligentLockBillRow>();
        String rowId = (String)map.get("rowId");
        List receivableBillIdSet = (List)map.get("receivablebillIdSet");
        String paySchDetailBillId = null;
        BigDecimal selectAmt = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((Collection)rowDate)) {
            for (int i = 0; i < rowDate.size(); ++i) {
                Map rowMap = (Map)rowDate.get(i);
                if (rowMap.get("minExpiredDate") != null) {
                    double minExpiredDate = (Double)rowMap.get("minExpiredDate");
                    rowMap.put("minExpiredDate", (int)minExpiredDate);
                }
                IntelligentLockBillRow row = new IntelligentLockBillRow();
                try {
                    row = (IntelligentLockBillRow)IntelligentLockBillWebFacadeControllerBean.mapToObject(rowMap, IntelligentLockBillRow.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (row.getId().equals(rowId)) {
                    paySchDetailBillId = row.getPaySchDetailBillId();
                    selectAmt = row.getNtSelectAmt().subtract(row.getBillAmt());
                    if (rowDate.size() == 1) {
                        IntelligentLockBillRow newRow = new IntelligentLockBillRow();
                        this.buildParentByRow(ctx, newRow, row);
                        newRowList.add(newRow);
                    }
                    if (!row.isExist()) continue;
                    this.unLock(ctx, row.getReceivableBillId(), paySchDetailBillId);
                    if (EmptyUtil.isEmpty((Collection)receivableBillIdSet)) continue;
                    receivableBillIdSet.remove(row.getReceivableBillId());
                    continue;
                }
                newRowList.add(row);
            }
        }
        this.setNewAmt(newRowList, paySchDetailBillId, selectAmt);
        result.put((Object)"rowList", newRowList);
        result.put((Object)"receivablebillIdSet", (Object)receivableBillIdSet);
        return result;
    }

    private void setNewAmt(List<IntelligentLockBillRow> newRowList, String paySchDetailBillId, BigDecimal selectAmt) {
        if (!EmptyUtil.isEmpty(newRowList)) {
            for (int i = 0; i < newRowList.size(); ++i) {
                IntelligentLockBillRow row = newRowList.get(i);
                if (!row.getPaySchDetailBillId().equals(paySchDetailBillId)) continue;
                row.setNtSelectAmt(selectAmt);
                row.setNtBalance(row.getNtAmt().subtract(selectAmt));
            }
        }
    }

    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) throws Exception {
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        BeanUtils.populate(obj, map);
        return obj;
    }

    @Override
    protected Map _updateReceivableBill(Context ctx, Map map) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        List rowDate = (List)map.get("rowDate");
        String rowId = (String)map.get("rowId");
        String receivableBillId = (String)map.get("receivableBillId");
        List receivableBillIdSet = (List)map.get("receivablebillIdSet");
        ArrayList<IntelligentLockBillRow> newRowList = new ArrayList<IntelligentLockBillRow>();
        String paySchDetailBillId = null;
        BigDecimal selectAmt = BigDecimal.ZERO;
        ReceivableBillInfo receivableBillInfo = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(receivableBillId), this.getReceivableBillSelector());
        if (!EmptyUtil.isEmpty((Collection)rowDate)) {
            for (int i = 0; i < rowDate.size(); ++i) {
                Map rowMap = (Map)rowDate.get(i);
                if (rowMap.get("minExpiredDate") != null) {
                    double minExpiredDate = (Double)rowMap.get("minExpiredDate");
                    rowMap.put("minExpiredDate", (int)minExpiredDate);
                }
                IntelligentLockBillRow row = new IntelligentLockBillRow();
                try {
                    row = (IntelligentLockBillRow)IntelligentLockBillWebFacadeControllerBean.mapToObject(rowMap, IntelligentLockBillRow.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (row.getId().equals(rowId)) {
                    IntelligentLockBillRow newRow = new IntelligentLockBillRow();
                    newRow.addRow(row);
                    this.buildEntrie(receivableBillInfo, newRow);
                    newRowList.add(newRow);
                    paySchDetailBillId = row.getPaySchDetailBillId();
                    selectAmt = row.getNtSelectAmt().subtract(row.getBillAmt()).add(newRow.getBillAmt());
                    if (!row.isExist()) continue;
                    this.unLock(ctx, row.getReceivableBillId(), paySchDetailBillId);
                    this.lock(ctx, receivableBillInfo.getId().toString(), paySchDetailBillId);
                    if (EmptyUtil.isEmpty((Collection)receivableBillIdSet)) continue;
                    receivableBillIdSet.remove(row.getReceivableBillId());
                    receivableBillIdSet.add(receivableBillInfo.getId().toString());
                    continue;
                }
                newRowList.add(row);
            }
        }
        this.setNewAmt(newRowList, paySchDetailBillId, selectAmt);
        result.put((Object)"rowList", newRowList);
        result.put((Object)"receivablebillIdSet", (Object)receivableBillIdSet);
        return result;
    }

    @Override
    protected Map _checPermission(Context ctx, String paySchDetailBillId, String perItemName) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("company.id");
        sic.add("company.name");
        PaySchDetailBillInfo paySchDetailBillInfo = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(paySchDetailBillId), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(paySchDetailBillInfo.getCompany().getId()), (String)perItemName);
        result.put("hasFunctionPermission", isPermission);
        return result;
    }

    protected void lock(Context ctx, String receivableBillId, String paySchDetailBill) throws BOSException, EASBizException {
        ReceivableBillInfo rInfo = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(receivableBillId), this.getReceivableBillSelector());
        PaySchDetailBillInfo pInfo = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(paySchDetailBill), this.getPaySchDetailBillSelector());
        LockReceivableBillWebFacadeFactory.getLocalInstance(ctx).lock(rInfo, pInfo);
    }

    protected void unLock(Context ctx, String receivableBillId, String paySchDetailBill) throws BOSException, EASBizException {
        ReceivableBillInfo rInfo = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(receivableBillId), this.getReceivableBillSelector());
        PaySchDetailBillInfo pInfo = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(paySchDetailBill), this.getPaySchDetailBillSelector());
        LockReceivableBillWebFacadeFactory.getLocalInstance(ctx).unLock(rInfo, pInfo);
    }

    protected SelectorItemCollection getReceivableBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("ntType.name");
        return selector;
    }

    protected SelectorItemCollection getPaySchDetailBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("settlementType.name"));
        selector.add(new SelectorItemInfo("payPlan.number"));
        selector.add(new SelectorItemInfo("ntSettleType.*"));
        selector.add(new SelectorItemInfo("nts.*"));
        return selector;
    }

    private boolean paramPP2020(Context ctx) {
        boolean PP2020 = false;
        try {
            PP2020 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "PP2020"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return PP2020;
    }
}

