/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PaySchDetailBillCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillInfo;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsCollection;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsFactory;
import com.kingdee.eas.fm.pp.PaySchDetailBillNTsInfo;
import com.kingdee.eas.fm.pp.StatusEnum;
import com.kingdee.eas.fm.pp.app.AbstractLockReceivableBillWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LockReceivableBillWebFacadeControllerBean
extends AbstractLockReceivableBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.LockReceivableBillWebFacadeControllerBean");

    @Override
    protected Map _batchLock(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        String paySchDetailBillId = (String)idMap.get("paySchDetailBillId");
        HashSet selectIdSet = new HashSet(idList);
        summary = summary + LockReceivableBillWebFacadeControllerBean.getResource(ctx, "002_setFundProperty", new String[]{selectIdSet.size() + ""});
        try {
            ReceivableBillCollection colls = this.getReceivableBillCollByIdSet(ctx, selectIdSet);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("ntAmt"));
            sic.add(new SelectorItemInfo("ntSelectAmt"));
            sic.add(new SelectorItemInfo("company"));
            sic.add(new SelectorItemInfo("ntAuditedAmt"));
            sic.add(new SelectorItemInfo("summaryFlag"));
            sic.add(new SelectorItemInfo("orgScheduleId"));
            PaySchDetailBillInfo pinfo = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(paySchDetailBillId), sic);
            this.verifyOrgScheduleStatus(ctx, pinfo);
            for (int i = 0; i < colls.size(); ++i) {
                ReceivableBillInfo info = colls.get(i);
                try {
                    if (info.isIsLockByBill() || info.isIsLockByManual() || info.isIsTrustee() || info.isIsPledge() && !info.isIsDisPledge() || info.isIsCollect() || info.isIsPoolPledge() || info.isIsPoolTrustee()) {
                        result.getDetailMsgList().add(LockReceivableBillWebFacadeControllerBean.getResource(ctx, "IS_LOCK_BYBILL", new String[]{info.getDraftNumber()}));
                        continue;
                    }
                    this.lock(ctx, info, pinfo);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(LockReceivableBillWebFacadeControllerBean.getResource(ctx, "IS_NOT_LOCK", new String[]{info.getDraftNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(LockReceivableBillWebFacadeControllerBean.getResource(ctx, "IS_LOCK_ERROR", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == selectIdSet.size() ? LockReceivableBillWebFacadeControllerBean.getResource(ctx, "LOCK_SUCCESS", null) : summary + LockReceivableBillWebFacadeControllerBean.getResource(ctx, "LOCK_SUCCESS_FAILED", new String[]{String.valueOf(success), String.valueOf(selectIdSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _batchUnLock(Context ctx, Map idMap) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = 0;
        List idList = (List)idMap.get("selectedIds");
        String paySchDetailBillId = (String)idMap.get("paySchDetailBillId");
        HashSet selectIdSet = new HashSet(idList);
        summary = summary + LockReceivableBillWebFacadeControllerBean.getResource(ctx, "002_setFundProperty", new String[]{selectIdSet.size() + ""});
        try {
            ReceivableBillCollection colls = this.getReceivableBillCollByIdSet(ctx, selectIdSet);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("ntAmt"));
            sic.add(new SelectorItemInfo("ntSelectAmt"));
            sic.add(new SelectorItemInfo("ntAuditedAmt"));
            sic.add(new SelectorItemInfo("isCrossOrg"));
            sic.add(new SelectorItemInfo("orgScheduleId"));
            PaySchDetailBillInfo pinfo = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillInfo((IObjectPK)new ObjectUuidPK(paySchDetailBillId), sic);
            this.verifyOrgScheduleStatus(ctx, pinfo);
            for (int i = 0; i < colls.size(); ++i) {
                ReceivableBillInfo info = colls.get(i);
                try {
                    this.unLock(ctx, info, pinfo);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(LockReceivableBillWebFacadeControllerBean.getResource(ctx, "IS_NOT_UNLOCK", new String[]{info.getDraftNumber()}) + e.getMessage());
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            result.setSummaryMsg(LockReceivableBillWebFacadeControllerBean.getResource(ctx, "IS_UNLOCK_ERROR", new String[]{e1.getMessage()}));
        }
        if (result.getSummaryMsg() == null) {
            summary = success == selectIdSet.size() ? LockReceivableBillWebFacadeControllerBean.getResource(ctx, "UNLOCK_SUCCESS", null) : summary + LockReceivableBillWebFacadeControllerBean.getResource(ctx, "UNLOCK_SUCCESS_FAILED", new String[]{String.valueOf(success), String.valueOf(selectIdSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected IObjectCollection _getLockReceivableBill(Context ctx, Map idMap) throws BOSException, EASBizException {
        String paySchDetailBillId = (String)idMap.get("paySchDetailBillId");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(paySchDetailBillId);
        ReceivableBillCollection colls = this.getReceivableBillCollection(ctx, idSet);
        return colls;
    }

    private ReceivableBillCollection getReceivableBillCollection(Context ctx, Set<String> idSet) throws BOSException {
        ReceivableBillCollection colls = new ReceivableBillCollection();
        if (idSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("receivableBill.*"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            PaySchDetailBillNTsCollection ntsColl = PaySchDetailBillNTsFactory.getLocalInstance(ctx).getPaySchDetailBillNTsCollection(view);
            if (ntsColl.size() > 0) {
                for (int i = 0; i < ntsColl.size(); ++i) {
                    colls.add(ntsColl.get(i).getReceivableBill());
                }
            }
        }
        return colls;
    }

    private IReceivableBill getBizInterface(Context ctx) throws BOSException {
        return ReceivableBillFactory.getLocalInstance((Context)ctx);
    }

    private ReceivableBillCollection getReceivableBillCollByIdSet(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(sic);
        return this.getBizInterface(ctx).getReceivableBillCollection(entityViewInfo);
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }

    @Override
    protected void _lock(Context ctx, IObjectValue receivableBillInfo, IObjectValue paySchDetailBill) throws BOSException, EASBizException {
        try {
            ReceivableBillCollection colls;
            ReceivableBillInfo info = (ReceivableBillInfo)receivableBillInfo;
            PaySchDetailBillInfo pInfo = (PaySchDetailBillInfo)paySchDetailBill;
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(pInfo.getId().toString());
            if (pInfo.getSummaryFlag() != null) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                view.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("summaryFlag", (Object)pInfo.getSummaryFlag()));
                view.setFilter(filter);
                PaySchDetailBillCollection paySchDetailColl = PaySchDetailBillFactory.getLocalInstance(ctx).getPaySchDetailBillCollection(view);
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)paySchDetailColl)) {
                    for (int i = 0; i < paySchDetailColl.size(); ++i) {
                        idSet.add(paySchDetailColl.get(i).getId().toString());
                    }
                }
            }
            if ((colls = this.getReceivableBillCollection(ctx, idSet)) != null && colls.size() > 0) {
                for (int i = 0; i < colls.size(); ++i) {
                    ReceivableBillInfo receInfo = colls.get(i);
                    if (!info.getCompany().getId().equals((Object)receInfo.getCompany().getId())) {
                        throw new PPException(PPException.LOCKRECEIVABLEBILL_COMPANY);
                    }
                    if (info.getSource() != receInfo.getSource()) {
                        throw new PPException(PPException.LOCKRECEIVABLEBILL_SOURCE);
                    }
                    if (info.getBillMedium() == receInfo.getBillMedium()) continue;
                    throw new PPException(PPException.LOCKRECEIVABLEBILL_BILLMEDIUM);
                }
            }
            String sql = "update T_NT_ReceivableBill set FisLockByBill=1,FLockAmt=FAvailableAmt,FAvailableAmt=0 where Fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            BigDecimal ntAmt = pInfo.getNtAuditedAmt() != null ? pInfo.getNtAuditedAmt() : BigDecimal.ZERO;
            BigDecimal ntSelectAmt = pInfo.getNtSelectAmt() != null ? pInfo.getNtSelectAmt() : BigDecimal.ZERO;
            BigDecimal ntBalance = BigDecimal.ZERO;
            BigDecimal billAmt = info.getBillAmt();
            ntSelectAmt = ntSelectAmt.add(billAmt);
            ntBalance = ntAmt.subtract(ntSelectAmt);
            pInfo.setNtSelectAmt(ntSelectAmt);
            pInfo.setNtBalance(ntBalance);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("ntSelectAmt"));
            selector.add(new SelectorItemInfo("ntBalance"));
            CompanyOrgUnitInfo companyInfo = pInfo.getCompany();
            if (!companyInfo.getId().equals((Object)info.getCompany().getId())) {
                pInfo.setIsCrossOrg(true);
                selector.add(new SelectorItemInfo("isCrossOrg"));
            }
            PaySchDetailBillFactory.getLocalInstance(ctx).updatePartial(pInfo, selector);
            PaySchDetailBillNTsInfo nTsInfo = new PaySchDetailBillNTsInfo();
            nTsInfo.setParent(pInfo);
            nTsInfo.setReceivableBill(info);
            PaySchDetailBillNTsFactory.getLocalInstance(ctx).save((CoreBaseInfo)nTsInfo);
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)pInfo.getBOSType(), null, (String)pInfo.getLogInfo(), (String)"pp_paySchDetail_lockReceivableBill");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _unLock(Context ctx, IObjectValue receivableBillInfo, IObjectValue paySchDetailBill) throws BOSException, EASBizException {
        try {
            ReceivableBillInfo info = (ReceivableBillInfo)receivableBillInfo;
            PaySchDetailBillInfo pInfo = (PaySchDetailBillInfo)paySchDetailBill;
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(pInfo.getId().toString());
            ReceivableBillCollection colls = this.getReceivableBillCollection(ctx, idSet);
            String sql = "delete from T_PP_PaySchDetailBillNTs where FParentID = ? and FReceivableBillID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pInfo.getId().toString(), info.getId().toString()});
            BigDecimal ntAmt = pInfo.getNtAuditedAmt() != null ? pInfo.getNtAuditedAmt() : BigDecimal.ZERO;
            BigDecimal ntSelectAmt = pInfo.getNtSelectAmt() != null ? pInfo.getNtSelectAmt() : BigDecimal.ZERO;
            BigDecimal ntBalance = BigDecimal.ZERO;
            BigDecimal billAmt = info.getBillAmt();
            ntSelectAmt = ntSelectAmt.subtract(billAmt);
            ntBalance = ntAmt.subtract(ntSelectAmt);
            pInfo.setNtSelectAmt(ntSelectAmt);
            pInfo.setNtBalance(ntBalance);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("ntSelectAmt"));
            selector.add(new SelectorItemInfo("ntBalance"));
            if (pInfo.isIsCrossOrg() && colls != null && colls.size() == 1) {
                pInfo.setIsCrossOrg(false);
                selector.add(new SelectorItemInfo("isCrossOrg"));
            }
            PaySchDetailBillFactory.getLocalInstance(ctx).updatePartial(pInfo, selector);
            info.setIsLockByBill(false);
            info.setAvailableAmt(info.getLockAmt());
            info.setLockAmt(BigDecimal.ZERO);
            this.getBizInterface(ctx).update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getId().toString())), (CoreBaseInfo)info);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void verifyOrgScheduleStatus(Context ctx, PaySchDetailBillInfo info) throws BOSException, EASBizException {
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(info.getOrgScheduleId()));
        if (orgScheduleInfo.getStatus() == StatusEnum.SCHEDULE_AUDIT || orgScheduleInfo.getStatus() == StatusEnum.ADJUST_AUDIT || orgScheduleInfo.getStatus() == StatusEnum.COMPLETE) {
            throw new PPException(PPException.STATUSCHANGE_REFRESH);
        }
    }
}

