/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.OperateBillEnum;
import com.kingdee.eas.fi.cas.PaymentBillLogFactory;
import com.kingdee.eas.fi.cas.PaymentBillLogInfo;
import com.kingdee.eas.fi.cas.PaymentOperateType;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PayPlanBillCollection;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.SrcBillTypeEnum;
import com.kingdee.eas.fm.pp.app.AbstractPayPlanBillControllerBean;
import com.kingdee.eas.fm.pp.app.service.PayPlanAddNewService;
import com.kingdee.eas.fm.pp.app.service.PayPlanSaveService;
import com.kingdee.eas.fm.pp.app.service.PayPlanSubmitService;
import com.kingdee.eas.fm.pp.app.service.handler.ServiceHandler;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayPlanBillControllerBean
extends AbstractPayPlanBillControllerBean {
    private static final long serialVersionUID = -6175226855927316366L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.PayPlanBillControllerBean");
    private static final String PAYABLEDATE = "\u5e94\u4ed8\u65e5\u671f";
    private static final String ASSTACTTYPE = "\u5f80\u6765\u6237\u7c7b\u578b";
    private static final String ASSTACTNAME = "\u5f80\u6765\u6237\u540d\u79f0";
    private static final String PAYEEACCOUNTBANK = "\u6536\u6b3e\u8d26\u53f7";
    private static final String PAYEEBANK = "\u6536\u6b3e\u5f00\u6237\u884c";
    private static final String SETFUNDPROPERTY = "\u6b3e\u9879\u6027\u8d28";
    private static final String SETTLEMENTTYPE = "\u7ed3\u7b97\u65b9\u5f0f";
    private static final String PAYERACCOUNTBANK = "\u4ed8\u6b3e\u8d26\u6237";
    private static final String PAYMENTBILLTYPE = "\u4ed8\u6b3e\u7c7b\u578b";
    private static final String CURRENCY = "\u5e01\u522b";
    private static final String APPLYPAYAMOUNT = "\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayPlanBillInfo info = (PayPlanBillInfo)model;
        PayPlanAddNewService addNewService = new PayPlanAddNewService();
        addNewService.initService(ctx, info);
        addNewService.beforeAddNew();
        IObjectPK pk = super._addnew(ctx, model);
        addNewService.afterAddNew(pk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayPlanBillInfo info = (PayPlanBillInfo)model;
        PayPlanSaveService saveService = new PayPlanSaveService();
        saveService.initService(ctx, info);
        saveService.beforeSave();
        boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (CS127) {
            this.recordPayInfoLog(ctx, info, PaymentOperateType.SAVE);
        }
        IObjectPK pk = super._save(ctx, model);
        saveService.afterSave(pk);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayPlanBillInfo info = (PayPlanBillInfo)model;
        PayPlanSubmitService submitService = new PayPlanSubmitService();
        submitService.initService(ctx, info);
        submitService.beforeSubmit();
        boolean CS127 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS127", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (CS127) {
            this.recordPayInfoLog(ctx, info, PaymentOperateType.SUBMIT);
        }
        IObjectPK pk = super._submit(ctx, model);
        submitService.afterSubmit(pk);
        return pk;
    }

    @Override
    protected void _batchSubmit(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        PayPlanBillCollection coll = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillCollection(view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                PayPlanBillInfo info = coll.get(i);
                this.submit(ctx, (CoreBaseInfo)info);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, Set idSet) throws EASBizException, BOSException {
        for (String id : idSet) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            this.delete(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws EASBizException, BOSException {
        for (String billId : idSet) {
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(billId));
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sourceBillNumber"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("auditor.id"));
        PayPlanBillCollection colls = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillCollection(view);
        StringBuffer numbers = new StringBuffer();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        for (int index = 0; index < colls.size(); ++index) {
            PayPlanBillInfo info = colls.get(index);
            if (info.getBillStatus() != BillStatusEnum.AUDIT) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_UNAUDIT")});
            }
            if (info.getSourceBillNumber() != null || info.getSourceBillType() != null || info.getSourceBillId() != null) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SourceBill_Not_UNAUDIT")});
            }
            boolean PS305 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS305", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (PS305 && userInfo != null && info.getAuditor() != null && !userInfo.getId().toString().equals(info.getAuditor().getId().toString())) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CurrentUser_Auditor_NotMatch")});
            }
            numbers.append(info.getNumber());
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        String sql = "UPDATE T_PP_PayPlanBill SET FAuditorID = null, FAuditDate = null, FBillStatus = ? , FLastUpdateUserID=?,FLastUpdateTime=?  WHERE FID IN " + ids;
        Integer status = new Integer(1);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), currTime});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new PayPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_payPlanBill_unAudit", (String)colls.get(0).getCompany().getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        this._audit4WF(ctx, pk, userInfo.getId().toString());
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, String auditorId) throws EASBizException, BOSException {
        PayPlanBillInfo info = this.getPayPlanBillInfo(ctx, pk);
        if (info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_AUDIT")});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (!EmptyUtil.isEmpty((String)auditorId)) {
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(auditorId));
        }
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(3);
        String sql = "UPDATE T_PP_PayPlanBill SET FAuditorID = ?, FAuditDate = ?, FBillStatus = ? ,FBillLastStatus = FBillStatus, FLastUpdateUserID=?,FLastUpdateTime=? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), currTime, status, userInfo.getId().toString(), currTime, pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_payPlanBill_audit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        PayPlanBillInfo info = this.getPayPlanBillInfo(ctx, pk);
        BillStatusEnum status = info.getBillStatus();
        if (status != BillStatusEnum.SUBMIT && status != BillStatusEnum.SAVE) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_DELETE")});
        }
        super._delete(ctx, pk);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_payPlanBill_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PayPlanBillInfo info = this.getPayPlanBillInfo(ctx, pk);
        if (info.getBillStatus() != BillStatusEnum.AUDIT) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_UNAUDIT")});
        }
        if (info.getSourceBillNumber() != null || info.getSourceBillType() != null || info.getSourceBillId() != null) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SourceBill_Not_UNAUDIT")});
        }
        boolean PS305 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS305", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (PS305 && userInfo != null && info.getAuditor() != null && !userInfo.getId().toString().equals(info.getAuditor().getId().toString())) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CurrentUser_Auditor_NotMatch")});
        }
        String sql = "UPDATE T_PP_PayPlanBill SET FAuditorID = null, FAuditDate = null, FBillStatus = ?,FLastUpdateUserID=?,FLastUpdateTime=? WHERE FID = ?";
        Integer status = new Integer(1);
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, userInfo.getId().toString(), currTime, pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_payPlanBill_unAudit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _backTo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PayPlanBillInfo info = this.getPayPlanBillInfo(ctx, pk);
        SrcBillTypeEnum SrcBillType = info.getSourceBillType();
        if (info.getBillStatus() != BillStatusEnum.REFUSE) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"NOREFUSE_No_BACKTO")});
        }
        if (info.getSourceBillType() == null) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"NoSourceType_No_BACKTO")});
        }
        if (info.getSourceBillId() == null || info.getSrcBillHeadID() == null) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"soueceId_srcId_NULL")});
        }
        if (info.getApplyPayAmount().compareTo(info.getSchdlBalanceAmt()) > 0) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SchdlBalanceAmt_less")});
        }
        this.delete(ctx, new IObjectPK[]{new ObjectUuidPK(info.getId())});
        String BosType = "";
        DisposerActionEnum diposeAction = null;
        try {
            if (info.getSourceBillType() == SrcBillTypeEnum.PAYREQUESTBILL) {
                BosType = new PayRequestBillInfo().getBOSType().toString();
                diposeAction = DisposerActionEnum.ANTI_AUDIT;
            } else if (SrcBillType.equals((Object)SrcBillTypeEnum.BC_BizAccountBill)) {
                BosType = new BizAccountBillInfo().getBOSType().toString();
                diposeAction = DisposerActionEnum.BC_CALLBACK;
            } else if (SrcBillType.equals((Object)SrcBillTypeEnum.BC_TravelAccountBill)) {
                BosType = new TravelAccountBillInfo().getBOSType().toString();
                diposeAction = DisposerActionEnum.BC_CALLBACK;
            } else if (SrcBillType.equals((Object)SrcBillTypeEnum.BC_DailyPurchaseAccountBill)) {
                BosType = new DailyPurchaseAccountBillInfo().getBOSType().toString();
                diposeAction = DisposerActionEnum.BC_CALLBACK;
            } else if (SrcBillType.equals((Object)SrcBillTypeEnum.BC_BizAccountOutBill)) {
                BosType = new BizAccountOutBillInfo().getBOSType().toString();
                diposeAction = DisposerActionEnum.BC_CALLBACK;
            } else if (SrcBillType.equals((Object)SrcBillTypeEnum.BC_DailyLoanBill)) {
                BosType = new DailyLoanBillInfo().getBOSType().toString();
                diposeAction = DisposerActionEnum.BC_CALLBACK;
            } else if (SrcBillType.equals((Object)SrcBillTypeEnum.BC_EvectionLoanBill)) {
                BosType = new EvectionLoanBillInfo().getBOSType().toString();
                diposeAction = DisposerActionEnum.BC_CALLBACK;
            }
            IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            botRelation.removeRelationByDestObjId(info.getId().toString(), BosType);
            ServiceHandler.dispose(ctx, info, diposeAction);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_payPlanBill_backTo");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private void recordPayInfoLog(Context ctx, PayPlanBillInfo info, PaymentOperateType operateType) throws BOSException, EASBizException {
        if (info.getId() == null || !PayPlanBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            return;
        }
        PayPlanBillInfo oldInfo = PayPlanBillFactory.getLocalInstance(ctx).getPayPlanBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelectorForLog());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection logCollection = new CoreBaseCollection();
        if (!oldInfo.getPayableDate().equals(info.getPayableDate())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYABLEDATE);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getAsstActType()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getAsstActType()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getAsstActType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getAsstActType()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getAsstActType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getAsstActType()) && !oldInfo.getAsstActType().getId().equals((Object)info.getAsstActType().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, ASSTACTTYPE);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getAsstActName()) && EmptyUtil.isEmpty((String)info.getAsstActName()) || EmptyUtil.isEmpty((String)oldInfo.getAsstActName()) && !EmptyUtil.isEmpty((String)info.getAsstActName()) || !EmptyUtil.isEmpty((String)oldInfo.getAsstActName()) && !EmptyUtil.isEmpty((String)info.getAsstActName()) && !oldInfo.getAsstActName().equals(info.getAsstActName())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, ASSTACTNAME);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getPayeeAccountBank()) && EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) || EmptyUtil.isEmpty((String)oldInfo.getPayeeAccountBank()) && !EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) || !EmptyUtil.isEmpty((String)oldInfo.getPayeeAccountBank()) && !EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) && !oldInfo.getPayeeAccountBank().equals(info.getPayeeAccountBank())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYEEACCOUNTBANK);
        }
        if (!EmptyUtil.isEmpty((String)oldInfo.getPayeeBank()) && EmptyUtil.isEmpty((String)info.getPayeeBank()) || EmptyUtil.isEmpty((String)oldInfo.getPayeeBank()) && !EmptyUtil.isEmpty((String)info.getPayeeBank()) || !EmptyUtil.isEmpty((String)oldInfo.getPayeeBank()) && !EmptyUtil.isEmpty((String)info.getPayeeBank()) && !oldInfo.getPayeeBank().equals(info.getPayeeBank())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYEEBANK);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSetFundProperty()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getSetFundProperty()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSetFundProperty()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSetFundProperty()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSetFundProperty()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSetFundProperty()) && !oldInfo.getSetFundProperty().getId().equals((Object)info.getSetFundProperty().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, SETFUNDPROPERTY);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettlementType()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettlementType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getSettlementType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType()) && !oldInfo.getSettlementType().getId().equals((Object)info.getSettlementType().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, SETTLEMENTTYPE);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAccountBank()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAccountBank()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAccountBank()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank()) && !oldInfo.getPayerAccountBank().getId().equals((Object)info.getPayerAccountBank().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYERACCOUNTBANK);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPaymentBillType()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getPaymentBillType()) || EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPaymentBillType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPaymentBillType()) || !EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPaymentBillType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getPaymentBillType()) && !oldInfo.getPaymentBillType().getId().equals((Object)info.getPaymentBillType().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, PAYMENTBILLTYPE);
        }
        if (!oldInfo.getCurrency().getId().equals((Object)info.getCurrency().getId())) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, CURRENCY);
        }
        if (oldInfo.getApplyPayAmount().compareTo(info.getApplyPayAmount()) != 0) {
            this.createPaymentLogInfo(ctx, logCollection, info, oldInfo, userInfo, currTime, operateType, APPLYPAYAMOUNT);
        }
        Date DestDate = DateTimeUtils.truncateDate((Date)this.getSrcDate(-30));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("operateTime", (Object)DestDate, CompareType.LESS_EQUALS));
        PaymentBillLogFactory.getLocalInstance((Context)ctx).delete(filter);
        PaymentBillLogFactory.getLocalInstance((Context)ctx).addnewBatchData(logCollection);
    }

    private void createPaymentLogInfo(Context ctx, CoreBaseCollection logCollection, PayPlanBillInfo info, PayPlanBillInfo oldInfo, UserInfo userInfo, Timestamp currTime, PaymentOperateType operateType, String column) {
        PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
        logInfo.setIP(ctx.getClientHostIP());
        logInfo.setOperateBillEnum(OperateBillEnum.PayPlanBill);
        logInfo.setBillNumber(info.getNumber());
        logInfo.setOperateTime(currTime);
        logInfo.setUserName(userInfo.getName());
        logInfo.setUserNumber(userInfo.getNumber());
        logInfo.setOperateType(operateType);
        logInfo.setCompany(info.getCompany());
        if (PAYABLEDATE.equals(column)) {
            logInfo.setUpdateColumn(PAYABLEDATE);
            if (oldInfo.getPayableDate() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getPayableDate()));
            }
            if (info.getPayableDate() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getPayableDate()));
            }
        } else if (ASSTACTTYPE.equals(column)) {
            logInfo.setUpdateColumn(ASSTACTTYPE);
            logInfo.setUpdateBefore("\u5176\u4ed6");
            if (oldInfo.getAsstActType() != null) {
                logInfo.setUpdateBefore(oldInfo.getAsstActType().getName());
            }
            logInfo.setUpdateAfter("\u5176\u4ed6");
            if (info.getAsstActType() != null) {
                logInfo.setUpdateAfter(info.getAsstActType().getName());
            }
        } else if (ASSTACTNAME.equals(column)) {
            logInfo.setUpdateColumn(ASSTACTNAME);
            if (oldInfo.getAsstActName() != null) {
                logInfo.setUpdateBefore(oldInfo.getAsstActName());
            }
            if (info.getAsstActName() != null) {
                logInfo.setUpdateAfter(info.getAsstActName());
            }
        } else if (PAYEEACCOUNTBANK.equals(column)) {
            logInfo.setUpdateColumn(PAYEEACCOUNTBANK);
            if (oldInfo.getPayeeAccountBank() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayeeAccountBank());
            }
            if (info.getPayeeAccountBank() != null) {
                logInfo.setUpdateAfter(info.getPayeeAccountBank());
            }
        } else if (PAYEEBANK.equals(column)) {
            logInfo.setUpdateColumn(PAYEEBANK);
            if (oldInfo.getPayeeBank() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayeeBank());
            }
            if (info.getPayeeBank() != null) {
                logInfo.setUpdateAfter(info.getPayeeBank());
            }
        } else if (SETFUNDPROPERTY.equals(column)) {
            logInfo.setUpdateColumn(SETFUNDPROPERTY);
            if (oldInfo.getSetFundProperty() != null) {
                logInfo.setUpdateBefore(oldInfo.getSetFundProperty().getName());
            }
            if (info.getSetFundProperty() != null) {
                logInfo.setUpdateAfter(info.getSetFundProperty().getName());
            }
        } else if (SETTLEMENTTYPE.equals(column)) {
            logInfo.setUpdateColumn(SETTLEMENTTYPE);
            if (oldInfo.getSettlementType() != null) {
                logInfo.setUpdateBefore(oldInfo.getSettlementType().getName());
            }
            if (info.getSettlementType() != null) {
                logInfo.setUpdateAfter(info.getSettlementType().getName());
            }
        } else if (PAYERACCOUNTBANK.equals(column)) {
            logInfo.setUpdateColumn(PAYERACCOUNTBANK);
            if (oldInfo.getPayerAccountBank() != null) {
                logInfo.setUpdateBefore(oldInfo.getPayerAccountBank().getName());
            }
            if (info.getPayerAccountBank() != null) {
                logInfo.setUpdateAfter(info.getPayerAccountBank().getName());
            }
        } else if (PAYMENTBILLTYPE.equals(column)) {
            logInfo.setUpdateColumn(PAYMENTBILLTYPE);
            if (oldInfo.getPaymentBillType() != null) {
                logInfo.setUpdateBefore(oldInfo.getPaymentBillType().getName());
            }
            if (info.getPaymentBillType() != null) {
                logInfo.setUpdateAfter(info.getPaymentBillType().getName());
            }
        } else if (CURRENCY.equals(column)) {
            logInfo.setUpdateColumn(CURRENCY);
            if (oldInfo.getCurrency() != null) {
                logInfo.setUpdateBefore(oldInfo.getCurrency().getName());
            }
            if (info.getCurrency() != null) {
                logInfo.setUpdateAfter(info.getCurrency().getName());
            }
        } else if (APPLYPAYAMOUNT.equals(column)) {
            logInfo.setUpdateColumn(APPLYPAYAMOUNT);
            if (oldInfo.getApplyPayAmount() != null) {
                logInfo.setUpdateBefore(String.valueOf(oldInfo.getApplyPayAmount().setScale(4, 4)));
            }
            if (info.getApplyPayAmount() != null) {
                logInfo.setUpdateAfter(String.valueOf(info.getApplyPayAmount().setScale(4, 4)));
            }
        }
        logCollection.add((CoreBaseInfo)logInfo);
    }

    private Date getSrcDate(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + days);
        return calendar.getTime();
    }

    private SelectorItemCollection getSelectorForLog() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("setFundProperty.id"));
        sic.add(new SelectorItemInfo("setFundProperty.name"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("SettlementType.name"));
        sic.add(new SelectorItemInfo("payerAccountBank.id"));
        sic.add(new SelectorItemInfo("payerAccountBank.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("paymentBillType.id"));
        sic.add(new SelectorItemInfo("paymentBillType.name"));
        return sic;
    }
}

