/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.pp.ISetFundProperty;
import com.kingdee.eas.fm.pp.SetFundPropertyCollection;
import com.kingdee.eas.fm.pp.SetFundPropertyFactory;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayRecPlanDataImportUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.PayRecPlanDataImportUtil");

    public static CompanyOrgUnitInfo getCompanyByNumber(Context ctx, String number) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        CompanyOrgUnitInfo company = null;
        try {
            ICompanyOrgUnit iCompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection coll = iCompanyOrg.getCompanyOrgUnitCollection("where number='" + number.trim() + "'");
            if (coll == null || coll.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"184_RecAndPayDataImportUtil", (Locale)ctx.getLocale()));
            }
            company = coll.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        return company;
    }

    public static CurrencyInfo getCurrencyByNumber(Context ctx, String number) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        CurrencyInfo currency = null;
        ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection collection = icurrency.getCurrencyCollection("where number='" + number.trim() + "' or name ='" + number.trim() + "'");
        if (collection == null || collection.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"185_RecAndPayDataImportUtil", (Locale)ctx.getLocale()));
        }
        currency = collection.get(0);
        return currency;
    }

    public static SetFundPropertyInfo getSetFundPropertyByNumber(Context ctx, String number, String comanyId) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        SetFundPropertyInfo setFundProperty = null;
        ISetFundProperty iSetFundProperty = SetFundPropertyFactory.getLocalInstance(ctx);
        SetFundPropertyCollection collection = iSetFundProperty.getSetFundPropertyCollection("where (number='" + number.trim() + "' or name='" + number.trim() + "') and company.id = '" + comanyId + "'");
        if (collection == null || collection.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"setFundProperty_NotMatch_Error", (Locale)ctx.getLocale()));
        }
        setFundProperty = collection.get(0);
        return setFundProperty;
    }

    public static AccountBankInfo getAccountBankByNumber(Context ctx, String fieldName, String companyid, String number, boolean flag, boolean isbyBankNumber) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        AccountBankInfo accountBank = null;
        IAccountBank iaccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (isbyBankNumber) {
            fi.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)number.trim()));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
        }
        if (companyid != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        }
        view.setFilter(fi);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("InnerAcct.*"));
        AccountBankCollection collection = iaccountBank.getAccountBankCollection(view);
        if (collection != null && collection.size() > 0) {
            accountBank = collection.get(0);
        } else if (flag) {
            throw new BOSException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"4_AgentPayBillDataImportUtil", (String[])new String[]{fieldName, fieldName}));
        }
        return accountBank;
    }

    public static AdminOrgUnitInfo getDepartmentByNumber(Context ctx, String number) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        AdminOrgUnitInfo departmentInfo = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
            view.setFilter(fi);
            AdminOrgUnitCollection collection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
            if (collection == null || collection.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"435_RecAndPayDataImportUtil2", (Locale)ctx.getLocale()));
            }
            departmentInfo = collection.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        return departmentInfo;
    }

    public static SettlementTypeInfo getSettlementTypeByNumber(Context ctx, String number) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        SettlementTypeInfo settlementType = null;
        try {
            ISettlementType iSettlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
            view.setFilter(fi);
            SettlementTypeCollection collection = iSettlementType.getSettlementTypeCollection(view);
            if (collection == null || collection.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"SettlementType_Error", (Locale)ctx.getLocale()));
            }
            settlementType = collection.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        return settlementType;
    }

    public static AsstActTypeInfo getAsstActTypeByNumber(Context ctx, String fieldName, String number) throws BOSException {
        if (EmptyUtil.isEmpty((String)number)) {
            return null;
        }
        AsstActTypeInfo asstActType = null;
        try {
            IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            IAsstActTypeDefault iAsstDefault = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("asstActType.number", (Object)number.trim()));
            evi.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("asstActType.id"));
            sic.add(new SelectorItemInfo("asstActType.*"));
            evi.getSelector().addObjectCollection((IObjectCollection)sic);
            AsstActTypeDefaultCollection defaultColl = iAsstDefault.getAsstActTypeDefaultCollection(evi);
            if (defaultColl == null || defaultColl.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"192_RecAndPayDataImportUtil", (Locale)ctx.getLocale(), (Object[])new Object[]{fieldName, fieldName}));
            }
            asstActType = defaultColl.get(0).getAsstActType();
            asstActType = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActType.getId()));
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
        return asstActType;
    }

    public static IRowSet getAsstActInfo(AsstActTypeInfo asstActType, String number, Context ctx) throws BOSException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String groupID = null;
        GeneralAsstActTypeGroupCollection col = GeneralAsstActTypeGroupFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeGroupCollection("select * where number = '" + asstActType.getNumber() + "'");
        IRowSet rs = null;
        if (col == null || col.size() == 0) {
            String tableName = asstActType.getRealtionDataObject();
            StringBuffer sb = new StringBuffer(128);
            if (tableName.equalsIgnoreCase("T_BD_SUPPLIER") || tableName.equalsIgnoreCase("T_BD_CUSTOMER")) {
                sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
                sb.append(tableName);
                sb.append(" where fusedstatus = 1 and Fnumber='");
                sb.append(number);
                sb.append("'");
            } else {
                sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
                sb.append(tableName);
                sb.append(" where Fnumber='");
                sb.append(number);
                sb.append("'");
            }
            ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
            try {
                rs = sqlExe.executeSQL();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            if (rs == null || rs.size() == 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"195_RecAndPayDataImportUtil", (Locale)ctx.getLocale()));
            }
        } else {
            GeneralAsstActTypeGroupInfo groupInfo = col.get(0);
            groupID = col.get(0).getId().toString();
            number = number.replace('.', '!');
            String tableName = asstActType.getRealtionDataObject();
            StringBuffer sb = new StringBuffer(128);
            if (tableName.equalsIgnoreCase("T_BD_SUPPLIER") || tableName.equalsIgnoreCase("T_BD_CUSTOMER")) {
                sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
                sb.append(tableName);
                sb.append(" where fusedstatus = 1 and fLongnumber='");
                sb.append(number);
                sb.append("'");
                sb.append(" and FGroupID = '");
                sb.append(groupID);
                sb.append("'");
            } else {
                sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
                sb.append(tableName);
                sb.append(" where fLongnumber='");
                sb.append(number);
                sb.append("'");
                sb.append(" and FGroupID = '");
                sb.append(groupID);
                sb.append("'");
            }
            sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
            sb.append(tableName);
            sb.append(" where fLongnumber='");
            sb.append(number);
            sb.append("'");
            sb.append(" and FGroupID = '");
            sb.append(groupID);
            sb.append("'");
            if (groupInfo.getShareTactic() == ShareTacticEnum.I) {
                sb.append(" and FControlUnitID = '");
                sb.append(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit().getId().toString());
                sb.append("'");
            }
            ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
            try {
                rs = sqlExe.executeSQL();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            if (rs == null || rs.size() == 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"195_RecAndPayDataImportUtil", (Locale)ctx.getLocale()));
            }
        }
        return rs;
    }

    public static IRowSet getAsstActInfoByName(AsstActTypeInfo asstActType, String name, Context ctx) throws BOSException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String groupID = null;
        GeneralAsstActTypeGroupCollection col = GeneralAsstActTypeGroupFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeGroupCollection("select * where number = '" + asstActType.getNumber() + "'");
        IRowSet rs = null;
        if (col == null || col.size() == 0) {
            String tableName = asstActType.getRealtionDataObject();
            StringBuffer sb = new StringBuffer(128);
            if (tableName.equalsIgnoreCase("T_BD_SUPPLIER") || tableName.equalsIgnoreCase("T_BD_CUSTOMER")) {
                sb.append("select fid,fnumber,fname_").append(loc).append(",fusedstatus from ");
                sb.append(tableName);
                sb.append(" where fusedstatus = 1 and fname_").append(loc).append("= '");
                sb.append(name);
                sb.append("'");
            } else {
                sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
                sb.append(tableName);
                sb.append(" where fname_").append(loc).append("= '");
                sb.append(name);
                sb.append("'");
            }
            ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
            try {
                rs = sqlExe.executeSQL();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            if (rs == null || rs.size() == 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"195_RecAndPayDataImportUtil", (Locale)ctx.getLocale()));
            }
        } else {
            GeneralAsstActTypeGroupInfo groupInfo = col.get(0);
            groupID = col.get(0).getId().toString();
            String tableName = asstActType.getRealtionDataObject();
            StringBuffer sb = new StringBuffer(128);
            if (tableName.equalsIgnoreCase("T_BD_SUPPLIER") || tableName.equalsIgnoreCase("T_BD_CUSTOMER")) {
                sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
                sb.append(tableName);
                sb.append(" where fusedstatus = 1 and fname_").append(loc).append("= '");
                sb.append(name);
                sb.append("'");
                sb.append(" and FGroupID = '");
                sb.append(groupID);
                sb.append("'");
            } else {
                sb.append("select fid,fnumber,fname_").append(loc).append("  from ");
                sb.append(tableName);
                sb.append(" where  fname_").append(loc).append("= '");
                sb.append(name);
                sb.append("'");
                sb.append(" and FGroupID = '");
                sb.append(groupID);
                sb.append("'");
            }
            if (groupInfo.getShareTactic() == ShareTacticEnum.I) {
                sb.append(" and FControlUnitID = '");
                sb.append(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit().getId().toString());
                sb.append("'");
            }
            ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
            try {
                rs = sqlExe.executeSQL();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            if (rs == null || rs.size() == 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PpResource", (String)"AsstActName__Error", (Locale)ctx.getLocale()));
            }
        }
        return rs;
    }

    public static BigDecimal objToBigDecimal(Context ctx, Object obj) throws BOSException {
        if (EmptyUtil.isEmpty((Object)obj)) {
            return null;
        }
        if (obj instanceof String && EmptyUtil.isEmpty((String)obj.toString())) {
            return null;
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)obj);
        }
        catch (Exception e) {
            throw new BOSException(obj + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"196_RecAndPayDataImportUtil", (Locale)ctx.getLocale()));
        }
        return value;
    }

    public static BigDecimal getLocAmount(Context ctx, String companyId, String currencyId, CurrencyInfo baseCurrency, BigDecimal amount, Date payableDate) throws EASBizException, BOSException {
        BigDecimal locAmount = BigDecimal.ZERO;
        Map exchangeRate = CASCommonWebFacadeFactory.getLocalInstance((Context)ctx).getExchangeRate(companyId, currencyId, payableDate);
        BigDecimal value = (BigDecimal)exchangeRate.get("exchangeRate");
        if (value.doubleValue() == 0.0) {
            value = new BigDecimal("1");
        }
        boolean isIndirectRate = (Integer)exchangeRate.get("isIndirectRate") == Integer.valueOf(1);
        int precision = baseCurrency.getPrecision();
        locAmount = isIndirectRate ? amount.divide(value, precision, 4) : amount.multiply(value);
        locAmount = locAmount.setScale(precision, 4);
        return locAmount;
    }
}

