/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.framework.DataStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PlanSourceSettingCompanyCollection;
import com.kingdee.eas.fm.pp.PlanSourceSettingFactory;
import com.kingdee.eas.fm.pp.PlanSourceSettingInfo;
import com.kingdee.eas.fm.pp.PlanSourceSettingRuleCollection;
import com.kingdee.eas.fm.pp.app.AbstractPlanSourceSettingControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PlanSourceSettingControllerBean
extends AbstractPlanSourceSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.PlanSourceSettingControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PlanSourceSettingInfo info = PlanSourceSettingFactory.getLocalInstance(ctx).getPlanSourceSettingInfo(pk);
        if (info.getState().equals((Object)DataStateEnum.ENABLE)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"92_PlanSourceSettingControllerBean", (Locale)ctx.getLocale())});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlanSourceSettingInfo info = (PlanSourceSettingInfo)model;
        this.verifyBillTypeUnique(info);
        this.verifyCompanyUnique(info);
        this.verifyCompanyAndBillTypeUnique(ctx, info);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        info.setStartDate(ts);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PlanSourceSettingInfo info = (PlanSourceSettingInfo)model;
        this.verifyBillTypeUnique(info);
        this.verifyCompanyUnique(info);
        this.verifyCompanyAndBillTypeUnique(ctx, info);
        super._update(ctx, pk, model);
    }

    protected void verifyCompanyAndBillTypeUnique(Context ctx, PlanSourceSettingInfo info) throws BOSException, EASBizException {
        PlanSourceSettingRuleCollection ruleSettingCol = info.getRuleSetting();
        PlanSourceSettingCompanyCollection companySettingCol = info.getCompanySetting();
        String sql = " select main.fid id,main.Fnumber number from T_PP_PlanSourceSetting main  left join T_PP_PlanSourceSettingCompany tCompany on main.fid=tCompany.FPlanSourceSettingID  left join T_PP_PlanSourceSettingRule tRule on main.fid=tRule.FPlanSourceSettingID  where tCompany.FCompanyID = ? and tRule.FBillTypeID=? ";
        for (int ruleIndex = 0; ruleIndex < ruleSettingCol.size(); ++ruleIndex) {
            String billTypeId = ruleSettingCol.get(ruleIndex).getBillType().getId().toString();
            String billTypeName = ruleSettingCol.get(ruleIndex).getBillType().getName();
            for (int companyIndex = 0; companyIndex < companySettingCol.size(); ++companyIndex) {
                String companyId = companySettingCol.get(companyIndex).getCompany().getId().toString();
                String companyName = companySettingCol.get(companyIndex).getCompany().getName();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId, billTypeId});
                try {
                    while (rs.next()) {
                        String settingId = rs.getString("id");
                        String settingNumber = rs.getString("number");
                        if (EmptyUtil.isEmpty((Object)info.getId())) {
                            throw new PPException(PPException.PLANSOURCESETTING_COMPANYBILLTYPE_UNIQUE, new Object[]{settingNumber, companyName, billTypeName});
                        }
                        if (info.getId().toString().equals(settingId)) continue;
                        throw new PPException(PPException.PLANSOURCESETTING_COMPANYBILLTYPE_UNIQUE, new Object[]{settingNumber, companyName, billTypeName});
                    }
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage());
                }
            }
        }
    }

    protected void verifyCompanyUnique(PlanSourceSettingInfo info) throws BOSException, EASBizException {
        PlanSourceSettingCompanyCollection companySettingCol = info.getCompanySetting();
        HashSet<String> companySet = new HashSet<String>();
        if (companySettingCol.size() <= 0) {
            throw new PPException(PPException.PLANSOURCESETTING_COMPANY_NULL);
        }
        for (int i = 0; i < companySettingCol.size(); ++i) {
            String companyId = companySettingCol.get(i).getCompany().getId().toString();
            String companyName = companySettingCol.get(i).getCompany().getName();
            if (companySet.contains(companyId)) {
                throw new PPException(PPException.PLANSOURCESETTING_COMPANY_UNIQUE, new Object[]{companyName});
            }
            companySet.add(companyId);
        }
    }

    protected void verifyBillTypeUnique(PlanSourceSettingInfo info) throws BOSException, EASBizException {
        PlanSourceSettingRuleCollection ruleSettingCol = info.getRuleSetting();
        HashSet<String> billTypeSet = new HashSet<String>();
        if (ruleSettingCol.size() <= 0) {
            throw new PPException(PPException.PLANSOURCESETTING_RULE_NULL);
        }
        for (int i = 0; i < ruleSettingCol.size(); ++i) {
            if (EmptyUtil.isEmpty((Object)((Object)ruleSettingCol.get(i).getBizSource())) || EmptyUtil.isEmpty((CoreBaseInfo)ruleSettingCol.get(i).getBillType()) || EmptyUtil.isEmpty((String)ruleSettingCol.get(i).getBotpRule())) {
                throw new PPException(PPException.PLANSOURCESETTING_RULE_SOMENULL);
            }
            String billTypeId = ruleSettingCol.get(i).getBillType().getId().toString();
            String billTypeName = ruleSettingCol.get(i).getBillType().getName();
            if (billTypeSet.contains(billTypeId)) {
                throw new PPException(PPException.PLANSOURCESETTING_BILLTYPE_UNIQUE, new Object[]{billTypeName});
            }
            billTypeSet.add(billTypeId);
        }
    }
}

