/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.RecPlanBillCollection;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.app.AbstractRecPlanBillControllerBean;
import com.kingdee.eas.fm.pp.app.service.RecPlanAddNewService;
import com.kingdee.eas.fm.pp.app.service.RecPlanSaveService;
import com.kingdee.eas.fm.pp.app.service.RecPlanSubmitService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecPlanBillControllerBean
extends AbstractRecPlanBillControllerBean {
    private static final long serialVersionUID = -4648582044299062855L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.RecPlanBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecPlanBillInfo info = (RecPlanBillInfo)model;
        RecPlanAddNewService addNewService = new RecPlanAddNewService();
        addNewService.initService(ctx, info);
        addNewService.beforeAddNew();
        IObjectPK pk = super._addnew(ctx, model);
        addNewService.afterAddNew(pk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecPlanBillInfo info = (RecPlanBillInfo)model;
        RecPlanSaveService saveService = new RecPlanSaveService();
        saveService.initService(ctx, info);
        saveService.beforeSave();
        IObjectPK pk = super._save(ctx, model);
        saveService.afterSave(pk);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecPlanBillInfo info = (RecPlanBillInfo)model;
        RecPlanSubmitService submitService = new RecPlanSubmitService();
        submitService.initService(ctx, info);
        submitService.beforeSubmit();
        IObjectPK pk = super._submit(ctx, model);
        submitService.afterSubmit(pk);
        return pk;
    }

    @Override
    protected void _batchSubmit(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        RecPlanBillCollection coll = RecPlanBillFactory.getLocalInstance(ctx).getRecPlanBillCollection(view);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                RecPlanBillInfo info = coll.get(i);
                this.submit(ctx, (CoreBaseInfo)info);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, Set idSet) throws EASBizException, BOSException {
        for (String id : idSet) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            this.delete(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws EASBizException, BOSException {
        for (String billId : idSet) {
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(billId));
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sourceBillNumber"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("auditor.id"));
        RecPlanBillCollection colls = RecPlanBillFactory.getLocalInstance(ctx).getRecPlanBillCollection(view);
        StringBuffer numbers = new StringBuffer();
        for (int index = 0; index < colls.size(); ++index) {
            UserInfo userInfo;
            RecPlanBillInfo info = colls.get(index);
            if (info.getBillStatus() != BillStatusEnum.AUDIT) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_UNAUDIT")});
            }
            if (info.getSourceBillNumber() != null || info.getSourceBillType() != null || info.getSourceBillId() != null) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SourceBill_Not_UNAUDIT")});
            }
            boolean PS305 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS305", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (PS305 && (userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null && info.getAuditor() != null && !userInfo.getId().toString().equals(info.getAuditor().getId().toString())) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CurrentUser_Auditor_NotMatch")});
            }
            numbers.append(info.getNumber());
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        String sql = "UPDATE T_PP_RecPlanBill SET FAuditorID = null, FAuditDate = null, FBillStatus = ? WHERE FID IN " + ids;
        Integer status = new Integer(1);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new RecPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_recPlanBill_unAudit", (String)colls.get(0).getCompany().getId().toString(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        this._audit4WF(ctx, pk, userInfo.getId().toString());
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, String auditorId) throws EASBizException, BOSException {
        RecPlanBillInfo info = this.getRecPlanBillInfo(ctx, pk);
        if (info.getBillStatus() != BillStatusEnum.SUBMIT) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_AUDIT")});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (!EmptyUtil.isEmpty((String)auditorId)) {
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(auditorId));
        }
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(3);
        String sql = "UPDATE T_PP_RecPlanBill SET FAuditorID = ?, FAuditDate = ?, FBillStatus = ?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), currTime, status, pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_recPlanBill_audit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        RecPlanBillInfo info = this.getRecPlanBillInfo(ctx, pk);
        BillStatusEnum status = info.getBillStatus();
        if (status != BillStatusEnum.SUBMIT && status != BillStatusEnum.SAVE) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_DELETE")});
        }
        super._delete(ctx, pk);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_recPlanBill_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo;
        RecPlanBillInfo info = this.getRecPlanBillInfo(ctx, pk);
        if (info.getBillStatus() != BillStatusEnum.AUDIT) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_UNAUDIT")});
        }
        if (info.getSourceBillNumber() != null || info.getSourceBillType() != null || info.getSourceBillId() != null) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SourceBill_Not_UNAUDIT")});
        }
        boolean PS305 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS305", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (PS305 && (userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null && info.getAuditor() != null && !userInfo.getId().toString().equals(info.getAuditor().getId().toString())) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CurrentUser_Auditor_NotMatch")});
        }
        String sql = "UPDATE T_PP_RecPlanBill SET FAuditorID = null, FAuditDate = null, FBillStatus = ? WHERE FID = ? ";
        Integer status = new Integer(1);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, pk.toString()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getLogInfo(), (String)"pp_recPlanBill_unAudit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }
}

