/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.ps.EnableStatusEnum;
import com.kingdee.eas.fm.ps.FundPropertyCollection;
import com.kingdee.eas.fm.ps.FundPropertyInfo;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.app.AbstractFundPropertyControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import org.apache.log4j.Logger;

public class FundPropertyControllerBean
extends AbstractFundPropertyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.FundPropertyControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"name");
        this.checkNameDup(ctx, model);
        FundPropertyInfo info = (FundPropertyInfo)model;
        info.setDeletedStatus(EnableStatusEnum.ENABLE);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"name");
        this.checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FundPropertyInfo info = (FundPropertyInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (super.exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)info, "number") + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private void checkNameDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FundPropertyInfo info = (FundPropertyInfo)model;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("id"));
        entityViewInfo.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        entityViewInfo.setFilter(filter);
        FundPropertyCollection colls = this.getFundPropertyCollection(ctx, entityViewInfo);
        if (colls != null && colls.size() > 0) {
            throw new PSException(PSException.FUNDPRO_NAME_EXIST, new Object[]{info.getName()});
        }
    }
}

