/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.model.MsgInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.ps.BillStatusEnum;
import com.kingdee.eas.fm.ps.DecomposeBillCollection;
import com.kingdee.eas.fm.ps.DecomposeBillEntryInfo;
import com.kingdee.eas.fm.ps.DecomposeBillFactory;
import com.kingdee.eas.fm.ps.DecomposeBillInfo;
import com.kingdee.eas.fm.ps.DecomposeBillStatusEnum;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.PayPlanSumSettleEntryCollection;
import com.kingdee.eas.fm.ps.PayPlanSumSettleEntryInfo;
import com.kingdee.eas.fm.ps.PayPlanSumaryCollection;
import com.kingdee.eas.fm.ps.PayPlanSumaryFactory;
import com.kingdee.eas.fm.ps.PayPlanSumaryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingInfo;
import com.kingdee.eas.fm.ps.ReportTypeEnum;
import com.kingdee.eas.fm.ps.SettlementCategoryInfo;
import com.kingdee.eas.fm.ps.SettlementPrioritySettingCollection;
import com.kingdee.eas.fm.ps.SummaryBillStatusEnum;
import com.kingdee.eas.fm.ps.app.AbstractPayPlanSumaryControllerBean;
import com.kingdee.eas.fm.ps.app.service.DecomposeBillService;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayPlanSumaryControllerBean
extends AbstractPayPlanSumaryControllerBean {
    private static final long serialVersionUID = -6008218662722004879L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.PayPlanSumaryControllerBean");
    public static final String PS_RES = "com.kingdee.eas.fm.ps.PsResource";
    private static final String PERM_ITEM_SAVE = "ps_payPlanSummary_03save";
    private static final String PERM_ITEM_SUBMIT = "ps_payPlanSummary_04submit";
    private static final String PERM_ITEM_AUDIT = "ps_payPlanSummary_07audit";
    private static final String PERM_ITEM_ANTIAUDIT = "ps_payPlanSummary_08unaudit";
    private static final String PERM_ITEM_DECOMPOSE = "ps_payPlanSummary_09decompose";
    private static final String PERM_ITEM_CANCELSUMARY = "ps_payPlanSummary_10cancel";

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company;
        PaymentScheduleSettingInfo payScheduleInfo;
        BOSUuid id = model.getId();
        PayPlanSumaryInfo info = this.getPayPlanSumInfo(ctx, model);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_SAVE);
        if (!isPermission) {
            throw new PSException(PSException.NO_SAVE_AUTH);
        }
        if (info.getBillStatus() != null && info.getBillStatus() != SummaryBillStatusEnum.SAVE) {
            throw new BOSException(PSUtils.getResource(ctx, "066_BILL_NOT_SAVE", null));
        }
        info.setBillStatus(SummaryBillStatusEnum.SAVE);
        if (id == null && (payScheduleInfo = PSUtils.getPaymentScheduleInfo(ctx, (company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()))).getCU().getId().toString())) != null && payScheduleInfo.isIsBySettleType()) {
            SettlementPrioritySettingCollection settlePriSettingColls = PSUtils.getSettlePriColls(ctx, payScheduleInfo.getId().toString());
            this.addPlanSummarySettleCateryEntrys(settlePriSettingColls, info);
        }
        return super.save(ctx, (CoreBaseInfo)info);
    }

    private void addPlanSummarySettleCateryEntrys(SettlementPrioritySettingCollection settlePriSettingColls, PayPlanSumaryInfo sumInfo) {
        block7: for (int i = 0; i < settlePriSettingColls.size(); ++i) {
            SettlementCategoryInfo categoryInfo = settlePriSettingColls.get(i).getCategory();
            SettlementTypeInfo settleInfo = settlePriSettingColls.get(i).getDefaultSettleType();
            PayPlanSumSettleEntryInfo payPlanSumSettleEntryInfo = new PayPlanSumSettleEntryInfo();
            payPlanSumSettleEntryInfo.setSettleCategory(categoryInfo);
            payPlanSumSettleEntryInfo.setApproveAmt(new BigDecimal("0"));
            payPlanSumSettleEntryInfo.setParent(sumInfo);
            payPlanSumSettleEntryInfo.setSettleType(settleInfo);
            sumInfo.getSettleEntries().add(payPlanSumSettleEntryInfo);
            switch (i + 1) {
                case 1: {
                    sumInfo.setSettleCate1(categoryInfo);
                    sumInfo.setApproveAmt1(new BigDecimal("0"));
                    continue block7;
                }
                case 2: {
                    sumInfo.setSettleCate2(categoryInfo);
                    sumInfo.setApproveAmt2(new BigDecimal("0"));
                    continue block7;
                }
                case 3: {
                    sumInfo.setSettleCate3(categoryInfo);
                    sumInfo.setApproveAmt3(new BigDecimal("0"));
                    continue block7;
                }
                case 4: {
                    sumInfo.setSettleCate4(categoryInfo);
                    sumInfo.setApproveAmt4(new BigDecimal("0"));
                    continue block7;
                }
                case 5: {
                    sumInfo.setSettleCate5(categoryInfo);
                    sumInfo.setApproveAmt5(new BigDecimal("0"));
                    continue block7;
                }
            }
        }
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        BOSUuid id = model.getId();
        PayPlanSumaryInfo info = this.getPayPlanSumInfo(ctx, model);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_SUBMIT);
        if (!isPermission) {
            throw new PSException(PSException.NO_SUBMIT_AUTH);
        }
        if (info.getBillStatus() != null && info.getBillStatus() != SummaryBillStatusEnum.SAVE && info.getBillStatus() != SummaryBillStatusEnum.SUBMIT) {
            throw new BOSException(PSUtils.getResource(ctx, "067_BILL_NOT_SAVE_SUBMIT", null));
        }
        info.setBillStatus(SummaryBillStatusEnum.SUBMIT);
        return super.submit(ctx, (CoreBaseInfo)info);
    }

    private PayPlanSumaryInfo getPayPlanSumInfo(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        PayPlanSumaryInfo info = (PayPlanSumaryInfo)model;
        if (info.getId() != null) {
            PayPlanSumaryInfo newInfo = PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            newInfo.setDepartment(info.getDepartment());
            newInfo.setAsstActID(info.getAsstActID());
            newInfo.setAsstActType(info.getAsstActType());
            newInfo.setAsstActNumber(info.getAsstActNumber());
            newInfo.setAsstActName(info.getAsstActName());
            newInfo.setFundFlowItem(info.getFundFlowItem());
            newInfo.setFundProperty(info.getFundProperty());
            newInfo.setSettlementType(info.getSettlementType());
            newInfo.setPayerAccountBank(info.getPayerAccountBank());
            newInfo.setPaymentMode(info.getPaymentMode());
            newInfo.setApplyPayAmt(info.getApplyPayAmt());
            info = newInfo;
        } else if (info.getNumber() == null || info.getNumber().equals("")) {
            String number = PSUtils.initNumber(ctx, info, info.getCompany().getId().toString());
            info.setNumber(number);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _cancelSummary(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        if (result.getSummaryMsg() != null) {
            return result;
        }
        int success = 0;
        String summary = PSUtils.getResource(ctx, "008_BILL_SUM", new String[]{idSet.size() + ""});
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        try {
            PayPlanSumaryCollection payPlanSumaryColls = this.getSummaryCollection(ctx, idSet);
            for (int i = 0; i < payPlanSumaryColls.size(); ++i) {
                PayPlanSumaryInfo info = payPlanSumaryColls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_CANCELSUMARY);
                    if (!isPermission) {
                        throw new PSException(PSException.NO_CANCEL_SUMARY_AUTH);
                    }
                    if (info.getReportType() == ReportTypeEnum.EMERGENCY) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "037_CANCEL_SUMMARY_FAIL", new String[]{info.getNumber(), PSUtils.getResource(ctx, "038_EMERGEBILL_CANEL_SUMARY", null)}));
                        continue;
                    }
                    if (info.getBillStatus() != SummaryBillStatusEnum.SAVE && info.getBillStatus() != SummaryBillStatusEnum.SUBMIT) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "037_CANCEL_SUMMARY_FAIL", new String[]{info.getNumber(), PSUtils.getResource(ctx, "039_BILLSTATE_NOTSAVE", null)}));
                        continue;
                    }
                    if (PSUtils.isInWorkFlow(ctx, info.getId().toString())) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "037_CANCEL_SUMMARY_FAIL", new String[]{info.getNumber(), PSUtils.getResource(ctx, "040_IN_WOKFLOW", null)}));
                        continue;
                    }
                    Boolean noLocked = (Boolean)requestMap.get(info.getId().toString());
                    if (!noLocked.booleanValue()) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "037_CANCEL_SUMMARY_FAIL", new String[]{info.getNumber(), PSUtils.getResource(ctx, "041_BILL_HAS_LOCK", null)}));
                        continue;
                    }
                    this.reversePayPlanBill(ctx, info.getPaymentPlanEntrys());
                    info.getPaymentPlanEntrys().clear();
                    this.delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource(ctx, "037_CANCEL_SUMMARY_FAIL", new String[]{info.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        summary = success == idSet.size() ? summary + PSUtils.getResource(ctx, "042_ALL_CANCEL_SUM_SUCC", null) : summary + PSUtils.getResource(ctx, "043_CANCEL_SUM_TITLE", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void reversePayPlanBill_back(Context ctx, PaymentPlanBillCollection paymentPlanBillColls) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < paymentPlanBillColls.size(); ++i) {
            PaymentPlanBillInfo info = paymentPlanBillColls.get(i);
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setIsSummary(false);
            info.setPlanSumary(null);
            info.setAuditDate(null);
            info.setAuditor(null);
            info.setSumBillStatus(null);
            colls.add((CoreBaseInfo)info);
        }
    }

    private void reversePayPlanBill(Context ctx, PaymentPlanBillCollection colls) throws BOSException {
        StringBuffer sql = new StringBuffer("update T_PS_PaymentPlanBill set FBillStatus = 3,FIsSummary = 0,FPlanSumaryID = null,FAuditDate = null,FAuditorID = null,FSumBillStatus = null where fid in (");
        int paramLen = colls.size();
        for (int i = 0; i < paramLen; ++i) {
            if (i != 0) {
                sql.append(",?");
                continue;
            }
            sql.append("?");
        }
        sql.append(" )");
        Object[] params = new Object[paramLen];
        for (int i = 0; i < paramLen; ++i) {
            PaymentPlanBillInfo info = colls.get(i);
            params[i] = info.getId().toString();
        }
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(PSUtils.getResource(ctx, "044_REVERSE_PAYPLAN_FAIL", null), (Throwable)e);
        }
    }

    private PayPlanSumaryCollection getSummaryCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        sel.add(new SelectorItemInfo("paymentPlanEntrys"));
        entityViewInfo.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        return PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryCollection(entityViewInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        if (result.getSummaryMsg() != null) {
            return result;
        }
        int success = 0;
        String summary = PSUtils.getResource(ctx, "008_BILL_SUM", new String[]{idSet.size() + ""});
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        try {
            PayPlanSumaryCollection payPlanSumaryColls = this.getSummaryCollection(ctx, idSet);
            UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            for (int i = 0; i < payPlanSumaryColls.size(); ++i) {
                PayPlanSumaryInfo info = payPlanSumaryColls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_AUDIT);
                    if (!isPermission) {
                        String msg = PSUtils.getResource(ctx, "133_NO_SUM_AUDIT_AUTH", new String[]{info.getCompany().getName()});
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "046_AUDIT_FAIL_REASON", new String[]{info.getNumber(), msg}));
                        continue;
                    }
                    if (info.getBillStatus() != SummaryBillStatusEnum.APPROVED) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "046_AUDIT_FAIL_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "047_BILL_NOT_APPROVE_AUDIT", null)}));
                        continue;
                    }
                    if (PSUtils.isInWorkFlow(ctx, info.getId().toString())) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "046_AUDIT_FAIL_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "040_IN_WOKFLOW", null)}));
                        continue;
                    }
                    Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                    if (!isLocked.booleanValue()) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "046_AUDIT_FAIL_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "041_BILL_HAS_LOCK", null)}));
                        continue;
                    }
                    info.setAuditor(currentUser);
                    info.setAuditDate(DateTimeUtils.truncateDate((Date)new Date()));
                    this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource(ctx, "046_AUDIT_FAIL_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "036_SYS_EXCEPTION", null)}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        summary = success == idSet.size() ? summary + PSUtils.getResource(ctx, "048_ALL_AUDIT_SUCC", null) : summary + PSUtils.getResource(ctx, "049_AUDIT_TITLE", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        if (result.getSummaryMsg() != null) {
            return result;
        }
        int success = 0;
        String summary = PSUtils.getResource(ctx, "008_BILL_SUM", new String[]{idSet.size() + ""});
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        try {
            PayPlanSumaryCollection payPlanSumaryColls = this.getSummaryCollection(ctx, idSet);
            for (int i = 0; i < payPlanSumaryColls.size(); ++i) {
                PayPlanSumaryInfo info = payPlanSumaryColls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_ANTIAUDIT);
                    if (!isPermission) {
                        String msg = PSUtils.getResource(ctx, "134_NO_SUM_ANTIAUDIT_AUTH", new String[]{info.getCompany().getName()});
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "046_AUDIT_FAIL_REASON", new String[]{info.getNumber(), msg}));
                        continue;
                    }
                    if (info.getReportType() == ReportTypeEnum.EMERGENCY && info.getNotIssuedAmt() != info.getApprovedAmt()) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "050_ANTI_AUDIT_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "143_SUAMARY_EMER_ANTIAUDIT", null)}));
                        continue;
                    }
                    if (PSUtils.isInWorkFlow(ctx, info.getId().toString())) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "050_ANTI_AUDIT_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "040_IN_WOKFLOW", null)}));
                        continue;
                    }
                    Boolean noLocked = (Boolean)requestMap.get(info.getId().toString());
                    if (!noLocked.booleanValue()) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "050_ANTI_AUDIT_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "041_BILL_HAS_LOCK", null)}));
                        continue;
                    }
                    info.setBillStatus(SummaryBillStatusEnum.APPROVED);
                    info.setAuditDate(null);
                    info.setAuditor(null);
                    this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                    this.reversePlanSumaryStatus(ctx, info.getId().toString(), SummaryBillStatusEnum.APPROVED);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource(ctx, "050_ANTI_AUDIT_REASON", new String[]{info.getNumber(), PSUtils.getResource(ctx, "036_SYS_EXCEPTION", null)}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        summary = success == idSet.size() ? summary + PSUtils.getResource(ctx, "052_ALL_ANTI_AUDIT_SUCC", null) : summary + PSUtils.getResource(ctx, "053_ANTI_AUDIT_TITLE", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _approve(Context ctx, List infoList) throws BOSException, EASBizException {
        Boolean PS004;
        BatchExecuteResult result = new BatchExecuteResult();
        List<String> idList = PSUtils.listId2List(infoList);
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idList.size() + ""});
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int success = 0;
        HashSet<String> idSet = new HashSet<String>();
        String companyId = null;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < infoList.size(); ++i) {
                PayPlanSumaryInfo paramInfo = (PayPlanSumaryInfo)infoList.get(i);
                idSet.add(paramInfo.getId().toString());
                String id = paramInfo.getId().toString();
                if (companyId == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("company.id"));
                    PayPlanSumaryInfo tmpInfo = (PayPlanSumaryInfo)PayPlanSumaryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id), sic);
                    companyId = tmpInfo.getCompany().getId().toString();
                }
                try {
                    Boolean isLocked = (Boolean)requestMap.get(id);
                    if (!isLocked.booleanValue()) {
                        throw new PSException(PSException.BILL_IS_MUTEXED);
                    }
                    if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
                        throw new PSException(PSException.BILL_NOT_EXISTS);
                    }
                    PayPlanSumaryInfo info = this.getPayPlanSumaryInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
                    if (info.getBillStatus() != SummaryBillStatusEnum.SAVE && info.getBillStatus() != SummaryBillStatusEnum.APPROVED) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"030_BILL_NOT_APPROVE"));
                    }
                    if (!this.sameSettleCate(info.getSettleEntries(), paramInfo.getSettleEntries())) {
                        throw new PSException(PSException.SETTLECATE_ISNOT_SAME);
                    }
                    if ((info = this.setApproveAmt(info, paramInfo)).getApplyPayAmt().compareTo(info.getApprovedAmt()) < 0) {
                        throw new PSException(PSException.APPLYPAYAMT_LESSTHAN_APPROVEDAMT);
                    }
                    this.setEntrySettleType(info, paramInfo);
                    info.setBillStatus(SummaryBillStatusEnum.APPROVED);
                    info.setApproveUser(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                    info.setApproveDate(DateUtil.getDayBegin());
                    ObjectUuidPK pk = new ObjectUuidPK(id);
                    this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
                    this.reversePlanSumaryStatus(ctx, id, SummaryBillStatusEnum.APPROVED);
                    if (!PSUtils.isInWorkFlow(ctx, id)) {
                        this.approve4WF(ctx, (IObjectPK)pk);
                    }
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"031_APPROVE_FAILED", (String[])new String[]{paramInfo.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        summary = success == idList.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"054_ALL_APPROVE_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"055_APPROVE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idList.size() - success)});
        result.setSummaryMsg(summary);
        if (companyId == null) {
            companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        }
        if ((PS004 = Boolean.valueOf(ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS004", (IObjectPK)new ObjectUuidPK(companyId)))).booleanValue()) {
            DecomposeThread decomposeThread = new DecomposeThread(ctx, idSet, companyId);
            decomposeThread.run();
        }
        return result;
    }

    private void setEntrySettleType(PayPlanSumaryInfo info, PayPlanSumaryInfo paramInfo) {
        PayPlanSumSettleEntryCollection coll = info.getSettleEntries();
        PayPlanSumSettleEntryCollection paramColl = paramInfo.getSettleEntries();
        PayPlanSumSettleEntryInfo entryInfo = null;
        PayPlanSumSettleEntryInfo paramEntryInfo = null;
        for (int i = 0; i < paramColl.size(); ++i) {
            entryInfo = coll.get(i);
            paramEntryInfo = paramColl.get(i);
            entryInfo.setSettleType(paramEntryInfo.getSettleType());
        }
    }

    private boolean sameSettleCate(PayPlanSumSettleEntryCollection entries, PayPlanSumSettleEntryCollection p_entries) {
        boolean same = false;
        if (entries.size() != p_entries.size()) {
            same = false;
        } else {
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < entries.size(); ++i) {
                PayPlanSumSettleEntryInfo entry = entries.get(i);
                idList.add(entry.getSettleCategory().getId().toString());
            }
            ArrayList<String> pidList = new ArrayList<String>();
            for (int i = 0; i < p_entries.size(); ++i) {
                PayPlanSumSettleEntryInfo entry = p_entries.get(i);
                pidList.add(entry.getSettleCategory().getId().toString());
            }
            if (idList.equals(pidList)) {
                same = true;
            }
        }
        return same;
    }

    private PaymentPlanBillCollection getPaymentPlanColls(Context ctx, String sumaryId) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("planSumary", (Object)sumaryId, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        return PaymentPlanBillFactory.getLocalInstance(ctx).getPaymentPlanBillCollection(entityViewInfo);
    }

    private void reversePlanSumaryStatus(Context ctx, String sumaryId, SummaryBillStatusEnum sumaryStatus) throws EASBizException, BOSException {
        PaymentPlanBillCollection paymentPlanColls = this.getPaymentPlanColls(ctx, sumaryId);
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int m = 0; m < paymentPlanColls.size(); ++m) {
            PaymentPlanBillInfo planInfo = paymentPlanColls.get(m);
            planInfo.setSumBillStatus(sumaryStatus);
            colls.add((CoreBaseInfo)planInfo);
        }
        PaymentPlanBillFactory.getLocalInstance(ctx).updateBatchData(colls);
    }

    private PayPlanSumaryInfo setApproveAmt(PayPlanSumaryInfo info, PayPlanSumaryInfo paramInfo) {
        info.setLimitStartDate(DateTimeUtils.truncateDate((Date)paramInfo.getLimitStartDate()));
        info.setLimitExpiredDate(DateTimeUtils.truncateDate((Date)paramInfo.getLimitExpiredDate()));
        BigDecimal totalApproveAmt = BigDecimal.ZERO;
        if (paramInfo.getApproveAmt1() == null) {
            paramInfo.setApproveAmt1(BigDecimal.ZERO);
        }
        if (paramInfo.getApproveAmt2() == null) {
            paramInfo.setApproveAmt2(BigDecimal.ZERO);
        }
        if (paramInfo.getApproveAmt3() == null) {
            paramInfo.setApproveAmt3(BigDecimal.ZERO);
        }
        if (!EmptyUtil.isEmpty((Object)paramInfo.getApproveAmt1())) {
            info.setApproveAmt1(paramInfo.getApproveAmt1());
            info.setNotIssuedAmt1(paramInfo.getApproveAmt1());
            totalApproveAmt = totalApproveAmt.add(info.getNotIssuedAmt1());
        }
        if (!EmptyUtil.isEmpty((Object)paramInfo.getApproveAmt2())) {
            info.setApproveAmt2(paramInfo.getApproveAmt2());
            info.setNotIssuedAmt2(paramInfo.getApproveAmt2());
            totalApproveAmt = totalApproveAmt.add(info.getNotIssuedAmt2());
        }
        if (!EmptyUtil.isEmpty((Object)paramInfo.getApproveAmt3())) {
            info.setApproveAmt3(paramInfo.getApproveAmt3());
            info.setNotIssuedAmt3(paramInfo.getApproveAmt3());
            totalApproveAmt = totalApproveAmt.add(info.getNotIssuedAmt3());
        }
        if (!EmptyUtil.isEmpty((Object)paramInfo.getApprovedAmt())) {
            info.setApprovedAmt(paramInfo.getApprovedAmt());
            info.setNotIssuedAmt(paramInfo.getApprovedAmt());
        } else {
            info.setApprovedAmt(totalApproveAmt);
            info.setNotIssuedAmt(totalApproveAmt);
        }
        block0: for (int i = 0; i < info.getSettleEntries().size(); ++i) {
            PayPlanSumSettleEntryInfo entry = info.getSettleEntries().get(i);
            String categoryId = entry.getSettleCategory().getId().toString();
            for (int j = 0; j < paramInfo.getSettleEntries().size(); ++j) {
                PayPlanSumSettleEntryInfo p_entry = paramInfo.getSettleEntries().get(i);
                String p_categoryId = p_entry.getSettleCategory().getId().toString();
                if (!categoryId.equals(p_categoryId)) continue;
                if (p_entry.getApproveAmt() == null) {
                    p_entry.setApproveAmt(BigDecimal.ZERO);
                }
                entry.setApproveAmt(p_entry.getApproveAmt());
                entry.setNotIssuedAmt(p_entry.getApproveAmt());
                continue block0;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _decompose(Context ctx, DecomposeBillInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        result.setError(-1);
        List<PayPlanSumaryInfo> sumList = info.getSumaryEntries();
        List<String> idList = PSUtils.listId2List(sumList);
        ArrayList<String> decomposeList = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            PayPlanSumaryCollection colls = new PayPlanSumaryCollection();
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            PaymentScheduleSettingInfo payScheduleInfo = PSUtils.getPaymentScheduleInfo(ctx, cu.getId().toString());
            int periodType = payScheduleInfo.getPeriodType().getValue();
            String period = null;
            String periodEntry = null;
            for (int i = 0; i < sumList.size(); ++i) {
                PayPlanSumaryInfo sumInfo = sumList.get(i);
                this.verify4Decompose(ctx, sumInfo, requestMap, result, colls);
                PayPlanSumaryInfo dbSumInfo = colls.get(i);
                if (i == 0) {
                    period = dbSumInfo.getPeriod();
                    periodEntry = dbSumInfo.getPeriodEntry();
                    continue;
                }
                this.verifyPeriod(ctx, period, periodEntry, periodType, dbSumInfo);
            }
            if (result.getDetailMsgList().size() == 0) {
                int i;
                HashMap<String, PayPlanSumaryInfo> sumaryMap = new HashMap<String, PayPlanSumaryInfo>();
                String number = PSUtils.initNumber(ctx, info, info.getCompany().getId().toString());
                info.setNumber(number);
                info.setBillStatus(DecomposeBillStatusEnum.SUBMIT);
                info.setDecompUser(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setDecompDate(DateUtil.getDayBegin());
                info.setPeriod(period);
                info.setPeriodEntry(periodEntry);
                BigDecimal sumNotIssuedAmt = Constants.ZERO;
                BigDecimal sumCurrentIssueAmt = Constants.ZERO;
                BigDecimal sumApplyPayAmt = Constants.ZERO;
                BigDecimal sumApprovedAmt = Constants.ZERO;
                for (int i2 = 0; i2 < sumList.size(); ++i2) {
                    PayPlanSumaryInfo payPlanSumInfo = colls.get(i2);
                    PayPlanSumaryInfo sumInfo = sumList.get(i2);
                    this.setDecomposeAmt(payPlanSumInfo, sumInfo);
                    DecomposeBillEntryInfo entryInfo = new DecomposeBillEntryInfo();
                    entryInfo.setSumNumber(payPlanSumInfo.getNumber());
                    entryInfo.setReportType(payPlanSumInfo.getReportType());
                    entryInfo.setDepartment(payPlanSumInfo.getDepartment());
                    entryInfo.setAsstActType(payPlanSumInfo.getAsstActType());
                    entryInfo.setAsstActID(payPlanSumInfo.getAsstActID());
                    entryInfo.setAsstActName(payPlanSumInfo.getAsstActName());
                    entryInfo.setAsstActNumber(payPlanSumInfo.getAsstActNumber());
                    entryInfo.setFundFlowItem(payPlanSumInfo.getFundFlowItem());
                    entryInfo.setFundProperty(payPlanSumInfo.getFundProperty());
                    entryInfo.setCurrency(payPlanSumInfo.getCurrency());
                    entryInfo.setApplyPayAmt(payPlanSumInfo.getApplyPayAmt());
                    entryInfo.setApprovedAmt(payPlanSumInfo.getApprovedAmt());
                    entryInfo.setNotIssuedAmt(payPlanSumInfo.getNotIssuedAmt());
                    entryInfo.setIssuedAmt(payPlanSumInfo.getIssuedAmt());
                    entryInfo.setCurrentIssueAmt(payPlanSumInfo.getCurrentIssuedAmt());
                    entryInfo.setLimitStartDate(payPlanSumInfo.getLimitStartDate());
                    entryInfo.setLimitExpiredDate(payPlanSumInfo.getLimitExpiredDate());
                    entryInfo.setSummary(payPlanSumInfo);
                    entryInfo.setPayerAccountBank(payPlanSumInfo.getPayerAccountBank());
                    if (payPlanSumInfo.getSettlementType() != null) {
                        entryInfo.setSettlementType(payPlanSumInfo.getSettlementType());
                        entryInfo.setSettleTypeName(payPlanSumInfo.getSettlementType().getName());
                    }
                    entryInfo.setSettleCate1(payPlanSumInfo.getSettleCate1());
                    entryInfo.setSettleCate2(payPlanSumInfo.getSettleCate2());
                    entryInfo.setSettleCate3(payPlanSumInfo.getSettleCate3());
                    entryInfo.setApproveAmt1(payPlanSumInfo.getApproveAmt1());
                    entryInfo.setApproveAmt2(payPlanSumInfo.getApproveAmt2());
                    entryInfo.setApproveAmt3(payPlanSumInfo.getApproveAmt3());
                    entryInfo.setNotIssueAmt1(payPlanSumInfo.getNotIssuedAmt1());
                    entryInfo.setNotIssueAmt2(payPlanSumInfo.getNotIssuedAmt2());
                    entryInfo.setNotIssueAmt3(payPlanSumInfo.getNotIssuedAmt3());
                    entryInfo.setCurrentIssueAmt1(payPlanSumInfo.getCurrentIssuedAmt1());
                    entryInfo.setCurrentIssueAmt2(payPlanSumInfo.getCurrentIssuedAmt2());
                    entryInfo.setCurrentIssueAmt3(payPlanSumInfo.getCurrentIssuedAmt3());
                    for (int m = 0; m < payPlanSumInfo.getSettleEntries().size(); ++m) {
                        PayPlanSumSettleEntryInfo entry = payPlanSumInfo.getSettleEntries().get(m);
                        String categoryId = entry.getSettleCategory().getId().toString();
                        if (entryInfo.getSettleCate1() != null && categoryId.equals(entryInfo.getSettleCate1().getId().toString())) {
                            entryInfo.setSettleType1(entry.getSettleType());
                            entryInfo.setPayerAccBank1(entry.getPayerAccountBank());
                            entryInfo.setNotIssueAmt1(payPlanSumInfo.getNotIssuedAmt1());
                            entryInfo.setCurrentIssueAmt1(payPlanSumInfo.getCurrentIssuedAmt1());
                        }
                        if (entryInfo.getSettleCate2() != null && categoryId.equals(entryInfo.getSettleCate2().getId().toString())) {
                            entryInfo.setSettleType2(entry.getSettleType());
                            entryInfo.setPayerAccBank2(entry.getPayerAccountBank());
                            entryInfo.setNotIssueAmt2(payPlanSumInfo.getNotIssuedAmt2());
                            entryInfo.setCurrentIssueAmt2(payPlanSumInfo.getCurrentIssuedAmt2());
                        }
                        if (entryInfo.getSettleCate3() == null || !categoryId.equals(entryInfo.getSettleCate3().getId().toString())) continue;
                        entryInfo.setSettleType3(entry.getSettleType());
                        entryInfo.setPayerAccBank3(entry.getPayerAccountBank());
                        entryInfo.setNotIssueAmt3(payPlanSumInfo.getNotIssuedAmt3());
                        entryInfo.setCurrentIssueAmt3(payPlanSumInfo.getCurrentIssuedAmt3());
                    }
                    info.getEntrys().add(entryInfo);
                    sumNotIssuedAmt = sumNotIssuedAmt.add(entryInfo.getNotIssuedAmt());
                    sumCurrentIssueAmt = sumCurrentIssueAmt.add(entryInfo.getCurrentIssueAmt());
                    sumApplyPayAmt = sumApplyPayAmt.add(entryInfo.getApplyPayAmt());
                    sumApprovedAmt = sumApprovedAmt.add(entryInfo.getApprovedAmt());
                    if (payPlanSumInfo.getNotIssuedAmt().compareTo(BigDecimal.ZERO) > 0) {
                        payPlanSumInfo.setBillStatus(SummaryBillStatusEnum.DECOMPOSING);
                    } else {
                        payPlanSumInfo.setBillStatus(SummaryBillStatusEnum.DECOMPOSED);
                    }
                    sumaryMap.put(payPlanSumInfo.getId().toString(), payPlanSumInfo);
                }
                info.setNotIssuedAmt(sumNotIssuedAmt);
                info.setCurrentIssueAmt(sumCurrentIssueAmt);
                info.setApplyPayAmt(sumApplyPayAmt);
                info.setApprovedAmt(sumApprovedAmt);
                info.setCurrency(info.getEntrys().get(0).getCurrency());
                Set<String> sumaryIdSet = sumaryMap.keySet();
                Set<String> decomposeSet = DecomposeBillService.getDecomposeBillIdSet(ctx, sumaryIdSet);
                DecomposeBillCollection decomposeColls = null;
                if (decomposeSet.size() > 0) {
                    decomposeList = new ArrayList<String>(decomposeSet);
                    Map decompseMap = iMutex.batchRequestBizObjIDForUpdate(decomposeList);
                    decomposeColls = DecomposeBillService.updateDecomposeBySumaryInfo(ctx, sumaryMap, decomposeSet, decompseMap);
                }
                IObjectPK id = DecomposeBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                CoreBaseCollection coreColls = new CoreBaseCollection();
                for (i = 0; i < colls.size(); ++i) {
                    coreColls.add((CoreBaseInfo)colls.get(i));
                }
                this.update(ctx, coreColls);
                if (decomposeSet.size() > 0) {
                    coreColls.clear();
                    if (decomposeColls != null && decomposeColls.size() > 0) {
                        for (i = 0; i < decomposeColls.size(); ++i) {
                            coreColls.add((CoreBaseInfo)decomposeColls.get(i));
                        }
                    }
                    DecomposeBillFactory.getLocalInstance(ctx).updateBatchData(coreColls);
                }
                for (i = 0; i < colls.size(); ++i) {
                    PayPlanSumaryInfo sumInfo = colls.get(i);
                    this.reversePlanSumaryStatus(ctx, sumInfo.getId().toString(), sumInfo.getBillStatus());
                }
                BOTPUtil.saveBOTRelation((Context)ctx, idList, (String)id.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "071_EXCEPTION", null) + e.getMessage());
            result.setError(1);
        }
        finally {
            if (decomposeList != null) {
                iMutex.batchReleaseObjIDForUpdate(decomposeList);
            }
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (result.getSummaryMsg() == null && result.getDetailMsgList().size() == 0) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "069_SUCCESS", null));
        } else if (result.getSummaryMsg() == null) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null) + PSUtils.getResource(ctx, "070_FAIL", null));
            result.setError(1);
        }
        return result;
    }

    private void verifyPeriod(Context ctx, String period, String periodEntry, int periodType, PayPlanSumaryInfo sumInfo) throws BOSException {
        boolean rs = true;
        if (!period.equals(sumInfo.getPeriod())) {
            rs = false;
        } else if (periodType == 0 && rs && !periodEntry.equals(sumInfo.getPeriodEntry())) {
            rs = false;
        }
        if (!rs) {
            String exMsg = PSUtils.getResource(ctx, "124_SUM_NOT_SAMEPERIOD", null);
            throw new BOSException(exMsg);
        }
    }

    private PayPlanSumaryCollection verify4Decompose(Context ctx, PayPlanSumaryInfo sumInfo, Map requestMap, BatchExecuteResult result, PayPlanSumaryCollection colls) {
        try {
            String id = sumInfo.getId().toString();
            Boolean isLocked = (Boolean)requestMap.get(id);
            if (!isLocked.booleanValue()) {
                throw new PSException(PSException.BILL_IS_MUTEXED);
            }
            if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
                throw new PSException(PSException.BILL_NOT_EXISTS);
            }
            PayPlanSumaryInfo paySumInfo = this.getPayPlanSumaryInfoById(ctx, id);
            if (paySumInfo.getReportType() == ReportTypeEnum.EMERGENCY) {
                String exMsg = PSUtils.getResource(ctx, "125_EMER_SUM_NOT_DECOM", null);
                throw new BOSException(exMsg);
            }
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(paySumInfo.getCompany().getId().toString()), (String)PERM_ITEM_DECOMPOSE);
            if (!isPermission) {
                throw new BOSException(PSUtils.getResource(ctx, "135_NO_SUM_DECOM_AUTH", new String[]{paySumInfo.getCompany().getName()}));
            }
            if (paySumInfo.getBillStatus() != SummaryBillStatusEnum.APPROVED && paySumInfo.getBillStatus() != SummaryBillStatusEnum.DECOMPOSING) {
                throw new BOSException(PSUtils.getResource(ctx, "072_BILL_DECOMPOSE", null));
            }
            if (paySumInfo.getNotIssuedAmt().compareTo(Constants.ZERO) == -1) {
                throw new BOSException(PSUtils.getResource(ctx, "068_DECOMPOSE_BILL_SUBMIT", null));
            }
            colls.add(paySumInfo);
        }
        catch (Exception e) {
            result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"073_NOT_ISSUE_LESS_ZERO", (String[])new String[]{sumInfo.getNumber(), e.getMessage()}));
        }
        return colls;
    }

    private PayPlanSumaryInfo getPayPlanSumaryInfoById(Context ctx, String id) throws EASBizException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        sel.add(new SelectorItemInfo("company.name"));
        sel.add(new SelectorItemInfo("settleEntries.*"));
        sel.add(new SelectorItemInfo("settleEntries.settleCategory"));
        entityViewInfo.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        return this.getPayPlanSumaryInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sel);
    }

    private PayPlanSumaryInfo setDecomposeAmt(PayPlanSumaryInfo info, PayPlanSumaryInfo paramInfo) {
        BigDecimal totalCurrentIssueAmt = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((Object)paramInfo.getBigDecimal("currentissuedamt1"))) {
            info.setNotIssuedAmt1(info.getNotIssuedAmt1().subtract(paramInfo.getBigDecimal("currentissuedamt1")));
            info.setCurrentIssuedAmt1(paramInfo.getBigDecimal("currentissuedamt1"));
            totalCurrentIssueAmt = totalCurrentIssueAmt.add(paramInfo.getBigDecimal("currentissuedamt1"));
        }
        if (!EmptyUtil.isEmpty((Object)paramInfo.getBigDecimal("currentissuedamt2"))) {
            info.setNotIssuedAmt2(info.getNotIssuedAmt2().subtract(paramInfo.getBigDecimal("currentissuedamt2")));
            info.setCurrentIssuedAmt2(paramInfo.getBigDecimal("currentissuedamt2"));
            totalCurrentIssueAmt = totalCurrentIssueAmt.add(paramInfo.getBigDecimal("currentissuedamt1"));
        }
        if (!EmptyUtil.isEmpty((Object)paramInfo.getBigDecimal("currentissuedamt3"))) {
            info.setNotIssuedAmt3(info.getNotIssuedAmt3().subtract(paramInfo.getBigDecimal("currentissuedamt3")));
            info.setCurrentIssuedAmt3(paramInfo.getBigDecimal("currentissuedamt3"));
            totalCurrentIssueAmt = totalCurrentIssueAmt.add(paramInfo.getBigDecimal("currentissuedamt1"));
        }
        if (!EmptyUtil.isEmpty((Object)paramInfo.getBigDecimal("currentissuedamt"))) {
            info.setNotIssuedAmt(info.getNotIssuedAmt().subtract(paramInfo.getBigDecimal("currentissuedamt")));
            info.setIssuedAmt(info.getApprovedAmt().subtract(info.getNotIssuedAmt()));
            info.setCurrentIssuedAmt(paramInfo.getBigDecimal("currentissuedamt"));
        } else {
            info.setCurrentIssuedAmt(totalCurrentIssueAmt);
            info.setNotIssuedAmt(info.getNotIssuedAmt().subtract(totalCurrentIssueAmt));
            info.setIssuedAmt(info.getIssuedAmt().add(totalCurrentIssueAmt));
        }
        block0: for (int i = 0; i < info.getSettleEntries().size(); ++i) {
            PayPlanSumSettleEntryInfo entry = info.getSettleEntries().get(i);
            String categoryId = entry.getSettleCategory().getId().toString();
            for (int j = 0; j < paramInfo.getSettleEntries().size(); ++j) {
                PayPlanSumSettleEntryInfo p_entry = paramInfo.getSettleEntries().get(i);
                String p_categoryId = p_entry.getSettleCategory().getId().toString();
                if (!categoryId.equals(p_categoryId)) continue;
                entry.setNotIssuedAmt(p_entry.getNotIssuedAmt().subtract(p_entry.getBigDecimal("currentissuedamt")));
                entry.setCurrentIssuedAmt(p_entry.getBigDecimal("currentissuedamt"));
                continue block0;
            }
        }
        return info;
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        PayPlanSumaryInfo info = PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo(pk);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_AUDIT);
        if (!isPermission) {
            String msg = PSUtils.getResource(ctx, "133_NO_SUM_AUDIT_AUTH", new String[]{info.getCompany().getName()});
            throw new BOSException(PSUtils.getResource(ctx, "046_AUDIT_FAIL_REASON", new String[]{info.getNumber(), msg}));
        }
        info.setAuditor(currentUser);
        info.setAuditDate(DateTimeUtils.truncateDate((Date)new Date()));
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _approve4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<MsgInfo> _importAmt(Context ctx, List infoList) throws BOSException, EASBizException {
        List<MsgInfo> errList = null;
        List<String> idList = PSUtils.listId2List(infoList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < infoList.size(); ++i) {
                PayPlanSumaryInfo paramInfo = (PayPlanSumaryInfo)infoList.get(i);
                String id = paramInfo.getId().toString();
                PayPlanSumaryInfo info = null;
                try {
                    Boolean isLocked = (Boolean)requestMap.get(id);
                    if (!isLocked.booleanValue()) {
                        throw new PSException(PSException.BILL_IS_MUTEXED);
                    }
                    info = this.getPayPlanSumaryInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
                    if (info.getBillStatus() != SummaryBillStatusEnum.SAVE && info.getBillStatus() != SummaryBillStatusEnum.APPROVED) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)PS_RES, (String)"030_BILL_NOT_APPROVE"));
                    }
                    if (!this.sameSettleCate(info.getSettleEntries(), paramInfo.getSettleEntries())) {
                        throw new PSException(PSException.SETTLECATE_ISNOT_SAME);
                    }
                    if ((info = this.setApproveAmt(info, paramInfo)).getApplyPayAmt().compareTo(info.getApprovedAmt()) < 0) {
                        throw new PSException(PSException.APPLYPAYAMT_LESSTHAN_APPROVEDAMT);
                    }
                    this.setEntrySettleType(info, paramInfo);
                    info.setBillStatus(SummaryBillStatusEnum.APPROVED);
                    info.setApproveUser(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                    info.setApproveDate(DateUtil.getDayBegin());
                    ObjectUuidPK pk = new ObjectUuidPK(id);
                    this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
                    this.reversePlanSumaryStatus(ctx, id, SummaryBillStatusEnum.APPROVED);
                    if (PSUtils.isInWorkFlow(ctx, id)) continue;
                    this._approve4WF(ctx, (IObjectPK)pk);
                    continue;
                }
                catch (Exception e) {
                    errList = this.setErrMsgList(errList, info, e.getMessage());
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        return errList;
    }

    private List<MsgInfo> setErrMsgList(List<MsgInfo> errList, PayPlanSumaryInfo info, String message) {
        if (errList == null) {
            errList = new ArrayList<MsgInfo>();
        }
        MsgInfo msgInfo = new MsgInfo();
        msgInfo.setId(info.getId().toString());
        msgInfo.setNumber(info.getNumber());
        msgInfo.setMsg(message);
        errList.add(msgInfo);
        return errList;
    }

    class DecomposeThread
    extends Thread {
        private Context ctx;
        private Set<String> idSet;
        private String companyId;

        public DecomposeThread(Context ctx, Set<String> idSet, String companyId) {
            this.ctx = ctx;
            this.idSet = idSet;
            this.companyId = companyId;
        }

        @Override
        public void run() {
            try {
                PayPlanSumaryCollection sumColls = this.getPayPlanSumaryColls(this.idSet);
                DecomposeBillInfo info = PSUtils.sumaryToDecomposeInfo(sumColls);
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyId));
                info.setCompany(companyInfo);
                info.setCU(companyInfo.getCU());
                DecomposeBillFactory.getLocalInstance(this.ctx).submitDecomposeBill(info);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.info((Object)e.getMessage());
            }
            catch (BOSException e) {
                e.printStackTrace();
                logger.info((Object)e.getMessage());
            }
        }

        private PayPlanSumaryCollection getPayPlanSumaryColls(Set<String> idSet) throws BOSException {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("department.name");
            selector.add("currency.name");
            selector.add("asstActType.name");
            selector.add("fundFlowItem.name");
            selector.add("settlementType.name");
            selector.add("fundProperty.name");
            selector.add("settleEntries.*");
            selector.add("settleEntries.settleType.name");
            selector.add("settleEntries.payerAccountBank.name");
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(selector);
            return PayPlanSumaryFactory.getLocalInstance(this.ctx).getPayPlanSumaryCollection(view);
        }
    }
}

