/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillPlanFactory;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.model.MsgInfo;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ps.BillStatusEnum;
import com.kingdee.eas.fm.ps.FundPropertyInfo;
import com.kingdee.eas.fm.ps.IPaymentPlanBillEntry;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.PayPlanSumSettleEntryCollection;
import com.kingdee.eas.fm.ps.PayPlanSumSettleEntryInfo;
import com.kingdee.eas.fm.ps.PayPlanSumaryFactory;
import com.kingdee.eas.fm.ps.PayPlanSumaryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingInfo;
import com.kingdee.eas.fm.ps.PeriodTypeEnum;
import com.kingdee.eas.fm.ps.ReportTypeEnum;
import com.kingdee.eas.fm.ps.SettlementCategoryFactory;
import com.kingdee.eas.fm.ps.SettlementCategoryInfo;
import com.kingdee.eas.fm.ps.SettlementPrioritySettingCollection;
import com.kingdee.eas.fm.ps.SettlementPrioritySettingInfo;
import com.kingdee.eas.fm.ps.SrcBillTypeEnum;
import com.kingdee.eas.fm.ps.SummaryBillStatusEnum;
import com.kingdee.eas.fm.ps.app.AbstractPaymentPlanBillControllerBean;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import com.kingdee.eas.fm.ps.vo.OtherEntryInfo;
import com.kingdee.eas.fm.ps.vo.PlanScheduledInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.framework.app.CoreBaseController;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PaymentPlanBillControllerBean
extends AbstractPaymentPlanBillControllerBean {
    private static final long serialVersionUID = -2652926148703913777L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.PaymentPlanBillControllerBean");
    private static final String webResourcePath = "com.kingdee.eas.fm.ps.PsResource";
    private static final String CAS_PAYMENTBILLTYPE_ID = "NLGLdwEREADgAAHcwKgSRj6TKVs=";
    private static final String PERM_ITEM_SUMMARY = "ps_plansummary_02summary";
    private static final String PERM_ITEM_BITBACK = "ps_plansummary_03bitBack";
    private static final String PERM_ITEM_CANCELSMANUSCHEDULE = "ps_paymentplan4schdl_03cancelManuSche";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
    private Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
    private static final String FIXED_PLAN_ID = "HbBLG4O2SveJKFbFkZiu+v25+gA=";
    private String destBosType = new PaymentBillInfo().getBOSType().toString();
    private List<OtherEntryInfo> otherEntryList = null;
    private Map<String, OtherBillInfo> otherBillCache = null;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PaymentPlanBillInfo info = (PaymentPlanBillInfo)model;
        if (info.getCU() == null) {
            info.setCU(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit());
        }
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            super.checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBillBaseInfo)info);
        }
        this.initPaymentPlanBillNumber(ctx, info);
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        Date now = new Date();
        String period = this.sdf.format(now);
        info.setPeriod(period);
        info.setPeriodEntry(new Integer(PSUtils.getCurWeek(now)).toString());
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        return pk;
    }

    private void initPaymentPlanBillNumber(Context ctx, BillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.error((Object)e);
                throw new PSException(PSException.NO_NUMCODERULE, e.getCause());
            }
            if (EmptyUtil.isEmpty((String)numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
        } while (this.exists(ctx, filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true)) && ++i < 10);
    }

    @Override
    protected Map _ordinary(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        PaymentPlanBillInfo model = (PaymentPlanBillInfo)info;
        model.setReportDate(new Date());
        model.setReportUser(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        model.setReportType(ReportTypeEnum.ORDINARY);
        model.setBillStatus(BillStatusEnum.REPORT);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(model.getId().toString()), (CoreBaseInfo)model);
        return null;
    }

    @Override
    protected Map _special(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        PaymentPlanBillInfo model = (PaymentPlanBillInfo)info;
        model.setReportDate(new Date());
        model.setReportUser(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        model.setReportType(ReportTypeEnum.SPECIAL);
        model.setBillStatus(BillStatusEnum.REPORT);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(model.getId().toString()), (CoreBaseInfo)model);
        return null;
    }

    @Override
    protected Map _cancel(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        PaymentPlanBillInfo model = (PaymentPlanBillInfo)info;
        model.setReportDate(null);
        model.setReportUser(null);
        model.setReportType(null);
        model.setBillStatus(BillStatusEnum.SAVE);
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("reportDate"));
        sel.add(new SelectorItemInfo("reportUser"));
        sel.add(new SelectorItemInfo("reportType"));
        sel.add(new SelectorItemInfo("billStatus"));
        this.updatePartial(ctx, (CoreBaseInfo)model, sel);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _cancelBatch(Context ctx, List idList) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPaymentPlanBillControllerBean._cancelBatch \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sumBillStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        ObjectUuidPK[] pkArray = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pkArray[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = PaymentPlanBillControllerBean.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        PaymentPlanBillInfo info = null;
        for (int i = 0; i < pkArray.length; ++i) {
            info = this.getPaymentPlanBillInfo(ctx, (IObjectPK)pkArray[i], sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ps_paymentplan_06cancel");
                if (!isPermission) {
                    throw new PSException(PSException.NO_CANCEL_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(PaymentPlanBillControllerBean.getResource(ctx, "021_IN_ADJUST_PERIOD_SINGLE", null));
                }
                if (!this.requestMutexLock(ctx, pkArray[i].toString())) {
                    throw new PSException(PSException.BILL_IS_MUTEXED, new Object[]{info.getNumber()});
                }
                if (info.getBillStatus() != null && info.getBillStatus().getValue() != 3 || info.getSumBillStatus() != null) {
                    throw new PSException(PSException.BILL_CANNOT_CANCEL, new Object[]{info.getNumber()});
                }
                if (this.isInWorkFlow(ctx, pkArray[i].toString())) {
                    result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "012_BILL_CANCEL_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                    continue;
                }
                this.cancel(ctx, info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "012_BILL_CANCEL_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "012_BILL_CANCEL_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                this.releaseMutexLock(ctx, pkArray[i].toString());
            }
        }
        summary = success == pkArray.length ? summary + PaymentPlanBillControllerBean.getResource(ctx, "020_ALL_CANCEL_SUCCESS", null) : summary + PaymentPlanBillControllerBean.getResource(ctx, "019_CANCEL_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _ordinaryBatch(Context ctx, List idList) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPaymentPlanBillControllerBean._ordinaryBatch \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        ObjectUuidPK[] pkArray = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pkArray[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = PaymentPlanBillControllerBean.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        PaymentPlanBillInfo info = null;
        for (int i = 0; i < pkArray.length; ++i) {
            info = this.getPaymentPlanBillInfo(ctx, (IObjectPK)pkArray[i], sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ps_paymentplan_05ordinary");
                if (!isPermission) {
                    throw new PSException(PSException.NO_ORDINARY_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(PaymentPlanBillControllerBean.getResource(ctx, "021_IN_ADJUST_PERIOD_SINGLE", null));
                }
                if (!this.requestMutexLock(ctx, pkArray[i].toString())) {
                    throw new PSException(PSException.BILL_IS_MUTEXED, new Object[]{info.getNumber()});
                }
                if (info.getBillStatus() != null && info.getBillStatus().getValue() != 1) {
                    throw new PSException(PSException.BILL_CANNOT_ORDINARY, new Object[]{info.getNumber()});
                }
                if (this.isInWorkFlow(ctx, pkArray[i].toString())) {
                    result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "011_BILL_ORDINARY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                    continue;
                }
                this.ordinary(ctx, info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "011_BILL_ORDINARY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "011_BILL_ORDINARY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                this.releaseMutexLock(ctx, pkArray[i].toString());
            }
        }
        summary = success == pkArray.length ? summary + PaymentPlanBillControllerBean.getResource(ctx, "018_ALL_ORDINARY_SUCCESS", null) : summary + PaymentPlanBillControllerBean.getResource(ctx, "017_ORDINARY_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _specialBatch(Context ctx, List idList) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPaymentPlanBillControllerBean._specialBatch \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        ObjectUuidPK[] pkArray = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pkArray[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = PaymentPlanBillControllerBean.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        PaymentPlanBillInfo info = null;
        for (int i = 0; i < pkArray.length; ++i) {
            info = this.getPaymentPlanBillInfo(ctx, (IObjectPK)pkArray[i], sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ps_paymentplan_05special");
                if (!isPermission) {
                    throw new PSException(PSException.NO_SPECIAL_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(PaymentPlanBillControllerBean.getResource(ctx, "021_IN_ADJUST_PERIOD_SINGLE", null));
                }
                if (!this.requestMutexLock(ctx, pkArray[i].toString())) {
                    throw new PSException(PSException.BILL_IS_MUTEXED, new Object[]{info.getNumber()});
                }
                if (info.getBillStatus() != null && info.getBillStatus().getValue() != 1) {
                    throw new PSException(PSException.BILL_CANNOT_SPECIAL, new Object[]{info.getNumber()});
                }
                if (this.isInWorkFlow(ctx, pkArray[i].toString())) {
                    result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "010_BILL_SPECIAL_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                    continue;
                }
                this.special(ctx, info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "010_BILL_SPECIAL_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "010_BILL_SPECIAL_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                this.releaseMutexLock(ctx, pkArray[i].toString());
            }
        }
        summary = success == pkArray.length ? summary + PaymentPlanBillControllerBean.getResource(ctx, "016_ALL_SPECIAL_SUCCESS", null) : summary + PaymentPlanBillControllerBean.getResource(ctx, "015_SPECIAL_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _deleteBatch(Context ctx, List idList) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPaymentPlanBillControllerBean._deleteBatch \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        PaymentPlanBillInfo info = null;
        ObjectUuidPK[] pkArray = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pkArray[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = PaymentPlanBillControllerBean.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        for (int i = 0; i < pkArray.length; ++i) {
            info = this.getPaymentPlanBillInfo(ctx, (IObjectPK)pkArray[i], sic);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ps_paymentplan_03delete");
                if (!isPermission) {
                    throw new PSException(PSException.NO_DELETE_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(PaymentPlanBillControllerBean.getResource(ctx, "021_IN_ADJUST_PERIOD_SINGLE", null));
                }
                if (!this.requestMutexLock(ctx, pkArray[i].toString())) {
                    throw new PSException(PSException.BILL_IS_MUTEXED, new Object[]{info.getNumber()});
                }
                if (info.getBillStatus() != null && info.getBillStatus().getValue() != 1) {
                    throw new PSException(PSException.BILL_CANNOT_DELETE, new Object[]{info.getNumber()});
                }
                if (this.isInWorkFlow(ctx, pkArray[i].toString())) {
                    result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "009_BILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                    continue;
                }
                this.delete(ctx, (IObjectPK)pkArray[i]);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "009_BILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "009_BILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                this.releaseMutexLock(ctx, pkArray[i].toString());
            }
        }
        summary = success == pkArray.length ? summary + PaymentPlanBillControllerBean.getResource(ctx, "014_ALL_DELETE_SUCCESS", null) : summary + PaymentPlanBillControllerBean.getResource(ctx, "013_DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("sourceBillId"));
        selector.add(new SelectorItemInfo("srcBillHeadID"));
        selector.add(new SelectorItemInfo("prePlanBillID"));
        PaymentPlanBillInfo info = this.getPaymentPlanBillInfo(ctx, pk, selector);
        if (info.getPrePlanBillID() != null) {
            throw new PSException(PSException.CARRYOVERBILL_CANNOT_DELETE);
        }
        super._delete(ctx, pk);
        String srcBillHeadID = info.getSrcBillHeadID();
        if (srcBillHeadID != null) {
            String bosType = BOSUuid.read((String)srcBillHeadID).getType().toString();
            String tableName = null;
            PayRequestBillEntryInfo payReqEntInfo = new PayRequestBillEntryInfo();
            OtherBillPlanInfo otherBillPlanInfo = new OtherBillPlanInfo();
            if (otherBillPlanInfo.getBOSType().toString().equals(bosType)) {
                tableName = "T_AP_OtherBillPlan";
            } else if (payReqEntInfo.getBOSType().toString().equals(bosType)) {
                tableName = "T_AP_PayRequestBillEntry";
            }
            StringBuffer sb = new StringBuffer("update ").append(tableName).append(" set FIsPayPlanCreated = 0 where fid = '");
            sb.append(srcBillHeadID).append("'");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    private boolean isInWorkFlow(Context ctx, String selectId) {
        try {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(selectId);
            return procInsts != null && procInsts.length != 0;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    private boolean requestMutexLock(Context ctx, String selectId) throws BOSException {
        return MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(selectId);
    }

    private boolean releaseMutexLock(Context ctx, String selectId) throws BOSException {
        MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(selectId);
        return true;
    }

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)webResourcePath, (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }

    @Override
    protected Map _summary(Context ctx, Set idSet) throws BOSException, EASBizException {
        return this._summary(ctx, idSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _summary(Context ctx, Set idSet, String companyId) throws BOSException, EASBizException {
        Boolean PS003;
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = PaymentPlanBillControllerBean.getResource(ctx, "008_BILL_SUM", new String[]{idSet.size() + ""});
        PaymentPlanBillCollection payPlanColls = null;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList idList = new ArrayList(idSet);
        List<PayPlanSumaryInfo> summaryList = null;
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        try {
            String cuId = null;
            Boolean isCheckPer = true;
            CtrlUnitInfo cu = null;
            if (companyId == null) {
                cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            } else {
                isCheckPer = false;
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add("cu.id");
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selectors);
                cuId = company.getCU().getId().toString();
                cu = company.getCU();
            }
            payPlanColls = this.getPaymentPlanColls(ctx, idSet);
            this.verifyPayPlan(ctx, payPlanColls, result, isCheckPer);
            if (result.getDetailMsgList() == null || result.getDetailMsgList().size() == 0) {
                ArrayList<String> demList = new ArrayList();
                PaymentScheduleSettingInfo payScheduleInfo = PSUtils.getPaymentScheduleInfo(ctx, cuId);
                if (payScheduleInfo != null) {
                    demList = this.getSumDemList(ctx, cuId);
                }
                summaryList = this.getPaySummaryList(ctx, idSet, payPlanColls, demList, payScheduleInfo.getPeriodType());
                if (payScheduleInfo != null && payScheduleInfo.isIsBySettleType()) {
                    SettlementPrioritySettingCollection settlePriSettingColls = this.getSettlePriColls(ctx, payScheduleInfo.getId().toString());
                    this.addPlanSummarySettleCateryEntrys(settlePriSettingColls, summaryList);
                }
                if (cu != null) {
                    this.fillCU(summaryList, cu);
                }
                this.fillPayerAccountBank(ctx, summaryList);
                this.savePayPlanSumaryBatch(ctx, summaryList);
                this.reversePaymentPlanBillBatch(ctx, payPlanColls);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PaymentPlanBillControllerBean.getResource(ctx, "025_ALL_SUMMARY_FAILED", new String[]{e.getMessage()}));
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (result.getSummaryMsg() == null) {
            summary = result.getDetailMsgList().size() == 0 ? summary + PaymentPlanBillControllerBean.getResource(ctx, "022_ALL_SUMMARY_SUCESS", null) : summary + "\u5168\u90e8\u6c47\u603b\u5931\u8d25\u3002";
            result.setSummaryMsg(summary);
        }
        if (companyId == null) {
            companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        }
        if ((PS003 = Boolean.valueOf(ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("PS003", (IObjectPK)new ObjectUuidPK(companyId)))).booleanValue() && !EmptyUtil.isEmpty(summaryList)) {
            ApproveThread approveThread = new ApproveThread(ctx, summaryList);
            approveThread.run();
        }
        return result;
    }

    private void fillCU(List<PayPlanSumaryInfo> summaryList, CtrlUnitInfo cu) {
        for (int i = 0; i < summaryList.size(); ++i) {
            summaryList.get(i).setCU(cu);
        }
    }

    private void doCheckPermission(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)PERM_ITEM_SUMMARY);
        if (!isPermission) {
            throw new PSException(PSException.NO_SUMMARY);
        }
        PSUtils.verifyOrgAdjust(ctx, company);
    }

    private void fillPayerAccountBank(Context ctx, List<PayPlanSumaryInfo> summaryList) throws BOSException {
        for (int i = 0; i < summaryList.size(); ++i) {
            PayPlanSumaryInfo info = summaryList.get(i);
            AccountBankInfo accInfo = this.getDefaultPayAccount(ctx, info.getCompany().getId().toString());
            PayPlanSumSettleEntryCollection settleEntrys = info.getSettleEntries();
            if (settleEntrys == null || settleEntrys.size() <= 0) continue;
            for (int m = 0; m < settleEntrys.size(); ++m) {
                PayPlanSumSettleEntryInfo entryInfo = settleEntrys.get(m);
                entryInfo.setPayerAccountBank(accInfo);
            }
        }
    }

    private AccountBankInfo getDefaultPayAccount(Context ctx, String companyId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultPayment", (Object)true, CompareType.EQUALS));
        view.setFilter(filter);
        AccountBankCollection bankColls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        if (bankColls != null && bankColls.size() > 0) {
            return bankColls.get(0);
        }
        return null;
    }

    private void verifyPayPlan(Context ctx, PaymentPlanBillCollection payPlanColls, BatchExecuteResult result, Boolean flag) throws BOSException, EASBizException {
        for (int i = 0; i < payPlanColls.size(); ++i) {
            boolean isPermission;
            PaymentPlanBillInfo info = payPlanColls.get(i);
            if (info.isIsSummary()) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "026_BILL_HAS_SUMMARY", new String[]{info.getNumber()}));
                continue;
            }
            if (info.getReportType() == null) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "027_BILL_REPROTTYPE_NULL", new String[]{info.getNumber()}));
                continue;
            }
            if (info.getBillStatus() != BillStatusEnum.REPORT) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "028_BILL_STATE_NOT_REPORT", new String[]{info.getNumber()}));
                continue;
            }
            if (info.getPeriod() == null) {
                String msg = PaymentPlanBillControllerBean.getResource(ctx, "131_PLAN_PERIOD_NOT_NULL", new String[]{info.getNumber()});
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "023_BILL_SUMMARY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), msg}));
                continue;
            }
            if (flag.booleanValue() && !(isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), (String)PERM_ITEM_SUMMARY))) {
                String msg = PaymentPlanBillControllerBean.getResource(ctx, "132_NO_SUMARY_AUTH", null);
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "023_BILL_SUMMARY_FAILED", new String[]{null, info.getNumber(), msg}));
                continue;
            }
            if (this.isInWorkFlow(ctx, info.getId().toString())) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "023_BILL_SUMMARY_FAILED", new String[]{null, info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                continue;
            }
            if (this.requestMutexLock(ctx, info.getId().toString())) continue;
            result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "023_BILL_SUMMARY_FAILED", new String[]{null, info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "029_BILL_IS_MUTEXED", null)}));
        }
    }

    private void savePayPlanSumaryBatch(Context ctx, List<PayPlanSumaryInfo> summaryList) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        Date date = new Date();
        for (int i = 0; i < summaryList.size(); ++i) {
            summaryList.get(i).getPaymentPlanEntrys().clear();
            summaryList.get(i).setBizDate(date);
            colls.add((CoreBaseInfo)summaryList.get(i));
        }
        PayPlanSumaryFactory.getLocalInstance(ctx).saveBatchData(colls);
    }

    private void reversePaymentPlanBillBatch(Context ctx, PaymentPlanBillCollection payPlanColls) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < payPlanColls.size(); ++i) {
            PaymentPlanBillInfo info = payPlanColls.get(i);
            info.setSumBillStatus(SummaryBillStatusEnum.SAVE);
            colls.add((CoreBaseInfo)info);
        }
        this.updateBatchData(ctx, colls);
    }

    private List<PayPlanSumaryInfo> getPaySummaryList(Context ctx, Set<String> idSet, PaymentPlanBillCollection payPlanColls, List<String> demList, PeriodTypeEnum periodType) throws BOSException, EASBizException {
        List<PayPlanSumaryInfo> sumaryList = this.getOrdinaryReportSummaryList(ctx, idSet, demList, periodType.getValue());
        this.doProcessOrdinaryReportPaysumaryEntrys(demList, payPlanColls, sumaryList, periodType.getValue());
        this.doProcessNotOrdinaryReportSummaryList(ctx, payPlanColls, sumaryList, periodType.getValue());
        return sumaryList;
    }

    private void doProcessOrdinaryReportPaysumaryEntrys(List<String> demList, PaymentPlanBillCollection payPlanColls, List<PayPlanSumaryInfo> sumaryList, int periodType) {
        for (int i = 0; i < sumaryList.size(); ++i) {
            PayPlanSumaryInfo payPlanSummaryInfo = sumaryList.get(i);
            if (payPlanSummaryInfo.getReportType() != ReportTypeEnum.ORDINARY) continue;
            for (int j = 0; j < payPlanColls.size(); ++j) {
                boolean isBelong = this.isBelongPaySummary(demList, payPlanColls.get(j), payPlanSummaryInfo, periodType);
                if (!isBelong) continue;
                payPlanColls.get(j).setPlanSumary(payPlanSummaryInfo);
                payPlanColls.get(j).setIsSummary(true);
                payPlanColls.get(j).setSumBillStatus(SummaryBillStatusEnum.SAVE);
            }
        }
    }

    private boolean isBelongPaySummary(List<String> demList, PaymentPlanBillInfo payPlanInfo, PayPlanSumaryInfo payPlanSummaryInfo, int periodType) {
        boolean result = true;
        if (payPlanInfo.getReportType() != ReportTypeEnum.ORDINARY) {
            result = false;
            return result;
        }
        if (demList.contains("department")) {
            if (payPlanSummaryInfo.getDepartment() == null) {
                if (payPlanInfo.getDepartment() != null) {
                    result = false;
                    return result;
                }
            } else if (!payPlanSummaryInfo.getDepartment().equals((Object)payPlanInfo.getDepartment())) {
                result = false;
                return result;
            }
        }
        if (demList.contains("asstActID")) {
            if (payPlanSummaryInfo.getAsstActID() == null) {
                if (payPlanInfo.getAsstActID() != null) {
                    result = false;
                    return result;
                }
            } else if (!payPlanSummaryInfo.getAsstActID().equals(payPlanInfo.getAsstActID())) {
                result = false;
                return result;
            }
        }
        if (demList.contains("fundProperty")) {
            if (payPlanSummaryInfo.getFundProperty() == null) {
                if (payPlanInfo.getFundProperty() != null) {
                    result = false;
                    return result;
                }
            } else if (!payPlanSummaryInfo.getFundProperty().equals(payPlanInfo.getFundProperty())) {
                result = false;
                return result;
            }
        }
        if (demList.contains("fundFlowItem")) {
            if (payPlanSummaryInfo.getFundFlowItem() == null) {
                if (payPlanInfo.getFundFlowItem() != null) {
                    result = false;
                    return result;
                }
            } else if (!payPlanSummaryInfo.getFundFlowItem().equals((Object)payPlanInfo.getFundFlowItem())) {
                result = false;
                return result;
            }
        }
        if (!payPlanInfo.getPeriod().equals(payPlanSummaryInfo.getPeriod())) {
            result = false;
            return result;
        }
        if (periodType == 0) {
            if (payPlanSummaryInfo.getPeriodEntry() == null) {
                if (payPlanInfo.getPeriodEntry() != null) {
                    result = false;
                    return result;
                }
            } else if (!payPlanSummaryInfo.getPeriodEntry().equals(payPlanInfo.getPeriodEntry())) {
                result = false;
                return result;
            }
        }
        if (!this.sdf.format(payPlanInfo.getPayableDate()).equals(payPlanSummaryInfo.getDescription())) {
            result = false;
            return result;
        }
        return result;
    }

    private void doProcessNotOrdinaryReportSummaryList(Context ctx, PaymentPlanBillCollection payPlanColls, List<PayPlanSumaryInfo> sumaryList, int periodType) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        for (int i = 0; i < payPlanColls.size(); ++i) {
            PaymentPlanBillInfo paymentPlanBillInfo = payPlanColls.get(i);
            if (paymentPlanBillInfo.getReportType() != ReportTypeEnum.SPECIAL) continue;
            PayPlanSumaryInfo paySummaryInfo = new PayPlanSumaryInfo();
            paySummaryInfo.setId(BOSUuid.create((BOSObjectType)paySummaryInfo.getBOSType()));
            paySummaryInfo.setCompany(currCompany);
            String number = this.initNumber(ctx, paySummaryInfo, (AbstractCoreBaseControllerBean)this);
            paySummaryInfo.setNumber(number);
            paySummaryInfo.setReportType(paymentPlanBillInfo.getReportType());
            paySummaryInfo.setCU(currCompany.getCU());
            paySummaryInfo.setCreator(currentUser);
            paySummaryInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            paySummaryInfo.setCurrency(paymentPlanBillInfo.getCurrency());
            paySummaryInfo.setBillStatus(SummaryBillStatusEnum.SAVE);
            paySummaryInfo.setDepartment(paymentPlanBillInfo.getDepartment());
            paySummaryInfo.setAsstActType(paymentPlanBillInfo.getAsstActType());
            paySummaryInfo.setAsstActID(paymentPlanBillInfo.getAsstActID());
            paySummaryInfo.setAsstActNumber(paymentPlanBillInfo.getAsstActNumber());
            paySummaryInfo.setAsstActName(paymentPlanBillInfo.getAsstActName());
            paySummaryInfo.setFundFlowItem(paymentPlanBillInfo.getFundFlowItem());
            paySummaryInfo.setFundProperty(paymentPlanBillInfo.getFundProperty());
            paySummaryInfo.setSettlementType(paymentPlanBillInfo.getSettlementType());
            paySummaryInfo.setApplyPayAmt(paymentPlanBillInfo.getApplyPayAmount());
            paySummaryInfo.setNotSettledAmt(BigDecimal.ZERO);
            paySummaryInfo.setSourceBillId(paymentPlanBillInfo.getId().toString());
            paySummaryInfo.setPeriod(paymentPlanBillInfo.getPeriod());
            if (periodType == 0) {
                paySummaryInfo.setPeriodEntry(paymentPlanBillInfo.getPeriodEntry());
            }
            paySummaryInfo.getPaymentPlanEntrys().add(paymentPlanBillInfo);
            paymentPlanBillInfo.setPlanSumary(paySummaryInfo);
            paymentPlanBillInfo.setIsSummary(true);
            sumaryList.add(paySummaryInfo);
        }
    }

    private List<PayPlanSumaryInfo> getOrdinaryReportSummaryList(Context ctx, Set<String> idSet, List<String> demList, int periodType) throws BOSException {
        ArrayList<PayPlanSumaryInfo> sumaryList = new ArrayList<PayPlanSumaryInfo>();
        IRowSet rs = null;
        try {
            StringBuffer sql = new StringBuffer("SELECT FPeriodId, SUBSTRING(to_char(FPayableDate,'YYYY-MM-DD'), 0, 7) AS FRefPeriod, FCompanyId,FCurrencyID");
            if (periodType == 0) {
                sql.append(",FPeriodEntryId ");
            }
            for (String dimen : demList) {
                sql.append(",");
                if (dimen.equals("department")) {
                    sql.append("FDepartmentID");
                    continue;
                }
                if (dimen.equals("asstActID")) {
                    sql.append("FAsstActID");
                    continue;
                }
                if (dimen.equals("fundProperty")) {
                    sql.append("FFundPropertyID");
                    continue;
                }
                if (!dimen.equals("fundFlowItem")) continue;
                sql.append("FFundFlowItemID");
            }
            sql.append(" ,SUM(FApplyPayAmount) as sumAppyPayAmt ,SUM(FSrcBillNotSettledAmt)  as sumNotSettleAmt FROM T_PS_PAYMENTPLANBILL  WHERE  fid IN ( ");
            ArrayList<String> idList = new ArrayList<String>(idSet);
            for (int i = 0; i < idList.size(); ++i) {
                if (i == 0) {
                    sql.append("'" + (String)idList.get(i) + "'");
                    continue;
                }
                sql.append(",'" + (String)idList.get(i) + "'");
            }
            sql.append(" ) and FReportType = 1 and FIsSummary = 0 GROUP BY FCompanyId,FCurrencyID,FPeriodId, SUBSTRING(to_char(FPayableDate,'YYYY-MM-DD'), 0, 7) ");
            if (periodType == 0) {
                sql.append(",FPeriodEntryId ");
            }
            for (String dimen : demList) {
                sql.append(",");
                if (dimen.equals("department")) {
                    sql.append("FDepartmentID");
                    continue;
                }
                if (dimen.equals("asstActID")) {
                    sql.append("FAsstActID");
                    continue;
                }
                if (dimen.equals("fundProperty")) {
                    sql.append("FFundPropertyID");
                    continue;
                }
                if (!dimen.equals("fundFlowItem")) continue;
                sql.append("FFundFlowItemID");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            while (rs.next()) {
                PayPlanSumaryInfo paySummaryInfo = new PayPlanSumaryInfo();
                paySummaryInfo.setId(BOSUuid.create((BOSObjectType)paySummaryInfo.getBOSType()));
                paySummaryInfo.setCompany(currCompany);
                paySummaryInfo.setCU(currCompany.getCU());
                paySummaryInfo.setCreator(currentUser);
                paySummaryInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                String number = this.initNumber(ctx, paySummaryInfo, (AbstractCoreBaseControllerBean)this);
                paySummaryInfo.setNumber(number);
                paySummaryInfo.setReportType(ReportTypeEnum.ORDINARY);
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("FCompanyId")));
                paySummaryInfo.setCompany(companyInfo);
                CurrencyInfo currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("FCurrencyID")));
                paySummaryInfo.setCurrency(currencyInfo);
                paySummaryInfo.setBillStatus(SummaryBillStatusEnum.SAVE);
                if (demList.contains("department")) {
                    AdminOrgUnitInfo adminOrgUnitInfo = null;
                    String departmentId = rs.getString("FDepartmentID");
                    if (departmentId != null) {
                        adminOrgUnitInfo = new AdminOrgUnitInfo();
                        adminOrgUnitInfo.setId(BOSUuid.read((String)departmentId));
                    }
                    paySummaryInfo.setDepartment(adminOrgUnitInfo);
                }
                if (demList.contains("asstActID")) {
                    String asstAcctID = rs.getString("FAsstActID");
                    if (asstAcctID != null) {
                        BOSObjectType bosType = new ObjectUuidPK(asstAcctID).getObjectType();
                        CoreBaseController coreBaseController = (CoreBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)bosType);
                        DataBaseInfo dbInfo = (DataBaseInfo)coreBaseController.getValue(ctx, (IObjectPK)new ObjectUuidPK(asstAcctID));
                        paySummaryInfo.setAsstActID(dbInfo.getId().toString());
                        paySummaryInfo.setAsstActNumber(dbInfo.getNumber());
                        paySummaryInfo.setAsstActName(dbInfo.getName());
                    } else {
                        paySummaryInfo.setAsstActID(asstAcctID);
                    }
                }
                if (demList.contains("fundProperty")) {
                    FundPropertyInfo fundPropertyInfo = null;
                    String fundPropertyId = rs.getString("FFundPropertyID");
                    if (fundPropertyId != null) {
                        fundPropertyInfo = new FundPropertyInfo();
                        fundPropertyInfo.setId(BOSUuid.read((String)rs.getString("FFundPropertyID")));
                    }
                    paySummaryInfo.setFundProperty(fundPropertyInfo);
                }
                if (demList.contains("fundFlowItem")) {
                    FundFlowItemInfo fundFlowItemInfo = null;
                    String fundFlowItemId = rs.getString("FFundFlowItemID");
                    if (fundFlowItemId != null) {
                        fundFlowItemInfo = new FundFlowItemInfo();
                        fundFlowItemInfo.setId(BOSUuid.read((String)fundFlowItemId));
                    }
                    paySummaryInfo.setFundFlowItem(fundFlowItemInfo);
                }
                paySummaryInfo.setApplyPayAmt(rs.getBigDecimal("sumAppyPayAmt"));
                paySummaryInfo.setNotSettledAmt(rs.getBigDecimal("sumNotSettleAmt"));
                paySummaryInfo.setPeriod(rs.getString("FPeriodId"));
                if (periodType == 0) {
                    paySummaryInfo.setPeriodEntry(rs.getString("FPeriodEntryId"));
                }
                paySummaryInfo.setDescription(StringUtils.replace((String)rs.getString("FRefPeriod"), (String)"-", (String)""));
                sumaryList.add(paySummaryInfo);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return sumaryList;
    }

    private void addPlanSummarySettleCateryEntrys(SettlementPrioritySettingCollection settlePriSettingColls, List<PayPlanSumaryInfo> sumaryList) {
        for (int i = 0; i < settlePriSettingColls.size(); ++i) {
            SettlementCategoryInfo categoryInfo = settlePriSettingColls.get(i).getCategory();
            SettlementTypeInfo settleInfo = settlePriSettingColls.get(i).getDefaultSettleType();
            block8: for (int j = 0; j < sumaryList.size(); ++j) {
                PayPlanSumaryInfo payPlanSumaryInfo = sumaryList.get(j);
                PayPlanSumSettleEntryInfo payPlanSumSettleEntryInfo = new PayPlanSumSettleEntryInfo();
                payPlanSumSettleEntryInfo.setSettleCategory(categoryInfo);
                payPlanSumSettleEntryInfo.setApproveAmt(new BigDecimal("0"));
                payPlanSumSettleEntryInfo.setParent(payPlanSumaryInfo);
                payPlanSumSettleEntryInfo.setSettleType(settleInfo);
                payPlanSumaryInfo.getSettleEntries().add(payPlanSumSettleEntryInfo);
                switch (i + 1) {
                    case 1: {
                        payPlanSumaryInfo.setSettleCate1(categoryInfo);
                        payPlanSumaryInfo.setApproveAmt1(new BigDecimal("0"));
                        continue block8;
                    }
                    case 2: {
                        payPlanSumaryInfo.setSettleCate2(categoryInfo);
                        payPlanSumaryInfo.setApproveAmt2(new BigDecimal("0"));
                        continue block8;
                    }
                    case 3: {
                        payPlanSumaryInfo.setSettleCate3(categoryInfo);
                        payPlanSumaryInfo.setApproveAmt3(new BigDecimal("0"));
                        continue block8;
                    }
                    case 4: {
                        payPlanSumaryInfo.setSettleCate4(categoryInfo);
                        payPlanSumaryInfo.setApproveAmt4(new BigDecimal("0"));
                        continue block8;
                    }
                    case 5: {
                        payPlanSumaryInfo.setSettleCate5(categoryInfo);
                        payPlanSumaryInfo.setApproveAmt5(new BigDecimal("0"));
                        continue block8;
                    }
                }
            }
        }
    }

    private PaymentPlanBillCollection getPaymentPlanColls(Context ctx, Set<String> idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        entityViewInfo.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        entityViewInfo.setSorter(sorter);
        return PaymentPlanBillFactory.getLocalInstance(ctx).getPaymentPlanBillCollection(entityViewInfo);
    }

    private String initNumber(Context ctx, BillBaseInfo info, AbstractCoreBaseControllerBean controller) throws BOSException, EASBizException {
        FilterInfo filter;
        String numberSilent = null;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return numberSilent;
        }
        int i = 0;
        do {
            if (EmptyUtil.isEmpty((String)(numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())))) {
                return numberSilent;
            }
            info.setNumber(numberSilent);
        } while (controller.exists(ctx, filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true)) && ++i < 10);
        return numberSilent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _submitBatch(Context ctx, List idList) throws BOSException, EASBizException {
        String perfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)("\u64cd\u4f5c\u65b9\u6cd5\uff1aPaymentPlanBillControllerBean._submitBatch \u64cd\u4f5c\u5458\uff1a" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("applyPayAmount"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("srcBillHeadID"));
        PaymentPlanBillInfo info = null;
        ObjectUuidPK[] pkArray = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pkArray[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = PaymentPlanBillControllerBean.getResource(ctx, "008_BILL_SUM", new String[]{pkArray.length + ""});
        int success = 0;
        for (int i = 0; i < pkArray.length; ++i) {
            info = this.getPaymentPlanBillInfo(ctx, (IObjectPK)pkArray[i], sic);
            try {
                PayRequestBillEntryInfo srcEntry;
                OtherBillPlanInfo otherPlan;
                BigDecimal unVerifyAmt;
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ps_paymentplan_04update");
                if (!isPermission) {
                    throw new PSException(PSException.NO_SUBMIT_AUTH);
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(PaymentPlanBillControllerBean.getResource(ctx, "021_IN_ADJUST_PERIOD_SINGLE", null));
                }
                if (!this.requestMutexLock(ctx, pkArray[i].toString())) {
                    throw new PSException(PSException.BILL_IS_MUTEXED, new Object[]{info.getNumber()});
                }
                BigDecimal applyAmt = info.getApplyPayAmount();
                if (info.getSourceBillType() == SrcBillTypeEnum.OTHERBILL ? applyAmt.compareTo(unVerifyAmt = (otherPlan = OtherBillPlanFactory.getLocalInstance((Context)ctx).getOtherBillPlanInfo((IObjectPK)new ObjectUuidPK(info.getSrcBillHeadID()))).getRecievePayAmount().subtract(otherPlan.getVerifyAmount())) != 0 : info.getSourceBillType() == SrcBillTypeEnum.PAYREQUESTBILL && applyAmt.compareTo((srcEntry = PayRequestBillEntryFactory.getLocalInstance((Context)ctx).getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(info.getSrcBillHeadID()))).getUnpayAmount()) != 0) {
                    throw new PSException(PSException.APPLYAMT_SRCUNVERIFYAMT_NOTEQUALS);
                }
                if (info.getBillStatus() != null && info.getBillStatus().getValue() != 1) {
                    throw new PSException(PSException.BILL_CANNOT_SUBMIT, new Object[]{info.getNumber()});
                }
                if (this.isInWorkFlow(ctx, pkArray[i].toString())) {
                    result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "035_BILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                    continue;
                }
                this.submit(ctx, (CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "035_BILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), PaymentPlanBillControllerBean.getResource(ctx, "ALREADY_IN_WORKFLOW", null)}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(PaymentPlanBillControllerBean.getResource(ctx, "035_BILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                this.releaseMutexLock(ctx, pkArray[i].toString());
            }
        }
        summary = success == pkArray.length ? summary + PaymentPlanBillControllerBean.getResource(ctx, "033_ALL_SUBMIT_SUCCESS", null) : summary + PaymentPlanBillControllerBean.getResource(ctx, "034_SUBMIT_RESULT", new String[]{String.valueOf(success), String.valueOf(pkArray.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord((String)perfLogId);
        return result;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PaymentPlanBillInfo info = (PaymentPlanBillInfo)model;
        return super._submit(ctx, (IObjectValue)info);
    }

    @Override
    protected List _carryOver(Context ctx, Date payableDate, String period, String periodWeek) throws BOSException, EASBizException {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        PaymentPlanBillCollection colls = this.getNeedCarryOverPaymentPlanColls(ctx, cu.getId().toString(), period, periodWeek);
        if (colls == null || colls.size() == 0) {
            return null;
        }
        Date currDate = new Date();
        CoreBaseCollection coreColls = new CoreBaseCollection();
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> verifyIds = new ArrayList<String>();
        PaymentPlanBillCollection filterColls = this.getFilterBEColls(ctx, colls);
        for (int i = 0; i < filterColls.size(); ++i) {
            PaymentPlanBillInfo info = filterColls.get(i);
            BigDecimal payAmt = info.getPayAmount() != null ? info.getPayAmount() : BigDecimal.ZERO;
            BigDecimal applyAmt = info.getApplyPayAmount().subtract(payAmt);
            if (info.getSourceBillType() == SrcBillTypeEnum.OTHERBILL) {
                if (!EmptyUtil.isEmpty((String)info.getSrcBillHeadID())) {
                    OtherBillPlanInfo otherPlan = OtherBillPlanFactory.getLocalInstance((Context)ctx).getOtherBillPlanInfo((IObjectPK)new ObjectUuidPK(info.getSrcBillHeadID()));
                    BigDecimal unVerifyAmt = otherPlan.getRecievePayAmount().subtract(otherPlan.getVerifyAmount());
                    if (applyAmt.compareTo(unVerifyAmt) != 0) {
                        applyAmt = unVerifyAmt;
                    }
                } else {
                    logger.error((Object)("------planInfo:[id=" + info.getId().toString() + ",srcOtherNumber=" + info.getSourceBillNumber() + "]"));
                }
            } else if (info.getSourceBillType() == SrcBillTypeEnum.PAYREQUESTBILL) {
                if (!EmptyUtil.isEmpty((String)info.getSrcBillHeadID())) {
                    PayRequestBillEntryInfo srcEntry = PayRequestBillEntryFactory.getLocalInstance((Context)ctx).getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(info.getSrcBillHeadID()));
                    if (applyAmt.compareTo(srcEntry.getUnpayAmount()) != 0) {
                        applyAmt = srcEntry.getUnpayAmount();
                    }
                } else {
                    logger.error((Object)("------planInfo:[id=" + info.getId().toString() + ",srcPayRequestNumber=" + info.getSourceBillNumber() + "]"));
                }
            }
            if (applyAmt.compareTo(BigDecimal.ZERO) > 0) {
                idList.add(info.getId().toString());
                PaymentPlanBillInfo newInfo = this.buildCarryOverInfo(ctx, info, applyAmt, currDate, period, periodWeek);
                coreColls.add((CoreBaseInfo)newInfo);
                continue;
            }
            verifyIds.add(info.getId().toString());
        }
        this.setPlanIsCarrayOver(ctx, idList);
        if (verifyIds.size() > 0) {
            String inClause = PSUtils.idListToInClause(verifyIds);
            logger.error((Object)("sourceBill is Verified, planBillID == " + inClause));
            StringBuffer sql = new StringBuffer("UPDATE T_PS_PaymentPlanBill set FBillStatus = 6 WHERE FID  IN (" + inClause + ")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        this.save(ctx, coreColls);
        logger.error((Object)("\u5df2\u7ed3\u8f6c\u4ed8\u6b3e\u8ba1\u5212\u6570\uff1a" + coreColls.size()));
        return null;
    }

    public PaymentPlanBillCollection getFilterBEColls(Context ctx, PaymentPlanBillCollection colls) throws BOSException, EASBizException {
        PaymentPlanBillCollection result = new PaymentPlanBillCollection();
        HashMap<String, BankPayingBillStateEnum> stateMap = new HashMap<String, BankPayingBillStateEnum>();
        block0: for (int i = 0; i < colls.size(); ++i) {
            BigDecimal payAmt;
            PaymentPlanBillInfo info = colls.get(i);
            BigDecimal bigDecimal = payAmt = info.getPayAmount() != null ? info.getPayAmount() : BigDecimal.ZERO;
            if (payAmt.compareTo(BigDecimal.ZERO) > 0) {
                List<String> paymentIDs = this.getPaymentBillIDs(ctx, info.getId().toString());
                if (paymentIDs != null && paymentIDs.size() > 0) {
                    for (String paymentID : paymentIDs) {
                        BankPayingBillStateEnum state = null;
                        if (stateMap.containsKey(paymentID)) {
                            state = (BankPayingBillStateEnum)stateMap.get(paymentID);
                        } else {
                            state = this.getBEState(ctx, paymentID);
                            if (state != null) {
                                logger.error((Object)("-------------PaymentBillID=" + paymentID + ", BEState=" + state.getAlias() + "-------------"));
                                stateMap.put(paymentID, state);
                            }
                        }
                        if (state != null) continue;
                        result.add(info);
                        continue block0;
                    }
                    continue;
                }
                result.add(info);
                continue;
            }
            result.add(info);
        }
        return result;
    }

    private BankPayingBillStateEnum getBEState(Context ctx, String paymentID) throws BOSException {
        BankPayingBillStateEnum state = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)paymentID));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)6, CompareType.NOTEQUALS));
        view.setFilter(filter);
        BankPayingBillCollection coll = BankPayingBillFactory.getLocalInstance((Context)ctx).getBankPayingBillCollection(view);
        if (coll != null && coll.size() > 0) {
            state = coll.get(0).getState();
        }
        return state;
    }

    private List<String> getPaymentBillIDs(Context ctx, String srcPlanBillID) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Distinct head.FID  AS FPaymentBillID ");
        sql.append(" FROM T_CAS_Paymentbill head LEFT JOIN T_CAS_PaymentbillEntry entrys ON entrys.FPaymentBillID = head.FID ");
        sql.append(" WHERE head.FBillStatus = 15 ");
        sql.append(" AND head.FIsCommitToBE = 1 ");
        sql.append(" AND entrys.FSrcPlanBillID = '" + srcPlanBillID + "'");
        logger.debug((Object)("sql:" + sql.toString()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                idList.add(rs.getString("FPaymentBillID"));
            }
        }
        catch (SQLException e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return idList;
    }

    public PaymentPlanBillInfo buildCarryOverInfo(Context ctx, PaymentPlanBillInfo info, BigDecimal applyAmt, Date currDate, String period, String periodWeek) throws BOSException {
        PaymentPlanBillInfo newInfo = new PaymentPlanBillInfo();
        newInfo.setBizDate(currDate);
        newInfo.setApplyPayAmount(applyAmt);
        newInfo.setCompany(info.getCompany());
        newInfo.setAsstActID(info.getAsstActID());
        newInfo.setAsstActName(info.getAsstActName());
        newInfo.setAsstActNumber(info.getAsstActNumber());
        newInfo.setAsstActType(info.getAsstActType());
        newInfo.setFundFlowItem(info.getFundFlowItem());
        newInfo.setDepartment(info.getDepartment());
        newInfo.setFundProperty(info.getFundProperty());
        newInfo.setSettlementType(info.getSettlementType());
        newInfo.setPayerAccountBank(info.getPayerAccountBank());
        newInfo.setCurrency(info.getCurrency());
        newInfo.setCreator(info.getCreator());
        newInfo.setSourceBillNumber(info.getSourceBillNumber());
        newInfo.setSourceBillType(info.getSourceBillType());
        newInfo.setApplyPayDate(info.getApplyPayDate());
        newInfo.setPayableDate(info.getPayableDate());
        newInfo.setBillStatus(BillStatusEnum.SAVE);
        newInfo.setNumber(PSUtils.initNumber(ctx, newInfo, newInfo.getCompany().getId().toString()));
        newInfo.setPlanSumary(null);
        newInfo.setPrePlanBillID(info.getId().toString());
        newInfo.setSourceBillId(info.getSourceBillId());
        newInfo.setSrcBillHeadID(info.getSrcBillHeadID());
        newInfo.setScheduleAmount(BigDecimal.ZERO);
        newInfo.setPayAmount(BigDecimal.ZERO);
        newInfo.setApprovedAmt(BigDecimal.ZERO);
        newInfo.setAuditDate(null);
        newInfo.setAuditor(null);
        newInfo.setIsSummary(false);
        newInfo.setPaymentMode(info.getPaymentMode());
        return newInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentPlanBillCollection getNeedCarryOverPaymentPlanColls(Context ctx, String cuId, String period, String periodWeek) throws BOSException, EASBizException {
        PaymentPlanBillCollection colls = null;
        List<String> idList = this.getCarryOverIDList(ctx, cuId, period, periodWeek);
        if (idList.size() > 500) {
            ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            String tableName = iTableManager.getTemporaryTableName("PLANID");
            try {
                if (tableName.length() > 30) {
                    tableName = tableName.substring(0, 30);
                }
                DbUtil.execute((Context)ctx, (String)MessageFormat.format("CREATE TABLE {0} ( FID VARCHAR(44) );", tableName));
                String insertSql = "INSERT INTO {0} (FID) VALUES(''{1}'');\n";
                StringBuilder sqlBuilder = new StringBuilder();
                for (String id : idList) {
                    sqlBuilder.append(MessageFormat.format(insertSql, tableName, id));
                }
                DbUtil.execute((Context)ctx, (String)sqlBuilder.toString());
                String oql = " WHERE id IN ( SELECT FID FROM " + tableName + " )";
                colls = this.getPaymentPlanBillCollection(ctx, oql);
            }
            finally {
                iTableManager.releaseTemporaryTableName(tableName);
            }
        } else {
            HashSet<String> idSet = new HashSet<String>(idList);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            colls = this.getPaymentPlanBillCollection(ctx, view);
        }
        return colls;
    }

    private List<String> getCarryOverIDList(Context ctx, String cuId, String period, String periodWeek) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer(" SELECT  FID ");
        sql.append(" FROM T_PS_PaymentPlanBill ");
        sql.append(" WHERE FBillStatus <> 6  and FIsCarryOver = 0 and FControlUnitID = '" + cuId + "'");
        sql.append(" and FApplyPayAmount > FPayAmount ");
        if (periodWeek == null) {
            sql.append(" and FPeriodId < '" + period + "'");
        } else {
            sql.append(" and (FPeriodId < '" + period + "' OR (FPeriodId = '" + period + "' and FPeriodEntryId < '" + periodWeek + "'))");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            while (rs.next()) {
                idList.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return idList;
    }

    private List<String> getSumDemList(Context ctx, String cuId) throws BOSException, EASBizException {
        ArrayList<String> demList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  dim.FPayPlanColumnName as payPlanColumnName  FROM T_PS_PaymentScheduleSetting setting ");
        sql.append(" LEFT JOIN T_PS_SummaryDimensionSetting sumdiemSetting  ON sumdiemSetting.FPaymentScheduleSettingID = setting.FID");
        sql.append(" LEFT JOIN T_PS_DIMENSION dim  ON dim.FID = sumdiemSetting.FDimensionID  ");
        sql.append(" WHERE setting.FControlUnitID = '" + cuId + "'");
        sql.append(" AND sumdiemSetting.FIsGrounpSummary = 1  ");
        sql.append("  order by sumdiemSetting.FPriority");
        logger.debug((Object)("sql:" + sql.toString()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs != null) {
                while (rs.next()) {
                    demList.add(rs.getString("payPlanColumnName"));
                }
                return demList;
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("parent.id"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
            if (company != null && company.getParent() != null) {
                this.getSumDemList(ctx, company.getParent().getId().toString());
            }
        }
        catch (SQLException e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return demList;
    }

    private SettlementPrioritySettingCollection getSettlePriColls(Context ctx, String payScheduleId) throws PSException, BOSException {
        SettlementPrioritySettingCollection coll = new SettlementPrioritySettingCollection();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT settlePri.fid AS settlePriId,settleCate.fid AS settleCateId, settlePri.FDefaultSettleType  as defaultSettleTypeId   FROM T_PS_PaymentScheduleSetting setting ");
        sql.append(" INNER JOIN T_PS_SettlementPrioritySetting settlePri ON settlePri.FPaySchdlSettingID = setting.fid");
        sql.append(" INNER JOIN T_PS_SettlementCategory  settleCate  ON   settleCate.fid = settlePri.FCategoryid");
        sql.append(" where setting.Fid = '" + payScheduleId + "'");
        sql.append(" ORDER BY settlePri.FPriority");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs != null) {
                while (rs.next()) {
                    SettlementPrioritySettingInfo settlePri = new SettlementPrioritySettingInfo();
                    SettlementCategoryInfo categoryInfo = new SettlementCategoryInfo();
                    categoryInfo.setId(BOSUuid.read((String)rs.getString("settleCateId")));
                    settlePri.setId(BOSUuid.read((String)rs.getString("settlePriId")));
                    settlePri.setCategory(categoryInfo);
                    if (rs.getString("defaultSettleTypeId") != null) {
                        SettlementTypeInfo settType = new SettlementTypeInfo();
                        settType.setId(BOSUuid.read((String)rs.getString("defaultSettleTypeId")));
                        settlePri.setDefaultSettleType(settType);
                    }
                    coll.add(settlePri);
                }
                return coll;
            }
        }
        catch (SQLException e) {
            throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _genPaymentBill(Context ctx, List idList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idList.size() + ""});
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = this.getSelector();
        view.setSelector(sic);
        PaymentPlanBillCollection colls = this.getPaymentPlanBillCollection(ctx, view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idSet.size());
        List<MsgInfo> errList = null;
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Boolean checkPermission = true;
        if (userInfo.getType().equals((Object)UserType.SYSTEM)) {
            checkPermission = false;
        }
        int fail = 0;
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            ArrayList<PaymentPlanBillInfo> infoList = new ArrayList<PaymentPlanBillInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                PaymentPlanBillInfo info = colls.get(i);
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                String msg = this.verify(ctx, isLocked, info, checkPermission);
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                infoList.add(info);
            }
            if (infoList.size() > 0) {
                errList = this.doProcess(ctx, infoList);
            }
            if (errList != null && errList.size() > 0) {
                block4: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block4;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"076_GEN_PAYMENTBILL_FAILED", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"077_ALL_GEN_PAYMENTBILL_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"078_GEN_PAYMENTBILL_RESULT", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.settleCate.id"));
        sic.add(new SelectorItemInfo("entries.settleCate.name"));
        sic.add(new SelectorItemInfo("entries.settleType.id"));
        sic.add(new SelectorItemInfo("entries.settleType.name"));
        sic.add(new SelectorItemInfo("entries.payerAccBank.id"));
        sic.add(new SelectorItemInfo("entries.payerAccBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("entries.payerAccBank.account.id"));
        sic.add(new SelectorItemInfo("entries.payerAccBank.account.name"));
        return sic;
    }

    private String verify(Context ctx, boolean isLocked, PaymentPlanBillInfo info, Boolean checkPermission) throws EASBizException, BOSException {
        String msg = null;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"cas_paymentbill_02addNew");
        if (checkPermission.booleanValue() && !isPermission) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"074_NO_PAYMENTBILL_ADDNEW_AUTHRIZED");
        } else if (!isLocked) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
        } else if (info.getBillStatus().getValue() <= 3 || info.getBillStatus() == BillStatusEnum.CLOSE) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"075_BILL_CANNOT_GEN_PAYMENTBILL");
        } else if (this.currentDate.compareTo(info.getSchdlPayDate()) < 0 || this.currentDate.compareTo(info.getSchdlExpiredDate()) > 0) {
            msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"149_SCHDLPAYDATE_RANGE_OVER");
        } else {
            BigDecimal payAmt;
            BigDecimal scheduleAmt = info.getScheduleAmount() != null ? info.getScheduleAmount() : BigDecimal.ZERO;
            BigDecimal lockAmt = info.getApprovedAmt() != null ? info.getApprovedAmt() : BigDecimal.ZERO;
            if ((scheduleAmt = scheduleAmt.subtract(lockAmt.add(payAmt = info.getPayAmount() != null ? info.getPayAmount() : BigDecimal.ZERO))).compareTo(BigDecimal.ZERO) <= 0) {
                msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"096_SCHLDAMT_NOT_ENOUGH");
            }
        }
        return msg;
    }

    private List<MsgInfo> doProcess(Context ctx, List<PaymentPlanBillInfo> infoList) throws EASBizException, BOSException {
        List<MsgInfo> errList = null;
        try {
            for (PaymentPlanBillInfo info : infoList) {
                ArrayList<PaymentBillInfo> lst = new ArrayList<PaymentBillInfo>();
                for (int i = 0; i < info.getEntries().size(); ++i) {
                    PaymentPlanBillEntryInfo entry = info.getEntries().get(i);
                    PaymentBillInfo destInfo = this.doGenerate(ctx, info, entry);
                    if (destInfo == null) continue;
                    lst.add(destInfo);
                }
                if (lst != null && lst.size() != 0) continue;
                throw new PSException(PSException.BILL_CANNOT_GENERATE);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            errList = this.setErrMsgList(errList, infoList, msg);
        }
        return errList;
    }

    private PaymentBillInfo doGenerate(Context ctx, PaymentPlanBillInfo info, PaymentPlanBillEntryInfo entry) throws EASBizException, BOSException {
        PaymentBillInfo destInfo = this.buildPaymentBillInfo(ctx, info, entry);
        if (destInfo != null && !EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            IObjectPK pk = PaymentBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)destInfo);
            ArrayList<String> srcIdList = new ArrayList<String>();
            String sourceBillID = info.getSourceBillId() != null ? info.getSourceBillId() : info.getId().toString();
            srcIdList.add(sourceBillID);
            BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
            if (info.getSourceBillId() != null) {
                ArrayList<String> planIdList = new ArrayList<String>();
                planIdList.add(info.getId().toString());
                BOTPUtil.saveBOTRelation((Context)ctx, planIdList, (String)pk.toString());
            }
        }
        return destInfo;
    }

    private PaymentBillInfo buildPaymentBillInfo(Context ctx, PaymentPlanBillInfo info, PaymentPlanBillEntryInfo entry) throws EASBizException, BOSException {
        PaymentBillInfo destInfo = null;
        String sourceBillId = info.getSourceBillId();
        BigDecimal lockAmt = entry.getLockAmt() != null ? entry.getLockAmt() : BigDecimal.ZERO;
        BigDecimal payAmt = entry.getPayAmt() != null ? entry.getPayAmt() : BigDecimal.ZERO;
        BigDecimal scheduleAmt = entry.getScheduleAmt().subtract(lockAmt.add(payAmt));
        if (scheduleAmt.compareTo(BigDecimal.ZERO) > 0) {
            String destBosType = new PaymentBillInfo().getBOSType().toString();
            BOTMappingCollection botMapCol = (BOTMappingCollection)BOTMappingHelper.getMappingForSelect((Context)ctx, (String)info.getBOSType().toString(), (String)destBosType, null);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)botMapCol)) {
                throw new BOTPException(BOTPException.NOMAPPING);
            }
            BOTMappingInfo maping = botMapCol.get(0);
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            CoreBillBaseCollection srcBillColls = new CoreBillBaseCollection();
            PaymentPlanBillInfo cloneInfo = (PaymentPlanBillInfo)info.clone();
            cloneInfo.getEntries().clear();
            cloneInfo.getEntries().add(entry);
            srcBillColls.add((CoreBillBaseInfo)cloneInfo);
            if (!EmptyUtil.isEmpty((String)sourceBillId)) {
                BOSObjectType bosType;
                ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
                srcBillColsList.add(srcBillColls);
                ArrayList<ObjectUuidPK> botMappingPkCols = new ArrayList<ObjectUuidPK>();
                botMappingPkCols.add(new ObjectUuidPK(maping.getId().toString()));
                BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillColsList, destBosType, botMappingPkCols);
                IObjectCollection colls = btpResult.getBills();
                if (colls != null && colls.size() > 0) {
                    destInfo = (PaymentBillInfo)colls.getObject(0);
                    destInfo.getEntries().clear();
                }
                if ((bosType = BOSUuid.read((String)sourceBillId).getType()).equals((Object)new OtherBillInfo().getBOSType())) {
                    destInfo = this.buildByOtherBill(ctx, sourceBillId, info, entry, destInfo);
                } else if (bosType.equals((Object)new PayRequestBillInfo().getBOSType())) {
                    destInfo = this.buildByPayRequestBill(ctx, sourceBillId, info, entry, destInfo);
                }
            } else {
                BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillColls, destBosType, (IObjectPK)new ObjectUuidPK(maping.getId().toString()));
                IObjectCollection colls = btpResult.getBills();
                if (colls != null && colls.size() > 0) {
                    destInfo = (PaymentBillInfo)colls.getObject(0);
                }
            }
        }
        return destInfo;
    }

    private PaymentBillInfo buildByPayRequestBill(Context ctx, String sourceBillId, PaymentPlanBillInfo info, PaymentPlanBillEntryInfo entry, PaymentBillInfo destInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.asstActType.*"));
        PayRequestBillInfo srcInfo = PayRequestBillFactory.getLocalInstance((Context)ctx).getPayRequestBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
        if (srcInfo != null) {
            BigDecimal lockAmt = entry.getLockAmt() != null ? entry.getLockAmt() : BigDecimal.ZERO;
            BigDecimal payAmt = entry.getPayAmt() != null ? entry.getPayAmt() : BigDecimal.ZERO;
            BigDecimal scheduleAmt = entry.getScheduleAmt().subtract(lockAmt.add(payAmt));
            if (scheduleAmt.compareTo(BigDecimal.ZERO) > 0) {
                PaymentBillEntryInfo destEntry = null;
                for (int i = 0; i < srcInfo.getEntrys().size(); ++i) {
                    PayRequestBillEntryInfo srcEntry = srcInfo.getEntrys().get(i);
                    if (!info.getSrcBillHeadID().equals(srcEntry.getId().toString()) || srcEntry.getUnpayAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                    destEntry = this.buildPaymentEntryInfo(ctx, scheduleAmt, sourceBillId, srcInfo.getAccount(), srcEntry);
                    destEntry.setSeq(1);
                    break;
                }
                if (destEntry != null) {
                    destInfo = this.buildPaymentInfo(ctx, destInfo, entry, srcInfo, info);
                    destInfo.getEntries().add(destEntry);
                } else {
                    destInfo = null;
                }
            }
        }
        return destInfo;
    }

    private PaymentBillInfo buildPaymentInfo(Context ctx, PaymentBillInfo destInfo, PaymentPlanBillEntryInfo entry, PayRequestBillInfo srcInfo, PaymentPlanBillInfo info) throws EASBizException, BOSException {
        if (destInfo == null) {
            destInfo = new PaymentBillInfo();
        }
        destInfo.setBizDate(new Date());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("accountBankName.bank.*"));
        PayRequestBillEntryInfo srcEntry = PayRequestBillEntryFactory.getLocalInstance((Context)ctx).getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(info.getSrcBillHeadID()), sic);
        if (destInfo.getPayeeType() == null) {
            destInfo.setPayeeType(srcEntry.getAsstActType());
        }
        if (destInfo.getPayeeID() == null) {
            destInfo.setPayeeID(srcEntry.getAsstActID());
        }
        if (destInfo.getPayeeNumber() == null) {
            destInfo.setPayeeNumber(srcEntry.getAsstActNumber());
        }
        if (destInfo.getPayeeName() == null) {
            destInfo.setPayeeName(srcEntry.getAsstActName());
        }
        if (destInfo.getPayeeBank() == null) {
            if (srcEntry.getAccountBankName() != null) {
                destInfo.setPayeeBank(srcEntry.getAccountBankName().getBank().toString());
            } else {
                destInfo.setPayeeBank(null);
            }
        }
        if (destInfo.getPayeeAccountBank() == null) {
            destInfo.setPayeeAccountBank(srcEntry.getAccountBankNo());
        }
        if (destInfo.getPayBillType() == null) {
            destInfo.setPayBillType(srcEntry.getPayType());
        }
        destInfo.setSourceType(SourceTypeEnum.AP);
        destInfo.setPayPlanBillID(entry.getId().toString());
        if (destInfo.getCurrency() == null) {
            destInfo.setCurrency(srcInfo.getCurrency());
        }
        if (destInfo.getExchangeRate() == null) {
            destInfo.setExchangeRate(srcInfo.getExchange_rate());
        }
        if (entry.getSettleType() != null) {
            destInfo.setSettlementType(entry.getSettleType());
        }
        if (entry.getPayerAccBank() != null) {
            destInfo.setPayerAccountBank(entry.getPayerAccBank());
            destInfo.setPayerAccount(entry.getPayerAccBank().getAccount());
        }
        if (destInfo.getOppAccount() == null) {
            destInfo.setOppAccount(srcInfo.getAccount());
        }
        destInfo.setBillStatus(com.kingdee.eas.fi.cas.BillStatusEnum.SAVE);
        destInfo.setPerson(srcInfo.getApplyer());
        if (destInfo.getCompany() == null) {
            destInfo.setCompany(srcInfo.getCompany());
        }
        destInfo.setSourceBillId(srcInfo.getId().toString());
        destInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return destInfo;
    }

    private PaymentBillEntryInfo buildPaymentEntryInfo(Context ctx, BigDecimal scheduleAmt, String sourceBillId, AccountViewInfo accountViewInfo, PayRequestBillEntryInfo srcInfo) throws EASBizException, BOSException {
        PaymentBillEntryInfo destInfo = new PaymentBillEntryInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setSourceBillId(sourceBillId);
        destInfo.setSourceBillEntryId(srcInfo.getId().toString());
        if (srcInfo.getCoreBillTypeId() != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            BOSObjectType bosType = BOSUuid.read((String)srcInfo.getCoreBillTypeId()).getType();
            EntityObjectInfo entityInfo = loader.getEntity(bosType);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("entryTable", (Object)entityInfo.getTable()));
            view.setFilter(filter);
            BillTypeCollection colls = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeCollection(view);
            if (colls != null && colls.size() > 0) {
                destInfo.setCoreBillType(colls.get(0));
            }
        }
        destInfo.setCoreBillId(srcInfo.getCoreBillId());
        destInfo.setCoreBillNumber(srcInfo.getCoreBillNumber());
        destInfo.setCoreBillEntryId(srcInfo.getCoreBillEntryId());
        destInfo.setCoreBillEntrySeq(srcInfo.getCoreBillLineNo());
        destInfo.setAmount(scheduleAmt);
        destInfo.setActualAmt(destInfo.getAmount());
        destInfo.setOppAccount(accountViewInfo);
        destInfo.setProject(srcInfo.getProject());
        destInfo.setTrackNumber(srcInfo.getTrackNumber());
        return destInfo;
    }

    private PaymentBillInfo buildByOtherBill(Context ctx, String sourceBillId, PaymentPlanBillInfo info, PaymentPlanBillEntryInfo entry, PaymentBillInfo destInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.coreBillType.id"));
        OtherBillInfo srcInfo = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
        if (srcInfo != null && srcInfo.getBillStatus() == com.kingdee.eas.fi.ar.BillStatusEnum.AUDITED) {
            BigDecimal lockAmt = entry.getLockAmt() != null ? entry.getLockAmt() : BigDecimal.ZERO;
            BigDecimal payAmt = entry.getPayAmt() != null ? entry.getPayAmt() : BigDecimal.ZERO;
            BigDecimal scheduleAmt = entry.getScheduleAmt().subtract(lockAmt.add(payAmt));
            if (scheduleAmt.compareTo(BigDecimal.ZERO) > 0) {
                PaymentBillEntryCollection destEntrys = this.decomposeAmt(scheduleAmt, sourceBillId, srcInfo.getExchangeRate(), srcInfo.getEntry());
                if (destEntrys.size() > 0) {
                    destInfo = this.buildPaymentInfo(ctx, destInfo, entry, srcInfo);
                    destInfo.getEntries().addCollection(destEntrys);
                } else {
                    destInfo = null;
                }
            }
        }
        return destInfo;
    }

    private PaymentBillInfo buildPaymentInfo(Context ctx, PaymentBillInfo destInfo, PaymentPlanBillEntryInfo entry, OtherBillInfo srcInfo) throws EASBizException, BOSException {
        if (destInfo == null) {
            destInfo = new PaymentBillInfo();
        }
        destInfo.setBizDate(new Date());
        if (destInfo.getPayeeType() == null) {
            destInfo.setPayeeType(srcInfo.getAsstActType());
        }
        if (destInfo.getPayeeID() == null) {
            destInfo.setPayeeID(srcInfo.getAsstActID());
        }
        if (destInfo.getPayeeNumber() == null) {
            destInfo.setPayeeNumber(srcInfo.getAsstActNumber());
        }
        if (destInfo.getPayeeName() == null) {
            destInfo.setPayeeName(srcInfo.getAsstActName());
        }
        if (destInfo.getPayBillType() == null) {
            destInfo.setPayBillType(PaymentBillTypeFactory.getLocalInstance((Context)ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(CAS_PAYMENTBILLTYPE_ID)));
        }
        destInfo.setSourceType(SourceTypeEnum.AP);
        destInfo.setPayPlanBillID(entry.getId().toString());
        if (destInfo.getCurrency() == null) {
            destInfo.setCurrency(srcInfo.getCurrency());
        }
        if (destInfo.getExchangeRate() == null) {
            destInfo.setExchangeRate(srcInfo.getExchangeRate());
        }
        if (destInfo.getSettlementType() == null) {
            destInfo.setSettlementType(srcInfo.getSettleType());
        }
        destInfo.setFundType(BizTypeEnum.CASH);
        destInfo.setIsCommitSettle(false);
        destInfo.setIsRedBill(false);
        destInfo.setIsTransBill(false);
        destInfo.setIsTransOtherBill(false);
        if (destInfo.getCompany() == null) {
            destInfo.setCompany(srcInfo.getCompany());
        }
        destInfo.setBillStatus(com.kingdee.eas.fi.cas.BillStatusEnum.SAVE);
        destInfo.setSourceBillId(null);
        destInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (entry.getSettleType() != null) {
            destInfo.setSettlementType(entry.getSettleType());
        }
        if (entry.getPayerAccBank() != null) {
            destInfo.setPayerAccountBank(entry.getPayerAccBank());
            destInfo.setPayerAccount(entry.getPayerAccBank().getAccount());
        }
        return destInfo;
    }

    private PaymentBillEntryCollection decomposeAmt(BigDecimal scheduleAmt, String sourceBillId, BigDecimal exRate, OtherBillentryCollection srcColl) {
        BigDecimal decompAmt = scheduleAmt;
        PaymentBillEntryCollection destEntrys = new PaymentBillEntryCollection();
        FMHelper.sortCollection((AbstractObjectCollection)srcColl, (String[])new String[]{"seq"});
        for (int i = 0; i < srcColl.size(); ++i) {
            OtherBillentryInfo srcInfo = srcColl.get(i);
            if (srcInfo.getLockUnVerifyAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            PaymentBillEntryInfo destInfo = this.buildPaymentEntryInfo(sourceBillId, srcInfo);
            destInfo.setSeq(i + 1);
            BigDecimal applyAmt = srcInfo.getLockUnVerifyAmt();
            if (applyAmt.compareTo(decompAmt) >= 0) {
                destInfo.setAmount(decompAmt);
                destInfo.setLocalAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
                destInfo.setUnLockAmt(destInfo.getAmount());
                destInfo.setUnLockLocAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
                destInfo.setUnVcAmount(destInfo.getAmount());
                destInfo.setUnVcLocAmount(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
                destEntrys.add(destInfo);
                break;
            }
            if (applyAmt.compareTo(decompAmt) < 0) {
                destInfo.setAmount(applyAmt);
                destInfo.setLocalAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
                destInfo.setUnLockAmt(destInfo.getAmount());
                destInfo.setUnLockLocAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
                destInfo.setUnVcAmount(destInfo.getAmount());
                destInfo.setUnVcLocAmount(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
                destEntrys.add(destInfo);
                decompAmt = decompAmt.subtract(applyAmt);
                continue;
            }
            destInfo.setAmount(decompAmt);
            destInfo.setLocalAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
            destInfo.setUnLockAmt(destInfo.getAmount());
            destInfo.setUnLockLocAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
            destInfo.setUnVcAmount(destInfo.getAmount());
            destInfo.setUnVcLocAmount(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
            destEntrys.add(destInfo);
            break;
        }
        return destEntrys;
    }

    private PaymentBillEntryInfo buildPaymentEntryInfo(String sourceBillId, OtherBillentryInfo srcInfo) {
        PaymentBillEntryInfo destInfo = new PaymentBillEntryInfo();
        destInfo.setSourceBillId(sourceBillId);
        destInfo.setSourceBillEntryId(srcInfo.getId().toString());
        destInfo.setCoreBillType(srcInfo.getCoreBillType());
        destInfo.setCoreBillId(srcInfo.getCoreBillId());
        destInfo.setCoreBillEntryId(srcInfo.getCoreBillEntryId());
        destInfo.setCoreBillNumber(srcInfo.getCoreBillNumber());
        destInfo.setCoreBillEntrySeq(srcInfo.getCoreBillEntrySeq());
        destInfo.setOppAccount(srcInfo.getAccount());
        destInfo.setProject(srcInfo.getProject());
        destInfo.setTrackNumber(srcInfo.getTrackNumberzc());
        return destInfo;
    }

    private List<MsgInfo> setErrMsgList(List<MsgInfo> errList, List<PaymentPlanBillInfo> infoList, String message) {
        if (errList == null) {
            errList = new ArrayList<MsgInfo>(infoList.size());
        }
        for (PaymentPlanBillInfo info : infoList) {
            MsgInfo msgInfo = new MsgInfo();
            msgInfo.setId(info.getId().toString());
            msgInfo.setNumber(info.getNumber());
            msgInfo.setMsg(message);
            errList.add(msgInfo);
        }
        return errList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _bitBack(Context ctx, Set idSet, String msg) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        CoreBaseCollection payPlanSumColls = new CoreBaseCollection();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int success = 0;
        try {
            Map mutextMap = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(idSet));
            PaymentPlanBillCollection colls = this.getPaymentPlanColls(ctx, idSet);
            for (int i = 0; i < colls.size(); ++i) {
                PaymentPlanBillInfo info = colls.get(i);
                try {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_BITBACK);
                    if (!isPermission) {
                        throw new PSException(PSException.NO_BIT_AUTH);
                    }
                    boolean isLock = (Boolean)mutextMap.get(info.getId().toString());
                    if (!isLock) {
                        throw new PSException(PSException.BILL_IS_MUTEXED);
                    }
                    if (info.getBillStatus() != BillStatusEnum.REPORT || info.isIsSummary()) {
                        result.getDetailMsgList().add(PSUtils.getResource(ctx, "089_BIT_FAIL", new String[]{info.getNumber(), PSUtils.getResource(ctx, "089_NOT_REPORT_SUMARY_BIT", null)}));
                        continue;
                    }
                    info.setBillStatus(BillStatusEnum.SAVE);
                    info.setReportDate(null);
                    info.setReportType(null);
                    info.setReportUser(null);
                    info.setDescription(msg);
                    this.save(ctx, (CoreBaseInfo)info);
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PSUtils.getResource(ctx, "089_BIT_FAIL", new String[]{info.getNumber(), e.getMessage()}));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSummaryMsg(PSUtils.getResource(ctx, "091_PAYPLAN_BIT_EXCE", new String[]{e.getMessage()}));
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(new ArrayList(idSet));
        }
        if (result.getSummaryMsg() == null && success == idSet.size()) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "092_BIT_ALL_SUCC", null));
        } else {
            summary = summary + PSUtils.getResource(ctx, "093_BIT_SUCC_FAIL_NUM", new String[]{success + "", String.valueOf(idSet.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    private void setPlanIsCarrayOver(Context ctx, List<String> idList) throws BOSException {
        if (idList.size() > 0) {
            String inClause = PSUtils.idListToInClause(idList);
            StringBuffer sql = new StringBuffer("UPDATE T_PS_PaymentPlanBill set FIsCarryOver = 1, FBillStatus = 6 WHERE FID  IN (" + inClause + ")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public static void main(String[] args) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT settlePri.fid AS settlePriId,settleCate.fid AS settleCateId FROM T_PS_PaymentScheduleSetting setting ");
        sql.append(" LEFT JOIN T_PS_SettlementPrioritySetting settlePri ON settlePri.FPaySchdlSettingID = setting.fid");
        sql.append(" LEFT JOIN T_PS_SettlementCategory  settleCate  ON   settleCate.fid = settlePri.FCategoryid");
        sql.append(" where setting.Fid = ");
        sql.append(" ORDER BY settlePri.FPriority");
        System.out.println(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _handSchedule(Context ctx, String planId, String paySumId) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        result.setError(-1);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            boolean isLock = iMutex.requestBizObjIDForUpdate(planId);
            if (!isLock) {
                throw new PSException(PSException.BILL_IS_MUTEXED);
            }
            isLock = iMutex.requestBizObjIDForUpdate(paySumId);
            if (!isLock) {
                throw new PSException(PSException.BILL_IS_MUTEXED);
            }
            PaymentPlanBillInfo planInfo = this.getPaymentPlanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(planId));
            PayPlanSumaryInfo sumInfo = PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo((IObjectPK)new ObjectUuidPK(paySumId));
            this.verify4Schedule(ctx, planInfo, sumInfo, result);
            if (result.getDetailMsgList() == null || result.getDetailMsgList().size() == 0) {
                this.doSchedule(ctx, planInfo, sumInfo);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(planInfo.getId()), (CoreBaseInfo)planInfo);
                PayPlanSumaryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sumInfo.getId()), (CoreBaseInfo)sumInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setError(1);
            result.setSummaryMsg(PSUtils.getResource(ctx, "137_HAND_SCHE_FAIL_REASON", null) + e.getMessage());
        }
        finally {
            iMutex.releaseObjIDForUpdate(planId);
            iMutex.releaseObjIDForUpdate(paySumId);
        }
        if (result.getSummaryMsg() == null && result.getDetailMsgList().size() == 0) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "139_HAND_SCHE_SUCC", null));
        } else if (result.getSummaryMsg() == null) {
            result.setSummaryMsg(PSUtils.getResource(ctx, "138_HAND_SCHE_FAIL", null));
            result.setError(1);
        }
        return result;
    }

    private void verify4Schedule(Context ctx, PaymentPlanBillInfo planInfo, PayPlanSumaryInfo sumInfo, BatchExecuteResult result) {
        if (planInfo.getBillStatus() != BillStatusEnum.SAVE) {
            result.getDetailMsgList().add(PSUtils.getResource(ctx, "163_PLAN_SAVE_SCHE", null));
            return;
        }
        if (sumInfo.getBillStatus() != SummaryBillStatusEnum.APPROVED) {
            result.getDetailMsgList().add(PSUtils.getResource(ctx, "141_SUMARY_AUDIT_SCHE", null));
            return;
        }
        if (sumInfo.getNotIssuedAmt().compareTo(planInfo.getApplyPayAmount()) < 0) {
            result.getDetailMsgList().add(PSUtils.getResource(ctx, "142_SUMARY_NOTISSUE_L_APPLY", null));
            return;
        }
    }

    private void doSchedule(Context ctx, PaymentPlanBillInfo planInfo, PayPlanSumaryInfo sumInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(planInfo.getCompany().getId()));
        List<SettlementCategoryInfo> settleCateList = PSUtils.getSettleCategoryList(ctx, company.getCU().getId().toString());
        if (settleCateList == null || settleCateList.size() == 0) {
            planInfo.setScheduleAmount(planInfo.getApplyPayAmount());
            sumInfo.setNotIssuedAmt(sumInfo.getNotIssuedAmt().subtract(planInfo.getScheduleAmount()));
            planInfo.setSettlementType(sumInfo.getSettlementType());
            planInfo.setPayerAccountBank(sumInfo.getPayerAccountBank());
        } else {
            BigDecimal totalCurScheduleAmt = BigDecimal.ZERO;
            PayPlanSumSettleEntryCollection settleColls = sumInfo.getSettleEntries();
            for (int i = 0; i < settleCateList.size(); ++i) {
                SettlementCategoryInfo settleCateInfo = settleCateList.get(i);
                if (planInfo.getScheduleAmount() == null) {
                    planInfo.setScheduleAmount(BigDecimal.ZERO);
                }
                if (planInfo.getScheduleAmount().compareTo(planInfo.getApplyPayAmount()) >= 0) break;
                PayPlanSumSettleEntryInfo settleEntryInfo = this.getSumarySettleEntry(settleCateInfo.getId().toString(), settleColls);
                if (settleEntryInfo.getNotIssuedAmt() == null || settleEntryInfo.getNotIssuedAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal noScheduleAmt = planInfo.getApplyPayAmount().subtract(totalCurScheduleAmt);
                BigDecimal curScheduleAmt = BigDecimal.ZERO;
                if (noScheduleAmt.compareTo(settleEntryInfo.getNotIssuedAmt()) <= 0) {
                    planInfo.setScheduleAmount(planInfo.getScheduleAmount().add(noScheduleAmt));
                    settleEntryInfo.setNotIssuedAmt(settleEntryInfo.getNotIssuedAmt().subtract(noScheduleAmt));
                    totalCurScheduleAmt = totalCurScheduleAmt.add(noScheduleAmt);
                    curScheduleAmt = noScheduleAmt;
                } else {
                    planInfo.setScheduleAmount(planInfo.getScheduleAmount().add(settleEntryInfo.getNotIssuedAmt()));
                    curScheduleAmt = settleEntryInfo.getNotIssuedAmt();
                    totalCurScheduleAmt = totalCurScheduleAmt.add(settleEntryInfo.getNotIssuedAmt());
                    settleEntryInfo.setNotIssuedAmt(BigDecimal.ZERO);
                }
                switch (i + 1) {
                    case 1: {
                        sumInfo.setNotIssuedAmt1(settleEntryInfo.getNotIssuedAmt());
                        break;
                    }
                    case 2: {
                        sumInfo.setNotIssuedAmt2(settleEntryInfo.getNotIssuedAmt());
                        break;
                    }
                    case 3: {
                        sumInfo.setNotIssuedAmt3(settleEntryInfo.getNotIssuedAmt());
                    }
                }
                int seqNo = planInfo.getEntries().size();
                PaymentPlanBillEntryInfo planEntryInfo = this.buildEntryInfo(settleEntryInfo.getSettleType(), settleEntryInfo.getPayerAccountBank(), settleCateInfo.getId().toString(), curScheduleAmt, seqNo);
                planInfo.getEntries().add(planEntryInfo);
            }
            sumInfo.setNotIssuedAmt(sumInfo.getNotIssuedAmt().subtract(totalCurScheduleAmt));
        }
        planInfo.setPlanSumary(sumInfo);
        planInfo.setSchdlPayDate(sumInfo.getLimitStartDate());
        planInfo.setSchdlExpiredDate(sumInfo.getLimitExpiredDate());
        sumInfo.getPaymentPlanEntrys().add(planInfo);
        planInfo.setBillStatus(BillStatusEnum.SCHEDULED);
        planInfo.setIsManualSche(true);
    }

    private PayPlanSumSettleEntryInfo getSumarySettleEntry(String cateId, PayPlanSumSettleEntryCollection settleColls) {
        for (int m = 0; m < settleColls.size(); ++m) {
            PayPlanSumSettleEntryInfo entryInfo = settleColls.get(m);
            if (!cateId.equals(entryInfo.getSettleCategory().getId().toString())) continue;
            return entryInfo;
        }
        return null;
    }

    private PaymentPlanBillEntryInfo buildEntryInfo(SettlementTypeInfo settleType, AccountBankInfo bankInfo, String settleCateId, BigDecimal schdlAmt, int seqNo) {
        PaymentPlanBillEntryInfo entry = new PaymentPlanBillEntryInfo();
        entry.setSeq(seqNo);
        SettlementCategoryInfo sc = new SettlementCategoryInfo();
        sc.setId(BOSUuid.read((String)settleCateId));
        entry.setSettleCate(sc);
        entry.setSettleType(settleType);
        entry.setPayerAccBank(bankInfo);
        entry.setScheduleAmt(schdlAmt);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _cancelManualSchedule(Context ctx, List idList) throws BOSException, EASBizException {
        int fail = 0;
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idList.size() + ""});
        BatchExecuteResult result = new BatchExecuteResult();
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>();
        List<MsgInfo> errList = null;
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PaymentPlanBillCollection paymentPlanColls = this.getPaymentPlanBillCollection(ctx, view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            Map mutexMap = iMutex.batchRequestBizObjIDForUpdate(idList);
            ArrayList<PaymentPlanBillInfo> planList = new ArrayList<PaymentPlanBillInfo>();
            for (int i = 0; i < paymentPlanColls.size(); ++i) {
                PaymentPlanBillInfo info = paymentPlanColls.get(i);
                String msg = this.verifyForCancelManualSchedule(ctx, mutexMap, info);
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                planList.add(info);
            }
            if (planList.size() > 0) {
                errList = this.doProcessCancelManualSche(ctx, planList);
            }
            if (errList != null && errList.size() > 0) {
                block6: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block6;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"159_CANCEL_MANUE_SCHE_FAIL", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"160_CANCEL_MANUE_SCHE_ALL_SUCC");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"161_CANCEL_MANU_SCHE_DETAIL", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private String verifyForCancelManualSchedule(Context ctx, Map mutexMap, PaymentPlanBillInfo info) throws EASBizException, BOSException {
        String msg;
        block3: {
            PaymentPlanBillEntryCollection payPlanBillEntryColls;
            block6: {
                block7: {
                    block5: {
                        block4: {
                            Boolean hasLock;
                            block2: {
                                msg = null;
                                Boolean hasPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_CANCELSMANUSCHEDULE);
                                hasLock = (Boolean)mutexMap.get(info.getId().toString());
                                if (hasPermission.booleanValue()) break block2;
                                msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"162_NO_PERM_CANCEL_MANU_SCHE");
                                break block3;
                            }
                            if (hasLock.booleanValue()) break block4;
                            msg = FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                            break block3;
                        }
                        if (info.isIsManualSche()) break block5;
                        msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"154_BILL_NOT_MANUE_SCHE");
                        break block3;
                    }
                    payPlanBillEntryColls = info.getEntries();
                    if (payPlanBillEntryColls != null && payPlanBillEntryColls.size() != 0) break block6;
                    if (info.getApprovedAmt().compareTo(BigDecimal.ZERO) == 0) break block7;
                    msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"157_BILL_LOCKAMT_NOT_ZERO");
                    break block3;
                }
                if (info.getPayAmount().compareTo(BigDecimal.ZERO) == 0) break block3;
                msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"158_BILL_PAYAMT_NOT_ZERO");
                break block3;
            }
            for (int i = 0; i < payPlanBillEntryColls.size(); ++i) {
                PaymentPlanBillEntryInfo planBillEntryInfo = payPlanBillEntryColls.get(i);
                SettlementCategoryInfo cateInfo = SettlementCategoryFactory.getLocalInstance(ctx).getSettlementCategoryInfo((IObjectPK)new ObjectUuidPK(planBillEntryInfo.getSettleCate().getId()));
                if (planBillEntryInfo.getLockAmt().compareTo(BigDecimal.ZERO) != 0) {
                    msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"155_BILL_LOCKAMT_NOT_ZERO_CATE", (String[])new String[]{cateInfo.getName()});
                    continue;
                }
                if (planBillEntryInfo.getPayAmt().compareTo(BigDecimal.ZERO) == 0) continue;
                msg = FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"156_BILL_PAYAMT_NOT_ZERO_CATE", (String[])new String[]{cateInfo.getName()});
            }
        }
        return msg;
    }

    private List<MsgInfo> doProcessCancelManualSche(Context ctx, List<PaymentPlanBillInfo> planList) {
        ArrayList<MsgInfo> errList = new ArrayList<MsgInfo>();
        for (int i = 0; i < planList.size(); ++i) {
            PaymentPlanBillInfo planInfo = planList.get(i);
            try {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(planInfo.getCompany().getId()));
                List<SettlementCategoryInfo> settleCateList = PSUtils.getSettleCategoryList(ctx, company.getCU().getId().toString());
                PayPlanSumaryInfo sumInfo = PayPlanSumaryFactory.getLocalInstance(ctx).getPayPlanSumaryInfo((IObjectPK)new ObjectUuidPK(planInfo.getPlanSumary().getId()));
                PaymentPlanBillEntryCollection planEntryColls = planInfo.getEntries();
                if (planEntryColls == null || planEntryColls.size() == 0) {
                    sumInfo.setNotIssuedAmt(sumInfo.getNotIssuedAmt().add(planInfo.getScheduleAmount()));
                } else {
                    BigDecimal totalScheAmt = BigDecimal.ZERO;
                    for (int m = 0; m < planEntryColls.size(); ++m) {
                        PaymentPlanBillEntryInfo planEntryInfo = planEntryColls.get(m);
                        String cateId = planEntryInfo.getSettleCate().getId().toString();
                        int priority = this.getPriority(cateId, settleCateList);
                        PayPlanSumSettleEntryInfo sumEntryInfo = this.getSumarySettleEntry(cateId, sumInfo.getSettleEntries());
                        sumEntryInfo.setNotIssuedAmt(sumEntryInfo.getNotIssuedAmt().add(planEntryInfo.getScheduleAmt()));
                        switch (priority) {
                            case 1: {
                                sumInfo.setNotIssuedAmt1(sumInfo.getNotIssuedAmt1().add(planEntryInfo.getScheduleAmt()));
                                break;
                            }
                            case 2: {
                                sumInfo.setNotIssuedAmt2(sumInfo.getNotIssuedAmt2().add(planEntryInfo.getScheduleAmt()));
                                break;
                            }
                            case 3: {
                                sumInfo.setNotIssuedAmt3(sumInfo.getNotIssuedAmt3().add(planEntryInfo.getScheduleAmt()));
                                break;
                            }
                            case 4: {
                                sumInfo.setNotIssuedAmt4(sumInfo.getNotIssuedAmt4().add(planEntryInfo.getScheduleAmt()));
                                break;
                            }
                            case 5: {
                                sumInfo.setNotIssuedAmt5(sumInfo.getNotIssuedAmt5().add(planEntryInfo.getScheduleAmt()));
                                break;
                            }
                        }
                        totalScheAmt = totalScheAmt.add(planEntryInfo.getScheduleAmt());
                    }
                    sumInfo.setNotIssuedAmt(sumInfo.getNotIssuedAmt().add(totalScheAmt));
                }
                planInfo.setBillStatus(BillStatusEnum.SAVE);
                planInfo.setIsManualSche(false);
                planInfo.getEntries().clear();
                planInfo.setScheduleAmount(BigDecimal.ZERO);
                planInfo.setPlanSumary(null);
                sumInfo.getPaymentPlanEntrys().remove(planInfo);
                PayPlanSumaryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sumInfo.getId()), (CoreBaseInfo)sumInfo);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(planInfo.getId()), (CoreBaseInfo)planInfo);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                MsgInfo info = new MsgInfo();
                info.setId(planInfo.getId().toString());
                info.setMsg(msg);
                errList.add(info);
            }
        }
        return errList;
    }

    private int getPriority(String cateId, List<SettlementCategoryInfo> settleCateList) {
        for (int i = 0; i < settleCateList.size(); ++i) {
            if (!cateId.equals(settleCateList.get(i).getId().toString())) continue;
            return i + 1;
        }
        return -1;
    }

    private void doDeletePaymentBillRatePayPlan(Context ctx, PaymentPlanBillInfo info) throws BOSException, EASBizException {
        if (info.getApprovedAmt() != null && info.getApprovedAmt().compareTo(BigDecimal.ZERO) != 0) {
            IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
            boolean isSourceBill = info.getSourceBillType() == SrcBillTypeEnum.OTHERBILL || info.getSourceBillType() == SrcBillTypeEnum.PAYREQUESTBILL;
            PaymentPlanBillEntryCollection planEntryColls = info.getEntries();
            for (int m = 0; m < planEntryColls.size(); ++m) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                if (isSourceBill) {
                    filter.getFilterItems().add(new FilterItemInfo("payPlanBillID", (Object)planEntryColls.get(m).getId().toString(), CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)planEntryColls.get(m).getId().toString(), CompareType.EQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)10, CompareType.EQUALS));
                view.setFilter(filter);
                PaymentBillCollection paymentBillColls = iPaymentBill.getPaymentBillCollection(view);
                if (paymentBillColls == null || paymentBillColls.size() <= 0) continue;
                HashSet<String> idList = new HashSet<String>();
                for (int i = 0; i < paymentBillColls.size(); ++i) {
                    idList.add(paymentBillColls.get(i).getId().toString());
                }
                iPaymentBill.batchRemove(idList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchGenPaymentBill(Context ctx, List idList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        HashSet idSet = new HashSet(idList);
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = this.getSelector();
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        view.setSorter(sorter);
        PaymentPlanBillCollection colls = this.getPaymentPlanBillCollection(ctx, view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<MsgInfo> msgList = new ArrayList<MsgInfo>(idSet.size());
        List<MsgInfo> errList = null;
        int fail = 0;
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Boolean checkPermission = true;
        if (userInfo.getType().equals((Object)UserType.SYSTEM)) {
            checkPermission = false;
        }
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            TreeMap<Integer, List<PlanScheduledInfo>> tmpMap = new TreeMap<Integer, List<PlanScheduledInfo>>();
            for (int i = 0; i < colls.size(); ++i) {
                PaymentPlanBillInfo info = colls.get(i);
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                String msg = this.verify(ctx, isLocked, info, checkPermission);
                MsgInfo msgInfo = new MsgInfo();
                msgInfo.setId(info.getId().toString());
                msgInfo.setNumber(info.getNumber());
                msgInfo.setMsg(msg);
                msgList.add(msgInfo);
                if (msg != null) continue;
                List<PlanScheduledInfo> subList = this.convertPlanInfo(info);
                for (PlanScheduledInfo planInfo : subList) {
                    int type = planInfo.getSourceBillType();
                    ArrayList<PlanScheduledInfo> lst = (ArrayList<PlanScheduledInfo>)tmpMap.get(type);
                    if (lst == null) {
                        lst = new ArrayList<PlanScheduledInfo>();
                    }
                    lst.add(planInfo);
                    tmpMap.put(type, lst);
                }
            }
            if (tmpMap.size() > 0) {
                OtherBillCollection otherColl = this.getOtherBillColl(ctx, (List)tmpMap.get(1));
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)otherColl)) {
                    this.otherEntryList = this.getOtherEntryList(otherColl);
                }
                Map<Integer, TreeMap<String, List<PlanScheduledInfo>>> typeMap = this.getTypeMap(tmpMap);
                errList = this.doProcess(ctx, typeMap);
            }
            if (errList != null && errList.size() > 0) {
                block5: for (MsgInfo msgInfo : msgList) {
                    for (MsgInfo errInfo : errList) {
                        if (!errInfo.getId().equals(msgInfo.getId())) continue;
                        msgInfo.setMsg(errInfo.getMsg());
                        continue block5;
                    }
                }
            }
            for (MsgInfo msgInfo : msgList) {
                if (EmptyUtil.isEmpty((String)msgInfo.getMsg())) continue;
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"076_GEN_PAYMENTBILL_FAILED", (String[])new String[]{msgInfo.getNumber(), msgInfo.getMsg()}));
                ++fail;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"077_ALL_GEN_PAYMENTBILL_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)webResourcePath, (String)"078_GEN_PAYMENTBILL_RESULT", (String[])new String[]{String.valueOf(idSet.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private OtherBillCollection getOtherBillColl(Context ctx, List<PlanScheduledInfo> infoList) throws EASBizException, BOSException {
        OtherBillCollection srcColl = null;
        if (infoList != null && infoList.size() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("asstActType.*"));
            sic.add(new SelectorItemInfo("billStatus"));
            sic.add(new SelectorItemInfo("entry.*"));
            sic.add(new SelectorItemInfo("entry.coreBillType.id"));
            srcColl = new OtherBillCollection();
            HashSet<String> idSet = new HashSet<String>();
            for (PlanScheduledInfo info : infoList) {
                String sourceBillId = info.getSourceBillID();
                if (idSet.contains(sourceBillId)) continue;
                idSet.add(sourceBillId);
                OtherBillInfo srcInfo = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
                if (srcInfo == null || srcInfo.getBillStatus() != com.kingdee.eas.fi.ar.BillStatusEnum.AUDITED) continue;
                srcColl.add(srcInfo);
            }
        }
        return srcColl;
    }

    private Map<Integer, TreeMap<String, List<PlanScheduledInfo>>> getTypeMap(Map<Integer, List<PlanScheduledInfo>> tmpMap) {
        HashMap<Integer, TreeMap<String, List<PlanScheduledInfo>>> typeMap = new HashMap<Integer, TreeMap<String, List<PlanScheduledInfo>>>();
        for (Integer type : tmpMap.keySet()) {
            List<PlanScheduledInfo> infoList = tmpMap.get(type);
            TreeMap<String, ArrayList<PlanScheduledInfo>> planMap = new TreeMap<String, ArrayList<PlanScheduledInfo>>();
            for (PlanScheduledInfo info : infoList) {
                String key = info.getSupplierID() + info.getSettleTypeID() + info.getAccountBankID();
                ArrayList<PlanScheduledInfo> lst = (ArrayList<PlanScheduledInfo>)planMap.get(key);
                if (lst == null) {
                    lst = new ArrayList<PlanScheduledInfo>();
                }
                lst.add(info);
                planMap.put(key, lst);
            }
            typeMap.put(type, planMap);
        }
        return typeMap;
    }

    private List<PlanScheduledInfo> convertPlanInfo(PaymentPlanBillInfo info) {
        ArrayList<PlanScheduledInfo> lst = new ArrayList<PlanScheduledInfo>(info.getEntries().size());
        for (int i = 0; i < info.getEntries().size(); ++i) {
            PaymentPlanBillEntryInfo entry = info.getEntries().get(i);
            BigDecimal lockAmt = entry.getLockAmt() != null ? entry.getLockAmt() : BigDecimal.ZERO;
            BigDecimal payAmt = entry.getPayAmt() != null ? entry.getPayAmt() : BigDecimal.ZERO;
            BigDecimal scheduleAmt = entry.getScheduleAmt().subtract(lockAmt.add(payAmt));
            if (scheduleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            PlanScheduledInfo planInfo = new PlanScheduledInfo();
            planInfo.setSupplierID(info.getAsstActID());
            planInfo.setSettleTypeID(entry.getSettleType() != null ? entry.getSettleType().getId().toString() : "");
            planInfo.setAccountBankID(entry.getPayerAccBank() != null ? entry.getPayerAccBank().getId().toString() : "");
            planInfo.setPlanID(info.getId().toString());
            planInfo.setPlanEntryID(entry.getId().toString());
            planInfo.setSourceBillID(info.getSourceBillId());
            planInfo.setSrcBillHeadID(info.getSrcBillHeadID());
            planInfo.setScheduleAmt(entry.getScheduleAmt() != null ? entry.getScheduleAmt() : BigDecimal.ZERO);
            planInfo.setLockAmt(entry.getLockAmt() != null ? entry.getLockAmt() : BigDecimal.ZERO);
            planInfo.setPayAmt(entry.getPayAmt() != null ? entry.getPayAmt() : BigDecimal.ZERO);
            planInfo.setPlanNumber(info.getNumber());
            planInfo.setSourceBillType(info.getSourceBillType() != null ? info.getSourceBillType().getValue() : 0);
            lst.add(planInfo);
        }
        return lst;
    }

    private List<MsgInfo> doProcess(Context ctx, Map<Integer, TreeMap<String, List<PlanScheduledInfo>>> typeMap) throws BOTPException, BOSException {
        List<MsgInfo> errList = null;
        String srcBosType = new PaymentPlanBillInfo().getBOSType().toString();
        BOTMappingCollection botMapCol = (BOTMappingCollection)BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBosType, (String)this.destBosType, null);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)botMapCol)) {
            throw new BOTPException(BOTPException.NOMAPPING);
        }
        BOTMappingInfo maping = botMapCol.get(0);
        for (Integer type : typeMap.keySet()) {
            TreeMap<String, List<PlanScheduledInfo>> planMap = typeMap.get(type);
            if (type != 0) {
                logger.info((Object)("-------------type=" + SrcBillTypeEnum.getEnum(type).getAlias() + "-------------"));
            } else {
                logger.info((Object)"-------------type=\u8ba1\u5212\u5355-------------");
            }
            for (String key : planMap.keySet()) {
                BigDecimal totalSchdlAmt = BigDecimal.ZERO;
                List<PlanScheduledInfo> infoList = planMap.get(key);
                for (PlanScheduledInfo info : infoList) {
                    BigDecimal schdlAmt = info.getScheduleAmt().subtract(info.getLockAmt().add(info.getPayAmt()));
                    totalSchdlAmt = totalSchdlAmt.add(schdlAmt);
                }
                logger.info((Object)("same key=" + key + ", totalSchdlAmt = " + totalSchdlAmt.toString()));
                try {
                    PaymentBillInfo destInfo = this.doGenerate(ctx, maping.getId().toString(), type, totalSchdlAmt, infoList);
                    if (destInfo != null) continue;
                    throw new PSException(PSException.BILL_CANNOT_GENERATE);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.toString();
                    }
                    errList = this.setErrMsgList4Batch(errList, infoList, msg);
                }
            }
        }
        return errList;
    }

    private PaymentBillInfo doGenerate(Context ctx, String mapingID, int srcBillType, BigDecimal totalSchdlAmt, List<PlanScheduledInfo> infoList) throws EASBizException, BOSException {
        PaymentBillInfo destInfo = this.buildPaymentBillInfo(ctx, mapingID, srcBillType, totalSchdlAmt, infoList);
        if (destInfo != null) {
            for (PlanScheduledInfo info : infoList) {
                if (EmptyUtil.isEmpty((String)info.getSourceBillID())) continue;
                IObjectPK pk = PaymentBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)destInfo);
                ArrayList<String> srcIdList = new ArrayList<String>();
                String sourceBillID = info.getSourceBillID() != null ? info.getSourceBillID() : info.getPlanID();
                srcIdList.add(sourceBillID);
                BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)pk.toString());
                if (info.getSourceBillID() == null) continue;
                ArrayList<String> planIdList = new ArrayList<String>();
                planIdList.add(info.getPlanID());
                BOTPUtil.saveBOTRelation((Context)ctx, planIdList, (String)pk.toString());
            }
        }
        return destInfo;
    }

    private PaymentBillInfo buildPaymentBillInfo(Context ctx, String mapingID, int srcBillType, BigDecimal totalSchdlAmt, List<PlanScheduledInfo> infoList) throws BOSException, EASBizException {
        PaymentBillInfo destInfo = null;
        if (totalSchdlAmt.compareTo(BigDecimal.ZERO) > 0) {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            IPaymentPlanBillEntry iPlanEntry = PaymentPlanBillEntryFactory.getLocalInstance(ctx);
            CoreBillBaseCollection srcBillColls = new CoreBillBaseCollection();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("asstActType.*"));
            for (PlanScheduledInfo planInfo : infoList) {
                PaymentPlanBillInfo info = this.getPaymentPlanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(planInfo.getPlanID()), sic);
                PaymentPlanBillInfo cloneInfo = (PaymentPlanBillInfo)info.clone();
                cloneInfo.getEntries().clear();
                PaymentPlanBillEntryInfo entry = iPlanEntry.getPaymentPlanBillEntryInfo((IObjectPK)new ObjectUuidPK(planInfo.getPlanEntryID()));
                cloneInfo.getEntries().add(entry);
                srcBillColls.add((CoreBillBaseInfo)cloneInfo);
            }
            if (srcBillType != 0) {
                ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
                srcBillColsList.add(srcBillColls);
                ArrayList<ObjectUuidPK> botMappingPkCols = new ArrayList<ObjectUuidPK>();
                botMappingPkCols.add(new ObjectUuidPK(mapingID));
                BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillColsList, this.destBosType, botMappingPkCols);
                IObjectCollection colls = btpResult.getBills();
                if (colls != null && colls.size() > 0) {
                    destInfo = (PaymentBillInfo)colls.getObject(0);
                    destInfo.getEntries().clear();
                }
                if (srcBillType == 1) {
                    destInfo = this.buildByOtherBill(ctx, infoList, destInfo);
                } else if (srcBillType == 2) {
                    destInfo = this.buildByPayRequestBill(ctx, infoList, destInfo);
                }
            } else {
                BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillColls, this.destBosType, (IObjectPK)new ObjectUuidPK(mapingID));
                IObjectCollection colls = btpResult.getBills();
                if (colls != null && colls.size() > 0) {
                    destInfo = (PaymentBillInfo)colls.getObject(0);
                }
            }
        }
        return destInfo;
    }

    private PaymentBillInfo buildByOtherBill(Context ctx, List<PlanScheduledInfo> infoList, PaymentBillInfo destInfo) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty(this.otherEntryList)) {
            return null;
        }
        String sourceBillID = infoList.get(0).getSourceBillID();
        if (this.otherBillCache == null) {
            this.otherBillCache = new HashMap<String, OtherBillInfo>();
        }
        OtherBillInfo srcInfo = null;
        if (this.otherBillCache.containsKey(sourceBillID)) {
            srcInfo = this.otherBillCache.get(sourceBillID);
        } else {
            srcInfo = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(sourceBillID));
            this.otherBillCache.put(sourceBillID, srcInfo);
        }
        BigDecimal exRate = srcInfo.getExchangeRate();
        PaymentBillEntryCollection destEntrys = this.decomposeAmt(infoList, exRate);
        if (destEntrys.size() > 0) {
            destInfo = this.buildPaymentInfo(ctx, destInfo, infoList.get(0), srcInfo);
            destInfo.getEntries().addCollection(destEntrys);
        } else {
            destInfo = null;
        }
        return destInfo;
    }

    private List<OtherEntryInfo> getOtherEntryList(OtherBillCollection srcColl) {
        ArrayList<OtherEntryInfo> srcEntryColl = new ArrayList<OtherEntryInfo>();
        for (int i = 0; i < srcColl.size(); ++i) {
            OtherBillInfo srcInfo = srcColl.get(i);
            OtherBillentryCollection srcEntrys = srcInfo.getEntry();
            FMHelper.sortCollection((AbstractObjectCollection)srcEntrys, (String[])new String[]{"seq"});
            for (int j = 0; j < srcEntrys.size(); ++j) {
                OtherBillentryInfo srcEntry = srcEntrys.get(j);
                if (srcEntry.getLockUnVerifyAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                OtherEntryInfo entry = this.buildOtherEntryInfo(srcEntry);
                entry.setParentID(srcInfo.getId().toString());
                srcEntryColl.add(entry);
            }
        }
        return srcEntryColl;
    }

    private OtherEntryInfo buildOtherEntryInfo(OtherBillentryInfo srcInfo) {
        OtherEntryInfo destInfo = new OtherEntryInfo();
        destInfo.setId(srcInfo.getId());
        destInfo.setCoreBillType(srcInfo.getCoreBillType());
        destInfo.setCoreBillId(srcInfo.getCoreBillId());
        destInfo.setCoreBillEntryId(srcInfo.getCoreBillEntryId());
        destInfo.setCoreBillNumber(srcInfo.getCoreBillNumber());
        destInfo.setCoreBillEntrySeq(srcInfo.getCoreBillEntrySeq());
        destInfo.setAccount(srcInfo.getAccount());
        destInfo.setOppAccount(srcInfo.getOppAccount());
        destInfo.setProject(srcInfo.getProject());
        destInfo.setTrackNumberzc(srcInfo.getTrackNumberzc());
        destInfo.setLockUnVerifyAmt(srcInfo.getLockUnVerifyAmt());
        return destInfo;
    }

    private PaymentBillEntryCollection decomposeAmt(List<PlanScheduledInfo> infoList, BigDecimal exRate) {
        PaymentBillEntryCollection destEntrys = new PaymentBillEntryCollection();
        int seqNo = 0;
        block0: for (int i = 0; i < this.otherEntryList.size(); ++i) {
            OtherEntryInfo srcEntry = this.otherEntryList.get(i);
            BigDecimal schdlAmt = BigDecimal.ZERO;
            BigDecimal applyAmt = srcEntry.getLockUnVerifyAmt().subtract(srcEntry.getActAmt());
            if (applyAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            for (PlanScheduledInfo schdlInfo : infoList) {
                PaymentBillEntryInfo destEntry;
                if (!srcEntry.getParentID().equals(schdlInfo.getSourceBillID()) || !schdlInfo.isAvalilable()) continue;
                BigDecimal lockAmt = schdlInfo.getLockAmt();
                BigDecimal payAmt = schdlInfo.getPayAmt();
                BigDecimal scheduleAmt = schdlInfo.getScheduleAmt().subtract(lockAmt.add(payAmt));
                if ((scheduleAmt = scheduleAmt.subtract(schdlInfo.getActAmt())).compareTo(BigDecimal.ZERO) <= 0) continue;
                if (scheduleAmt.compareTo(applyAmt) < 0) {
                    schdlAmt = scheduleAmt;
                    schdlInfo.setActAmt(scheduleAmt);
                    srcEntry.setActAmt(srcEntry.getActAmt().add(scheduleAmt));
                    destEntry = this.buildPaymentEntryInfo(schdlInfo, srcEntry, schdlAmt, exRate, ++seqNo);
                    destEntrys.add(destEntry);
                    applyAmt = applyAmt.subtract(scheduleAmt);
                    schdlInfo.setAvalilable(false);
                    continue;
                }
                schdlAmt = applyAmt;
                schdlInfo.setActAmt(schdlInfo.getActAmt().add(applyAmt));
                srcEntry.setActAmt(srcEntry.getActAmt().add(applyAmt));
                destEntry = this.buildPaymentEntryInfo(schdlInfo, srcEntry, schdlAmt, exRate, ++seqNo);
                destEntrys.add(destEntry);
                continue block0;
            }
        }
        return destEntrys;
    }

    private PaymentBillEntryInfo buildPaymentEntryInfo(PlanScheduledInfo schdlInfo, OtherBillentryInfo srcInfo, BigDecimal schdlAmt, BigDecimal exRate, int seqNo) {
        PaymentBillEntryInfo destInfo = new PaymentBillEntryInfo();
        destInfo.setId(BOSUuid.create((BOSObjectType)destInfo.getBOSType()));
        destInfo.setSourceBillId(schdlInfo.getSourceBillID());
        destInfo.setSourceBillEntryId(srcInfo.getId().toString());
        destInfo.setCoreBillType(srcInfo.getCoreBillType());
        destInfo.setCoreBillId(srcInfo.getCoreBillId());
        destInfo.setCoreBillEntryId(srcInfo.getCoreBillEntryId());
        destInfo.setCoreBillNumber(srcInfo.getCoreBillNumber());
        destInfo.setCoreBillEntrySeq(srcInfo.getCoreBillEntrySeq());
        destInfo.setOppAccount(srcInfo.getAccount());
        destInfo.setProject(srcInfo.getProject());
        destInfo.setTrackNumber(srcInfo.getTrackNumberzc());
        destInfo.setSrcPlanBillID(schdlInfo.getPlanID());
        destInfo.setSrcPlanBillEntryID(schdlInfo.getPlanEntryID());
        destInfo.setAmount(schdlAmt != null ? schdlAmt : schdlInfo.getScheduleAmt().subtract(schdlInfo.getLockAmt().add(schdlInfo.getPayAmt())));
        destInfo.setLocalAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
        destInfo.setUnLockAmt(destInfo.getAmount());
        destInfo.setUnLockLocAmt(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
        destInfo.setUnVcAmount(destInfo.getAmount());
        destInfo.setUnVcLocAmount(FMHelper.getLocalAmount((BigDecimal)destInfo.getAmount(), (BigDecimal)exRate));
        return destInfo;
    }

    private PaymentBillInfo buildPaymentInfo(Context ctx, PaymentBillInfo destInfo, PlanScheduledInfo schdlInfo, OtherBillInfo srcInfo) throws EASBizException, BOSException {
        if (destInfo == null) {
            destInfo = new PaymentBillInfo();
        }
        destInfo.setBizDate(new Date());
        if (destInfo.getPayeeType() == null) {
            destInfo.setPayeeType(srcInfo.getAsstActType());
        }
        if (destInfo.getPayeeID() == null) {
            destInfo.setPayeeID(srcInfo.getAsstActID());
        }
        if (destInfo.getPayeeNumber() == null) {
            destInfo.setPayeeNumber(srcInfo.getAsstActNumber());
        }
        if (destInfo.getPayeeName() == null) {
            destInfo.setPayeeName(srcInfo.getAsstActName());
        }
        if (destInfo.getPayBillType() == null) {
            destInfo.setPayBillType(PaymentBillTypeFactory.getLocalInstance((Context)ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(CAS_PAYMENTBILLTYPE_ID)));
        }
        destInfo.setSourceType(SourceTypeEnum.AP);
        destInfo.setPayPlanBillID(FIXED_PLAN_ID);
        if (destInfo.getCurrency() == null) {
            destInfo.setCurrency(srcInfo.getCurrency());
        }
        if (destInfo.getExchangeRate() == null) {
            destInfo.setExchangeRate(srcInfo.getExchangeRate());
        }
        if (destInfo.getSettlementType() == null) {
            destInfo.setSettlementType(srcInfo.getSettleType());
        }
        destInfo.setFundType(BizTypeEnum.CASH);
        destInfo.setIsCommitSettle(false);
        destInfo.setIsRedBill(false);
        destInfo.setIsTransBill(false);
        destInfo.setIsTransOtherBill(false);
        if (destInfo.getCompany() == null) {
            destInfo.setCompany(srcInfo.getCompany());
        }
        destInfo.setBillStatus(com.kingdee.eas.fi.cas.BillStatusEnum.SAVE);
        destInfo.setSourceBillId(null);
        destInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if (!EmptyUtil.isEmpty((String)schdlInfo.getSettleTypeID())) {
            SettlementTypeInfo settleType = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeInfo((IObjectPK)new ObjectUuidPK(schdlInfo.getSettleTypeID()));
            destInfo.setSettlementType(settleType);
        }
        if (!EmptyUtil.isEmpty((String)schdlInfo.getAccountBankID())) {
            AccountBankInfo accBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(schdlInfo.getAccountBankID()));
            destInfo.setPayerAccountBank(accBank);
            destInfo.setPayerAccount(accBank.getAccount());
        }
        return destInfo;
    }

    private PaymentBillInfo buildByPayRequestBill(Context ctx, List<PlanScheduledInfo> infoList, PaymentBillInfo destInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.asstActType.*"));
        int seqNo = 1;
        for (PlanScheduledInfo schdlInfo : infoList) {
            String sourceBillId = schdlInfo.getSourceBillID();
            PayRequestBillInfo srcInfo = PayRequestBillFactory.getLocalInstance((Context)ctx).getPayRequestBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            if (srcInfo == null) continue;
            BigDecimal lockAmt = schdlInfo.getLockAmt();
            BigDecimal payAmt = schdlInfo.getPayAmt();
            BigDecimal scheduleAmt = schdlInfo.getScheduleAmt().subtract(lockAmt.add(payAmt));
            if (scheduleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            PaymentBillEntryInfo destEntry = null;
            PayRequestBillEntryCollection srcColl = srcInfo.getEntrys();
            FMHelper.sortCollection((AbstractObjectCollection)srcColl, (String[])new String[]{"seq"});
            for (int i = 0; i < srcColl.size(); ++i) {
                PayRequestBillEntryInfo srcEntry = srcColl.get(i);
                if (!schdlInfo.getSrcBillHeadID().equals(srcEntry.getId().toString()) || srcEntry.getUnpayAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                destEntry = this.buildPaymentEntryInfo(ctx, scheduleAmt, sourceBillId, srcInfo.getAccount(), srcEntry);
                destEntry.setSrcPlanBillID(schdlInfo.getPlanID());
                destEntry.setSrcPlanBillEntryID(schdlInfo.getPlanEntryID());
                destEntry.setSeq(seqNo++);
                break;
            }
            if (destEntry == null) continue;
            if (seqNo - 1 == 1) {
                destInfo = this.buildPaymentInfo(ctx, destInfo, schdlInfo, srcInfo);
            }
            destInfo.getEntries().add(destEntry);
        }
        if (destInfo.getEntries() == null || destInfo.getEntries().size() <= 0) {
            destInfo = null;
        }
        return destInfo;
    }

    private PaymentBillInfo buildPaymentInfo(Context ctx, PaymentBillInfo destInfo, PlanScheduledInfo schdlInfo, PayRequestBillInfo srcInfo) throws EASBizException, BOSException {
        if (destInfo == null) {
            destInfo = new PaymentBillInfo();
        }
        destInfo.setBizDate(new Date());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("accountBankName.bank.*"));
        PayRequestBillEntryInfo srcEntry = PayRequestBillEntryFactory.getLocalInstance((Context)ctx).getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(schdlInfo.getSrcBillHeadID()), sic);
        if (destInfo.getPayeeType() == null) {
            destInfo.setPayeeType(srcEntry.getAsstActType());
        }
        if (destInfo.getPayeeID() == null) {
            destInfo.setPayeeID(srcEntry.getAsstActID());
        }
        if (destInfo.getPayeeNumber() == null) {
            destInfo.setPayeeNumber(srcEntry.getAsstActNumber());
        }
        if (destInfo.getPayeeName() == null) {
            destInfo.setPayeeName(srcEntry.getAsstActName());
        }
        if (destInfo.getPayeeBank() == null) {
            if (srcEntry.getAccountBankName() != null) {
                destInfo.setPayeeBank(srcEntry.getAccountBankName().getBank().toString());
            } else {
                destInfo.setPayeeBank(null);
            }
        }
        if (destInfo.getPayeeAccountBank() == null) {
            destInfo.setPayeeAccountBank(srcEntry.getAccountBankNo());
        }
        if (destInfo.getPayBillType() == null) {
            destInfo.setPayBillType(srcEntry.getPayType());
        }
        destInfo.setSourceType(SourceTypeEnum.AP);
        destInfo.setPayPlanBillID(FIXED_PLAN_ID);
        if (destInfo.getCurrency() == null) {
            destInfo.setCurrency(srcInfo.getCurrency());
        }
        if (destInfo.getExchangeRate() == null) {
            destInfo.setExchangeRate(srcInfo.getExchange_rate());
        }
        if (!EmptyUtil.isEmpty((String)schdlInfo.getSettleTypeID())) {
            SettlementTypeInfo settleType = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeInfo((IObjectPK)new ObjectUuidPK(schdlInfo.getSettleTypeID()));
            destInfo.setSettlementType(settleType);
        }
        if (!EmptyUtil.isEmpty((String)schdlInfo.getAccountBankID())) {
            AccountBankInfo accBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(schdlInfo.getAccountBankID()));
            destInfo.setPayerAccountBank(accBank);
            destInfo.setPayerAccount(accBank.getAccount());
        }
        if (destInfo.getOppAccount() == null) {
            destInfo.setOppAccount(srcInfo.getAccount());
        }
        destInfo.setBillStatus(com.kingdee.eas.fi.cas.BillStatusEnum.SAVE);
        destInfo.setPerson(srcInfo.getApplyer());
        if (destInfo.getCompany() == null) {
            destInfo.setCompany(srcInfo.getCompany());
        }
        if (destInfo.getSourceBillId() == null) {
            destInfo.setSourceBillId(srcInfo.getId().toString());
        }
        destInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        destInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return destInfo;
    }

    private List<MsgInfo> setErrMsgList4Batch(List<MsgInfo> errList, List<PlanScheduledInfo> infoList, String msg) {
        if (errList == null) {
            errList = new ArrayList<MsgInfo>(infoList.size());
        }
        for (PlanScheduledInfo info : infoList) {
            MsgInfo msgInfo = new MsgInfo();
            msgInfo.setId(info.getPlanID());
            msgInfo.setNumber(info.getPlanNumber());
            msgInfo.setMsg(msg);
            errList.add(msgInfo);
        }
        return errList;
    }

    class ApproveThread
    extends Thread {
        private Context ctx;
        private List<PayPlanSumaryInfo> list;

        public ApproveThread(Context ctx, List<PayPlanSumaryInfo> list) {
            this.ctx = ctx;
            this.list = list;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.list.size(); ++i) {
                    PayPlanSumaryInfo info = this.list.get(i);
                    String companyId = info.getCompany().getId().toString();
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    String cuId = company.getCU().getId().toString();
                    PaymentScheduleSettingInfo setInfo = PSUtils.getPaymentScheduleInfo(this.ctx, cuId);
                    setInfo.get("settlePriorityEntrys");
                    List<SettlementCategoryInfo> cateInfolist = this.getSettleCategoryList(this.ctx, cuId);
                    Date limitStartDate = DateHelper.getDayBegin();
                    Date limitExpiredDate = null;
                    PaymentScheduleSettingInfo setting = PSUtils.getPaymentScheduleInfo(this.ctx, cuId);
                    Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
                    if (setting != null && setting.getPeriodType() == PeriodTypeEnum.WEEK) {
                        Date addWeek = DateTimeUtils.addHour((Date)currentDate, (long)168L);
                        Date nextWeekFirst = DateHelper.getFirstDayOfWeek((Date)addWeek);
                        limitExpiredDate = DateHelper.getNextDay((Date)nextWeekFirst, (int)6);
                    } else {
                        Date addMonth = DateTimeUtils.addMonth((Date)currentDate, (int)1);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(addMonth);
                        cal.set(5, cal.getActualMaximum(5));
                        limitExpiredDate = cal.getTime();
                    }
                    info.setLimitStartDate(limitStartDate);
                    info.setLimitExpiredDate(limitExpiredDate);
                    this.getSummaryColl(this.list, cateInfolist);
                }
                PayPlanSumaryFactory.getLocalInstance(this.ctx).approve(this.list);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                logger.info((Object)e.getMessage());
            }
            catch (BOSException e) {
                e.printStackTrace();
                logger.info((Object)e.getMessage());
            }
        }

        private List<PayPlanSumaryInfo> getSummaryColl(List<PayPlanSumaryInfo> sumaryList, List<SettlementCategoryInfo> cateInfolist) throws BOSException {
            for (int i = 0; i < sumaryList.size(); ++i) {
                PayPlanSumaryInfo info = sumaryList.get(i);
                if (info.getBillStatus() == SummaryBillStatusEnum.APPROVED) continue;
                if (cateInfolist != null) {
                    int size = cateInfolist.size();
                    if (size == 1) {
                        info.setApproveAmt1(info.getApplyPayAmt());
                    } else if (size == 2) {
                        info.setApproveAmt1(info.getApplyPayAmt().multiply(cateInfolist.get(0).getApproveAmtRatio().divide(new BigDecimal("100"))));
                        info.setApproveAmt2(info.getApplyPayAmt().multiply(cateInfolist.get(1).getApproveAmtRatio().divide(new BigDecimal("100"))));
                        info.setApprovedAmt(info.getApproveAmt1().add(info.getApproveAmt2()));
                    } else if (size == 3) {
                        info.setApproveAmt1(info.getApplyPayAmt().multiply(cateInfolist.get(0).getApproveAmtRatio().divide(new BigDecimal("100"))));
                        info.setApproveAmt2(info.getApplyPayAmt().multiply(cateInfolist.get(1).getApproveAmtRatio().divide(new BigDecimal("100"))));
                        info.setApproveAmt3(info.getApplyPayAmt().multiply(cateInfolist.get(2).getApproveAmtRatio().divide(new BigDecimal("100"))));
                        info.setApprovedAmt(info.getApproveAmt1().add(info.getApproveAmt2()).add(info.getApproveAmt3()));
                    }
                    PayPlanSumSettleEntryCollection colls = info.getSettleEntries();
                    if (EmptyUtil.isEmpty((AbstractObjectCollection)colls)) continue;
                    int collSize = colls.size();
                    if (collSize == 1) {
                        colls.get(0).setApproveAmt(info.getApproveAmt1());
                        colls.get(0).setNotIssuedAmt(info.getApproveAmt1());
                        continue;
                    }
                    if (collSize == 2) {
                        colls.get(0).setApproveAmt(info.getApproveAmt1());
                        colls.get(0).setNotIssuedAmt(info.getApproveAmt1());
                        colls.get(1).setApproveAmt(info.getApproveAmt2());
                        colls.get(1).setNotIssuedAmt(info.getApproveAmt2());
                        continue;
                    }
                    if (collSize != 3) continue;
                    colls.get(0).setApproveAmt(info.getApproveAmt1());
                    colls.get(0).setNotIssuedAmt(info.getApproveAmt1());
                    colls.get(1).setApproveAmt(info.getApproveAmt2());
                    colls.get(1).setNotIssuedAmt(info.getApproveAmt2());
                    colls.get(2).setApproveAmt(info.getApproveAmt3());
                    colls.get(2).setNotIssuedAmt(info.getApproveAmt3());
                    continue;
                }
                if (info.getApprovedAmt() != null) continue;
                info.setApprovedAmt(info.getApplyPayAmt());
            }
            return sumaryList;
        }

        private List<SettlementCategoryInfo> getSettleCategoryList(Context ctx, String cuId) throws BOSException, EASBizException {
            ArrayList<SettlementCategoryInfo> list = null;
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT settle.FCategoryID, settleCate.FName_l2 AS settleCateName, settle.FApproveAmtRatio ");
            sql.append(" FROM T_PS_PaymentScheduleSetting schdl ");
            sql.append(" INNER JOIN T_PS_SettlementPrioritySetting settle ");
            sql.append(" ON settle.FPaySchdlSettingID = schdl.FID ");
            sql.append(" INNER JOIN T_PS_SettlementCategory settleCate ");
            sql.append(" ON settleCate.FID = settle.FCategoryID ");
            sql.append(" WHERE schdl.FControlUnitID = '" + cuId + "'");
            sql.append(" AND schdl.FIsBySettleType = 1 ");
            sql.append(" ORDER BY settle.FPriority ");
            try {
                IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
                if (rs != null && rs.size() > 0) {
                    list = new ArrayList<SettlementCategoryInfo>();
                    while (rs.next()) {
                        SettlementCategoryInfo info = new SettlementCategoryInfo();
                        info.setId(BOSUuid.read((String)rs.getString("FCategoryID")));
                        info.setName(rs.getString("settleCateName"));
                        info.setApproveAmtRatio(new BigDecimal(rs.getInt("FApproveAmtRatio")));
                        list.add(info);
                    }
                } else {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("parent.id"));
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
                    if (company != null && company.getParent() != null) {
                        this.getSettleCategoryList(ctx, company.getParent().getId().toString());
                    }
                }
            }
            catch (SQLException e) {
                throw new PSException(PSException.SQL_EXCEPTION, e, new Object[]{e.getMessage()});
            }
            return list;
        }
    }
}

