/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ps.PaymentPlanBillFactory;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingCollection;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingFactory;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingInfo;
import com.kingdee.eas.fm.ps.PeriodTypeEnum;
import com.kingdee.eas.fm.ps.app.AbstractPaymentPlanFacadeControllerBean;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentPlanFacadeControllerBean
extends AbstractPaymentPlanFacadeControllerBean {
    private static final long serialVersionUID = 2418428410463549616L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.PaymentPlanFacadeControllerBean");

    @Override
    protected Map _autoCarryOver(Context ctx) throws BOSException, EASBizException {
        try {
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            Map rsMap = this.getPaymentScheduleSetting(ctx, cu.getId().toString());
            if (rsMap != null) {
                boolean isCarrayOver = (Boolean)rsMap.get("isCarrayOver");
                PeriodTypeEnum periodType = (PeriodTypeEnum)((Object)rsMap.get("periodType"));
                if (isCarrayOver) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
                    String period = sdf.format(new java.util.Date());
                    String periodWeek = null;
                    if (periodType.getValue() == 0) {
                        int curWeek = PSUtils.getCurWeek(new java.util.Date());
                        periodWeek = String.valueOf(curWeek);
                    }
                    this.autoCloseBill(ctx, period, periodWeek, 1);
                    this.autoCloseBill(ctx, period, periodWeek, 2);
                    PaymentPlanBillFactory.getLocalInstance(ctx).carryOver(null, period, periodWeek);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private java.util.Date calcuPayableDate(PeriodTypeEnum periodType) {
        java.util.Date payableDate = null;
        java.util.Date now = new java.util.Date();
        if (periodType.equals((Object)PeriodTypeEnum.MONTH)) {
            java.util.Date curMonFirst = DateUtil.getFirstDayOfCurMonth();
            payableDate = DateTimeUtils.truncateDate((java.util.Date)curMonFirst);
        } else if (periodType.equals((Object)PeriodTypeEnum.WEEK)) {
            java.util.Date curWeekFirst = DateUtil.getFirstDayOfWeek((java.util.Date)now);
            payableDate = DateTimeUtils.truncateDate((java.util.Date)curWeekFirst);
        }
        return payableDate;
    }

    private void autoClosePaymentPlan(Context ctx, java.util.Date endDate) throws BOSException {
        Date today = new Date(new java.util.Date().getTime());
        Date endDateSql = null;
        String sql = "UPDATE T_PS_PaymentPlanBill set FBillStatus = 6 where FSchdlExpiredDate < ?  and FBillStatus != 6";
        if (endDate != null) {
            endDateSql = new Date(endDate.getTime());
            sql = "UPDATE T_PS_PaymentPlanBill set FBillStatus = 6 where (FSchdlExpiredDate < ?  or FBizDate < ?)  and FBillStatus != 6";
        }
        try {
            if (endDate != null) {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{today, endDateSql});
            } else {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{today});
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u5173\u95ed\u5931\u6548\u7684\u4ed8\u6b3e\u8ba1\u5212\u5f02\u5e38");
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void autoCloseBill(Context ctx, String period, String periodWeek, int type) throws BOSException {
        String sql = null;
        String tableName = null;
        int billStatus = 6;
        switch (type) {
            case 0: {
                tableName = "T_PS_PaymentPlanBill";
                billStatus = 6;
                break;
            }
            case 1: {
                tableName = "T_PS_PayPlanSumary";
                billStatus = 7;
                break;
            }
            case 2: {
                tableName = "T_PS_DecomposeBill";
                billStatus = 5;
            }
        }
        sql = "UPDATE  " + tableName + "  set FBillStatus = ? where  FPeriodId <?  and FBillStatus != ?";
        if (periodWeek != null) {
            sql = "UPDATE  " + tableName + "  set FBillStatus = ? where ( FPeriodId <?  or (FPeriodId =? and FPeriodEntryId <?)) and FBillStatus != ?";
        }
        try {
            if (periodWeek == null) {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billStatus, period, billStatus});
            } else {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billStatus, period, period, periodWeek, billStatus});
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u5173\u95ed\u5931\u6548\u7684\u5355\u636e\u5f02\u5e38\uff1a" + sql));
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private Map getPaymentScheduleSetting(Context ctx, String cuId) throws BOSException, EASBizException {
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        PaymentScheduleSettingInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        PaymentScheduleSettingCollection colls = PaymentScheduleSettingFactory.getLocalInstance(ctx).getPaymentScheduleSettingCollection(entityViewInfo);
        if (colls != null && colls.size() > 0) {
            info = colls.get(0);
            rsMap.put("isCarrayOver", info.isIsCarryOver());
            rsMap.put("periodType", (Object)info.getPeriodType());
            return rsMap;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cuId), selector);
        if (company != null && company.getParent() != null) {
            this.getPaymentScheduleSetting(ctx, company.getParent().getId().toString());
        }
        return null;
    }

    @Override
    protected Map _autoSummary(Context ctx) throws BOSException, EASBizException {
        Map result = new HashMap();
        try {
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String cuId = null;
            if (cu.getLevel() != 1) {
                cuId = cu.getId().toString();
            }
            Map<String, Set> idMap = this.getPayPlanIds(ctx, cuId);
            for (String companyId : idMap.keySet()) {
                result = PaymentPlanBillFactory.getLocalInstance(ctx).summary(idMap.get(companyId), companyId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Map<String, Set> getPayPlanIds(Context ctx, String cuId) throws BOSException, SQLException {
        HashMap<String, Set> idMap = new HashMap<String, Set>();
        String sql = null;
        IRowSet rowSet = null;
        if (cuId == null) {
            sql = "SELECT FID,FCOMPANYID FROM T_PS_PAYMENTPLANBILL WHERE FBILLSTATUS = ? AND (FSUMBILLSTATUS is null or FSUMBILLSTATUS = 0)";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{3});
        } else {
            sql = "SELECT FID,FCOMPANYID FROM T_PS_PAYMENTPLANBILL WHERE FCONTROLUNITID = ? AND FBILLSTATUS = ? AND (FSUMBILLSTATUS is null or FSUMBILLSTATUS = 0)";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cuId, 3});
        }
        while (rowSet.next()) {
            String payID = rowSet.getString("FID");
            String companyId = rowSet.getString("FCOMPANYID");
            if (idMap.containsKey(companyId)) {
                ((Set)idMap.get(companyId)).add(payID);
                continue;
            }
            HashSet<String> tmp = new HashSet<String>();
            tmp.add(payID);
            idMap.put(companyId, tmp);
        }
        return idMap;
    }

    @Override
    protected Map _autoGenPaymentBill(Context ctx, int rangeType) throws BOSException, EASBizException {
        Map result = new HashMap();
        try {
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String cuId = null;
            if (cu.getLevel() != 1) {
                cuId = cu.getId().toString();
            }
            Map<String, List<String>> idMap = this.getPayPlanIds2(ctx, cuId, rangeType);
            for (String companyId : idMap.keySet()) {
                result = PaymentPlanBillFactory.getLocalInstance(ctx).batchGenPaymentBill(idMap.get(companyId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Map<String, List<String>> getPayPlanIds2(Context ctx, String cuId, int rangeType) throws BOSException, SQLException {
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
        IRowSet rowSet = null;
        java.util.Date today = DateUtil.getDayBegin();
        Timestamp todayTime = new Timestamp(today.getTime());
        String sql = "SELECT FID,FCOMPANYID FROM T_PS_PAYMENTPLANBILL WHERE FSCHDLPAYDATE <=?  AND FSCHDLEXPIREDDATE >=? AND FBILLSTATUS IN ('41','42') ";
        java.util.Date tom = DateUtil.getAfterDay((java.util.Date)today);
        Timestamp tomTime = new Timestamp(tom.getTime());
        if (rangeType != 1) {
            if (rangeType == 2) {
                sql = sql + " AND FPAYABLEDATE < ? ";
            } else {
                return idMap;
            }
        }
        if (cuId == null) {
            rowSet = rangeType == 2 ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{todayTime, todayTime, tomTime}) : DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{todayTime, todayTime});
        } else {
            sql = sql + " AND FCONTROLUNITID = ? ";
            rowSet = rangeType == 2 ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{todayTime, todayTime, tomTime, cuId}) : DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{todayTime, todayTime, cuId});
        }
        while (rowSet.next()) {
            String payID = rowSet.getString("FID");
            String companyId = rowSet.getString("FCOMPANYID");
            if (idMap.containsKey(companyId)) {
                ((List)idMap.get(companyId)).add(payID);
                continue;
            }
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(payID);
            idMap.put(companyId, tmp);
        }
        return idMap;
    }
}

