/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingCollection;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingFactory;
import com.kingdee.eas.fm.ps.PaymentScheduleSettingInfo;
import com.kingdee.eas.fm.ps.SettlementCategoryInfo;
import com.kingdee.eas.fm.ps.SettlementPrioritySettingCollection;
import com.kingdee.eas.fm.ps.SettlementPrioritySettingInfo;
import com.kingdee.eas.fm.ps.app.AbstractSettlementPrioritySettingControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SettlementPrioritySettingControllerBean
extends AbstractSettlementPrioritySettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ps.app.SettlementPrioritySettingControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SettlementPrioritySettingInfo info = (SettlementPrioritySettingInfo)model;
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        StringBuffer sql = new StringBuffer("update T_PS_SettlementCategory set FName_l2 = '");
        sql.append(info.getCategory().getName()).append("' where fid = '").append(info.getCategory().getId()).append("'");
        com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("update T_PS_PaymentScheduleSetting set FIsPayBySettleTypePriority = ");
        sql.append(info.isIsPayBySettlePriorty() ? new Integer(1) : new Integer(0)).append(" where fid = '").append(info.getParent().getId()).append("'");
        com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql.toString());
        return pk;
    }

    protected IObjectPK[] _saveBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        SettlementPrioritySettingInfo info = null;
        BigDecimal totalRatio = new BigDecimal(0);
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        List<SettlementCategoryInfo> settleCateList = this.getSettleCategoryList(ctx, cuID);
        if (settleCateList != null && this.existsBizData(ctx, cuID)) {
            throw new PSException(PSException.EXISTS_BIZDATA_NOTEDIT);
        }
        SettlementTypeInfo settleTypeInfo = null;
        HashMap<BOSUuid, BOSUuid> identityMap = new HashMap<BOSUuid, BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            info = (SettlementPrioritySettingInfo)colls.getObject(i);
            totalRatio = totalRatio.add(info.getApproveAmtRatio() == null ? new BigDecimal(0) : info.getApproveAmtRatio());
            for (int j = 0; j < info.getEntries().size(); ++j) {
                settleTypeInfo = info.getEntries().get(j).getSettleType();
                if (identityMap.containsKey(settleTypeInfo.getId())) {
                    throw new PSException(PSException.HAS_SAME_SETTLTTYPE, new Object[]{settleTypeInfo.getName()});
                }
                identityMap.put(settleTypeInfo.getId(), settleTypeInfo.getId());
            }
        }
        if (totalRatio.compareTo(new BigDecimal(100)) > 0) {
            throw new PSException(PSException.SUMAPPAMTRAT_MORE_THAN_100);
        }
        IObjectPK[] pkArr = super._saveBatchData(ctx, colls);
        StringBuffer sql = null;
        for (int i = 0; i < colls.size(); ++i) {
            info = (SettlementPrioritySettingInfo)colls.getObject(i);
            sql = new StringBuffer("update T_PS_SettlementCategory set FName_l2 = ? where fid = ? ");
            com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getCategory().getName(), info.getCategory().getId().toString()});
        }
        if (info != null) {
            sql = new StringBuffer("update T_PS_PaymentScheduleSetting set FIsPayBySettleTypePriority = ? where fid = ? ");
            com.kingdee.eas.base.core.util.DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.isIsPayBySettlePriorty() ? new Integer(1) : new Integer(0), info.getParent().getId().toString()});
        }
        return pkArr;
    }

    private boolean existsBizData(Context ctx, String cuID) throws BOSException, EASBizException {
        boolean exists = false;
        String sql = "SELECT COUNT(*) FROM T_PS_PayPlanSumary WHERE FControlUnitID = '" + cuID + "' AND FBillStatus NOT IN (1, 2, 7)";
        int count = 0;
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt(1);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        if (count > 0) {
            exists = true;
        }
        return exists;
    }

    private List<SettlementCategoryInfo> getSettleCategoryList(Context ctx, String cuID) throws BOSException, EASBizException {
        ArrayList<SettlementCategoryInfo> list = new ArrayList<SettlementCategoryInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isBySettleType"));
        sic.add(new SelectorItemInfo("settlePriorityEntrys.category.id"));
        sic.add(new SelectorItemInfo("settlePriorityEntrys.category.name"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuID));
        Date now = DateTimeUtils.truncateDate((Date)new Date());
        filter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)now, CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("settlePriorityEntrys.priority"));
        view.setSorter(sort);
        PaymentScheduleSettingCollection colls = PaymentScheduleSettingFactory.getLocalInstance(ctx).getPaymentScheduleSettingCollection(view);
        if (colls != null && colls.size() > 0) {
            PaymentScheduleSettingInfo scheduleInfo = colls.get(0);
            if (((Boolean)scheduleInfo.get("isBySettleType")).booleanValue()) {
                SettlementPrioritySettingCollection settleColls = colls.get(0).getSettlePriorityEntrys();
                if (settleColls != null && settleColls.size() > 0) {
                    for (int i = 0; i < settleColls.size(); ++i) {
                        list.add(settleColls.get(i).getCategory());
                    }
                }
            } else {
                list = null;
            }
        }
        return list;
    }
}

