/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fm.ps.DecomposeBillCollection;
import com.kingdee.eas.fm.ps.DecomposeBillEntryCollection;
import com.kingdee.eas.fm.ps.DecomposeBillEntryInfo;
import com.kingdee.eas.fm.ps.DecomposeBillFactory;
import com.kingdee.eas.fm.ps.DecomposeBillInfo;
import com.kingdee.eas.fm.ps.PSException;
import com.kingdee.eas.fm.ps.PayPlanSumaryInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DecomposeBillService {
    public static DecomposeBillCollection updateDecomposeBySumaryInfo(Context ctx, Map<String, PayPlanSumaryInfo> sumaryMap, Set<String> decomposeSet, Map decompseMutexMap) throws BOSException, PSException {
        for (String decomId : decomposeSet) {
            Boolean isLocked = (Boolean)decompseMutexMap.get(decomId);
            if (isLocked.booleanValue()) continue;
            throw new PSException(PSException.BILL_IS_MUTEXED);
        }
        EntityViewInfo decomView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", decomposeSet, CompareType.INCLUDE));
        decomView.setFilter(filter);
        DecomposeBillCollection decomColls = DecomposeBillFactory.getLocalInstance(ctx).getDecomposeBillCollection(decomView);
        for (int i = 0; i < decomColls.size(); ++i) {
            DecomposeBillInfo decomInfo = decomColls.get(i);
            DecomposeBillEntryCollection entryColls = decomInfo.getEntrys();
            BigDecimal sumaryNotIssueAmt = BigDecimal.ZERO;
            for (int m = 0; m < entryColls.size(); ++m) {
                DecomposeBillEntryInfo entryInfo = entryColls.get(m);
                PayPlanSumaryInfo sumaryInfo = sumaryMap.get(entryInfo.getSummary().getId().toString());
                if (sumaryInfo != null) {
                    entryInfo.setNotIssueAmt1(sumaryInfo.getNotIssuedAmt1());
                    entryInfo.setNotIssueAmt2(sumaryInfo.getNotIssuedAmt2());
                    entryInfo.setNotIssueAmt3(sumaryInfo.getNotIssuedAmt3());
                    entryInfo.setNotIssuedAmt(sumaryInfo.getNotIssuedAmt());
                }
                sumaryNotIssueAmt = sumaryNotIssueAmt.add(entryInfo.getNotIssuedAmt());
            }
            decomInfo.setNotIssuedAmt(sumaryNotIssueAmt);
        }
        return decomColls;
    }

    public static Set<String> getDecomposeBillIdSet(Context ctx, Set<String> sumaryIdSet) throws BOSException {
        HashSet<String> decomSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct(fparentid )from T_PS_DecomposeBillEntry where FSummaryID in (");
        for (int i = 0; i < sumaryIdSet.size(); ++i) {
            if (i == 0) {
                sql.append(" ? ");
                continue;
            }
            sql.append(" , ? ");
        }
        sql.append(" ) ");
        Object[] idArray = new Object[sumaryIdSet.size()];
        int m = 0;
        for (String sumId : sumaryIdSet) {
            idArray[m] = sumId;
            ++m;
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idArray);
            if (rs != null) {
                while (rs.next()) {
                    decomSet.add(rs.getString("fparentid"));
                }
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return decomSet;
    }
}

