/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ps.PayPlanSourceSettingInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.fm.ps.utils.PSUtils;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.CoreBillBaseController;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class TransPsBillBaseAdapter {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    private IObjectCollection getSrcBillColl(Context ctx, String srcID, String srcBosType, BOTMappingInfo botMapInfo, Map filterMap) throws BOSException, BTPException {
        SelectorItemCollection botpSelectors = null;
        try {
            botpSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMapInfo);
        }
        catch (Exception e) {
            throw new BTPException(BTPException.CALLBACKBIZERR, new Object[]{e.getMessage()});
        }
        String[] idList = new String[]{srcID};
        return this.getBillList(ctx, idList, srcBosType, botpSelectors, filterMap);
    }

    private IObjectCollection getBillList(Context ctx, String[] idList, String srcBillType, SelectorItemCollection botpSelectors, Map filterMap) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        String key = (String)filterMap.get("key");
        List filterList = (List)filterMap.get("filterList");
        HashSet set = new HashSet(filterList);
        String strIdLists = BOTMappingHelper.objectArray2String((Object[])idList, (String)",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo = new FilterInfo();
        filterInfo.setEntryName(key);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        entityViewInfo.getEntryFilters().add(filterInfo);
        if (botpSelectors != null) {
            entityViewInfo.put("selector", (Object)botpSelectors);
        }
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        try {
            sourceBillCollection = controller.getCoreBillBaseCollection(ctx, entityViewInfo);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return sourceBillCollection;
    }

    protected PaymentPlanBillInfo trans2PaymentPlanBillInfo(Context ctx, CoreBillBaseInfo coreBillBaseInfo, BOTMappingInfo botMapInfo) throws EASBizException, BOSException {
        PaymentPlanBillInfo payPlanInfo = new PaymentPlanBillInfo();
        ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add(coreBillBaseInfo);
        srcBillColsList.add(sourceBillCollection);
        ArrayList<String> botMappingPKCols = new ArrayList<String>();
        botMappingPKCols.add(botMapInfo.getId().toString());
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillColsList, payPlanInfo.getBOSType().toString(), botMappingPKCols);
        PaymentPlanBillCollection paymentPlanBillCol = (PaymentPlanBillCollection)btpResult.getBills();
        if (paymentPlanBillCol.size() > 0) {
            payPlanInfo = paymentPlanBillCol.get(0);
            if (payPlanInfo.getSourceBillId() == null) {
                payPlanInfo.setSourceBillId(coreBillBaseInfo.getId().toString());
            }
            Map periodMap = this.getPeriodMap(payPlanInfo);
            payPlanInfo.setPeriod(periodMap.get("period").toString());
            payPlanInfo.setPeriodEntry(periodMap.get("periodEntry").toString());
            this.doProcessPayPlanInfo(coreBillBaseInfo, payPlanInfo);
            return payPlanInfo;
        }
        return null;
    }

    protected Map getPeriodMap(PaymentPlanBillInfo payPlanInfo) {
        Date date = new Date();
        String dateStr = dateFormat.format(date);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("periodEntry", new Integer(PSUtils.getCurWeek(date)));
        map.put("period", dateStr.substring(0, 6));
        return map;
    }

    protected abstract void doProcessPayPlanInfo(CoreBillBaseInfo var1, PaymentPlanBillInfo var2);

    protected abstract BOTMappingInfo getBotMappingInfo(Context var1, PayPlanSourceSettingInfo var2) throws EASBizException, BOSException;

    protected abstract Map getDetailBillFilterMap(String var1, Map var2);

    protected abstract void doTrans2PaymentPlanBillColl(Context var1, CoreBillBaseCollection var2, PaymentPlanBillCollection var3, BOTMappingInfo var4) throws EASBizException, BOSException;

    public PaymentPlanBillCollection trans2PaymentPlanBillColl(Context ctx, PayPlanSourceSettingInfo info, String srcId, Map srcDetailBillMap) throws EASBizException, BOSException {
        PaymentPlanBillCollection payPlanBillCol = new PaymentPlanBillCollection();
        BOTMappingInfo botMapInfo = this.getBotMappingInfo(ctx, info);
        if (botMapInfo != null) {
            Map filterMap = this.getDetailBillFilterMap(srcId, srcDetailBillMap);
            CoreBillBaseCollection coreBillBaseColl = (CoreBillBaseCollection)this.getSrcBillColl(ctx, srcId, BOSUuid.read((String)srcId).getType().toString(), botMapInfo, filterMap);
            this.doTrans2PaymentPlanBillColl(ctx, coreBillBaseColl, payPlanBillCol, botMapInfo);
        }
        return payPlanBillCol;
    }

    public PaymentPlanBillCollection trans2PaymentPlanBillColl(Context ctx, String mappingID, String srcId, Map srcDetailBillMap) throws EASBizException, BOSException {
        PaymentPlanBillCollection payPlanBillCol = new PaymentPlanBillCollection();
        BOTMappingInfo botMapInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK(mappingID));
        if (botMapInfo != null) {
            Map filterMap = this.getDetailBillFilterMap(srcId, srcDetailBillMap);
            CoreBillBaseCollection coreBillBaseColl = (CoreBillBaseCollection)this.getSrcBillColl(ctx, srcId, BOSUuid.read((String)srcId).getType().toString(), botMapInfo, filterMap);
            this.doTrans2PaymentPlanBillColl(ctx, coreBillBaseColl, payPlanBillCol, botMapInfo);
        }
        return payPlanBillCol;
    }

    public abstract Map diposeSrcBill(Context var1, String var2) throws BOSException;

    public abstract Map getSrcBillHeadDetailMap(Context var1, PayPlanSourceSettingInfo var2, String var3, String var4) throws BOSException;

    public abstract Map<String, List<String>> getSrcBillHeadDetailMap(Context var1, List<String> var2) throws BOSException;

    protected Map getDateRange(Context ctx, PayPlanSourceSettingInfo info, String startDateTime, String endDateTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)startDateTime) && !StringUtils.isEmpty((String)endDateTime)) {
            result.put("startDate", startDateTime);
            result.put("endDate", endDateTime);
            return result;
        }
        String payableDateRange = info.getPayableDateRange().getValue();
        Date date = new Date();
        Date startDate = null;
        Date endDate = null;
        if ("0".equals(payableDateRange)) {
            Date nextMonDate = DateUtil.getNextMonth((Date)date);
            startDate = DateUtil.getFirstDayOfMonth((Date)nextMonDate);
            endDate = DateUtil.getLastDayOfMonth((Date)startDate);
        } else if ("2".equals(payableDateRange)) {
            startDate = DateUtil.getFirstDayOfCurMonth();
            endDate = DateUtil.getLastDayOfCurMonth();
        } else if ("4".equals(payableDateRange)) {
            Date firstDate = DateUtil.getFirstDayOfCurMonth();
            startDate = DateUtil.getFirstDayOfMonth((Date)DateUtil.getBeforeDay((Date)firstDate));
            endDate = DateUtil.getLastDayOfMonth((Date)firstDate);
        } else if ("6".equals(payableDateRange)) {
            startDate = DateUtil.getFirstDayOfCurYear();
            Date nextMonFirst = DateUtil.getNextMonth((Date)date);
            endDate = DateUtil.getLastDayOfMonth((Date)nextMonFirst);
        } else if ("1".equals(payableDateRange)) {
            Date nextWeekDate = DateUtil.getNextDay((Date)date, (int)7);
            startDate = DateUtil.getFirstDayOfWeek((Date)nextWeekDate);
            endDate = DateUtil.getNextDay((Date)startDate, (int)7);
        } else if ("3".equals(payableDateRange)) {
            startDate = DateUtil.getFirstDayOfCurMonth();
            Date nextWeekDate = DateUtil.getNextDay((Date)date, (int)7);
            endDate = DateUtil.getBeforeDay((Date)DateUtil.getFirstDayOfWeek((Date)nextWeekDate));
        } else if ("5".equals(payableDateRange)) {
            Date firstDate = DateUtil.getFirstDayOfCurMonth();
            startDate = DateUtil.getFirstDayOfMonth((Date)DateUtil.getBeforeDay((Date)firstDate));
            Date nextWeekDate = DateUtil.getNextDay((Date)date, (int)7);
            endDate = DateUtil.getBeforeDay((Date)DateUtil.getFirstDayOfWeek((Date)nextWeekDate));
        } else if ("7".equals(payableDateRange)) {
            startDate = DateUtil.getFirstDayOfCurYear();
            Date nextWeekDate = DateUtil.getNextDay((Date)date, (int)7);
            endDate = DateUtil.getNextDay((Date)DateUtil.getFirstDayOfWeek((Date)nextWeekDate), (int)7);
        }
        result.put("startDate", DateUtil.DateToString((Date)startDate));
        result.put("endDate", DateUtil.DateToString((Date)endDate));
        return result;
    }
}

