/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.test;

import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import com.kingdee.eas.fm.ps.SrcBillTypeEnum;
import com.kingdee.eas.fm.ps.vo.PlanScheduledInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BatchGenPaymentBillTest {
    public static void main(String[] args) {
        PaymentPlanBillCollection coll = new PaymentPlanBillCollection();
        PaymentPlanBillInfo head1 = new PaymentPlanBillInfo();
        head1.setSourceBillType(SrcBillTypeEnum.OTHERBILL);
        head1.setNumber("M001");
        head1.setAsstActID("SupplierID01");
        PaymentPlanBillEntryInfo entry1 = new PaymentPlanBillEntryInfo();
        entry1.setScheduleAmt(new BigDecimal(2000));
        head1.getEntries().add(entry1);
        coll.add(head1);
        PaymentPlanBillInfo head2 = new PaymentPlanBillInfo();
        head2.setSourceBillType(SrcBillTypeEnum.PAYREQUESTBILL);
        head2.setNumber("M002");
        head2.setAsstActID("SupplierID01");
        PaymentPlanBillEntryInfo entry2 = new PaymentPlanBillEntryInfo();
        entry2.setScheduleAmt(new BigDecimal(4000));
        head2.getEntries().add(entry2);
        coll.add(head2);
        PaymentPlanBillInfo head3 = new PaymentPlanBillInfo();
        head3.setSourceBillType(SrcBillTypeEnum.OTHERBILL);
        head3.setNumber("M003");
        head3.setAsstActID("SupplierID01");
        PaymentPlanBillEntryInfo entry3 = new PaymentPlanBillEntryInfo();
        entry3.setScheduleAmt(new BigDecimal(3000));
        head3.getEntries().add(entry3);
        coll.add(head3);
        PaymentPlanBillInfo head4 = new PaymentPlanBillInfo();
        head4.setSourceBillType(SrcBillTypeEnum.OTHERBILL);
        head4.setNumber("M004");
        head4.setAsstActID("SupplierID01");
        PaymentPlanBillEntryInfo entry4 = new PaymentPlanBillEntryInfo();
        entry4.setScheduleAmt(new BigDecimal(3000));
        head4.getEntries().add(entry4);
        coll.add(head4);
        Map<Integer, TreeMap<String, List<PlanScheduledInfo>>> typeMap = BatchGenPaymentBillTest.getTypeMap(coll);
        for (Integer type : typeMap.keySet()) {
            TreeMap<String, List<PlanScheduledInfo>> planMap = typeMap.get(type);
            System.out.println("-------------type=" + SrcBillTypeEnum.getEnum(type).getAlias() + "-------------");
            for (String key : planMap.keySet()) {
                BigDecimal totalSchdlAmt = BigDecimal.ZERO;
                List<PlanScheduledInfo> infoList = planMap.get(key);
                for (PlanScheduledInfo info : infoList) {
                    BigDecimal schdlAmt = info.getScheduleAmt().subtract(info.getLockAmt().add(info.getPayAmt()));
                    totalSchdlAmt = totalSchdlAmt.add(schdlAmt);
                    System.out.println("info = " + info.getPlanNumber() + "\t" + info.getScheduleAmt().toString());
                }
                System.out.println("same key=" + key + ", totalSchdlAmt = " + totalSchdlAmt.toString());
            }
        }
    }

    private static Map<Integer, TreeMap<String, List<PlanScheduledInfo>>> getTypeMap(PaymentPlanBillCollection colls) {
        HashMap<Integer, TreeMap<String, List<PlanScheduledInfo>>> typeMap = new HashMap<Integer, TreeMap<String, List<PlanScheduledInfo>>>();
        TreeMap<Integer, ArrayList<PlanScheduledInfo>> tmpMap = new TreeMap<Integer, ArrayList<PlanScheduledInfo>>();
        for (int i = 0; i < colls.size(); ++i) {
            PaymentPlanBillInfo info = colls.get(i);
            List<PlanScheduledInfo> subList = BatchGenPaymentBillTest.convertPlanInfo(info);
            for (PlanScheduledInfo planInfo : subList) {
                int type = planInfo.getSourceBillType();
                ArrayList<PlanScheduledInfo> lst = (ArrayList<PlanScheduledInfo>)tmpMap.get(type);
                if (lst == null) {
                    lst = new ArrayList<PlanScheduledInfo>();
                }
                lst.add(planInfo);
                tmpMap.put(type, lst);
            }
        }
        for (Integer type : tmpMap.keySet()) {
            List infoList = (List)tmpMap.get(type);
            TreeMap<String, ArrayList<PlanScheduledInfo>> planMap = new TreeMap<String, ArrayList<PlanScheduledInfo>>();
            for (PlanScheduledInfo info : infoList) {
                String key = info.getSupplierID() + info.getSettleTypeID() + info.getAccountBankID();
                ArrayList<PlanScheduledInfo> lst = (ArrayList<PlanScheduledInfo>)planMap.get(key);
                if (lst == null) {
                    lst = new ArrayList<PlanScheduledInfo>();
                }
                lst.add(info);
                planMap.put(key, lst);
            }
            typeMap.put(type, planMap);
        }
        return typeMap;
    }

    private static List<PlanScheduledInfo> convertPlanInfo(PaymentPlanBillInfo info) {
        ArrayList<PlanScheduledInfo> lst = new ArrayList<PlanScheduledInfo>(info.getEntries().size());
        for (int i = 0; i < info.getEntries().size(); ++i) {
            PlanScheduledInfo planInfo = new PlanScheduledInfo();
            planInfo.setSupplierID(info.getAsstActID());
            PaymentPlanBillEntryInfo entry = info.getEntries().get(i);
            planInfo.setSettleTypeID(entry.getSettleType() != null ? entry.getSettleType().getId().toString() : "");
            planInfo.setAccountBankID(entry.getPayerAccBank() != null ? entry.getPayerAccBank().getId().toString() : "");
            planInfo.setSourceBillID(info.getSourceBillId());
            planInfo.setSrcBillHeadID(info.getSrcBillHeadID());
            planInfo.setScheduleAmt(entry.getScheduleAmt() != null ? entry.getScheduleAmt() : BigDecimal.ZERO);
            planInfo.setLockAmt(entry.getLockAmt() != null ? entry.getLockAmt() : BigDecimal.ZERO);
            planInfo.setPayAmt(entry.getPayAmt() != null ? entry.getPayAmt() : BigDecimal.ZERO);
            planInfo.setPlanNumber(info.getNumber());
            planInfo.setSourceBillType(info.getSourceBillType() != null ? info.getSourceBillType().getValue() : 0);
            lst.add(planInfo);
        }
        return lst;
    }
}

